/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.SendCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.DeleteRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.misc.ItemIdWrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteItemRequest
extends DeleteRequest<ServiceResponse> {
    private ItemIdWrapperList itemIds = new ItemIdWrapperList();
    private AffectedTaskOccurrence affectedTaskOccurrences;
    private SendCancellationsMode sendCancellationsMode;

    public DeleteItemRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.itemIds, "ItemIds");
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.itemIds.getCount();
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    public String getXmlElementName() {
        return "DeleteItem";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "DeleteItemResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "DeleteItemResponseMessage";
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        if (this.affectedTaskOccurrences != null) {
            writer.writeAttributeValue("AffectedTaskOccurrences", (Object)this.getAffectedTaskOccurrences());
        }
        if (this.sendCancellationsMode != null) {
            writer.writeAttributeValue("SendMeetingCancellations", (Object)this.getSendCancellationsMode());
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.itemIds.writeToXml(writer, XmlNamespace.Messages, "ItemIds");
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public ItemIdWrapperList getItemIds() {
        return this.itemIds;
    }

    AffectedTaskOccurrence getAffectedTaskOccurrences() {
        return this.affectedTaskOccurrences;
    }

    public void setAffectedTaskOccurrences(AffectedTaskOccurrence affectedTaskOccurrences) {
        this.affectedTaskOccurrences = affectedTaskOccurrences;
    }

    SendCancellationsMode getSendCancellationsMode() {
        return this.sendCancellationsMode;
    }

    public void setSendCancellationsMode(SendCancellationsMode sendCancellationsMode) {
        this.sendCancellationsMode = sendCancellationsMode;
    }
}

