/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.request.MoveCopyRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.misc.ItemIdWrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MoveCopyItemRequest<TResponse extends ServiceResponse>
extends MoveCopyRequest<Item, TResponse> {
    private ItemIdWrapperList itemIds = new ItemIdWrapperList();
    private Boolean newItemIds;

    @Override
    public void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getItemIds(), "ItemIds");
    }

    protected MoveCopyItemRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void writeIdsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getItemIds().writeToXml(writer, XmlNamespace.Messages, "ItemIds");
        if (this.getReturnNewItemIds() != null) {
            writer.writeElementValue(XmlNamespace.Messages, "ReturnNewItemIds", this.getReturnNewItemIds());
        }
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getItemIds().getCount();
    }

    public ItemIdWrapperList getItemIds() {
        return this.itemIds;
    }

    protected Boolean getReturnNewItemIds() {
        return this.newItemIds;
    }

    public void setReturnNewItemIds(Boolean value) {
        this.newItemIds = value;
    }
}

