/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.response;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.search.FindItemsResults;
import microsoft.exchange.webservices.data.search.GroupedFindItemsResults;
import microsoft.exchange.webservices.data.search.ItemGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindItemResponse<TItem extends Item>
extends ServiceResponse {
    private FindItemsResults<TItem> results;
    private boolean isGrouped;
    private GroupedFindItemsResults<TItem> groupedFindResults;
    private PropertySet propertySet;

    public FindItemResponse(boolean isGrouped, PropertySet propertySet) {
        this.isGrouped = isGrouped;
        this.propertySet = propertySet;
        EwsUtilities.ewsAssert(this.propertySet != null, "FindItemResponse.ctor", "PropertySet should not be null");
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws Exception {
        Integer nextPageOffset;
        reader.readStartElement(XmlNamespace.Messages, "RootFolder");
        int totalItemsInView = reader.readAttributeValue(Integer.class, "TotalItemsInView");
        boolean moreItemsAvailable = reader.readAttributeValue(Boolean.class, "IncludesLastItemInRange") == false;
        Integer n = nextPageOffset = moreItemsAvailable ? reader.readNullableAttributeValue(Integer.class, "IndexedPagingOffset") : null;
        if (!this.isGrouped) {
            this.results = new FindItemsResults();
            this.results.setTotalCount(totalItemsInView);
            this.results.setNextPageOffset(nextPageOffset);
            this.results.setMoreAvailable(moreItemsAvailable);
            this.internalReadItemsFromXml(reader, this.propertySet, this.results.getItems());
        } else {
            this.groupedFindResults = new GroupedFindItemsResults();
            this.groupedFindResults.setTotalCount(totalItemsInView);
            this.groupedFindResults.setNextPageOffset(nextPageOffset);
            this.groupedFindResults.setMoreAvailable(moreItemsAvailable);
            reader.readStartElement(XmlNamespace.Types, "Groups");
            if (!reader.isEmptyElement()) {
                do {
                    reader.read();
                    if (!reader.isStartElement(XmlNamespace.Types, "GroupedItems")) continue;
                    String groupIndex = reader.readElementValue(XmlNamespace.Types, "GroupIndex");
                    ArrayList itemList = new ArrayList();
                    this.internalReadItemsFromXml(reader, this.propertySet, itemList);
                    reader.readEndElement(XmlNamespace.Types, "GroupedItems");
                    this.groupedFindResults.getItemGroups().add(new ItemGroup(groupIndex, itemList));
                } while (!reader.isEndElement(XmlNamespace.Types, "Groups"));
            } else {
                reader.read();
            }
        }
        reader.readEndElement(XmlNamespace.Messages, "RootFolder");
    }

    private void internalReadItemsFromXml(EwsServiceXmlReader reader, PropertySet propertySet, List<TItem> destinationList) throws XMLStreamException, ServiceXmlDeserializationException, Exception {
        EwsUtilities.ewsAssert(destinationList != null, "FindItemResponse.InternalReadItemsFromXml", "destinationList is null.");
        reader.readStartElement(XmlNamespace.Types, "Items");
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (reader.getNodeType().nodeType != 1) continue;
                Item item = (Item)EwsUtilities.createEwsObjectFromXmlElementName(Item.class, reader.getService(), reader.getLocalName());
                if (item == null) {
                    reader.skipCurrentElement();
                    continue;
                }
                item.loadFromXml(reader, true, propertySet, true);
                destinationList.add(item);
            } while (!reader.isEndElement(XmlNamespace.Types, "Items"));
        } else {
            reader.read();
        }
    }

    public GroupedFindItemsResults<TItem> getGroupedFindResults() {
        return this.groupedFindResults;
    }

    public FindItemsResults<TItem> getResults() {
        return this.results;
    }
}

