/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpandGroupResults
implements Iterable<EmailAddress> {
    private boolean includesAllMembers;
    private Collection<EmailAddress> members = new ArrayList<EmailAddress>();

    public int getCount() {
        return this.getMembers().size();
    }

    public boolean getIncludesAllMembers() {
        return this.includesAllMembers;
    }

    public Collection<EmailAddress> getMembers() {
        return this.members;
    }

    public void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Messages, "DLExpansion");
        if (!reader.isEmptyElement()) {
            int totalItemsInView = reader.readAttributeValue(Integer.class, "TotalItemsInView");
            this.includesAllMembers = reader.readAttributeValue(Boolean.class, "IncludesLastItemInRange");
            for (int i = 0; i < totalItemsInView; ++i) {
                EmailAddress emailAddress = new EmailAddress();
                reader.readStartElement(XmlNamespace.Types, "Mailbox");
                emailAddress.loadFromXml(reader, "Mailbox");
                this.getMembers().add(emailAddress);
            }
            reader.readEndElement(XmlNamespace.Messages, "DLExpansion");
        } else {
            reader.read();
        }
    }

    @Override
    public Iterator<EmailAddress> iterator() {
        return this.members.iterator();
    }
}

