/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.notification;

import java.util.Date;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.notification.EventType;
import microsoft.exchange.webservices.data.notification.NotificationEvent;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemId;

public final class ItemEvent
extends NotificationEvent {
    private ItemId itemId;
    private ItemId oldItemId;

    protected ItemEvent(EventType eventType, Date timestamp) {
        super(eventType, timestamp);
    }

    protected void internalLoadFromXml(EwsServiceXmlReader reader) throws Exception {
        super.internalLoadFromXml(reader);
        this.itemId = new ItemId();
        this.itemId.loadFromXml(reader, reader.getLocalName());
        reader.read();
        this.setParentFolderId(new FolderId());
        this.getParentFolderId().loadFromXml(reader, "ParentFolderId");
        EventType eventType = this.getEventType();
        switch (eventType) {
            case Moved: 
            case Copied: {
                reader.read();
                this.oldItemId = new ItemId();
                this.oldItemId.loadFromXml(reader, reader.getLocalName());
                reader.read();
                this.setOldParentFolderId(new FolderId());
                this.getOldParentFolderId().loadFromXml(reader, reader.getLocalName());
                break;
            }
        }
    }

    public ItemId getItemId() {
        return this.itemId;
    }

    public ItemId getOldItemId() {
        return this.oldItemId;
    }
}

