/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.recurrence.range;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.recurrence.pattern.Recurrence;
import microsoft.exchange.webservices.data.property.complex.recurrence.range.RecurrenceRange;

public final class EndDateRecurrenceRange
extends RecurrenceRange {
    private Date endDate;

    public EndDateRecurrenceRange() {
    }

    public EndDateRecurrenceRange(Date startDate, Date endDate) {
        super(startDate);
        this.endDate = endDate;
    }

    public String getXmlElementName() {
        return "EndDateRecurrence";
    }

    public void setupRecurrence(Recurrence recurrence) throws Exception {
        super.setupRecurrence(recurrence);
        recurrence.setEndDate(this.endDate);
    }

    public void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        Date d = this.endDate;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String formattedString = df.format(d);
        super.writeElementsToXml(writer);
        writer.writeElementValue(XmlNamespace.Types, "EndDate", formattedString);
    }

    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (super.tryReadElementFromXml(reader)) {
            return true;
        }
        if (reader.getLocalName().equals("EndDate")) {
            Date temp = reader.readElementValueAsUnspecifiedDate();
            if (temp != null) {
                this.endDate = temp;
            }
            return true;
        }
        return false;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date value) {
        this.canSetFieldValue(this.endDate, value);
    }
}

