/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneTransition;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneTransitionGroup;

public class AbsoluteDateTransition
extends TimeZoneTransition {
    private Date dateTime;

    protected String getXmlElementName() {
        return "AbsoluteDateTransition";
    }

    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws ParseException, Exception {
        boolean result = super.tryReadElementFromXml(reader);
        if (!result && reader.getLocalName().equals("DateTime")) {
            SimpleDateFormat sdfin = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.dateTime = sdfin.parse(reader.readElementValue());
            result = true;
        }
        return result;
    }

    public void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        super.writeElementsToXml(writer);
        writer.writeElementValue(XmlNamespace.Types, "DateTime", this.dateTime);
    }

    protected AbsoluteDateTransition(TimeZoneDefinition timeZoneDefinition) {
        super(timeZoneDefinition);
    }

    protected AbsoluteDateTransition(TimeZoneDefinition timeZoneDefinition, TimeZoneTransitionGroup targetGroup) {
        super(timeZoneDefinition, targetGroup);
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    protected void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }
}

