/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertyBag;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexPropertyDefinitionBase
extends PropertyDefinition {
    protected ComplexPropertyDefinitionBase(String xmlElementName, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, flags, version);
    }

    protected ComplexPropertyDefinitionBase(String xmlElementName, String uri, ExchangeVersion version) {
        super(xmlElementName, uri, version);
    }

    protected ComplexPropertyDefinitionBase(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, uri, flags, version);
    }

    public abstract ComplexProperty createPropertyInstance(ServiceObject var1);

    protected void internalLoadFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        OutParam<ComplexProperty> complexProperty = new OutParam<ComplexProperty>();
        boolean justCreated = this.getPropertyInstance(propertyBag, complexProperty);
        if (!justCreated && this.hasFlag(PropertyDefinitionFlags.UpdateCollectionItems, propertyBag.getOwner().getService().getRequestedServerVersion())) {
            ComplexProperty c = (ComplexProperty)complexProperty.getParam();
            c.updateFromXml(reader, reader.getLocalName());
        } else {
            ComplexProperty c = (ComplexProperty)complexProperty.getParam();
            c.loadFromXml(reader, reader.getLocalName());
        }
        propertyBag.setObjectFromPropertyDefinition(this, complexProperty.getParam());
    }

    private boolean getPropertyInstance(PropertyBag propertyBag, OutParam<ComplexProperty> complexProperty) {
        ServiceObject owner = propertyBag.getOwner();
        ExchangeService service = owner.getService();
        if (!propertyBag.tryGetValue(this, complexProperty) || !this.hasFlag(PropertyDefinitionFlags.ReuseInstance, service.getRequestedServerVersion())) {
            complexProperty.setParam((Object)this.createPropertyInstance(owner));
            return true;
        }
        return false;
    }

    @Override
    public void loadPropertyValueFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, this.getXmlElement());
        if (!reader.isEmptyElement() || reader.hasAttributes()) {
            this.internalLoadFromXml(reader, propertyBag);
        }
        reader.readEndElementIfNecessary(XmlNamespace.Types, this.getXmlElement());
    }

    @Override
    public void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws Exception {
        ComplexProperty complexProperty = (ComplexProperty)propertyBag.getObjectFromPropertyDefinition(this);
        if (complexProperty != null) {
            complexProperty.writeToXml(writer, this.getXmlElement());
        }
    }
}

