/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertyBag;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.service.schema.AppointmentSchema;
import microsoft.exchange.webservices.data.property.complex.MeetingTimeZone;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.TimeZonePropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartTimeZonePropertyDefinition
extends TimeZonePropertyDefinition {
    public StartTimeZonePropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, uri, flags, version);
    }

    @Override
    protected void registerAssociatedInternalProperties(List<PropertyDefinition> properties) {
        super.registerAssociatedInternalProperties(properties);
        properties.add(AppointmentSchema.MeetingTimeZone);
    }

    @Override
    public void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws Exception {
        Object value = propertyBag.getObjectFromPropertyDefinition(this);
        if (value != null) {
            ExchangeService service = (ExchangeService)writer.getService();
            if (service.getRequestedServerVersion() == ExchangeVersion.Exchange2007_SP1) {
                if (!service.getExchange2007CompatibilityMode()) {
                    MeetingTimeZone meetingTimeZone = new MeetingTimeZone((TimeZoneDefinition)value);
                    meetingTimeZone.writeToXml(writer, "MeetingTimeZone");
                }
            } else {
                super.writePropertyValueToXml(writer, propertyBag, isUpdateOperation);
            }
        }
    }

    @Override
    public void writeToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        if (writer.getService().getRequestedServerVersion() == ExchangeVersion.Exchange2007_SP1) {
            AppointmentSchema.MeetingTimeZone.writeToXml(writer);
        } else {
            super.writeToXml(writer);
        }
    }

    @Override
    public boolean hasFlag(PropertyDefinitionFlags flag, ExchangeVersion version) {
        if (version != null && version == ExchangeVersion.Exchange2007_SP1) {
            return AppointmentSchema.MeetingTimeZone.hasFlag(flag, version);
        }
        return super.hasFlag(flag, version);
    }
}

