/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.core.enumeration.property.TaskDelegationState;
import microsoft.exchange.webservices.data.property.definition.GenericPropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskDelegationStatePropertyDefinition
extends GenericPropertyDefinition<TaskDelegationState> {
    private static final String NoMatch = "NoMatch";
    private static final String OwnNew = "OwnNew";
    private static final String Owned = "Owned";
    private static final String Accepted = "Accepted";

    public TaskDelegationStatePropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(TaskDelegationState.class, xmlElementName, uri, flags, version);
    }

    @Override
    protected TaskDelegationState parse(String value) {
        switch (Status.valueOf(value)) {
            case NoMatch: {
                return TaskDelegationState.NoDelegation;
            }
            case OwnNew: {
                return TaskDelegationState.Unknown;
            }
            case Owned: {
                return TaskDelegationState.Accepted;
            }
            case Accepted: {
                return TaskDelegationState.Declined;
            }
        }
        EwsUtilities.ewsAssert(false, "TaskDelegationStatePropertyDefinition.Parse", String.format("TaskDelegationStatePropertyDefinition.Parse(): value %s cannot be handled.", value));
        return null;
    }

    @Override
    protected String toString(TaskDelegationState value) {
        if (value.equals((Object)TaskDelegationState.NoDelegation)) {
            return NoMatch;
        }
        if (value.equals((Object)TaskDelegationState.Unknown)) {
            return OwnNew;
        }
        if (value.equals((Object)TaskDelegationState.Accepted)) {
            return Owned;
        }
        if (value.equals((Object)TaskDelegationState.Declined)) {
            return Accepted;
        }
        EwsUtilities.ewsAssert(false, "TaskDelegationStatePropertyDefinition.ToString", "Invalid TaskDelegationState value.");
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NoMatch,
        OwnNew,
        Owned,
        Accepted;

    }
}

