/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import microsoft.exchange.webservices.data.Appointment;
import microsoft.exchange.webservices.data.AppointmentSchema;
import microsoft.exchange.webservices.data.BasePropertySet;
import microsoft.exchange.webservices.data.CalendarFolder;
import microsoft.exchange.webservices.data.ConflictResolutionMode;
import microsoft.exchange.webservices.data.DeleteMode;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.FindFoldersResults;
import microsoft.exchange.webservices.data.Folder;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.FolderView;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ServiceResponseException;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import microsoft.exchange.webservices.data.WellKnownFolderName;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.extension.exchange.service.CorrespondenceService;
import org.exoplatform.extension.exchange.service.util.CalendarConverterService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;

public class ExchangeStorageService
implements Serializable {
    private static final long serialVersionUID = 6348129698208975430L;
    private static final Log LOG = ExoLogger.getLogger(ExchangeStorageService.class);
    private OrganizationService organizationService;
    private CorrespondenceService correspondenceService;

    public ExchangeStorageService(OrganizationService organizationService, CorrespondenceService correspondenceService) {
        this.organizationService = organizationService;
        this.correspondenceService = correspondenceService;
    }

    public List<FolderId> getAllExchangeCalendars(ExchangeService service) throws Exception {
        ArrayList<FolderId> calendarFolderIds = new ArrayList<FolderId>();
        CalendarFolder calendarRootFolder = CalendarFolder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.Calendar);
        calendarFolderIds.add(calendarRootFolder.getId());
        List<Folder> calendarfolders = this.searchSubFolders(service, calendarRootFolder.getId());
        if (calendarfolders != null && !calendarfolders.isEmpty()) {
            for (Folder tmpFolder : calendarfolders) {
                calendarFolderIds.add(tmpFolder.getId());
            }
        }
        return calendarFolderIds;
    }

    public boolean updateOrCreateExchangeAppointment(String username, ExchangeService service, CalendarEvent event, String exoMasterId, TimeZone userCalendarTimeZone, List<CalendarEvent> eventsToUpdateModifiedTime) throws Exception {
        return this.updateOrCreateExchangeAppointment(username, service, event, exoMasterId, userCalendarTimeZone, eventsToUpdateModifiedTime, true);
    }

    private boolean updateOrCreateExchangeAppointment(String username, ExchangeService service, CalendarEvent event, String exoMasterId, TimeZone userCalendarTimeZone, List<CalendarEvent> eventsToUpdateModifiedTime, boolean checkDates) throws Exception {
        if (event == null) {
            return false;
        }
        String folderIdString = this.correspondenceService.getCorrespondingId(username, event.getCalendarId());
        if (folderIdString == null || folderIdString.isEmpty()) {
            LOG.trace((Object)("eXo Calendar with id '" + event.getCalendarId() + "' is not synhronized with Exchange, ignore Event:" + event.getSummary()));
            return false;
        }
        String itemId = this.correspondenceService.getCorrespondingId(username, event.getId());
        boolean isNew = true;
        Appointment appointment = null;
        if (itemId != null) {
            try {
                appointment = Appointment.bind((ExchangeService)service, (ItemId)ItemId.getItemIdFromString((String)itemId));
                isNew = false;
            }
            catch (ServiceResponseException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Item was not bound, it was deleted or not yet created:" + event.getId()));
                }
                this.correspondenceService.deleteCorrespondingId(username, event.getId());
            }
        }
        if (event.getRecurrenceId() == null && (event.getRepeatType() == null || event.getRepeatType().equals(CalendarEvent.RP_NOREPEAT))) {
            if (isNew) {
                if (CalendarConverterService.isExchangeEventId(event.getId())) {
                    LOG.error((Object)"Conflict in modification, inconsistant data, the event was deleted in Exchange but seems always in eXo, the event will be deleted from Exchange.");
                    this.deleteAppointmentByExoEventId(username, service, event.getId(), event.getCalendarId());
                    return false;
                }
                appointment = new Appointment(service);
            }
            CalendarConverterService.convertExoToExchangeEvent(appointment, event, username, this.organizationService.getUserHandler(), this.getTimeZoneDefinition(service, userCalendarTimeZone), userCalendarTimeZone);
        } else if (event.getRecurrenceId() != null && !event.getRecurrenceId().isEmpty() || event.getIsExceptionOccurrence() != null && event.getIsExceptionOccurrence().booleanValue()) {
            if (isNew) {
                String exchangeMasterId = this.correspondenceService.getCorrespondingId(username, exoMasterId);
                Appointment tmpAppointment = this.getAppointmentOccurence(service, exchangeMasterId, event.getRecurrenceId());
                if (tmpAppointment != null) {
                    appointment = tmpAppointment;
                    isNew = false;
                } else {
                    appointment = new Appointment(service);
                }
            }
            CalendarConverterService.convertExoToExchangeOccurenceEvent(appointment, event, username, this.organizationService.getUserHandler(), this.getTimeZoneDefinition(service, userCalendarTimeZone), userCalendarTimeZone);
        } else {
            List<Appointment> toDeleteOccurences;
            if (isNew) {
                if (CalendarConverterService.isExchangeEventId(event.getId())) {
                    LOG.error((Object)"Conflict in modification, inconsistant data, the event was deleted in Exchange but seems always in eXo, the event will be deleted from Exchange.");
                    this.deleteAppointmentByExoEventId(username, service, event.getId(), event.getCalendarId());
                    return false;
                }
                appointment = new Appointment(service);
            }
            if ((toDeleteOccurences = CalendarConverterService.convertExoToExchangeMasterRecurringCalendarEvent(appointment, event, username, this.organizationService.getUserHandler(), this.getTimeZoneDefinition(service, userCalendarTimeZone), userCalendarTimeZone)) != null && !toDeleteOccurences.isEmpty()) {
                for (Appointment occAppointment : toDeleteOccurences) {
                    CalendarServiceImpl calendarService = (CalendarServiceImpl)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                    CalendarEvent tmpEvent = CalendarConverterService.getOccurenceOfDate(username, calendarService.getDataStorage(), event, CalendarConverterService.getExoDateFromExchangeFormat(occAppointment.getOriginalStart()), userCalendarTimeZone);
                    if (tmpEvent != null) {
                        CalendarConverterService.convertExoToExchangeOccurenceEvent(occAppointment, tmpEvent, username, this.organizationService.getUserHandler(), this.getTimeZoneDefinition(service, userCalendarTimeZone), userCalendarTimeZone);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Create Exchange Exceptional Occurence Appointment: " + tmpEvent.getSummary()));
                        }
                        occAppointment.update(ConflictResolutionMode.AlwaysOverwrite);
                        this.correspondenceService.setCorrespondingId(username, tmpEvent.getId(), occAppointment.getId().getUniqueId());
                        if (eventsToUpdateModifiedTime == null) continue;
                        eventsToUpdateModifiedTime.add(event);
                        continue;
                    }
                    String exoId = this.correspondenceService.getCorrespondingId(username, occAppointment.getId().getUniqueId());
                    if (exoId != null) continue;
                    this.deleteAppointment(username, service, occAppointment.getId());
                }
            }
        }
        if (isNew) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Create Exchange Appointment: " + event.getSummary()));
            }
            FolderId folderId = FolderId.getFolderIdFromString((String)folderIdString);
            appointment.save(folderId);
            this.correspondenceService.setCorrespondingId(username, event.getId(), appointment.getId().getUniqueId());
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Update Exchange Appointment: " + event.getSummary()));
            }
            appointment.update(ConflictResolutionMode.AlwaysOverwrite);
            this.correspondenceService.setCorrespondingId(username, event.getId(), appointment.getId().getUniqueId());
        }
        if (eventsToUpdateModifiedTime != null) {
            eventsToUpdateModifiedTime.add(event);
        }
        return false;
    }

    public void deleteAppointmentByExoEventId(String username, ExchangeService service, String eventId, String calendarId) throws Exception {
        String itemId = this.correspondenceService.getCorrespondingId(username, eventId);
        if (itemId == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"The event was deleted from eXo but seems don't have corresponding Event in Exchange, ignore.");
            }
        } else if (this.correspondenceService.getCorrespondingId(username, calendarId) == null) {
            LOG.warn((Object)("Calendar with id '" + calendarId + "' seems not synchronized with exchange."));
            this.correspondenceService.deleteCorrespondingId(username, eventId);
        } else {
            this.deleteAppointment(username, service, itemId);
        }
    }

    public void deleteAppointment(String username, ExchangeService service, String itemId) throws Exception {
        this.deleteAppointment(username, service, ItemId.getItemIdFromString((String)itemId));
    }

    public void deleteAppointment(String username, ExchangeService service, ItemId itemId) throws Exception {
        block3: {
            Appointment appointment = null;
            try {
                appointment = Appointment.bind((ExchangeService)service, (ItemId)itemId);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Delete Exchange appointment: " + appointment.getSubject()));
                }
                appointment.delete(DeleteMode.HardDelete);
            }
            catch (ServiceResponseException e) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace((Object)("Exchange Item was not bound, it was deleted or not yet created:" + itemId));
            }
        }
        this.correspondenceService.deleteCorrespondingId(username, itemId.getUniqueId());
    }

    public void deleteExchangeFolderByCalenarId(String username, ExchangeService service, String calendarId) throws Exception {
        block4: {
            if (CalendarConverterService.isExchangeCalendarId(calendarId)) {
                LOG.warn((Object)("Can't delete Exchange Calendar, because it was created on Exchange: " + calendarId));
                return;
            }
            String folderId = this.correspondenceService.getCorrespondingId(username, calendarId);
            if (folderId == null) {
                LOG.warn((Object)"Conflict in modification, inconsistant data, the Calendar was deleted from eXo but seems don't have corresponding Folder in Exchange, ignore.");
                return;
            }
            Folder folder = null;
            try {
                folder = Folder.bind((ExchangeService)service, (FolderId)FolderId.getFolderIdFromString((String)folderId));
                LOG.trace((Object)("Delete Exchange folder: " + folder.getDisplayName()));
                folder.delete(DeleteMode.MoveToDeletedItems);
            }
            catch (ServiceResponseException e) {
                if (!LOG.isTraceEnabled()) break block4;
                LOG.trace((Object)("Exchange Folder was not bound, it was deleted or not yet created:" + folderId));
            }
        }
        this.correspondenceService.deleteCorrespondingId(username, calendarId);
    }

    private TimeZoneDefinition getTimeZoneDefinition(ExchangeService service, TimeZone userCalendarTimeZone) {
        TimeZoneDefinition serverTimeZoneDefinition = null;
        for (TimeZoneDefinition timeZoneDefinition : service.getServerTimeZones()) {
            if (!timeZoneDefinition.getId().equals(userCalendarTimeZone.getID())) continue;
            serverTimeZoneDefinition = timeZoneDefinition;
            break;
        }
        return serverTimeZoneDefinition;
    }

    private List<Folder> searchSubFolders(ExchangeService service, FolderId parentFolderId) throws Exception {
        FolderView view = new FolderView(1000);
        view.setPropertySet(new PropertySet(BasePropertySet.FirstClassProperties));
        FindFoldersResults findResults = service.findFolders(parentFolderId, view);
        return findResults.getFolders();
    }

    private Appointment getAppointmentOccurence(ExchangeService service, String exchangeMasterId, String recurrenceId) throws Exception {
        Appointment masterAppointment = Appointment.bind((ExchangeService)service, (ItemId)ItemId.getItemIdFromString((String)exchangeMasterId), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.Recurrence}));
        return CalendarConverterService.getAppointmentOccurence(masterAppointment, recurrenceId);
    }

    public CalendarFolder getExchangeCalendar(ExchangeService service, String folderId) throws Exception {
        return this.getExchangeCalendar(service, FolderId.getFolderIdFromString((String)folderId));
    }

    public CalendarFolder getExchangeCalendar(ExchangeService service, FolderId folderId) throws Exception {
        CalendarFolder folder = null;
        try {
            folder = CalendarFolder.bind((ExchangeService)service, (FolderId)folderId);
        }
        catch (ServiceResponseException e) {
            LOG.warn((Object)("Can't get Folder identified by id: " + folderId.getUniqueId()));
        }
        return folder;
    }

    public Appointment getAppointment(ExchangeService service, String appointmentId) throws Exception {
        return this.getAppointment(service, ItemId.getItemIdFromString((String)appointmentId));
    }

    public Appointment getAppointment(ExchangeService service, ItemId appointmentId) throws Exception {
        Appointment appointment;
        block2: {
            appointment = null;
            try {
                appointment = Appointment.bind((ExchangeService)service, (ItemId)appointmentId);
            }
            catch (ServiceResponseException e) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("Can't get appointment identified by id: " + appointmentId.getUniqueId()));
            }
        }
        return appointment;
    }

    public Item getItem(ExchangeService service, String itemId) throws Exception {
        return this.getItem(service, ItemId.getItemIdFromString((String)itemId));
    }

    public Item getItem(ExchangeService service, ItemId itemId) throws Exception {
        Item item = null;
        try {
            item = Item.bind((ExchangeService)service, (ItemId)itemId);
        }
        catch (ServiceResponseException e) {
            LOG.warn((Object)("Can't get item identified by id: " + itemId.getUniqueId()));
        }
        return item;
    }
}

