/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.listener;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.extension.exchange.listener.IntegrationListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.jaas.AbstractLoginModule;

public class ExchangeIntegrationLoginModule
extends AbstractLoginModule {
    private static final Log LOG = ExoLogger.getLogger(ExchangeIntegrationLoginModule.class);
    private IntegrationListener exchangeListenerService;
    private String username = null;

    public boolean commit() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            if (!StringUtils.isEmpty((String)this.username) && !StringUtils.isEmpty((String)password)) {
                this.getExchangeListenerService().userLoggedIn(this.username, password);
            }
        }
        catch (Exception e) {
            this.getLogger().warn((Object)e);
        }
        return true;
    }

    public boolean login() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.username != null) {
            this.exchangeListenerService.userLoggedOut(this.username);
        }
        return false;
    }

    protected Log getLogger() {
        return LOG;
    }

    public IntegrationListener getExchangeListenerService() {
        if (this.exchangeListenerService == null) {
            try {
                this.exchangeListenerService = (IntegrationListener)this.getContainer().getComponentInstanceOfType(IntegrationListener.class);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return this.exchangeListenerService;
    }
}

