/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.service;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.jcr.Node;
import microsoft.exchange.webservices.data.Appointment;
import microsoft.exchange.webservices.data.BasePropertySet;
import microsoft.exchange.webservices.data.CalendarFolder;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.FindItemsResults;
import microsoft.exchange.webservices.data.Folder;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemEvent;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.ItemSchema;
import microsoft.exchange.webservices.data.ItemView;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.SearchFilter;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.WellKnownFolderName;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.extension.exchange.service.CorrespondenceService;
import org.exoplatform.extension.exchange.service.ExchangeStorageService;
import org.exoplatform.extension.exchange.service.ExoStorageService;
import org.exoplatform.extension.exchange.service.util.CalendarConverterService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.AbstractCodecBuilder;
import org.exoplatform.web.security.security.TokenServiceInitializationException;
import org.gatein.common.io.IOTools;

public class IntegrationService {
    public static final String USER_EXCHANGE_SERVER_URL_ATTRIBUTE = "exchange.server.url";
    public static final String USER_EXCHANGE_SERVER_DOMAIN_ATTRIBUTE = "exchange.server.domain";
    public static final String USER_EXCHANGE_USERNAME_ATTRIBUTE = "exchange.username";
    public static final String USER_EXCHANGE_PASSWORD_ATTRIBUTE = "exchange.password";
    private static final Log LOG = ExoLogger.getLogger(IntegrationService.class);
    private static final String USER_EXCHANGE_HANDLED_ATTRIBUTE = "exchange.check.date";
    private static final String USER_EXO_HANDLED_ATTRIBUTE = "exo.check.date";
    private static final Map<String, IntegrationService> instances = new HashMap<String, IntegrationService>();
    private static AbstractCodec codec;
    private final String username;
    private final ExchangeService service;
    private final ExoStorageService exoStorageService;
    private final ExchangeStorageService exchangeStorageService;
    private final CorrespondenceService correspondenceService;
    private final OrganizationService organizationService;
    private final CalendarService calendarService;
    private boolean synchIsCurrentlyRunning = false;

    public IntegrationService(OrganizationService organizationService, CalendarService calendarService, ExoStorageService exoStorageService, ExchangeStorageService exchangeStorageService, CorrespondenceService correspondenceService, ExchangeService service, String username) {
        this.organizationService = organizationService;
        this.calendarService = calendarService;
        this.exoStorageService = exoStorageService;
        this.exchangeStorageService = exchangeStorageService;
        this.correspondenceService = correspondenceService;
        this.service = service;
        this.username = username;
        instances.put(username, this);
    }

    public static IntegrationService getInstance(String username) {
        return instances.get(username);
    }

    public CalendarFolder getExchangeCalendar(FolderId folderId) throws Exception {
        return this.exchangeStorageService.getExchangeCalendar(this.service, folderId);
    }

    public List<String> synchronizeFullCalendar(FolderId folderId) throws Exception {
        ArrayList<String> updatedExoEventIds = new ArrayList<String>();
        CalendarFolder folder = this.exchangeStorageService.getExchangeCalendar(this.service, folderId);
        this.exoStorageService.getOrCreateUserCalendar(this.username, (Folder)folder);
        List<Item> items = this.searchAllItems(folderId);
        this.synchronizeAllExchangeAppointments(updatedExoEventIds, items);
        this.deleteExoEventsOutOfSynchronization(folderId);
        return updatedExoEventIds;
    }

    public void synchronizeModificationsOfCalendar(FolderId folderId, Date lastSyncDate, List<String> updatedExoEventIDs, int diffTimeZone) throws Exception {
        Date exoLastSyncDate = this.getUserExoLastCheckDate();
        if (exoLastSyncDate == null || exoLastSyncDate.before(lastSyncDate)) {
            exoLastSyncDate = lastSyncDate;
        }
        this.synchronizeAppointmentsByModificationDate(folderId, lastSyncDate, updatedExoEventIDs, diffTimeZone);
        this.synchronizeNewExoEvents(folderId, updatedExoEventIDs, exoLastSyncDate);
        this.synchronizeExoEventsByModificationDate(folderId, updatedExoEventIDs, exoLastSyncDate);
    }

    public List<FolderId> getAllExchangeCalendars() throws Exception {
        return this.exchangeStorageService.getAllExchangeCalendars(this.service);
    }

    public boolean isCalendarSynchronizedWithExchange(String id) throws Exception {
        return this.correspondenceService.getCorrespondingId(this.username, id) != null;
    }

    public boolean isCalendarPresentInExo(FolderId folderId) throws Exception {
        return this.exoStorageService.getUserCalendar(this.username, folderId.getUniqueId()) != null;
    }

    public List<CalendarEvent> createOrUpdateOrDelete(ItemEvent itemEvent) throws Exception {
        List<CalendarEvent> updatedEvents = null;
        Appointment appointment = this.exchangeStorageService.getAppointment(this.service, itemEvent.getItemId());
        if (appointment == null) {
            this.exoStorageService.deleteEventByAppointmentID(itemEvent.getItemId().getUniqueId(), this.username);
        } else {
            String eventId = this.correspondenceService.getCorrespondingId(this.username, appointment.getId().getUniqueId());
            updatedEvents = eventId == null ? this.exoStorageService.createEvent(appointment, this.username, this.getUserExoCalenarTimeZoneSetting()) : this.exoStorageService.updateEvent(appointment, this.username, this.getUserExoCalenarTimeZoneSetting());
        }
        return updatedEvents;
    }

    public Calendar getUserCalendarByExchangeFolderId(FolderId folderId) throws Exception {
        return this.exoStorageService.getUserCalendar(this.username, folderId.getUniqueId());
    }

    public void updateOrCreateExchangeCalendarEvent(Node eventNode) throws Exception {
        CalendarEvent event = this.exoStorageService.getExoEventByNode(eventNode);
        if (this.isCalendarSynchronizedWithExchange(event.getCalendarId())) {
            ArrayList<CalendarEvent> calendarEventsToUpdateModifiedTime = new ArrayList<CalendarEvent>();
            this.updateOrCreateExchangeCalendarEvent(event, calendarEventsToUpdateModifiedTime);
            if (!calendarEventsToUpdateModifiedTime.isEmpty()) {
                for (CalendarEvent calendarEvent : calendarEventsToUpdateModifiedTime) {
                    this.exoStorageService.updateModifiedDateOfEvent(this.username, calendarEvent);
                }
            }
        }
    }

    public boolean updateOrCreateExchangeCalendarEvent(String eventId) throws Exception {
        CalendarEvent event = ((CalendarServiceImpl)this.calendarService).getDataStorage().getEvent(this.username, eventId);
        return this.updateOrCreateExchangeCalendarEvent(event);
    }

    public boolean updateOrCreateExchangeCalendarEvent(CalendarEvent event, List<CalendarEvent> eventsToUpdate) throws Exception {
        String exoMasterId = null;
        if (event.getIsExceptionOccurrence() != null && event.getIsExceptionOccurrence().booleanValue() && (exoMasterId = this.exoStorageService.getExoEventMasterRecurenceByOriginalUUID(event.getOriginalReference())) == null) {
            LOG.error((Object)("No master Id was found for occurence: " + event.getSummary() + " with recurrenceId = " + event.getRecurrenceId() + ". The event will not be updated."));
        }
        return this.exchangeStorageService.updateOrCreateExchangeAppointment(this.username, this.service, event, exoMasterId, this.getUserExoCalenarTimeZoneSetting(), eventsToUpdate);
    }

    public boolean updateOrCreateExchangeCalendarEvent(CalendarEvent event) throws Exception {
        return this.updateOrCreateExchangeCalendarEvent(event, null);
    }

    public void deleteExchangeCalendarEvent(String eventId, String calendarId) throws Exception {
        this.exchangeStorageService.deleteAppointmentByExoEventId(this.username, this.service, eventId, calendarId);
    }

    public boolean deleteExoCalendar(FolderId folderId) throws Exception {
        CalendarFolder folder = this.exchangeStorageService.getExchangeCalendar(this.service, folderId);
        if (folder != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Folder was found, but event seems saying that it was deleted.");
            }
            return false;
        }
        return this.exoStorageService.deleteCalendar(this.username, folderId.getUniqueId());
    }

    public void deleteExchangeCalendar(String calendarId) throws Exception {
        this.exchangeStorageService.deleteExchangeFolderByCalenarId(this.username, this.service, calendarId);
    }

    public void removeInstance() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Stop Exchange Integration Service for user: " + this.username));
        }
        instances.remove(this.username);
    }

    public List<String> synchronizeExchangeFolderState(List<FolderId> calendarFolderIds, boolean synchronizeAllExchangeFolders, boolean deleteExoCalendarOnUnsync) throws Exception {
        Iterator<FolderId> iterator = calendarFolderIds.iterator();
        while (iterator.hasNext()) {
            FolderId folderId = iterator.next();
            this.deleteExoCalendarOutOfSync(deleteExoCalendarOnUnsync, iterator, folderId);
        }
        List<String> updatedCalendarEventIds = null;
        if (synchronizeAllExchangeFolders) {
            List<FolderId> folderIds = this.exchangeStorageService.getAllExchangeCalendars(this.service);
            for (FolderId folderId : folderIds) {
                if (calendarFolderIds.contains(folderId)) continue;
                this.exoStorageService.deleteCalendar(this.username, folderId.getUniqueId());
                List<String> tmpUpdatedCalendarEventIds = this.synchronizeFullCalendar(folderId);
                if (tmpUpdatedCalendarEventIds != null && !tmpUpdatedCalendarEventIds.isEmpty()) {
                    if (updatedCalendarEventIds == null) {
                        updatedCalendarEventIds = tmpUpdatedCalendarEventIds;
                    } else {
                        updatedCalendarEventIds.addAll(tmpUpdatedCalendarEventIds);
                    }
                }
                calendarFolderIds.add(folderId);
            }
        } else {
            List<FolderId> synchronizedFolderIds = this.getSynchronizedExchangeCalendars();
            for (FolderId folderId : synchronizedFolderIds) {
                if (calendarFolderIds.contains(folderId)) continue;
                this.exoStorageService.deleteCalendar(this.username, folderId.getUniqueId());
                List<String> tmpUpdatedCalendarEventIds = this.synchronizeFullCalendar(folderId);
                if (tmpUpdatedCalendarEventIds != null && !tmpUpdatedCalendarEventIds.isEmpty()) {
                    if (updatedCalendarEventIds == null) {
                        updatedCalendarEventIds = tmpUpdatedCalendarEventIds;
                    } else {
                        updatedCalendarEventIds.addAll(tmpUpdatedCalendarEventIds);
                    }
                }
                calendarFolderIds.add(folderId);
            }
            Iterator<FolderId> folderIdIterator = calendarFolderIds.iterator();
            while (folderIdIterator.hasNext()) {
                FolderId folderId;
                folderId = folderIdIterator.next();
                if (synchronizedFolderIds.contains(folderId)) continue;
                folderIdIterator.remove();
            }
        }
        return updatedCalendarEventIds;
    }

    private void deleteExoCalendarOutOfSync(boolean deleteExoCalendarOnUnsync, Iterator<FolderId> iterator, FolderId folderId) throws Exception {
        Calendar calendar;
        CalendarFolder folder = this.exchangeStorageService.getExchangeCalendar(this.service, folderId);
        if (folder == null && (folder = this.exchangeStorageService.getExchangeCalendar(this.service, FolderId.getFolderIdFromWellKnownFolderName((WellKnownFolderName)WellKnownFolderName.Calendar))) != null && (calendar = this.exoStorageService.getUserCalendar(this.username, folderId.getUniqueId())) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Folder '" + folderId.getUniqueId() + "' was deleted from Exchange, stopping synchronization for this folder."));
            }
            if (deleteExoCalendarOnUnsync) {
                this.exoStorageService.deleteCalendar(this.username, folderId.getUniqueId());
            } else {
                this.correspondenceService.deleteCorrespondingId(this.username, folderId.getUniqueId());
            }
            iterator.remove();
        }
    }

    public List<FolderId> getSynchronizedExchangeCalendars() throws Exception {
        ArrayList<FolderId> folderIds = new ArrayList<FolderId>();
        List<String> folderIdsString = this.correspondenceService.getSynchronizedExchangeFolderIds(this.username);
        for (String folderIdString : folderIdsString) {
            folderIds.add(FolderId.getFolderIdFromString((String)folderIdString));
        }
        return folderIds;
    }

    public void addFolderToSynchronization(String folderIdString) throws Exception {
        String calendarId = CalendarConverterService.getCalendarId(folderIdString);
        this.correspondenceService.setCorrespondingId(this.username, calendarId, folderIdString);
    }

    public void deleteFolderFromSynchronization(String folderIdString) throws Exception {
        this.correspondenceService.deleteCorrespondingId(this.username, folderIdString);
    }

    public synchronized void setSynchronizationStarted() {
        this.synchIsCurrentlyRunning = true;
    }

    public synchronized void setSynchronizationStopped() {
        this.synchIsCurrentlyRunning = false;
    }

    public synchronized boolean isSynchronizationStarted() {
        return this.synchIsCurrentlyRunning;
    }

    private void deleteExoEventsOutOfSynchronization(FolderId folderId) throws Exception {
        List<CalendarEvent> events = this.exoStorageService.getUserCalendarEvents(this.username, folderId.getUniqueId());
        for (CalendarEvent calendarEvent : events) {
            if (this.correspondenceService.getCorrespondingId(this.username, calendarEvent.getId()) == null) {
                this.exoStorageService.deleteEvent(this.username, calendarEvent);
                continue;
            }
            String itemId = this.correspondenceService.getCorrespondingId(this.username, calendarEvent.getId());
            Appointment appointment = this.exchangeStorageService.getAppointment(this.service, itemId);
            if (appointment != null) continue;
            this.exoStorageService.deleteEvent(this.username, calendarEvent);
        }
    }

    private void synchronizeAllExchangeAppointments(List<String> eventIds, Iterable<Item> items) throws Exception, ServiceLocalException {
        for (Item item : items) {
            if (item instanceof Appointment) {
                List<CalendarEvent> updatedEvents = this.exoStorageService.createOrUpdateEvent((Appointment)item, this.username, this.getUserExoCalenarTimeZoneSetting());
                if (updatedEvents == null || updatedEvents.isEmpty()) continue;
                for (CalendarEvent calendarEvent : updatedEvents) {
                    eventIds.add(calendarEvent.getId());
                }
                continue;
            }
            LOG.warn((Object)("Item bound from exchange but not of type 'Appointment':" + item.getItemClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserLastCheckDate(long time) throws Exception {
        if (this.organizationService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)this.organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
        }
        try {
            long savedTime;
            UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(this.username);
            userProfile.setAttribute(USER_EXCHANGE_HANDLED_ATTRIBUTE, "" + time);
            long l = savedTime = userProfile.getAttribute(USER_EXO_HANDLED_ATTRIBUTE) == null ? 0L : Long.valueOf(userProfile.getAttribute(USER_EXO_HANDLED_ATTRIBUTE));
            if (time > savedTime) {
                userProfile.setAttribute(USER_EXO_HANDLED_ATTRIBUTE, "" + time);
            }
            this.organizationService.getUserProfileHandler().saveUserProfile(userProfile, false);
        }
        finally {
            if (this.organizationService instanceof ComponentRequestLifecycle) {
                ((ComponentRequestLifecycle)this.organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getUserLastCheckDate() throws Exception {
        if (this.organizationService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)this.organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
        }
        try {
            UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(this.username);
            long time = userProfile.getAttribute(USER_EXCHANGE_HANDLED_ATTRIBUTE) == null ? 0L : Long.valueOf(userProfile.getAttribute(USER_EXCHANGE_HANDLED_ATTRIBUTE));
            Date lastSyncDate = null;
            if (time > 0L) {
                lastSyncDate = new Date(time);
            }
            Date date = lastSyncDate;
            return date;
        }
        finally {
            if (this.organizationService instanceof ComponentRequestLifecycle) {
                ((ComponentRequestLifecycle)this.organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserExoLastCheckDate(long time) throws Exception {
        if (this.organizationService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)this.organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
        }
        try {
            long savedTime;
            UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(this.username);
            long l = savedTime = userProfile.getAttribute(USER_EXO_HANDLED_ATTRIBUTE) == null ? 0L : Long.valueOf(userProfile.getAttribute(USER_EXO_HANDLED_ATTRIBUTE));
            if (savedTime <= 0L) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("User '" + this.username + "' exo last check time was not set before, may be the synhronization was not run before or an error occured in the meantime."));
                }
            } else {
                userProfile.setAttribute(USER_EXO_HANDLED_ATTRIBUTE, "" + time);
                this.organizationService.getUserProfileHandler().saveUserProfile(userProfile, false);
            }
        }
        finally {
            if (this.organizationService instanceof ComponentRequestLifecycle) {
                ((ComponentRequestLifecycle)this.organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getUserExoLastCheckDate() throws Exception {
        if (this.organizationService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)this.organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
        }
        try {
            UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(this.username);
            long time = userProfile.getAttribute(USER_EXO_HANDLED_ATTRIBUTE) == null ? 0L : Long.valueOf(userProfile.getAttribute(USER_EXO_HANDLED_ATTRIBUTE));
            Date lastSyncDate = null;
            if (time > 0L) {
                lastSyncDate = new Date(time);
            }
            Date date = lastSyncDate;
            return date;
        }
        finally {
            if (this.organizationService instanceof ComponentRequestLifecycle) {
                ((ComponentRequestLifecycle)this.organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserArrtibute(OrganizationService organizationService, String username, String name, String value) throws Exception {
        if (organizationService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
        }
        try {
            UserProfile userProfile;
            if (USER_EXCHANGE_PASSWORD_ATTRIBUTE.equals(name)) {
                value = IntegrationService.encodePassword(value);
            }
            if ((userProfile = organizationService.getUserProfileHandler().findUserProfileByName(username)) == null) {
                userProfile = organizationService.getUserProfileHandler().createUserProfileInstance(username);
                organizationService.getUserProfileHandler().saveUserProfile(userProfile, true);
            }
            userProfile.setAttribute(name, value);
            organizationService.getUserProfileHandler().saveUserProfile(userProfile, false);
        }
        finally {
            if (organizationService instanceof ComponentRequestLifecycle) {
                ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserArrtibute(OrganizationService organizationService, String username, String name) throws Exception {
        if (organizationService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
        }
        try {
            UserProfile userProfile = organizationService.getUserProfileHandler().findUserProfileByName(username);
            String value = null;
            if (userProfile != null && (value = userProfile.getAttribute(name)) != null && USER_EXCHANGE_PASSWORD_ATTRIBUTE.equals(name)) {
                value = IntegrationService.decodePassword(value);
            }
            String string = value;
            return string;
        }
        finally {
            if (organizationService instanceof ComponentRequestLifecycle) {
                ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
        }
    }

    public ExchangeService getService() {
        return this.service;
    }

    private TimeZone getUserExoCalenarTimeZoneSetting() {
        try {
            CalendarSetting calendarSetting = this.calendarService.getCalendarSetting(this.username);
            return TimeZone.getTimeZone(calendarSetting.getTimeZone());
        }
        catch (Exception e) {
            LOG.error((Object)("Error while getting user '" + this.username + "'Calendar TimeZone setting, use default, this may cause some inconsistance."));
            return TimeZone.getDefault();
        }
    }

    private void synchronizeExoEventsByModificationDate(FolderId folderId, List<String> updatedExoEventIDs, Date exoLastSyncDate) throws Exception {
        List<CalendarEvent> modifiedCalendarEvents = this.searchCalendarEventsModifiedSince(this.getUserCalendarByExchangeFolderId(folderId), exoLastSyncDate);
        for (CalendarEvent calendarEvent : modifiedCalendarEvents) {
            boolean deleteEvent;
            if (updatedExoEventIDs.contains(calendarEvent.getId())) continue;
            String exoMasterId = null;
            if (calendarEvent.getIsExceptionOccurrence() != null && calendarEvent.getIsExceptionOccurrence().booleanValue() && (exoMasterId = this.exoStorageService.getExoEventMasterRecurenceByOriginalUUID(calendarEvent.getOriginalReference())) == null) {
                LOG.error((Object)("No master Id was found for occurence: " + calendarEvent.getSummary() + " with recurrenceId = " + calendarEvent.getRecurrenceId() + ". The event will not be updated."));
            }
            if (deleteEvent = this.exchangeStorageService.updateOrCreateExchangeAppointment(this.username, this.service, calendarEvent, exoMasterId, this.getUserExoCalenarTimeZoneSetting(), null)) {
                this.exoStorageService.deleteEvent(this.username, calendarEvent);
            }
            updatedExoEventIDs.add(calendarEvent.getId());
        }
    }

    private void synchronizeNewExoEvents(FolderId folderId, List<String> updatedExoEventIDs, Date exoLastSyncDate) throws Exception {
        Iterable<CalendarEvent> unsynchronizedEvents = this.searchUnsynchronizedAppointments(this.username, folderId.getUniqueId());
        for (CalendarEvent calendarEvent : unsynchronizedEvents) {
            if (updatedExoEventIDs != null && updatedExoEventIDs.contains(calendarEvent.getId()) || calendarEvent.getLastUpdatedTime() == null) continue;
            if (calendarEvent.getLastUpdatedTime().after(exoLastSyncDate)) {
                String exoMasterId = null;
                if (calendarEvent.getIsExceptionOccurrence() != null && calendarEvent.getIsExceptionOccurrence().booleanValue() && (exoMasterId = this.exoStorageService.getExoEventMasterRecurenceByOriginalUUID(calendarEvent.getOriginalReference())) == null) {
                    LOG.error((Object)("No master Id was found for occurence: " + calendarEvent.getSummary() + " with recurrenceId = " + calendarEvent.getRecurrenceId() + ". The event will not be updated."));
                    continue;
                }
                boolean deleteEvent = this.exchangeStorageService.updateOrCreateExchangeAppointment(this.username, this.service, calendarEvent, exoMasterId, this.getUserExoCalenarTimeZoneSetting(), null);
                if (deleteEvent) {
                    this.exoStorageService.deleteEvent(this.username, calendarEvent);
                }
                if (updatedExoEventIDs == null) continue;
                updatedExoEventIDs.add(calendarEvent.getId());
                continue;
            }
            this.exoStorageService.deleteEvent(this.username, calendarEvent);
        }
    }

    private void synchronizeAppointmentsByModificationDate(FolderId folderId, Date lastSyncDate, List<String> updatedExoEventIDs, int diffTimeZone) throws Exception, ServiceLocalException, ParseException {
        List<Item> items = this.searchAllAppointmentsModifiedSince(folderId, lastSyncDate, diffTimeZone);
        for (Item item : items) {
            if (item instanceof Appointment) {
                CalendarEvent event = this.exoStorageService.getEventByAppointmentId(this.username, item.getId().getUniqueId());
                if (event != null) {
                    List<CalendarEvent> updatedEvents;
                    if (updatedExoEventIDs != null && updatedExoEventIDs.contains(event.getId())) continue;
                    Date eventModifDate = CalendarConverterService.convertDateToUTC(event.getLastUpdatedTime());
                    Date itemModifDate = item.getLastModifiedTime();
                    if (!itemModifDate.after(eventModifDate) || (updatedEvents = this.exoStorageService.updateEvent((Appointment)item, this.username, this.getUserExoCalenarTimeZoneSetting())) == null || updatedEvents.isEmpty() || updatedExoEventIDs == null) continue;
                    for (CalendarEvent calendarEvent : updatedEvents) {
                        updatedExoEventIDs.add(calendarEvent.getId());
                    }
                    continue;
                }
                List<CalendarEvent> updatedEvents = this.exoStorageService.createEvent((Appointment)item, this.username, this.getUserExoCalenarTimeZoneSetting());
                if (updatedEvents == null || updatedEvents.isEmpty() || updatedExoEventIDs == null) continue;
                for (CalendarEvent calendarEvent : updatedEvents) {
                    updatedExoEventIDs.add(calendarEvent.getId());
                }
                continue;
            }
            LOG.warn((Object)("Item bound from exchange but not of type 'Appointment':" + item.getItemClass()));
        }
    }

    private Iterable<CalendarEvent> searchUnsynchronizedAppointments(String username, String folderId) throws Exception {
        List<CalendarEvent> calendarEvents = this.exoStorageService.getUserCalendarEvents(username, folderId);
        Iterator<CalendarEvent> calendarEventsIterator = calendarEvents.iterator();
        while (calendarEventsIterator.hasNext()) {
            Appointment appointment;
            CalendarEvent calendarEvent = calendarEventsIterator.next();
            String itemId = this.correspondenceService.getCorrespondingId(username, calendarEvent.getId());
            if (itemId == null || (appointment = this.exchangeStorageService.getAppointment(this.service, ItemId.getItemIdFromString((String)itemId))) == null) continue;
            calendarEventsIterator.remove();
        }
        return calendarEvents;
    }

    private List<Item> searchAllItems(FolderId parentFolderId) throws Exception {
        ItemView view = new ItemView(1000);
        view.setPropertySet(new PropertySet(BasePropertySet.FirstClassProperties));
        FindItemsResults findResults = this.service.findItems(parentFolderId, view);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Exchange user calendar '" + this.username + "', items found: " + findResults.getTotalCount()));
        }
        return findResults.getItems();
    }

    private List<CalendarEvent> searchCalendarEventsModifiedSince(Calendar calendar, Date date) throws Exception {
        if (date == null) {
            return this.exoStorageService.getAllExoEvents(this.username, calendar);
        }
        return this.exoStorageService.findExoEventsModifiedSince(this.username, calendar, date);
    }

    private List<Item> searchAllAppointmentsModifiedSince(FolderId parentFolderId, Date date, int diffTimeZone) throws Exception {
        if (date == null) {
            return this.searchAllItems(parentFolderId);
        }
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, diffTimeZone);
        calendar.add(13, 1);
        ItemView view = new ItemView(100);
        view.setPropertySet(new PropertySet(BasePropertySet.FirstClassProperties));
        FindItemsResults findResults = this.service.findItems(parentFolderId, (SearchFilter)new SearchFilter.IsGreaterThan((PropertyDefinitionBase)ItemSchema.LastModifiedTime, (Object)calendar.getTime()), view);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Exchange user calendar '" + this.username + "', items found: " + findResults.getTotalCount()));
        }
        return findResults.getItems();
    }

    private static void initCodec() throws Exception {
        HashMap<String, String> config;
        String builderType;
        block16: {
            block15: {
                builderType = PropertyManager.getProperty((String)"gatein.codec.builderclass");
                config = new HashMap<String, String>();
                if (builderType == null) break block15;
                String configFile = PropertyManager.getProperty((String)"gatein.codec.config");
                FileInputStream in = null;
                try {
                    File f = new File(configFile);
                    in = new FileInputStream(f);
                    Properties properties = new Properties();
                    properties.load(in);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        config.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    config.put("gatein.codec.config.basedir", f.getParentFile().getAbsolutePath());
                }
                catch (IOException e) {
                    try {
                        throw new TokenServiceInitializationException("Failed to read the config parameters from file '" + configFile + "'.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOTools.safeClose(in);
                        throw throwable;
                    }
                }
                IOTools.safeClose((Closeable)in);
                break block16;
            }
            builderType = "org.exoplatform.web.security.codec.JCASymmetricCodecBuilder";
            String gtnConfDir = PropertyManager.getProperty((String)"gatein.conf.dir");
            if (gtnConfDir == null || gtnConfDir.length() == 0) {
                throw new TokenServiceInitializationException("'gatein.conf.dir' property must be set.");
            }
            File f = new File(gtnConfDir + "/codec/codeckey.txt");
            if (!f.exists()) {
                File codecDir = f.getParentFile();
                if (!codecDir.exists()) {
                    codecDir.mkdir();
                }
                FileOutputStream out = null;
                try {
                    KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                    keyGen.init(128);
                    SecretKey key = keyGen.generateKey();
                    KeyStore store = KeyStore.getInstance("JCEKS");
                    store.load(null, "gtnStorePass".toCharArray());
                    store.setEntry("gtnKey", new KeyStore.SecretKeyEntry(key), new KeyStore.PasswordProtection("gtnKeyPass".toCharArray()));
                    out = new FileOutputStream(f);
                    store.store(out, "gtnStorePass".toCharArray());
                }
                catch (Exception e) {
                    try {
                        throw new TokenServiceInitializationException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOTools.safeClose(out);
                        throw throwable;
                    }
                }
                IOTools.safeClose((Closeable)out);
            }
            config.put("gatein.codec.jca.symmetric.keyalg", "AES");
            config.put("gatein.codec.jca.symmetric.keystore", "codeckey.txt");
            config.put("gatein.codec.jca.symmetric.storetype", "JCEKS");
            config.put("gatein.codec.jca.symmetric.alias", "gtnKey");
            config.put("gatein.codec.jca.symmetric.keypass", "gtnKeyPass");
            config.put("gatein.codec.jca.symmetric.storepass", "gtnStorePass");
            config.put("gatein.codec.config.basedir", f.getParentFile().getAbsolutePath());
        }
        try {
            codec = Class.forName(builderType).asSubclass(AbstractCodecBuilder.class).newInstance().build(config);
            LOG.info((Object)("Initialized CookieTokenService.codec using builder " + builderType));
        }
        catch (Exception e) {
            throw new TokenServiceInitializationException("Could not initialize CookieTokenService.codec.", (Throwable)e);
        }
    }

    private static String decodePassword(String password) {
        try {
            if (codec == null) {
                IntegrationService.initCodec();
            }
            password = codec.decode(password);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while decoding password, it will be used in plain text", (Throwable)e);
        }
        return password;
    }

    private static String encodePassword(String password) {
        try {
            if (codec == null) {
                IntegrationService.initCodec();
            }
            password = codec.encode(password);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while encoding password, it will be used in plain text", (Throwable)e);
        }
        return password;
    }
}

