/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.listener;

import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.commons.chain.Context;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.extension.exchange.service.IntegrationService;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;

public class CalendarCreateUpdateAction
implements Action {
    public static final ThreadLocal<Long> MODIFIED_DATE = new ThreadLocal();
    private static final ThreadLocal<Boolean> IGNORE_UPDATE = new ThreadLocal();
    private static final List<String> PROPERTIES_WATCHED = Arrays.asList("exo:participantStatus", "exo:repeatInterval", "exo:repeatFinishDate", "exo:repeatByMonthDay", "exo:repeatByDay");
    private static final String EXO_DATETIME_PROPERTY = "exo:datetime";
    private static final Log LOG = ExoLogger.getLogger(CalendarCreateUpdateAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context context) throws Exception {
        block16: {
            if (IGNORE_UPDATE.get() != null && IGNORE_UPDATE.get().booleanValue()) {
                return false;
            }
            Object object = context.get((Object)"currentItem");
            Node node = null;
            Property property = null;
            if (object instanceof Node) {
                node = (Node)object;
            } else if (object instanceof Property) {
                property = (Property)object;
                node = property.getParent();
            }
            if (!this.isNodeValid(node)) {
                return false;
            }
            if (property != null && !this.isLastPropertyToSet(node, property)) {
                return false;
            }
            String eventId = node.getName();
            try {
                String userId = null;
                ConversationState state = ConversationState.getCurrent();
                userId = state == null || state.getIdentity() == null || state.getIdentity().getUserId().equals(IdentityConstants.ANONIM) ? node.getNode("../../../../..").getName() : state.getIdentity().getUserId();
                if (userId == null) {
                    LOG.warn((Object)("No user was found while trying to create/update eXo Calendar event with id: " + eventId));
                    return false;
                }
                IntegrationService integrationService = IntegrationService.getInstance(userId);
                if (integrationService == null) {
                    LOG.trace("No authenticated user was found while trying to create/update eXo Calendar event with id: '{}' for user: {}", new Object[]{eventId, userId});
                    return false;
                }
                if (MODIFIED_DATE.get() == null || MODIFIED_DATE.get() == 0L) {
                    boolean started;
                    String calendarId;
                    String string = calendarId = node.hasProperty("exo:calendarId") ? node.getProperty("exo:calendarId").getString() : null;
                    if (!integrationService.isCalendarSynchronizedWithExchange(calendarId) || !(started = integrationService.setSynchronizationStarted())) break block16;
                    try {
                        this.modifyUpdateDate(node, System.currentTimeMillis());
                        integrationService.updateOrCreateExchangeCalendarEvent(node);
                        break block16;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error while create/update an Exchange item for eXo event: " + eventId), (Throwable)e);
                        break block16;
                    }
                    finally {
                        integrationService.setSynchronizationStopped();
                    }
                }
                this.modifyUpdateDate(node, MODIFIED_DATE.get());
            }
            catch (Exception e) {
                LOG.error((Object)("Error while updating Exchange with the eXo Event with Id: " + eventId), (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyUpdateDate(Node node, long lastModifiedDate) throws Exception {
        IGNORE_UPDATE.set(true);
        try {
            GregorianCalendar modifiedDate = new GregorianCalendar();
            if (lastModifiedDate > 0L) {
                modifiedDate.setTimeInMillis(lastModifiedDate);
            }
            if (!node.isNodeType(EXO_DATETIME_PROPERTY)) {
                if (node.canAddMixin(EXO_DATETIME_PROPERTY)) {
                    node.addMixin(EXO_DATETIME_PROPERTY);
                }
                node.setProperty("exo:dateCreated", (Calendar)modifiedDate);
            }
            node.setProperty("exo:dateModified", (Calendar)modifiedDate);
        }
        finally {
            IGNORE_UPDATE.set(false);
        }
    }

    private boolean isLastPropertyToSet(Node node, Property property) throws Exception {
        String repeatType;
        Long repeatCount;
        Calendar dateRepeatTo;
        String propertyName = property.getName();
        if (!PROPERTIES_WATCHED.contains(propertyName)) {
            return false;
        }
        if (!node.isNodeType("exo:repeatCalendarEvent")) {
            return true;
        }
        Calendar calendar = dateRepeatTo = node.hasProperty("exo:repeatUntil") && node.getProperty("exo:repeatUntil") != null && node.getProperty("exo:repeatUntil").getValue() != null ? node.getProperty("exo:repeatUntil").getDate() : null;
        if (dateRepeatTo != null) {
            return propertyName.equals("exo:repeatFinishDate");
        }
        Long l = repeatCount = node.hasProperty("exo:repeatCount") && node.getProperty("exo:repeatCount") != null && node.getProperty("exo:repeatCount").getValue() != null ? Long.valueOf(node.getProperty("exo:repeatCount").getLong()) : null;
        if (repeatCount != null && repeatCount > 0L) {
            return propertyName.equals("exo:repeatFinishDate");
        }
        String string = repeatType = node.hasProperty("exo:repeat") && node.getProperty("exo:repeat") != null && node.getProperty("exo:repeat").getValue() != null ? node.getProperty("exo:repeat").getString() : null;
        if (StringUtils.equals(repeatType, (String)CalendarEvent.RP_WEEKLY)) {
            return propertyName.equals("exo:repeatByDay");
        }
        if (StringUtils.equals(repeatType, (String)CalendarEvent.RP_MONTHLY)) {
            return propertyName.equals("exo:repeatByMonthDay");
        }
        return true;
    }

    private boolean isNodeValid(Node node) throws Exception {
        return node != null && node.isNodeType("exo:calendarEvent");
    }
}

