/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.listener;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.extension.exchange.listener.IntegrationListener;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;

@Asynchronous
public class ExchangeLoginListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(ExchangeLoginListener.class);
    private IntegrationListener exchangeListenerService;

    public ExchangeLoginListener(IntegrationListener integrationListener) {
        this.exchangeListenerService = integrationListener;
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        String eventName = event.getEventName();
        if (eventName.endsWith(".unregister")) {
            String username;
            String string = username = event.getData() == null || ((ConversationState)event.getData()).getIdentity() == null ? null : ((ConversationState)event.getData()).getIdentity().getUserId();
            if (StringUtils.isNotBlank(username) && !username.equals(IdentityConstants.ANONIM)) {
                try {
                    this.exchangeListenerService.userLoggedOut(username);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while user logout from MS Exchange Server", (Throwable)e);
                }
            }
        } else {
            String username = ((ConversationState)event.getData()).getIdentity().getUserId();
            if (StringUtils.isNotBlank((String)username) && !username.equals(IdentityConstants.ANONIM)) {
                try {
                    this.exchangeListenerService.userLoggedIn(username, null);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while authenticating user to MS Exchange Server", (Throwable)e);
                }
            }
        }
    }
}

