/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.box;

import com.box.boxjavalibv2.BoxClient;
import com.box.boxjavalibv2.BoxConfigBuilder;
import com.box.boxjavalibv2.BoxRESTClient;
import com.box.boxjavalibv2.authorization.IAuthSecureStorage;
import com.box.boxjavalibv2.authorization.OAuthDataController;
import com.box.boxjavalibv2.authorization.OAuthRefreshListener;
import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxEnterprise;
import com.box.boxjavalibv2.dao.BoxEvent;
import com.box.boxjavalibv2.dao.BoxEventCollection;
import com.box.boxjavalibv2.dao.BoxFile;
import com.box.boxjavalibv2.dao.BoxFolder;
import com.box.boxjavalibv2.dao.BoxItem;
import com.box.boxjavalibv2.dao.BoxOAuthToken;
import com.box.boxjavalibv2.dao.BoxServerError;
import com.box.boxjavalibv2.dao.BoxSharedLink;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import com.box.boxjavalibv2.dao.BoxUser;
import com.box.boxjavalibv2.dao.IAuthData;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxJSONException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.jsonparsing.BoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.BoxResourceHub;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.box.boxjavalibv2.requests.requestobjects.BoxEventRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxFileRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxFolderDeleteRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxFolderRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxItemCopyRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxItemRestoreRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxRequestExtras;
import com.box.boxjavalibv2.utils.ISO8601DateParser;
import com.box.boxjavalibv2.utils.Utils;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import com.box.restclientv2.requestsbase.BoxFileUploadRequestObject;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.ConflictException;
import org.exoplatform.clouddrive.FileTrashRemovedException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.box.BoxException;
import org.exoplatform.clouddrive.oauth2.UserToken;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BoxAPI {
    protected static final Log LOG = ExoLogger.getLogger(BoxAPI.class);
    public static final int BOX_PAGE_SIZE = 100;
    public static final String NO_STATE = "__no_state_set__";
    public static final String BOX_ROOT_ID = "0";
    public static final String BOX_TRASH_ID = "1";
    public static final String BOX_ITEM_STATE_ACTIVE = "active";
    public static final String BOX_ITEM_STATE_TRASHED = "trashed";
    public static final String BOX_APP_URL = "https://app.box.com/";
    protected static final String BOX_FILES_PATH = "files/0/f/";
    public static final String BOX_FILE_URL = "https://app.box.com/files/0/f/";
    public static final String BOX_WEBDOCUMENT_EXT = "webdoc";
    public static final String BOX_WEBDOCUMENT_MIMETYPE = "application/x-exo.box.webdoc";
    public static final String BOX_NOTE_EXT = "boxnote";
    public static final String BOX_NOTE_MIMETYPE = "application/x-exo.box.note";
    public static final String BOX_EMBED_URL = "https://%sapp.box.com/embed_widget/000000000000/%s?view=list&sort=date&theme=gray&show_parent_path=no&show_item_feed_actions=no&session_expired=true";
    public static final String BOX_EMBED_URL_SSO = "https://app.box.com/login/auto_initiate_sso?enterprise_id=%s&redirect_url=%s";
    public static final Pattern BOX_URL_CUSTOM_PATTERN = Pattern.compile("^https://([\\p{ASCII}]*){1}?\\.app\\.box\\.com/.*\\z");
    public static final Pattern BOX_URL_MAKE_CUSTOM_PATTERN = Pattern.compile("^(https)://(app\\.box\\.com/.*)\\z");
    public static final Set<String> BOX_EVENTS = new HashSet<String>();
    private StoredToken token;
    private BoxClient client;
    private ChangesLink changesLink;
    private String enterpriseId;
    private String enterpriseName;
    private String customDomain;

    BoxAPI(String key, String clientSecret, String authCode, String redirectUri) throws BoxException, CloudDriveException {
        BoxResourceHub hub = new BoxResourceHub();
        BoxJSONParser parser = new BoxJSONParser((IBoxResourceHub)hub);
        this.client = new BoxClient(key, clientSecret, (IBoxResourceHub)hub, (IBoxJSONParser)parser, (IBoxRESTClient)new RESTClient(), new BoxConfigBuilder().build());
        this.token = new StoredToken();
        this.client.addOAuthRefreshListener((OAuthRefreshListener)this.token);
        try {
            BoxOAuthToken bt = this.client.getOAuthManager().createOAuth(authCode, key, clientSecret, redirectUri);
            this.token.store(bt);
            this.client.authenticate((IAuthData)bt);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error submiting authentication code: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            throw new BoxException("Error authenticating user code: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            throw new BoxException("Authentication code error: " + e.getMessage(), e);
        }
        this.updateChangesLink();
        this.initUser();
    }

    BoxAPI(String key, String clientSecret, String accessToken, String refreshToken, long expirationTime) throws CloudDriveException {
        BoxResourceHub hub = new BoxResourceHub();
        BoxJSONParser parser = new BoxJSONParser((IBoxResourceHub)hub);
        this.client = new BoxClient(key, clientSecret, (IBoxResourceHub)hub, (IBoxJSONParser)parser, (IBoxRESTClient)new RESTClient(), new BoxConfigBuilder().build());
        this.token = new StoredToken();
        this.token.load(accessToken, refreshToken, expirationTime);
        this.client.addOAuthRefreshListener((OAuthRefreshListener)this.token);
        this.client.authenticateFromSecureStorage((IAuthSecureStorage)this.token);
        this.initUser();
    }

    void updateToken(UserToken newToken) throws CloudDriveException {
        this.token.merge(newToken);
    }

    StoredToken getToken() {
        return this.token;
    }

    BoxUser getCurrentUser() throws BoxException, RefreshAccessException {
        BoxDefaultRequestObject obj = new BoxDefaultRequestObject();
        obj.getRequestExtras().addField("id");
        obj.getRequestExtras().addField("type");
        obj.getRequestExtras().addField("name");
        obj.getRequestExtras().addField("login");
        obj.getRequestExtras().addField("created_at");
        obj.getRequestExtras().addField("modified_at");
        obj.getRequestExtras().addField("status");
        obj.getRequestExtras().addField("job_title");
        obj.getRequestExtras().addField("phone");
        obj.getRequestExtras().addField("address");
        obj.getRequestExtras().addField("avatar_url");
        obj.getRequestExtras().addField("role");
        obj.getRequestExtras().addField("enterprise");
        try {
            return this.client.getUsersManager().getCurrentUser(obj);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error requesting current user: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            throw new BoxException("Error getting current user: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error for current user: " + e.getMessage(), e);
        }
    }

    BoxFolder getRootFolder() throws BoxException {
        try {
            BoxFolder root = this.client.getFoldersManager().getFolder(BOX_ROOT_ID, null);
            return root;
        }
        catch (BoxRestException e) {
            throw new BoxException("Error getting root folder: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            throw new BoxException("Error reading root folder: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            throw new BoxException("Authentication error for root folder: " + e.getMessage(), e);
        }
    }

    ItemsIterator getFolderItems(String folderId) throws CloudDriveException {
        return new ItemsIterator(folderId);
    }

    Calendar parseDate(String dateString) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        Date d = ISO8601DateParser.parse((String)dateString);
        calendar.setTime(d);
        return calendar;
    }

    String formatDate(Calendar date) {
        return ISO8601DateParser.toString((Date)date.getTime());
    }

    String getLink(BoxItem item) {
        CharSequence link;
        BoxSharedLink shared = item.getSharedLink();
        if (shared != null && (link = shared.getUrl()) != null) {
            return this.link((String)link);
        }
        link = new StringBuilder();
        ((StringBuilder)link).append(this.link(BOX_FILE_URL));
        String id = item.getId();
        if (BOX_ROOT_ID.equals(id)) {
            ((StringBuilder)link).append(id);
        } else if (item instanceof BoxFile) {
            String parentId = item.getParent().getId();
            ((StringBuilder)link).append(parentId);
            ((StringBuilder)link).append("/1/f_");
            ((StringBuilder)link).append(id);
        } else if (item instanceof BoxFolder) {
            ((StringBuilder)link).append(id);
            ((StringBuilder)link).append('/');
            ((StringBuilder)link).append(item.getName());
        } else {
            ((StringBuilder)link).append(BOX_ROOT_ID);
        }
        ((StringBuilder)link).append("/");
        return ((StringBuilder)link).toString();
    }

    String getEmbedLink(BoxItem item) {
        String link;
        String[] lparts;
        StringBuilder linkValue = new StringBuilder();
        BoxSharedLink shared = item.getSharedLink();
        if (shared != null && (lparts = (link = shared.getUrl()).split("/")).length > 3 && lparts[lparts.length - 2].equals("s")) {
            linkValue.append("s/");
            linkValue.append(lparts[lparts.length - 1]);
        }
        if (linkValue.length() == 0) {
            linkValue.append(BOX_FILES_PATH);
            String id = item.getId();
            if (BOX_ROOT_ID.equals(id)) {
                linkValue.append(id);
            } else if (item instanceof BoxFile) {
                String parentId = item.getParent().getId();
                linkValue.append(parentId);
                linkValue.append("/1/f_");
                linkValue.append(id);
            } else if (item instanceof BoxFolder) {
                linkValue.append(id);
            } else {
                linkValue.append(BOX_ROOT_ID);
            }
        }
        if (this.customDomain != null) {
            return String.format(BOX_EMBED_URL, this.customDomain + ".", linkValue.toString());
        }
        return String.format(BOX_EMBED_URL, "", linkValue.toString());
    }

    String getThumbnailLink(BoxItem item) {
        return this.getLink(item);
    }

    ChangesLink getChangesLink() throws BoxException, RefreshAccessException {
        if (this.changesLink == null || this.changesLink.isOutdated()) {
            this.updateChangesLink();
        }
        return this.changesLink;
    }

    void updateChangesLink() throws BoxException, RefreshAccessException {
        BoxDefaultRequestObject obj = new BoxDefaultRequestObject();
        try {
            long retryTimeout;
            long maxRetries;
            long ttl;
            String type;
            String url;
            BoxCollection changesPoll = this.client.getEventsManager().getEventOptions(obj);
            ArrayList ce = changesPoll.getEntries();
            if (ce.size() > 0) {
                BoxTypedObject c = (BoxTypedObject)ce.get(0);
                Object urlObj = c.getValue("url");
                url = urlObj != null ? urlObj.toString() : null;
                Object typeObj = c.getValue("type");
                type = typeObj != null ? typeObj.toString() : null;
                Object ttlObj = c.getValue("ttl");
                if (ttlObj == null) {
                    ttlObj = c.getExtraData("ttl");
                }
                try {
                    ttl = ttlObj != null ? Long.parseLong(ttlObj.toString()) : 10L;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Error parsing ttl value in Events response [" + ttlObj + "]: " + e));
                    ttl = 10L;
                }
                Object maxRetriesObj = c.getValue("max_retries");
                if (maxRetriesObj == null) {
                    maxRetriesObj = c.getExtraData("max_retries");
                }
                try {
                    maxRetries = maxRetriesObj != null ? Long.parseLong(maxRetriesObj.toString()) : 0L;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Error parsing max_retries value in Events response [" + maxRetriesObj + "]: " + e));
                    maxRetries = 2L;
                }
                Object retryTimeoutObj = c.getValue("retry_timeout");
                if (retryTimeoutObj == null) {
                    retryTimeoutObj = c.getExtraData("retry_timeout");
                }
                try {
                    retryTimeout = retryTimeoutObj != null ? Long.parseLong(retryTimeoutObj.toString()) * 1000L : 600000L;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Error parsing retry_timeout value in Events response [" + retryTimeoutObj + "]: " + e));
                    retryTimeout = 600000L;
                }
            } else {
                throw new BoxException("Empty entries from Events service.");
            }
            this.changesLink = new ChangesLink(type, url, ttl, maxRetries, retryTimeout);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error requesting changes long poll URL: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            throw new BoxException("Error reading changes long poll URL: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error for changes long poll URL: " + e.getMessage(), e);
        }
    }

    EventsIterator getEvents(long streamPosition) throws BoxException, RefreshAccessException {
        return new EventsIterator(streamPosition);
    }

    BoxFile createFile(String parentId, String name, Calendar created, InputStream data) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            try {
                this.readFolder(parentId);
            }
            catch (NotFoundException e) {
                throw new NotFoundException("Parent not found " + parentId + ". Cannot start file uploading " + name, (Throwable)e);
            }
            BoxFileUploadRequestObject obj = BoxFileUploadRequestObject.uploadFileRequestObject((String)parentId, (String)name, (InputStream)data);
            obj.setLocalFileCreatedAt(created.getTime());
            obj.put("created_at", (Object)this.formatDate(created));
            return this.client.getFilesManager().uploadFile(obj);
        }
        catch (BoxJSONException e) {
            throw new BoxException("Error uploading file: " + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxException("Error uploading file: " + e.getMessage(), e);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error uploading file: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("Parent not found " + parentId + ". File uploading canceled for " + name, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to upload a file " + name, (Throwable)e);
            }
            if (status == 409) {
                throw new ConflictException("File with the same name as creating already exists " + name, (Throwable)e);
            }
            throw new BoxException("Error uploading file: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when uploading file: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BoxException("File " + name + " uploading interrupted.", e);
        }
    }

    BoxFolder createFolder(String parentId, String name, Calendar created) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            BoxFolderRequestObject obj = BoxFolderRequestObject.createFolderRequestObject((String)name, (String)parentId);
            obj.put("created_at", (Object)this.formatDate(created));
            return this.client.getFoldersManager().createFolder(obj);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error creating folder: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("Parent not found " + parentId, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to create a folder " + name, (Throwable)e);
            }
            if (status == 409) {
                throw new ConflictException("File with the same name as creating already exists " + name, (Throwable)e);
            }
            throw new BoxException("Error creating folder: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when creating folder: " + e.getMessage(), e);
        }
    }

    BoxFolder createSharedFolder(String parentId, String name, Calendar created) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            BoxFolderRequestObject obj = BoxFolderRequestObject.createSharedLinkRequestObject(null);
            obj.put("created_at", (Object)this.formatDate(created));
            return this.client.getSharedFoldersManager("sharedLink", "password").createFolder(obj);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error creating folder: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("Parent not found " + parentId, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to create a folder " + name, (Throwable)e);
            }
            if (status == 409) {
                throw new ConflictException("File with the same name as creating already exists " + name, (Throwable)e);
            }
            throw new BoxException("Error creating folder: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when creating folder: " + e.getMessage(), e);
        }
    }

    void deleteFile(String id) throws BoxException, NotFoundException, RefreshAccessException {
        try {
            BoxDefaultRequestObject obj = new BoxDefaultRequestObject();
            this.client.getFilesManager().deleteFile(id, obj);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error deleting file: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to the file " + id, (Throwable)e);
            }
            throw new BoxException("Error deleting file: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when deleting file: " + e.getMessage(), e);
        }
    }

    void deleteFolder(String id) throws BoxException, NotFoundException, RefreshAccessException {
        try {
            BoxFolderDeleteRequestObject obj = BoxFolderDeleteRequestObject.deleteFolderRequestObject((boolean)true);
            this.client.getFoldersManager().deleteFolder(id, obj);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error deleting folder: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to the folder " + id, (Throwable)e);
            }
            throw new BoxException("Error deleting folder: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when deleting folder: " + e.getMessage(), e);
        }
    }

    BoxFile trashFile(String id) throws BoxException, FileTrashRemovedException, NotFoundException, RefreshAccessException {
        try {
            BoxDefaultRequestObject deleteObj = new BoxDefaultRequestObject();
            this.client.getFilesManager().deleteFile(id, deleteObj);
            try {
                BoxDefaultRequestObject trashObj = new BoxDefaultRequestObject();
                return this.client.getTrashManager().getTrashFile(id, trashObj);
            }
            catch (BoxRestException e) {
                throw new BoxException("Error reading trashed file: " + e.getMessage(), e);
            }
            catch (BoxServerException e) {
                int status = this.getErrorStatus(e);
                if (status == 404 || status == 412) {
                    throw new FileTrashRemovedException("Trashed file deleted permanently " + id);
                }
                throw new BoxException("Error reading trashed file: " + e.getMessage(), e);
            }
        }
        catch (BoxRestException e) {
            throw new BoxException("Error trashing file: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to the file " + id, (Throwable)e);
            }
            throw new BoxException("Error trashing file: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when trashing file: " + e.getMessage(), e);
        }
    }

    BoxFolder trashFolder(String id) throws BoxException, FileTrashRemovedException, NotFoundException, RefreshAccessException {
        try {
            BoxFolderDeleteRequestObject deleteObj = BoxFolderDeleteRequestObject.deleteFolderRequestObject((boolean)true);
            this.client.getFoldersManager().deleteFolder(id, deleteObj);
            try {
                BoxDefaultRequestObject trashObj = new BoxDefaultRequestObject();
                return this.client.getTrashManager().getTrashFolder(id, trashObj);
            }
            catch (BoxRestException e) {
                throw new BoxException("Error reading trashed foler: " + e.getMessage(), e);
            }
            catch (BoxServerException e) {
                int status = this.getErrorStatus(e);
                if (status == 404 || status == 412) {
                    throw new FileTrashRemovedException("Trashed folder deleted permanently " + id);
                }
                throw new BoxException("Error reading trashed foler: " + e.getMessage(), e);
            }
        }
        catch (BoxRestException e) {
            throw new BoxException("Error trashing foler: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to the folder " + id, (Throwable)e);
            }
            throw new BoxException("Error trashing foler: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when trashing foler: " + e.getMessage(), e);
        }
    }

    BoxFile untrashFile(String id, String name) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            BoxItemRestoreRequestObject obj = BoxItemRestoreRequestObject.restoreItemRequestObject();
            if (name != null) {
                obj.setNewName(name);
            }
            return this.client.getTrashManager().restoreTrashFile(id, obj);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error untrashing file: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("Trashed file not found " + id, (Throwable)e);
            }
            if (status == 405) {
                throw new NotFoundException("File not in the trash " + id, (Throwable)e);
            }
            if (status == 409) {
                throw new ConflictException("File with the same name as untrashed already exists " + id, (Throwable)e);
            }
            throw new BoxException("Error untrashing file: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when untrashing file: " + e.getMessage(), e);
        }
    }

    BoxFolder untrashFolder(String id, String name) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            BoxItemRestoreRequestObject obj = BoxItemRestoreRequestObject.restoreItemRequestObject();
            if (name != null) {
                obj.setNewName(name);
            }
            return this.client.getTrashManager().restoreTrashFolder(id, obj);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error untrashing folder: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("Trashed folder not found " + id, (Throwable)e);
            }
            if (status == 405) {
                throw new NotFoundException("Folder not in the trash " + id, (Throwable)e);
            }
            if (status == 409) {
                throw new ConflictException("Folder with the same name as untrashed already exists " + id, (Throwable)e);
            }
            throw new BoxException("Error untrashing folder: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when untrashing folder: " + e.getMessage(), e);
        }
    }

    BoxFile updateFile(String parentId, String id, String name, Calendar modified) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        boolean parentChanged;
        BoxFile existing = this.readFile(id);
        int attemts = 0;
        boolean nameChanged = !existing.getName().equals(name);
        boolean bl = parentChanged = !existing.getParent().getId().equals(parentId);
        while ((nameChanged || parentChanged) && attemts < 3) {
            ++attemts;
            try {
                BoxFileRequestObject obj = BoxFileRequestObject.getRequestObject();
                if (nameChanged) {
                    obj.setName(name);
                }
                if (parentChanged) {
                    obj.setParent(parentId);
                }
                obj.put("modified_at", (Object)this.formatDate(modified));
                return this.client.getFilesManager().updateFileInfo(id, obj);
            }
            catch (BoxRestException e) {
                throw new BoxException("Error updating file: " + e.getMessage(), e);
            }
            catch (BoxServerException e) {
                int status = this.getErrorStatus(e);
                if (status == 404 || status == 412) {
                    throw new NotFoundException("File not found " + id, (Throwable)e);
                }
                if (status == 409) {
                    if (attemts < 3) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("File with the same name as updated already exists " + id + ". Trying again."));
                        }
                        nameChanged = !(existing = this.readFile(id)).getName().equalsIgnoreCase(name);
                        parentChanged = !existing.getParent().getId().equals(parentId);
                        continue;
                    }
                    throw new ConflictException("File with the same name as updated already exists " + id);
                }
                throw new BoxException("Error updating file: " + e.getMessage(), e);
            }
            catch (UnsupportedEncodingException e) {
                throw new BoxException("Error updating file: " + e.getMessage(), e);
            }
            catch (AuthFatalFailureException e) {
                this.checkTokenState();
                throw new BoxException("Authentication error when updating file: " + e.getMessage(), e);
            }
        }
        return existing;
    }

    BoxFile updateFileContent(String parentId, String id, String name, Calendar modified, InputStream data) throws BoxException, NotFoundException, RefreshAccessException {
        try {
            BoxFileUploadRequestObject obj = BoxFileUploadRequestObject.uploadFileRequestObject((String)parentId, (String)name, (InputStream)data);
            obj.setLocalFileLastModifiedAt(modified.getTime());
            obj.put("modified_at", (Object)this.formatDate(modified));
            return this.client.getFilesManager().uploadNewVersion(id, obj);
        }
        catch (BoxJSONException e) {
            throw new BoxException("Error uploading new version of file: " + e.getMessage(), e);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error uploading new version of file: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            throw new BoxException("Error uploading new version of file: " + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxException("Error uploading new version of file: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when uploading new version of file: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BoxException("File " + name + ", new version uploading interrupted.", e);
        }
    }

    BoxFolder updateFolder(String parentId, String id, String name, Calendar modified) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        boolean parentChanged;
        BoxFolder existing = this.readFolder(id);
        int attemts = 0;
        boolean nameChanged = !existing.getName().equals(name);
        boolean bl = parentChanged = !existing.getParent().getId().equals(parentId);
        while ((nameChanged || parentChanged) && attemts < 3) {
            ++attemts;
            try {
                BoxFolderRequestObject obj = BoxFolderRequestObject.createFolderRequestObject((String)name, (String)parentId);
                obj.put("modified_at", (Object)this.formatDate(modified));
                return this.client.getFoldersManager().updateFolderInfo(id, obj);
            }
            catch (BoxRestException e) {
                throw new BoxException("Error updating folder: " + e.getMessage(), e);
            }
            catch (BoxServerException e) {
                int status = this.getErrorStatus(e);
                if (status == 404 || status == 412) {
                    throw new NotFoundException("Folder not found " + id, (Throwable)e);
                }
                if (status == 409) {
                    if (attemts < 3) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Folder with the same name as updated already exists " + id + ". Trying again."));
                        }
                        nameChanged = !(existing = this.readFolder(id)).getName().equalsIgnoreCase(name);
                        parentChanged = !existing.getParent().getId().equals(parentId);
                        continue;
                    }
                    throw new ConflictException("Folder with the same name as updated already exists " + id);
                }
                throw new BoxException("Error updating folder: " + e.getMessage(), e);
            }
            catch (UnsupportedEncodingException e) {
                throw new BoxException("Error updating folder: " + e.getMessage(), e);
            }
            catch (AuthFatalFailureException e) {
                this.checkTokenState();
                throw new BoxException("Authentication error when updating folder: " + e.getMessage(), e);
            }
        }
        return existing;
    }

    BoxFile copyFile(String id, String parentId, String name) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            BoxItemCopyRequestObject obj = BoxItemCopyRequestObject.copyItemRequestObject((String)parentId);
            obj.setName(name);
            return this.client.getFilesManager().copyFile(id, obj);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error copying file: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            if (status == 409) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("File with the same name as copying already exists " + id + ". Trying again."));
                }
                throw new ConflictException("File with the same name as copying already exists " + id);
            }
            throw new BoxException("Error copying file: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when copying file: " + e.getMessage(), e);
        }
    }

    BoxFolder copyFolder(String id, String parentId, String name) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            BoxItemCopyRequestObject obj = BoxItemCopyRequestObject.copyItemRequestObject((String)parentId);
            obj.setName(name);
            return this.client.getFoldersManager().copyFolder(id, obj);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error copying folder: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("Folder not found " + id, (Throwable)e);
            }
            if (status == 409) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Folder with the same name as copying already exists " + id + ". Trying again."));
                }
                throw new ConflictException("Folder with the same name as copying already exists " + id);
            }
            throw new BoxException("Error copying folder: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when copying folder: " + e.getMessage(), e);
        }
    }

    BoxFile readFile(String id) throws BoxException, NotFoundException, RefreshAccessException {
        try {
            return this.client.getFilesManager().getFile(id, new BoxDefaultRequestObject());
        }
        catch (BoxRestException e) {
            throw new BoxException("Error reading file: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            throw new BoxException("Error reading file: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when reading file: " + e.getMessage(), e);
        }
    }

    BoxFolder readFolder(String id) throws BoxException, NotFoundException, RefreshAccessException {
        try {
            return this.client.getFoldersManager().getFolder(id, new BoxDefaultRequestObject());
        }
        catch (BoxRestException e) {
            throw new BoxException("Error reading folder: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            int status = this.getErrorStatus(e);
            if (status == 404 || status == 412) {
                throw new NotFoundException("Folder not found " + id, (Throwable)e);
            }
            throw new BoxException("Error reading folder: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            this.checkTokenState();
            throw new BoxException("Authentication error when reading folder: " + e.getMessage(), e);
        }
    }

    String getEnterpriseName() {
        return this.enterpriseName;
    }

    String getEnterpriseId() {
        return this.enterpriseId;
    }

    String getCustomDomain() {
        return this.customDomain;
    }

    private int getErrorStatus(BoxServerException e) {
        int status;
        BoxServerError se = e.getError();
        if (se != null && (status = se.getStatus().intValue()) != 0) {
            return status;
        }
        return e.getStatusCode();
    }

    private void checkTokenState() throws RefreshAccessException {
        if (OAuthDataController.OAuthTokenState.FAIL.equals((Object)this.client.getAuthState())) {
            throw new RefreshAccessException("Authentication failure. Reauthenticate.");
        }
    }

    private void initUser() throws BoxException, RefreshAccessException, NotFoundException {
        BoxEnterprise enterprise;
        BoxUser user = this.getCurrentUser();
        String avatarUrl = user.getAvatarUrl();
        Matcher m = BOX_URL_CUSTOM_PATTERN.matcher(avatarUrl);
        if (m.matches()) {
            this.customDomain = m.group(1);
        }
        if ((enterprise = user.getEnterprise()) != null) {
            this.enterpriseName = enterprise.getName();
            this.enterpriseId = enterprise.getExtraData("id").toString();
        }
    }

    private String link(String fileLink) {
        Matcher m;
        if (this.customDomain != null && (m = BOX_URL_MAKE_CUSTOM_PATTERN.matcher(fileLink)).matches()) {
            return m.replaceFirst("$1://" + this.customDomain + ".$2");
        }
        return fileLink;
    }

    static {
        BOX_EVENTS.add("ITEM_CREATE");
        BOX_EVENTS.add("ITEM_UPLOAD");
        BOX_EVENTS.add("ITEM_MOVE");
        BOX_EVENTS.add("ITEM_COPY");
        BOX_EVENTS.add("ITEM_TRASH");
        BOX_EVENTS.add("ITEM_UNDELETE_VIA_TRASH");
        BOX_EVENTS.add("ITEM_RENAME");
    }

    class RESTClient
    extends BoxRESTClient {
        final HttpClient httpClient;

        RESTClient() {
            SSLSocketFactory socketFactory;
            SchemeRegistry schemeReg = new SchemeRegistry();
            schemeReg.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmfactory.init(null, null);
                KeyManager[] keymanagers = kmfactory.getKeyManagers();
                TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmfactory.init((KeyStore)null);
                TrustManager[] trustmanagers = tmfactory.getTrustManagers();
                sslContext.init(keymanagers, trustmanagers, null);
                socketFactory = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failure initializing default SSL context for Box REST client", ex);
            }
            schemeReg.register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
            ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(schemeReg);
            connectionManager.setDefaultMaxPerRoute(4);
            connectionManager.setMaxTotal(40);
            this.httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        }

        public HttpClient getRawHttpClient() {
            return this.httpClient;
        }
    }

    public static class ChangesLink {
        final String type;
        final String url;
        final long maxRetries;
        final long retryTimeout;
        final long ttl;
        final long outdatedTimeout;
        final long created;

        ChangesLink(String type, String url, long ttl, long maxRetries, long retryTimeout) {
            this.type = type;
            this.url = url;
            this.ttl = ttl;
            this.maxRetries = maxRetries;
            this.retryTimeout = retryTimeout;
            this.outdatedTimeout = retryTimeout - (long)Math.round((float)retryTimeout * 0.05f);
            this.created = System.currentTimeMillis();
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public long getTtl() {
            return this.ttl;
        }

        public long getMaxRetries() {
            return this.maxRetries;
        }

        public long getRetryTimeout() {
            return this.retryTimeout;
        }

        public long getOutdatedTimeout() {
            return this.outdatedTimeout;
        }

        public long getCreated() {
            return this.created;
        }

        public boolean isOutdated() {
            return System.currentTimeMillis() - this.created > this.outdatedTimeout;
        }
    }

    class EventsIterator
    extends ChunkIterator<BoxEvent> {
        final Set<String> eventIds = new HashSet<String>();
        Long streamPosition;
        Integer offset = 0;
        Integer chunkSize = 0;

        EventsIterator(long streamPosition) throws BoxException, RefreshAccessException {
            this.streamPosition = streamPosition <= -1L ? -1L : streamPosition;
            this.iter = this.nextChunk();
        }

        protected Iterator<BoxEvent> nextChunk() throws BoxException, RefreshAccessException {
            try {
                BoxEventRequestObject request = BoxEventRequestObject.getEventsRequestObject((long)this.streamPosition);
                request.setStreamType("changes");
                request.setLimit(100);
                BoxEventCollection ec = BoxAPI.this.client.getEventsManager().getEvents(request);
                this.streamPosition = ec.getNextStreamPosition();
                ArrayList<BoxEvent> events = new ArrayList<BoxEvent>();
                for (BoxTypedObject eobj : ec.getEntries()) {
                    String id;
                    BoxEvent event = (BoxEvent)eobj;
                    if (!BOX_EVENTS.contains(event.getEventType()) || this.eventIds.contains(id = event.getId())) continue;
                    this.eventIds.add(id);
                    events.add(event);
                }
                this.chunkSize = events.size();
                return events.iterator();
            }
            catch (BoxRestException e) {
                throw new BoxException("Error requesting Events service: " + e.getMessage(), e);
            }
            catch (BoxServerException e) {
                throw new BoxException("Error reading Events service: " + e.getMessage(), e);
            }
            catch (AuthFatalFailureException e) {
                BoxAPI.this.checkTokenState();
                throw new BoxException("Authentication error for Events service: " + e.getMessage(), e);
            }
        }

        protected boolean hasNextChunk() {
            return this.chunkSize > 0;
        }

        long getNextStreamPosition() {
            return this.streamPosition;
        }
    }

    class ItemsIterator
    extends ChunkIterator<BoxItem> {
        final String folderId;
        int offset = 0;
        int total = 0;
        BoxFolder parent;

        ItemsIterator(String folderId) throws CloudDriveException {
            this.folderId = folderId;
            this.iter = this.nextChunk();
        }

        protected Iterator<BoxItem> nextChunk() throws CloudDriveException {
            BoxDefaultRequestObject obj = new BoxDefaultRequestObject();
            obj.setPage(100, this.offset);
            BoxRequestExtras ext = obj.getRequestExtras();
            ext.addField("id");
            ext.addField("parent");
            ext.addField("name");
            ext.addField("type");
            ext.addField("etag");
            ext.addField("sequence_id");
            ext.addField("created_at");
            ext.addField("modified_at");
            ext.addField("description");
            ext.addField("size");
            ext.addField("created_by");
            ext.addField("modified_by");
            ext.addField("owned_by");
            ext.addField("shared_link");
            ext.addField("item_status");
            ext.addField("path_collection");
            ext.addField("item_collection");
            try {
                this.parent = BoxAPI.this.client.getFoldersManager().getFolder(this.folderId, obj);
                BoxCollection items = this.parent.getItemCollection();
                this.total = items.getTotalCount();
                if (this.offset == 0) {
                    this.available(this.total);
                }
                this.offset += items.getEntries().size();
                ArrayList oitems = new ArrayList();
                oitems.addAll(Utils.getTypedObjects((BoxCollection)items, BoxFolder.class));
                oitems.addAll(Utils.getTypedObjects((BoxCollection)items, BoxFile.class));
                return oitems.iterator();
            }
            catch (BoxRestException e) {
                throw new BoxException("Error getting folder items: " + e.getMessage(), e);
            }
            catch (BoxServerException e) {
                int status = BoxAPI.this.getErrorStatus(e);
                if (status == 404 || status == 412) {
                    throw new NotFoundException("Folder not found " + this.folderId, (Throwable)e);
                }
                throw new BoxException("Error reading folder items: " + e.getMessage(), e);
            }
            catch (AuthFatalFailureException e) {
                BoxAPI.this.checkTokenState();
                throw new BoxException("Authentication error on folder items: " + e.getMessage(), e);
            }
        }

        protected boolean hasNextChunk() {
            return this.total > this.offset;
        }
    }

    class StoredToken
    extends UserToken
    implements OAuthRefreshListener,
    IAuthSecureStorage {
        StoredToken() {
        }

        void store(BoxOAuthToken btoken) throws CloudDriveException {
            this.store(btoken.getAccessToken(), btoken.getRefreshToken(), btoken.getExpiresIn().intValue());
        }

        public void onRefresh(IAuthData newAuthData) {
            BoxOAuthToken newToken = (BoxOAuthToken)newAuthData;
            try {
                this.store(newToken);
            }
            catch (CloudDriveException e) {
                LOG.error((Object)"Error storing refreshed access token", (Throwable)e);
            }
        }

        public void saveAuth(IAuthData auth) {
            try {
                this.store((BoxOAuthToken)auth);
            }
            catch (CloudDriveException e) {
                LOG.error((Object)"Error saving access token", (Throwable)e);
            }
        }

        public IAuthData getAuth() {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("access_token", this.getAccessToken());
            data.put("refresh_token", this.getRefreshToken());
            data.put("expires_in", this.getExpirationTime());
            data.put("token_type", "bearer");
            return new BoxOAuthToken(data);
        }
    }
}

