/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.cmis;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.DocumentType;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.CmisBindingFactory;
import org.apache.chemistry.opencmis.client.bindings.spi.LinkAccess;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.ConflictException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.cmis.CMISException;
import org.exoplatform.clouddrive.cmis.CMISInvalidArgumentException;
import org.exoplatform.clouddrive.cmis.JCRLocalCMISDrive;
import org.exoplatform.clouddrive.cmis.WrongCMISProviderException;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CMISAPI {
    protected static final Log LOG = ExoLogger.getLogger(CMISAPI.class);
    public static final String NO_STATE = "__no_state_set__";
    public static final int OBJECT_PAGE_SIZE = 1024;
    public static final int FOLDER_PAGE_SIZE = 10240;
    public static final String TOKEN_DATATIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected static final Set<String> FOLDER_PROPERTY_SET = new HashSet<String>();
    private final Lock lock = new ReentrantLock();
    protected Map<String, String> parameters;
    protected String repositoryId;
    protected String repositoryName;
    protected String productName;
    protected String productVersion;
    protected String vendorName;
    protected DriveState state;
    protected String enterpriseId;
    protected String enterpriseName;
    protected String customDomain;
    protected OperationContext objectContext;
    protected OperationContext folderContext;
    protected final AtomicReference<Session> session = new AtomicReference();

    protected CMISAPI(String serviceURL, String user, String password) throws CMISException, CloudDriveException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.user", user);
        parameters.put("org.apache.chemistry.opencmis.password", password);
        parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", serviceURL);
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        this.parameters = parameters;
        this.updateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUser(Map<String, String> parameters) {
        try {
            this.lock.lock();
            this.parameters = new HashMap<String, String>(parameters);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getParamaters() {
        try {
            this.lock.lock();
            Map<String, String> map = Collections.unmodifiableMap(this.parameters);
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUser() {
        try {
            this.lock.lock();
            String string = this.parameters.get("org.apache.chemistry.opencmis.user");
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPassword() {
        try {
            this.lock.lock();
            String string = this.parameters.get("org.apache.chemistry.opencmis.password");
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServiceURL() {
        try {
            this.lock.lock();
            String string = this.parameters.get("org.apache.chemistry.opencmis.binding.atompub.url");
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void initRepository(String repositoryId) throws CMISException, RefreshAccessException {
        this.repositoryId = repositoryId;
        RepositoryInfo info = this.getRepositoryInfo();
        this.repositoryName = info.getName();
        this.productName = info.getProductName();
        this.productVersion = info.getProductVersion();
        this.vendorName = info.getVendorName();
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryName() {
        return this.repositoryName != null ? this.repositoryName : this.repositoryId;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getUserTitle() {
        return this.getUser();
    }

    protected List<Repository> getRepositories() throws CMISException, RefreshAccessException {
        return Collections.unmodifiableList(this.repositories());
    }

    protected Folder getRootFolder() throws CMISException, RefreshAccessException {
        try {
            Folder root = this.session().getRootFolder();
            return root;
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error getting root folder: " + e.getMessage(), e);
        }
    }

    protected CmisObject readObject(String id, Session session, OperationContext context) {
        return session.getObject(id, context);
    }

    protected CmisObject getObject(String objectId) throws CMISException, NotFoundException, CloudDriveAccessException {
        try {
            CmisObject object = this.readObject(objectId, this.session(), this.objectContext);
            return object;
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error reading object: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error reading object: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error reading object: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for document content reading: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document reading: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new CloudDriveAccessException("Unauthorized for reading document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error reading document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error reading document: " + e.getMessage(), e);
        }
    }

    protected ChildrenIterator getFolderItems(String folderId) throws CloudDriveException {
        return new ChildrenIterator(folderId);
    }

    protected ChangesIterator getChanges(ChangeToken changeToken) throws CMISException, RefreshAccessException {
        return new ChangesIterator(changeToken);
    }

    protected String getLink(CmisObject file) throws CMISException, RefreshAccessException {
        LinkAccess link = (LinkAccess)this.session().getBinding().getObjectService();
        String linkContent = link.loadContentLink(this.repositoryId, file.getId());
        if (linkContent != null) {
            return linkContent;
        }
        return link.loadLink(this.repositoryId, file.getId(), "self", "application/atom+xml;type=entry");
    }

    protected String getLink(Folder file) throws CMISException, RefreshAccessException {
        LinkAccess link = (LinkAccess)this.session().getBinding().getObjectService();
        String linkSelfEntry = link.loadLink(this.repositoryId, file.getId(), "self", "application/atom+xml;type=entry");
        return linkSelfEntry;
    }

    protected String getEmbedLink(CmisObject item) throws CMISException, RefreshAccessException {
        return this.getLink(item);
    }

    protected String getEmbedLink(Folder folder) throws CMISException, RefreshAccessException {
        return this.getLink(folder);
    }

    protected String getEmbedLink(Document doc) throws CMISException, RefreshAccessException {
        return this.getLink((CmisObject)doc);
    }

    protected DriveState getState() throws CMISException, RefreshAccessException {
        return null;
    }

    protected void updateState() throws CMISException, RefreshAccessException {
        try {
            this.state = null;
        }
        catch (Exception e) {
            throw new CMISException("Error getting drive state: " + e.getMessage(), e);
        }
    }

    protected Document createDocument(String parentId, String name, String mimeType, InputStream data) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException {
        Session session = this.session();
        try {
            CmisObject obj;
            try {
                obj = this.readObject(parentId, session, this.objectContext);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
            }
            if (this.isFolder(obj)) {
                Folder parent = (Folder)obj;
                ObjectType docType = session.getTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value());
                VersioningState vstate = this.isVersionable(docType) ? VersioningState.MAJOR : VersioningState.NONE;
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("cmis:objectTypeId", BaseTypeId.CMIS_DOCUMENT.value());
                properties.put("cmis:name", name);
                ContentStream contentStream = session.getObjectFactory().createContentStream(name, -1L, mimeType, data);
                return parent.createDocument(properties, contentStream, vstate, null, null, null, this.objectContext);
            }
            throw new CMISException("Parent not a folder: " + parentId + ", " + obj.getName());
        }
        catch (CmisUpdateConflictException e) {
            throw new ConflictException("Document update conflict for '" + name + "'", (Throwable)e);
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error creating document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable to create document with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new CMISException("Unable to create document '" + name + "' due to repository constraints", e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error creating document: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error creating document: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for document content upload: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document creation: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new CloudDriveAccessException("Unauthorized for create document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error creating document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error creating document: " + e.getMessage(), e);
        }
    }

    protected Folder createFolder(String parentId, String name) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException {
        Session session = this.session();
        try {
            CmisObject obj;
            try {
                obj = this.readObject(parentId, session, this.objectContext);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
            }
            if (this.isFolder(obj)) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("cmis:objectTypeId", BaseTypeId.CMIS_FOLDER.value());
                properties.put("cmis:name", name);
                Folder parent = (Folder)obj;
                return parent.createFolder(properties, null, null, null, this.folderContext);
            }
            throw new CMISException("Parent not a folder: " + parentId + ", " + obj.getName());
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error creating folder: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable create folder with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new CMISException("Unable create folder '" + name + "' due to repository constraints", e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error creating folder: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error creating folder: " + e.getMessage(), e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for folder creation: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new CloudDriveAccessException("Unauthorized to create folder: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error creating folder: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error creating folder: " + e.getMessage(), e);
        }
    }

    protected void deleteDocument(String id) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException {
        Session session = this.session();
        String name = "";
        try {
            CmisObject obj = this.readObject(id, session, this.objectContext);
            name = obj.getName();
            obj.delete(true);
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Document not found: " + id, (Throwable)e);
        }
        catch (CmisUpdateConflictException e) {
            throw new ConflictException("Document removal conflict for '" + name + "'", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new CMISException("Unable delete document '" + name + "' due to repository constraints", e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error deleting document: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error deleting document: " + e.getMessage(), e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document removal: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new CloudDriveAccessException("Unauthorized to delete document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error deleting document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error deleting document: " + e.getMessage(), e);
        }
    }

    protected void deleteFolder(String id) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException {
        Session session = this.session();
        String name = "";
        try {
            CmisObject obj = this.readObject(id, session, this.objectContext);
            name = obj.getName();
            if (!this.isFolder(obj)) {
                throw new CMISException("Not a folder: " + id + ", " + name);
            }
            Folder folder = (Folder)obj;
            folder.deleteTree(true, UnfileObject.DELETE, false);
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error deleting folder: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUpdateConflictException e) {
            throw new ConflictException("Folder removal conflict for '" + name + "'", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new CMISException("Unable to delete folder '" + name + "' due to repository constraints", e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error deleting folder: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error deleting folder: " + e.getMessage(), e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for folder removal: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new CloudDriveAccessException("Unauthorized for deleting folder: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error deleting folder: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error deleting folder: " + e.getMessage(), e);
        }
    }

    protected Document updateContent(String id, String name, InputStream data, String mimeType, JCRLocalCMISDrive.LocalFile local) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException {
        Session session = this.session();
        try {
            CmisObject obj;
            try {
                obj = this.readObject(id, session, this.objectContext);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Document not found: " + id, (Throwable)e);
            }
            if (this.isDocument(obj)) {
                ContentStream contentStream;
                Document updatedDocument;
                Document document = (Document)obj;
                if (!document.getName().equals(name)) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("cmis:name", name);
                    ObjectId objId = document.updateProperties(properties, true);
                    if (objId != null && objId instanceof Document) {
                        document = (Document)objId;
                    }
                }
                if ((updatedDocument = document.setContentStream(contentStream = session.getObjectFactory().createContentStream(name, -1L, mimeType, data), true)) != null) {
                    document = updatedDocument;
                }
                return document;
            }
            throw new CMISException("Object not a document: " + id + ", " + obj.getName());
        }
        catch (CmisContentAlreadyExistsException e) {
            throw new ConflictException("Document content already exists for '" + name + "' and overwrite not requested", (Throwable)e);
        }
        catch (CmisUpdateConflictException e) {
            throw new ConflictException("Conflict of document updating for '" + name + "'", (Throwable)e);
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error updating document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable to update document with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new CMISException("Unable to update document '" + name + "' due to repository constraints", e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error updating cloud document: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error updating cloud document: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for document content update: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document updating: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new CloudDriveAccessException("Unauthorized for updating document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error updating document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error updating document: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CmisObject updateObject(String parentId, String id, String name, JCRLocalCMISDrive.LocalFile local) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException {
        Session session = this.session();
        try {
            FileableCmisObject moved;
            Folder srcParent;
            CmisObject obj;
            CmisObject result = null;
            try {
                obj = this.readObject(id, session, this.objectContext);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Object not found: " + id, (Throwable)e);
            }
            if (!obj.getName().equals(name)) {
                obj = result = this.rename(name, obj, session);
            }
            if (!this.isFileable(obj)) throw new CMISException("Object not a document: " + id + ", " + obj.getName());
            FileableCmisObject fileable = (FileableCmisObject)obj;
            List parents = fileable.getParents(this.folderContext);
            boolean move = parents.size() > 0;
            HashSet<String> parentIds = new HashSet<String>();
            for (Folder p : parents) {
                String pid = p.getId();
                parentIds.add(pid);
                if (!pid.equals(parentId)) continue;
                move = false;
                break;
            }
            if (!move) return result;
            try {
                obj = this.readObject(parentId, session, this.objectContext);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
            }
            if (!this.isFolder(obj)) throw new CMISException("Parent not a folder: " + parentId + ", " + obj.getName());
            Folder parent = (Folder)obj;
            if (parents.size() > 1) {
                String rpid = local.findRemoteParent(id, parentIds);
                if (rpid == null) {
                    if (session.getRepositoryInfo().getCapabilities().isMultifilingSupported() == false) throw new CMISException("Cannot move document without source folder and with disabled multi-filing: " + id + ", " + name);
                    fileable.addToFolder((ObjectId)parent, true);
                    return fileable;
                }
                try {
                    obj = this.readObject(rpid, session, this.objectContext);
                }
                catch (CmisObjectNotFoundException e) {
                    throw new NotFoundException("Source parent not found: " + rpid, (Throwable)e);
                }
                if (!this.isFolder(obj)) throw new CMISException("Source parent not a folder: " + rpid + ", " + obj.getName());
                srcParent = (Folder)obj;
            } else {
                srcParent = (Folder)parents.get(0);
            }
            if ((moved = fileable.move((ObjectId)srcParent, (ObjectId)parent, this.objectContext)) != null) {
                return moved;
            }
            fileable.refresh();
            return fileable;
        }
        catch (CmisUpdateConflictException e) {
            throw new ConflictException("Conflict of object updating for '" + name + "'", (Throwable)e);
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error updating object: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable to update object with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new CMISException("Unable to update object '" + name + "' due to repository constraints", e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error updating object: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error updating object: " + e.getMessage(), e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for object updating: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new CloudDriveAccessException("Unauthorized to update object: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error updating object: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error updating object: " + e.getMessage(), e);
        }
    }

    protected CmisObject rename(String newName, CmisObject obj, Session session) {
        ObjectId objId = obj.rename(newName, true);
        if (objId != null && objId instanceof CmisObject) {
            obj = (CmisObject)objId;
        } else {
            obj.refresh();
        }
        return obj;
    }

    @Deprecated
    protected Folder updateFolder(String parentId, String id, String name, JCRLocalCMISDrive.LocalFile local) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException {
        CmisObject obj = this.updateObject(parentId, id, name, local);
        if (obj == null || this.isFolder(obj)) {
            return (Folder)obj;
        }
        throw new CMISException("Object not a folder: " + id + ", " + obj.getName());
    }

    protected Document copyDocument(String id, String parentId, String name) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException {
        Session session = this.session();
        try {
            CmisObject obj;
            try {
                obj = this.readObject(parentId, session, this.objectContext);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
            }
            if (this.isFolder(obj)) {
                Folder parent = (Folder)obj;
                try {
                    obj = this.readObject(id, session, this.objectContext);
                }
                catch (CmisObjectNotFoundException e) {
                    throw new NotFoundException("Source not found: " + parentId, (Throwable)e);
                }
                if (this.isDocument(obj)) {
                    return this.copyDocument((Document)obj, parent, name);
                }
                throw new CMISException("Source not a document: " + id + ", " + obj.getName());
            }
            throw new CMISException("Parent not a folder: " + parentId + ", " + obj.getName());
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
    }

    protected Document copyDocument(Document source, Folder parent, String name) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException {
        try {
            Session session = this.session();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("cmis:baseTypeId", source.getBaseType().getId());
            properties.put("cmis:objectTypeId", source.getType().getId());
            properties.put("cmis:name", name);
            ObjectType docType = session.getTypeDefinition(source.getBaseType().getId());
            VersioningState vstate = this.isVersionable(docType) ? VersioningState.MAJOR : VersioningState.NONE;
            try {
                return parent.createDocumentFromSource((ObjectId)source, properties, vstate, null, null, null, this.objectContext);
            }
            catch (CmisNotSupportedException e) {
                LOG.warn((Object)("Cannot copy document " + source.getName() + " (" + source.getId() + ") to " + parent.getName() + "/" + name + ". Will try use actual content copying. " + e.getMessage()));
                ContentStream sourceContent = source.getContentStream();
                ContentStream destContent = session.getObjectFactory().createContentStream(name, sourceContent.getLength(), sourceContent.getMimeType(), sourceContent.getStream());
                for (Property p : source.getProperties()) {
                    if (properties.containsKey(p.getId())) continue;
                    if (p.isMultiValued()) {
                        properties.put(p.getId(), p.getValues());
                        continue;
                    }
                    properties.put(p.getId(), p.getValue());
                }
                return parent.createDocument(properties, destContent, vstate, null, null, null, this.objectContext);
            }
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error copying document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable to copy document with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new CMISException("Unable to copy document '" + name + "' due to repository constraints", e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for document content copying: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document copying: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new CloudDriveAccessException("Unauthorized for copying document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
    }

    protected Folder copyFolder(String id, String parentId, String name) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException {
        Session session = this.session();
        try {
            CmisObject obj;
            try {
                obj = this.readObject(parentId, session, this.objectContext);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
            }
            if (this.isFolder(obj)) {
                Folder parent = (Folder)obj;
                try {
                    obj = this.readObject(id, session, this.objectContext);
                }
                catch (CmisObjectNotFoundException e) {
                    throw new NotFoundException("Source not found: " + parentId, (Throwable)e);
                }
                if (this.isFolder(obj)) {
                    Folder source = (Folder)obj;
                    return this.copyFolder(source, parent, name);
                }
                throw new CMISException("Source not a folder: " + id + ", " + obj.getName());
            }
            throw new CMISException("Parent not a folder: " + parentId + ", " + obj.getName());
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
    }

    protected Folder copyFolder(Folder source, Folder parent, String name) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException {
        try {
            HashMap<String, String> properties = new HashMap<String, String>(2);
            properties.put("cmis:name", source.getName());
            properties.put("cmis:objectTypeId", source.getBaseTypeId().value());
            Folder copyFolder = parent.createFolder(properties, null, null, null, this.folderContext);
            for (CmisObject child : source.getChildren()) {
                if (this.isDocument(child)) {
                    this.copyDocument((Document)child, parent, child.getName());
                    continue;
                }
                if (!(child instanceof Folder)) continue;
                this.copyFolder((Folder)child, parent, child.getName());
            }
            return copyFolder;
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error copying document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable to copy document with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new CMISException("Unable to copy document '" + name + "' due to repository constraints", e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for document content copying: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document copying: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new CloudDriveAccessException("Unauthorized for copying document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
    }

    protected RepositoryInfo getRepositoryInfo() throws CMISException, RefreshAccessException {
        try {
            return this.session(true).getRepositoryInfo();
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error getting repository info: " + e.getMessage(), e);
        }
        catch (CmisObjectNotFoundException e) {
            throw new CMISException("Error getting repository info: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error getting repository info: " + e.getMessage(), e);
        }
    }

    protected boolean isFolder(CmisObject object) {
        return object.getBaseTypeId().equals((Object)BaseTypeId.CMIS_FOLDER);
    }

    protected boolean isDocument(CmisObject object) {
        return object.getBaseTypeId().equals((Object)BaseTypeId.CMIS_DOCUMENT);
    }

    protected boolean isRelationship(CmisObject object) {
        return object.getBaseTypeId().equals((Object)BaseTypeId.CMIS_RELATIONSHIP);
    }

    protected boolean isFileable(CmisObject object) {
        return object instanceof FileableCmisObject;
    }

    protected List<Repository> repositories() throws CMISException, RefreshAccessException {
        try {
            this.lock.lock();
            SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
            List list = sessionFactory.getRepositories(this.parameters);
            return list;
        }
        catch (CmisConnectionException e) {
            throw new CMISException("CMIS server is unreachable", e);
        }
        catch (CmisUnauthorizedException e) {
            throw new RefreshAccessException("CMIS user rejected", (Throwable)e);
        }
        catch (CmisObjectNotFoundException e) {
            throw new WrongCMISProviderException("Error reading repositories list: " + e.getMessage(), e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Runtime error when reading CMIS repositories list", e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error reading CMIS repositories list", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected CmisBinding binding() throws CMISException {
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        HashMap<String, String> sessionParameters = new HashMap<String, String>(this.parameters);
        if (this.repositoryId != null) {
            sessionParameters.put("org.apache.chemistry.opencmis.session.repository.id", this.repositoryId);
        }
        return factory.createCmisAtomPubBinding(this.parameters);
    }

    protected Session session() throws CMISException, RefreshAccessException {
        return this.session(false);
    }

    protected Session session(boolean forceNew) throws CMISException, RefreshAccessException {
        Session session = this.session.get();
        if (session != null && !forceNew) {
            return session;
        }
        for (Repository r : this.repositories()) {
            if (!r.getId().equals(this.repositoryId)) continue;
            session = r.createSession();
            OperationContext context = session.createOperationContext();
            context.setCacheEnabled(false);
            session.setDefaultContext(context);
            Context objectContext = new Context("*", true, true, true, IncludeRelationships.NONE, "cmis:none", null, 1024);
            ObjectType type = session.getTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value());
            StringBuilder filter = new StringBuilder();
            for (String propId : FOLDER_PROPERTY_SET) {
                PropertyDefinition propDef = (PropertyDefinition)type.getPropertyDefinitions().get(propId);
                if (propDef == null) continue;
                if (filter.length() > 0) {
                    filter.append(',');
                }
                filter.append(propDef.getQueryName());
            }
            Context folderContext = new Context(filter.toString(), false, false, false, IncludeRelationships.NONE, "cmis:none", null, 10240);
            this.session.set(session);
            this.objectContext = objectContext;
            this.folderContext = folderContext;
            return session;
        }
        throw new CMISException("CMIS repository not found: " + this.repositoryId);
    }

    protected ChangeToken readToken(ChangeEvent event) throws CMISException {
        Object obj;
        List tl = (List)event.getProperties().get("ChangeToken");
        if (tl != null && tl.size() > 0 && (obj = tl.get(0)) != null && obj instanceof String) {
            return this.readToken((String)obj);
        }
        GregorianCalendar time = event.getChangeTime();
        if (time != null) {
            return new TimeChangeToken(time);
        }
        throw new CMISException("ChangeToken property not found, change time is null for " + event.getObjectId() + " " + event.getChangeType());
    }

    protected ChangeToken readToken(String tokenString) throws CMISException {
        if (tokenString != null) {
            return new ChangeToken(tokenString);
        }
        throw new CMISException("ChangeToken string is null");
    }

    protected boolean isVersionable(ObjectType type) {
        return type instanceof DocumentType ? ((DocumentType)type).isVersionable() : false;
    }

    protected boolean isSyncableChange(ChangeEvent change) throws RefreshAccessException, CMISException {
        boolean res = true;
        List objTypeIdList = (List)change.getProperties().get("cmis:objectTypeId");
        if (objTypeIdList != null) {
            res = false;
            for (Object tid : objTypeIdList) {
                if (!(tid instanceof String)) continue;
                try {
                    BaseTypeId btid = this.session().getTypeDefinition((String)tid, true).getBaseTypeId();
                    if (btid.equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
                        res = true;
                        continue;
                    }
                    if (!btid.equals((Object)BaseTypeId.CMIS_FOLDER)) continue;
                    res = true;
                }
                catch (CmisRuntimeException e) {
                    throw new CMISException("Error reading object type (" + tid + "): " + e.getMessage(), e);
                }
                catch (CmisObjectNotFoundException e) {
                    throw new CMISException("Error reading object type (" + tid + "): " + e.getMessage(), e);
                }
                catch (CmisBaseException e) {
                    throw new CMISException("Error reading object type (" + tid + "): " + e.getMessage(), e);
                }
            }
        }
        return res;
    }

    public static String formatTokenTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(TOKEN_DATATIME_FORMAT);
        return format.format(date);
    }

    static {
        FOLDER_PROPERTY_SET.add("cmis:objectId");
        FOLDER_PROPERTY_SET.add("cmis:objectTypeId");
        FOLDER_PROPERTY_SET.add("cmis:name");
        FOLDER_PROPERTY_SET.add("cmis:contentStreamMimeType");
        FOLDER_PROPERTY_SET.add("cmis:contentStreamLength");
        FOLDER_PROPERTY_SET.add("cmis:contentStreamFileName");
        FOLDER_PROPERTY_SET.add("cmis:createdBy");
        FOLDER_PROPERTY_SET.add("cmis:creationDate");
        FOLDER_PROPERTY_SET.add("cmis:lastModifiedBy");
        FOLDER_PROPERTY_SET.add("cmis:lastModificationDate");
        FOLDER_PROPERTY_SET.add("cmis:isVersionSeriesCheckedOut");
        FOLDER_PROPERTY_SET.add("cmis:versionSeriesCheckedOutId");
    }

    protected class Context
    extends OperationContextImpl {
        private static final long serialVersionUID = 1L;

        protected Context(String filter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, String renditionFilter, String orderBy, int maxItemsPerPage) {
            this.setFilterString(filter);
            this.setIncludeAcls(includeAcls);
            this.setIncludeAllowableActions(includeAllowableActions);
            this.setIncludePolicies(includePolicies);
            this.setIncludeRelationships(includeRelationships);
            this.setRenditionFilterString(renditionFilter);
            this.setOrderBy(orderBy);
            this.setMaxItemsPerPage(maxItemsPerPage);
            this.setIncludePathSegments(false);
            this.setCacheEnabled(false);
        }
    }

    public static class DriveState {
        protected final String type;
        protected final String url;
        protected final long retryTimeout;
        protected final long created;

        protected DriveState(String type, String url, long retryTimeout) {
            this.type = type;
            this.url = url;
            this.retryTimeout = retryTimeout;
            this.created = System.currentTimeMillis();
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public long getRetryTimeout() {
            return this.retryTimeout;
        }

        public long getCreated() {
            return this.created;
        }

        public boolean isOutdated() {
            return System.currentTimeMillis() - this.created > this.retryTimeout;
        }
    }

    protected class TimeChangeToken
    extends ChangeToken {
        protected final GregorianCalendar time;

        protected TimeChangeToken(GregorianCalendar time) {
            super(String.valueOf(time.getTimeInMillis()));
            this.time = time;
        }

        protected GregorianCalendar getTime() {
            return this.time;
        }

        @Override
        public boolean equals(ChangeToken other) {
            if (other instanceof TimeChangeToken) {
                return this.getTime().equals(((TimeChangeToken)other).getTime());
            }
            return super.equals(other);
        }

        @Override
        public int compareTo(ChangeToken other) {
            if (other instanceof TimeChangeToken) {
                return this.getTime().compareTo(((TimeChangeToken)other).getTime());
            }
            return super.compareTo(other);
        }
    }

    protected class ChangeToken
    implements Comparable<ChangeToken> {
        protected final String token;

        protected ChangeToken(String token) {
            this.token = token;
        }

        public boolean equals(ChangeToken other) {
            if (other != null) {
                return this.getString().equals(other.getString());
            }
            return false;
        }

        @Override
        public int compareTo(ChangeToken other) {
            return this.getString().compareTo(other.getString());
        }

        public boolean isAfter(ChangeToken other) {
            return this.compareTo(other) > 0;
        }

        public boolean isBefore(ChangeToken other) {
            return this.compareTo(other) < 0;
        }

        public String getString() {
            return this.token;
        }

        public String toString() {
            return this.getString();
        }
    }

    protected class ChangesIterator
    extends ChunkIterator<ChangeEvent> {
        protected ChangeToken changeToken;
        protected ChangeToken lastFetchedToken;
        protected ChangeToken latestChunkToken;
        protected List<ChangeEvent> changes;
        protected boolean firstRun = true;
        protected boolean hasMoreItems = true;
        protected boolean cleanNext = true;

        protected ChangesIterator(ChangeToken startChangeToken) throws CMISException, RefreshAccessException {
            this.changeToken = startChangeToken;
            this.lastFetchedToken = null;
            this.iter = this.nextChunk();
            this.firstRun = false;
        }

        protected Iterator<ChangeEvent> nextChunk() throws CMISException, RefreshAccessException {
            if (this.changeToken != null) {
                try {
                    ChangeEvents events = CMISAPI.this.session().getContentChanges(this.changeToken.getString(), true, 10240L);
                    this.changes = events.getChangeEvents();
                    String latestChangeToken = events.getLatestChangeLogToken();
                    this.latestChunkToken = latestChangeToken != null ? CMISAPI.this.readToken(latestChangeToken) : null;
                    int changesLen = this.changes.size();
                    if (changesLen > 0) {
                        ChangeToken first = CMISAPI.this.readToken(this.changes.get(0));
                        if (first.equals(this.changeToken) || first.equals(this.lastFetchedToken)) {
                            this.changes.remove(0);
                            changesLen = this.changes.size();
                        }
                        if (events.getHasMoreItems() && changesLen > 0) {
                            ChangeToken nextToken = this.latestChunkToken == null ? CMISAPI.this.readToken(this.changes.get(changesLen - 1)) : this.latestChunkToken;
                            this.hasMoreItems = this.lastFetchedToken != null ? nextToken.isAfter(this.lastFetchedToken) : true;
                            this.changeToken = this.hasMoreItems ? nextToken : null;
                        } else {
                            this.hasMoreItems = false;
                            this.changeToken = null;
                        }
                    } else {
                        this.hasMoreItems = false;
                        this.changeToken = null;
                    }
                    this.available(changesLen);
                    return this.changes.iterator();
                }
                catch (CmisRuntimeException e) {
                    throw new CMISException("Error requesting Content Changes service: " + e.getMessage(), e);
                }
            }
            return new ArrayList().iterator();
        }

        protected boolean hasNextChunk() {
            return this.hasMoreItems;
        }

        public boolean hasNext() throws CloudDriveException {
            boolean hasNext = super.hasNext();
            if (hasNext && this.cleanNext) {
                this.lastFetchedToken = CMISAPI.this.readToken((ChangeEvent)this.next);
                if (!ChangeType.DELETED.equals((Object)((ChangeEvent)this.next).getChangeType())) {
                    for (ChangeEvent che : this.changes) {
                        if (!((ChangeEvent)this.next).getObjectId().equals(che.getObjectId()) || !ChangeType.DELETED.equals((Object)che.getChangeType())) continue;
                        try {
                            this.next();
                            hasNext = this.hasNext();
                        }
                        catch (NoSuchElementException e) {
                            hasNext = false;
                        }
                        break;
                    }
                }
                this.cleanNext = false;
            }
            return hasNext;
        }

        public ChangeEvent next() throws NoSuchElementException, CloudDriveException {
            ChangeEvent next = (ChangeEvent)super.next();
            this.cleanNext = true;
            return next;
        }

        protected ChangeToken getLastChangeToken() {
            return this.lastFetchedToken != null ? this.lastFetchedToken : (this.latestChunkToken != null ? this.latestChunkToken : this.changeToken);
        }
    }

    protected class ChildrenIterator
    extends ChunkIterator<CmisObject> {
        protected final String folderId;
        protected Folder parent;
        protected ItemIterable<CmisObject> children;

        protected ChildrenIterator(String folderId) throws CloudDriveException {
            this.folderId = folderId;
            this.iter = this.nextChunk();
        }

        protected Iterator<CmisObject> nextChunk() throws CloudDriveException {
            try {
                CmisObject obj = CMISAPI.this.readObject(this.folderId, CMISAPI.this.session(), CMISAPI.this.objectContext);
                if (CMISAPI.this.isFolder(obj)) {
                    this.parent = (Folder)obj;
                    this.children = this.parent.getChildren(CMISAPI.this.folderContext);
                    long total = this.children.getTotalNumItems();
                    if (total == -1L) {
                        total = this.children.getPageNumItems();
                    }
                    this.available(total);
                    return this.children.iterator();
                }
                return new ArrayList().iterator();
            }
            catch (CmisRuntimeException e) {
                throw new CMISException("Error getting folder items: " + e.getMessage(), e);
            }
        }

        protected boolean hasNextChunk() {
            return false;
        }
    }
}

