/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.cmis;

import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.cmis.CMISAPI;
import org.exoplatform.clouddrive.cmis.CMISException;
import org.exoplatform.clouddrive.cmis.CMISProvider;

public class CMISUser
extends CloudUser {
    protected final CMISAPI api;

    public CMISUser(String id, String username, String email, CloudProvider provider, CMISAPI api) {
        super(id, username, email, provider);
        this.api = api;
    }

    protected CMISAPI api() {
        return this.api;
    }

    public String createDriveTitle() throws RepositoryException, DriveRemovedException, CloudDriveException {
        StringBuilder title = new StringBuilder();
        String predefinedName = this.getPredefinedRepositoryName();
        if (predefinedName != null) {
            title.append(predefinedName);
        } else {
            title.append(this.api().getVendorName());
            title.append(' ');
            title.append("CMIS");
        }
        title.append(" - ");
        title.append(this.getRepositoryName());
        title.append(" - ");
        title.append(this.getUserTitle());
        return title.toString();
    }

    public String getRepositoryId() {
        return this.api().getRepositoryId();
    }

    public String getRepositoryName() {
        return this.api().getRepositoryName();
    }

    public String getUserTitle() {
        return this.api().getUserTitle();
    }

    public CMISProvider getProvider() {
        return (CMISProvider)super.getProvider();
    }

    public List<Repository> getRepositories() throws CloudDriveAccessException, CMISException {
        return this.api().getRepositories();
    }

    public void setRepositoryId(String repositoryId) throws CMISException, RefreshAccessException {
        this.api().initRepository(repositoryId);
    }

    public String getServiceName() {
        return this.api().getVendorName() + " " + this.getProvider().getName();
    }

    protected String getPredefinedRepositoryName() {
        for (CMISProvider.AtomPub predefined : this.getProvider().getPredefinedAtompubServices()) {
            if (!predefined.getUrl().equals(this.api.getServiceURL())) continue;
            return predefined.getName();
        }
        return null;
    }
}

