/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.dropbox;

import com.dropbox.core.BadResponseCodeException;
import com.dropbox.core.DbxApiException;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.InvalidAccessTokenException;
import com.dropbox.core.RetryException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.CreateFolderErrorException;
import com.dropbox.core.v2.files.CreateFolderResult;
import com.dropbox.core.v2.files.DeleteErrorException;
import com.dropbox.core.v2.files.DeleteResult;
import com.dropbox.core.v2.files.DownloadErrorException;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.GetMetadataErrorException;
import com.dropbox.core.v2.files.GetTemporaryLinkErrorException;
import com.dropbox.core.v2.files.GetTemporaryLinkResult;
import com.dropbox.core.v2.files.ListFolderContinueErrorException;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.ListFolderGetLatestCursorResult;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.LookupError;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.RelocationError;
import com.dropbox.core.v2.files.RelocationErrorException;
import com.dropbox.core.v2.files.RelocationResult;
import com.dropbox.core.v2.files.RestoreErrorException;
import com.dropbox.core.v2.files.ThumbnailErrorException;
import com.dropbox.core.v2.files.ThumbnailSize;
import com.dropbox.core.v2.files.UploadSessionCursor;
import com.dropbox.core.v2.files.UploadSessionFinishErrorException;
import com.dropbox.core.v2.files.UploadSessionFinishUploader;
import com.dropbox.core.v2.files.UploadSessionLookupError;
import com.dropbox.core.v2.files.UploadSessionLookupErrorException;
import com.dropbox.core.v2.files.UploadSessionStartResult;
import com.dropbox.core.v2.files.UploadSessionStartUploader;
import com.dropbox.core.v2.files.WriteConflictError;
import com.dropbox.core.v2.files.WriteError;
import com.dropbox.core.v2.files.WriteMode;
import com.dropbox.core.v2.sharing.CreateSharedLinkWithSettingsErrorException;
import com.dropbox.core.v2.sharing.ListSharedLinksErrorException;
import com.dropbox.core.v2.sharing.ListSharedLinksResult;
import com.dropbox.core.v2.sharing.SharedLinkMetadata;
import com.dropbox.core.v2.sharing.SharedLinkSettingsError;
import com.dropbox.core.v2.users.FullAccount;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.ConflictException;
import org.exoplatform.clouddrive.NotAcceptableException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.RetryLaterException;
import org.exoplatform.clouddrive.UnauthorizedException;
import org.exoplatform.clouddrive.dropbox.DropboxException;
import org.exoplatform.clouddrive.dropbox.ResetCursorException;
import org.exoplatform.clouddrive.oauth2.UserToken;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.clouddrive.utils.Web;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DropboxAPI {
    public static final int VERSION = 2;
    public static final String ROOT_URL = "https://www.dropbox.com/home";
    public static final String ROOT_PATH_V2 = "".intern();
    public static final int TEMP_LINK_EXPIRATION = 14395000;
    public static final int CHANGES_LONGPOLL_TIMEOUT = 60;
    public static final String CHANGES_LONGPOLL_URL = "https://notify.dropboxapi.com/2/files/list_folder/longpoll";
    public static final int UPLOAD_LIMIT = 0x9600000;
    public static final int UPLOAD_BUFFER_SIZE = 2048;
    public static final int UPLOAD_CHUNK_SIZE = 157282304;
    public static final int RETRY_TIMEOUT_MILLIS = 1000;
    protected static final Log LOG = ExoLogger.getLogger(DropboxAPI.class);
    private DbxClientV2 client;
    private StoredToken token;
    private PathEncoder pathEncoder = new PathEncoder();

    DropboxAPI(DbxRequestConfig config, DbxAuthFinish authData) throws DropboxException, CloudDriveException {
        this.client = new DbxClientV2(config, authData.getAccessToken());
        this.token = new StoredToken();
        this.token.store(authData.getAccessToken());
        this.initUser();
    }

    DropboxAPI(DbxRequestConfig config, String accessToken) throws CloudDriveException {
        this.client = new DbxClientV2(config, accessToken);
        this.token = new StoredToken();
        this.token.load(accessToken, null, -1L);
        this.initUser();
    }

    void updateToken(UserToken newToken) throws CloudDriveException {
        this.token.merge(newToken);
    }

    StoredToken getToken() {
        return this.token;
    }

    FullAccount getCurrentUser() throws DropboxException, RefreshAccessException {
        try {
            return this.client.users().getCurrentAccount();
        }
        catch (DbxException e) {
            throw new DropboxException("Error requesting current account: " + e.getMessage(), e);
        }
    }

    ListFolder listFolder(String idPath) throws NotFoundException, DropboxException, RefreshAccessException, RetryLaterException, NotAcceptableException {
        return new ListFolder(idPath, null);
    }

    ListFolder listFolderContinued(String idPath, String cursor) throws NotFoundException, DropboxException, RefreshAccessException, RetryLaterException, NotAcceptableException {
        return new ListFolder(idPath, cursor);
    }

    Metadata get(String idPath) throws DropboxException, NotFoundException, RefreshAccessException, RetryLaterException, NotAcceptableException {
        return this.get(idPath, false);
    }

    Metadata get(String idPath, boolean includeDeleted) throws DropboxException, NotFoundException, RefreshAccessException, RetryLaterException, NotAcceptableException {
        try {
            Metadata md = includeDeleted ? this.client.files().getMetadataBuilder(idPath).withIncludeDeleted(Boolean.valueOf(true)).start() : this.client.files().getMetadata(idPath);
            return md;
        }
        catch (GetMetadataErrorException e) {
            if (e.errorValue.isPath()) {
                LookupError lookupError = e.errorValue.getPathValue();
                if (lookupError.isNotFound() || lookupError.isNotFile()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("File not found in Dropbox: " + idPath), (Throwable)e);
                    }
                    throw new NotFoundException("File not found: " + idPath, (Throwable)e);
                }
                if (lookupError.isMalformedPath()) {
                    throw new NotAcceptableException("Malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
                }
                if (lookupError.isRestrictedContent()) {
                    throw new NotAcceptableException("Cannot read file due to restrictions: " + idPath, (Throwable)e);
                }
                throw new DropboxException("Failed to read file due to lookup error: " + idPath, e);
            }
            throw new DropboxException("Failed to read file: " + idPath, e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Failed to read file: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Failed to read file: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    DbxDownloader<FileMetadata> getContent(String idPath) throws DropboxException, NotFoundException, RefreshAccessException, NotAcceptableException, RetryLaterException {
        try {
            return this.client.files().download(idPath);
        }
        catch (DownloadErrorException e) {
            if (e.errorValue.isPath()) {
                LookupError lookupError = e.errorValue.getPathValue();
                if (lookupError.isNotFound() || lookupError.isNotFile()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("File not found in Dropbox: " + idPath), (Throwable)e);
                    }
                    throw new NotFoundException("File not found: " + idPath, (Throwable)e);
                }
                if (lookupError.isMalformedPath()) {
                    throw new NotAcceptableException("Malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
                }
                if (lookupError.isRestrictedContent()) {
                    throw new NotAcceptableException("Cannot download file due to restrictions: " + idPath, (Throwable)e);
                }
                throw new NotAcceptableException("Failed to download file due to lookup error: " + idPath, (Throwable)e);
            }
            throw new DropboxException("Failed to download file: " + idPath, e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Error downloading: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error downloading: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    String getLatestCursor(String idPath, boolean recursive) throws DropboxException, NotFoundException, RefreshAccessException, RetryLaterException, NotAcceptableException {
        try {
            ListFolderGetLatestCursorResult res = recursive ? this.client.files().listFolderGetLatestCursorBuilder(idPath).withRecursive(Boolean.valueOf(true)).start() : this.client.files().listFolderGetLatestCursor(idPath);
            return res.getCursor();
        }
        catch (ListFolderErrorException e) {
            if (e.errorValue.isPath()) {
                LookupError lookupError = e.errorValue.getPathValue();
                if (lookupError.isNotFound() || lookupError.isNotFolder()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Folder not found in Dropbox: " + idPath), (Throwable)e);
                    }
                    throw new NotFoundException("Folder not found: " + idPath, (Throwable)e);
                }
                if (lookupError.isMalformedPath()) {
                    throw new NotAcceptableException("Malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
                }
                if (lookupError.isRestrictedContent()) {
                    throw new NotAcceptableException("Cannot read folder cursor due to restrictions: " + idPath, (Throwable)e);
                }
                throw new DropboxException("Failed to read folder cursor due to lookup error: " + idPath, e);
            }
            throw new DropboxException("Failed to read folder cursor: " + idPath, e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Failed to read folder cursor: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Failed to read folder cursor: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    String getUserFileLink(String parentPath, String name) {
        StringBuilder link = new StringBuilder(ROOT_URL);
        if (!ROOT_PATH_V2.equals(parentPath)) {
            link.append(this.pathEncoder.encode(parentPath));
        }
        link.append("?preview=").append(Web.formEncode((String)name));
        return link.toString();
    }

    String getUserFolderLink(String path) {
        if (ROOT_PATH_V2.equals(path)) {
            return ROOT_URL;
        }
        return ROOT_URL + this.pathEncoder.encode(path);
    }

    String getDirectLink(String idPath) throws RefreshAccessException, DropboxException, NotFoundException, RetryLaterException, NotAcceptableException {
        if (ROOT_PATH_V2.equals(idPath)) {
            return null;
        }
        try {
            GetTemporaryLinkResult res = this.client.files().getTemporaryLink(idPath);
            return res.getLink();
        }
        catch (GetTemporaryLinkErrorException e) {
            if (e.errorValue.isPath()) {
                LookupError lookupError = e.errorValue.getPathValue();
                if (lookupError.isNotFound() || lookupError.isNotFile() || lookupError.isNotFolder()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("File not found in Dropbox: " + idPath), (Throwable)e);
                    }
                    throw new NotFoundException("File not found: " + idPath, (Throwable)e);
                }
                if (lookupError.isMalformedPath()) {
                    throw new NotAcceptableException("Malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
                }
                if (lookupError.isRestrictedContent()) {
                    throw new NotAcceptableException("Cannot request file link due to restrictions: " + idPath, (Throwable)e);
                }
                throw new DropboxException("Failed to request file link due to lookup error: " + idPath, e);
            }
            throw new DropboxException("Failed to request file link: " + idPath, e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Error requesting file link: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error requesting file link: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    SharedLinkMetadata createSharedLink(String idPath) throws RefreshAccessException, DropboxException, RetryLaterException, NotFoundException, NotAcceptableException, UnauthorizedException {
        if (ROOT_PATH_V2.equals(idPath)) {
            return null;
        }
        try {
            return this.client.sharing().createSharedLinkWithSettings(idPath);
        }
        catch (CreateSharedLinkWithSettingsErrorException e) {
            if (e.errorValue.isPath()) {
                LookupError lookupError = e.errorValue.getPathValue();
                if (lookupError.isNotFound() || lookupError.isNotFile() || lookupError.isNotFolder()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("File not found in Dropbox: " + idPath), (Throwable)e);
                    }
                    throw new NotFoundException("File not found: " + idPath, (Throwable)e);
                }
                if (lookupError.isMalformedPath()) {
                    throw new NotAcceptableException("Malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
                }
                if (lookupError.isRestrictedContent()) {
                    throw new NotAcceptableException("Cannot request shared link due to restrictions: " + idPath, (Throwable)e);
                }
                throw new DropboxException("Failed to request shared link due to lookup error: " + idPath, e);
            }
            if (e.errorValue.isSettingsError()) {
                SharedLinkSettingsError settingsError = e.errorValue.getSettingsErrorValue();
                if (SharedLinkSettingsError.INVALID_SETTINGS.equals((Object)settingsError)) {
                    throw new NotAcceptableException("Cannot request shared link due invalid settings: " + idPath, (Throwable)e);
                }
                if (SharedLinkSettingsError.NOT_AUTHORIZED.equals((Object)settingsError)) {
                    throw new UnauthorizedException("User is not allowed to modify the settings of this link: " + idPath, (Throwable)e);
                }
                throw new NotAcceptableException("Cannot request shared link due settings error: " + idPath, (Throwable)e);
            }
            if (e.errorValue.isAccessDenied()) {
                throw new UnauthorizedException("Access to the requested path is forbidden: " + idPath, (Throwable)e);
            }
            if (e.errorValue.isEmailNotVerified()) {
                throw new NotAcceptableException("User email should be verified to request shared link: " + idPath, (Throwable)e);
            }
            if (e.errorValue.isSharedLinkAlreadyExists()) {
                List<SharedLinkMetadata> links = this.listSharedLinks(idPath);
                if (links.size() > 0) {
                    return links.get(0);
                }
                throw new NotAcceptableException("Shared link already exists but cannot be listed: " + idPath, (Throwable)e);
            }
            throw new DropboxException("Failed to request shared link: " + idPath, e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Error requesting shared link: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error requesting shared link: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    List<SharedLinkMetadata> listSharedLinks(String idPath) throws RefreshAccessException, DropboxException, RetryLaterException, NotFoundException, NotAcceptableException, UnauthorizedException {
        if (ROOT_PATH_V2.equals(idPath)) {
            return null;
        }
        try {
            ListSharedLinksResult res = this.client.sharing().listSharedLinksBuilder().withPath(idPath).start();
            return res.getLinks();
        }
        catch (ListSharedLinksErrorException e) {
            if (e.errorValue.isPath()) {
                LookupError lookupError = e.errorValue.getPathValue();
                if (lookupError.isNotFound() || lookupError.isNotFile() || lookupError.isNotFolder()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("File not found in Dropbox: " + idPath), (Throwable)e);
                    }
                    throw new NotFoundException("File not found: " + idPath, (Throwable)e);
                }
                if (lookupError.isMalformedPath()) {
                    throw new NotAcceptableException("Malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
                }
                if (lookupError.isRestrictedContent()) {
                    throw new NotAcceptableException("Cannot list shared links due to restrictions: " + idPath, (Throwable)e);
                }
                throw new DropboxException("Failed to list shared links due to lookup error: " + idPath, e);
            }
            throw new DropboxException("Failed to list shared link: " + idPath, e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Error listing shared links: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error listing shared links: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    DbxDownloader<FileMetadata> getThumbnail(String idPath, ThumbnailSize size) throws DropboxException, RefreshAccessException, RetryLaterException, NotAcceptableException, NotFoundException {
        if (ROOT_PATH_V2.equals(idPath)) {
            return null;
        }
        try {
            return this.client.files().getThumbnailBuilder(idPath).withSize(size).start();
        }
        catch (ThumbnailErrorException e) {
            if (e.errorValue.isPath()) {
                LookupError lookupError = e.errorValue.getPathValue();
                if (lookupError.isNotFound() || lookupError.isNotFile()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("File not found in Dropbox: " + idPath), (Throwable)e);
                    }
                    throw new NotFoundException("File not found: " + idPath, (Throwable)e);
                }
                if (lookupError.isMalformedPath()) {
                    throw new NotAcceptableException("Malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
                }
                if (lookupError.isRestrictedContent()) {
                    throw new NotAcceptableException("Cannot get thumbnail due to restrictions: " + idPath, (Throwable)e);
                }
                throw new DropboxException("Failed to get thumbnail due to lookup error: " + idPath, e);
            }
            if (e.errorValue.isUnsupportedImage()) {
                throw new NotAcceptableException("The image cannot be converted to a thumbnail: " + idPath, (Throwable)e);
            }
            if (e.errorValue.isConversionError()) {
                throw new NotAcceptableException("An error occurs during thumbnail conversion: " + idPath, (Throwable)e);
            }
            if (e.errorValue.isUnsupportedExtension()) {
                throw new NotAcceptableException("The file extension doesn't allow conversion to a thumbnail: " + idPath, (Throwable)e);
            }
            throw new DropboxException("Failed to get thumbnail: " + idPath, e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Error requesting thumbnail: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error requesting thumbnail: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ". " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    private void handleUploadLookupError(UploadSessionLookupError lookupError, DbxApiException e) throws RetryLaterException, DropboxException {
        if (lookupError.isNotFound()) {
            throw new RetryLaterException("Upload session expired. Please retry", 1000L, (Throwable)e);
        }
        if (lookupError.isIncorrectOffset()) {
            LOG.warn((Object)("Upload failed due to not completed request. Need retry with correct offset from Dropbox (" + lookupError.getIncorrectOffsetValue().getCorrectOffset() + "). " + e.getMessage()));
            throw new RetryLaterException("Upload not complete. Please retry", 1000L, (Throwable)e);
        }
        if (lookupError.isClosed()) {
            throw new DropboxException("Upload cannot be continued if session closed");
        }
        if (lookupError.isNotClosed()) {
            throw new DropboxException("Upload session must be closed before finishing");
        }
        throw new DropboxException("Upload failed", (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileMetadata uploadFile(String parentIdPath, String name, InputStream data, String updateRev) throws DropboxException, NotFoundException, RefreshAccessException, ConflictException, NotAcceptableException, RetryLaterException {
        String path = this.filePath(parentIdPath, name);
        try {
            String uploadSessionId = null;
            long uploaded = 0L;
            long dataStatus = 0L;
            do {
                OutputStream out;
                UploadSessionStartUploader uploader;
                if (uploadSessionId == null) {
                    uploader = this.client.files().uploadSessionStart();
                    try {
                        out = uploader.getOutputStream();
                        int[] transferRes = this.transferChunk(data, out);
                        uploaded += (long)transferRes[0];
                        dataStatus = transferRes[1];
                        UploadSessionStartResult res = (UploadSessionStartResult)uploader.finish();
                        uploadSessionId = res.getSessionId();
                    }
                    finally {
                        uploader.close();
                    }
                } else {
                    uploader = this.client.files().uploadSessionAppendV2(new UploadSessionCursor(uploadSessionId, uploaded));
                    try {
                        out = uploader.getOutputStream();
                        int[] chunkRes = this.transferChunk(data, out);
                        uploaded += (long)chunkRes[0];
                        dataStatus = chunkRes[1];
                        uploader.finish();
                    }
                    catch (UploadSessionLookupErrorException e) {
                        this.handleUploadLookupError(e.errorValue, (DbxApiException)e);
                    }
                    finally {
                        uploader.close();
                    }
                }
            } while (dataStatus != -1L);
            try {
                WriteMode writeMode = updateRev != null ? WriteMode.update((String)updateRev) : WriteMode.ADD;
                UploadSessionFinishUploader finish = this.client.files().uploadSessionFinish(new UploadSessionCursor(uploadSessionId, uploaded), CommitInfo.newBuilder((String)path).withMode(writeMode).build());
                return (FileMetadata)finish.finish();
            }
            catch (UploadSessionFinishErrorException e) {
                if (e.errorValue.isLookupFailed()) {
                    UploadSessionLookupError lookupError = e.errorValue.getLookupFailedValue();
                    this.handleUploadLookupError(lookupError, (DbxApiException)e);
                } else if (e.errorValue.isPath()) {
                    WriteError writeError = e.errorValue.getPathValue();
                    this.handleWriteError(writeError, "Upload", path, (DbxApiException)e);
                } else {
                    if (e.errorValue.isTooManySharedFolderTargets()) {
                        throw new DropboxException("Upload cannot be done for files into too many different shared folders", e);
                    }
                    if (e.errorValue.isTooManyWriteOperations()) {
                        throw new RetryLaterException("Upload cannot complete due too many write operations. Please retry", 1000L, (Throwable)e);
                    }
                }
                throw new DropboxException("Upload failed");
            }
        }
        catch (IllegalStateException e) {
            throw new RetryLaterException("Upload session unexpectedly closed. Please retry", 1000L, (Throwable)e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Error creating file ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + path + ": (" + e.getStatusCode() + ")"), (Throwable)e);
            }
            throw new DropboxException(msg + name);
        }
        catch (DbxException e) {
            String msg = "Error creating file ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + path + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + name);
        }
        catch (IOException e) {
            String msg = "Error creating file ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + path + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + name + ". " + e.getMessage());
        }
    }

    FolderMetadata createFolder(String parentPath, String name) throws DropboxException, NotFoundException, RefreshAccessException, ConflictException, NotAcceptableException, RetryLaterException {
        String path = this.filePath(parentPath, name);
        try {
            CreateFolderResult res = this.client.files().createFolderV2(path);
            return res.getMetadata();
        }
        catch (CreateFolderErrorException e) {
            if (e.errorValue.isPath()) {
                WriteError writeError = e.errorValue.getPathValue();
                this.handleWriteError(writeError, "Folder creation", path, (DbxApiException)e);
            }
            throw new DropboxException("Folder creation failed: " + name, e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Error creating folder: " + name;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ", parentId: + " + parentPath + " (" + e.getStatusCode() + ") " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error creating folder ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + path + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + name);
        }
    }

    Metadata delete(String idPath) throws DropboxException, NotFoundException, RefreshAccessException, NotAcceptableException, RetryLaterException, ConflictException {
        try {
            DeleteResult res = this.client.files().deleteV2(idPath);
            return res.getMetadata();
        }
        catch (DeleteErrorException e) {
            if (e.errorValue.isPathLookup()) {
                LookupError lookupError = e.errorValue.getPathLookupValue();
                if (lookupError.isNotFound()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("File not found on Dropbox (to delete): " + idPath), (Throwable)e);
                    }
                    throw new NotFoundException("No file found: " + idPath);
                }
                if (lookupError.isNotFolder()) {
                    throw new NotFoundException("Folder expected: " + idPath);
                }
                if (lookupError.isNotFile()) {
                    throw new NotFoundException("File expected: " + idPath);
                }
                if (lookupError.isMalformedPath()) {
                    throw new NotAcceptableException("Malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
                }
                if (lookupError.isRestrictedContent()) {
                    throw new NotAcceptableException("Cannot delete due to restrictions: " + idPath, (Throwable)e);
                }
                throw new DropboxException("Failed to delete due to lookup error: " + idPath, e);
            }
            if (e.errorValue.isPathWrite()) {
                WriteError writeError = e.errorValue.getPathWriteValue();
                this.handleWriteError(writeError, "Delete", idPath, (DbxApiException)e);
            } else {
                if (e.errorValue.isTooManyFiles()) {
                    throw new NotAcceptableException("Deletion of " + idPath + " involved too many files. Please retry with less of files", (Throwable)e);
                }
                if (e.errorValue.isTooManyWriteOperations()) {
                    throw new RetryLaterException("Deletion cannot complete due too many write operations. Please retry", 1000L, (Throwable)e);
                }
            }
            throw new DropboxException("Failed to delete: " + idPath, e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Error deleting folder: " + idPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error deleting folder ";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + idPath + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + idPath);
        }
    }

    FileMetadata restoreFile(String path, String rev) throws DropboxException, NotFoundException, RefreshAccessException, RetryLaterException, NotAcceptableException, ConflictException {
        try {
            return this.client.files().restore(path, rev);
        }
        catch (RestoreErrorException e) {
            if (e.errorValue.isPathLookup()) {
                LookupError lookupError = e.errorValue.getPathLookupValue();
                if (lookupError.isNotFound()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("File not found on Dropbox (to restore): " + path + " (" + rev + ")"), (Throwable)e);
                    }
                    throw new NotFoundException("No file found: " + path + " (" + rev + ")");
                }
                if (lookupError.isNotFolder()) {
                    throw new NotFoundException("Folder expected: " + path + " (" + rev + ")");
                }
                if (lookupError.isNotFile()) {
                    throw new NotFoundException("File expected: " + path + " (" + rev + ")");
                }
                if (lookupError.isMalformedPath()) {
                    throw new NotAcceptableException("Malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
                }
                if (lookupError.isRestrictedContent()) {
                    throw new NotAcceptableException("Cannot restore file due to restrictions: " + path + " (" + rev + ")", (Throwable)e);
                }
                throw new DropboxException("Failed to restore file due to lookup error: " + path + " (" + rev + ")", e);
            }
            if (e.errorValue.isInvalidRevision()) {
                throw new NotAcceptableException("Cannot restore file due to wrong revision: " + path + " (" + rev + ")", (Throwable)e);
            }
            if (e.errorValue.isPathWrite()) {
                WriteError writeError = e.errorValue.getPathWriteValue();
                this.handleWriteError(writeError, "File restore", path, (DbxApiException)e);
            }
            throw new DropboxException("File restore failed: " + path + " (" + rev + ")", e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Error restoring file " + path;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (rev: " + rev + "): (" + e.getStatusCode() + ") " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
        catch (DbxException e) {
            String msg = "Error restoring file " + path;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (rev: " + rev + "): " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg);
        }
    }

    Metadata move(String fromIdPath, String toPath) throws DropboxException, ConflictException, NotFoundException, RefreshAccessException, NotAcceptableException, RetryLaterException {
        try {
            RelocationResult res = this.client.files().moveV2(fromIdPath, toPath);
            return res.getMetadata();
        }
        catch (RelocationErrorException e) {
            return this.handleRelocationError(e.errorValue, "Move", fromIdPath, toPath, (DbxApiException)e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Error moving file";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ", " + fromIdPath + " to " + toPath + ": (" + e.getStatusCode() + ") " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + " " + fromIdPath);
        }
        catch (DbxException e) {
            String msg = "Error moving file";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ", " + fromIdPath + " to " + toPath + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + " " + fromIdPath);
        }
    }

    private void handleWriteError(WriteError writeError, String opName, String itemPath, DbxApiException e) throws NotFoundException, ConflictException, NotAcceptableException {
        if (writeError.isConflict()) {
            StringBuilder msg = new StringBuilder(opName + " conflict");
            if (WriteConflictError.FILE.equals((Object)writeError.getConflictValue())) {
                msg.append(": file found at destination");
            } else if (WriteConflictError.FOLDER.equals((Object)writeError.getConflictValue())) {
                msg.append(": folder found at destination");
            } else {
                if (WriteConflictError.FILE_ANCESTOR.equals((Object)writeError.getConflictValue())) {
                    msg.append(": file at an ancestor path - cannot create the required parent folders");
                    throw new NotFoundException(msg.toString(), (Throwable)e);
                }
                msg.append(": check if destination doesn't have such file or folder already");
            }
            throw new ConflictException(msg.toString(), (Throwable)e);
        }
        if (writeError.isNoWritePermission()) {
            throw new NotAcceptableException(opName + " failed due to write permissions: " + itemPath, (Throwable)e);
        }
        if (writeError.isDisallowedName()) {
            throw new NotAcceptableException(opName + " failed due to disallowed name: " + itemPath, (Throwable)e);
        }
        if (writeError.isMalformedPath()) {
            throw new NotAcceptableException(opName + " failed due to malformed path: " + writeError.getMalformedPathValue(), (Throwable)e);
        }
        if (writeError.isInsufficientSpace()) {
            throw new NotAcceptableException(opName + " failed due to insufficient space: " + itemPath, (Throwable)e);
        }
        if (writeError.isTeamFolder()) {
            throw new NotAcceptableException(opName + " not possible for team folder: " + itemPath, (Throwable)e);
        }
        throw new NotAcceptableException(opName + " failed: " + itemPath, (Throwable)e);
    }

    Metadata handleRelocationError(RelocationError relocationError, String opName, String fromPath, String toPath, DbxApiException e) throws NotFoundException, ConflictException, NotAcceptableException, DropboxException {
        if (relocationError.isFromLookup()) {
            LookupError lookupError = relocationError.getFromLookupValue();
            if (lookupError.isNotFound() || lookupError.isNotFile() || lookupError.isNotFolder()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(opName + " source file not found in Dropbox: " + fromPath), (Throwable)e);
                }
                throw new NotFoundException("Source file not found: " + fromPath, (Throwable)e);
            }
            if (lookupError.isMalformedPath()) {
                throw new NotAcceptableException("Source has malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
            }
            if (lookupError.isRestrictedContent()) {
                throw new NotAcceptableException(" of source file cannot be done due to restrictions: " + fromPath, (Throwable)e);
            }
            throw new DropboxException(opName + " failed due to lookup error: " + fromPath, (Throwable)e);
        }
        if (relocationError.isFromWrite()) {
            WriteError writeError = relocationError.getFromWriteValue();
            this.handleWriteError(writeError, "Source " + opName.toLowerCase(), fromPath, e);
        } else if (relocationError.isTo()) {
            WriteError writeError = relocationError.getToValue();
            this.handleWriteError(writeError, opName, toPath, e);
        } else {
            if (relocationError.isCantCopySharedFolder()) {
                throw new NotAcceptableException("Cannot " + opName.toLowerCase() + " shared folder: " + fromPath, (Throwable)e);
            }
            if (relocationError.isCantNestSharedFolder()) {
                throw new NotAcceptableException("Cannot " + opName.toLowerCase() + " shared folder " + fromPath + " into itself", (Throwable)e);
            }
            if (relocationError.isCantMoveFolderIntoItself()) {
                throw new NotAcceptableException("Cannot " + opName.toLowerCase() + " " + fromPath + " into itself", (Throwable)e);
            }
            if (relocationError.isCantTransferOwnership()) {
                throw new NotAcceptableException(opName + " of " + fromPath + " would result in an ownership transfer", (Throwable)e);
            }
            if (relocationError.isTooManyFiles()) {
                throw new NotAcceptableException(opName + " of " + fromPath + " involved too many files. Please retry with less of files", (Throwable)e);
            }
            if (relocationError.isDuplicatedOrNestedPaths()) {
                throw new NotAcceptableException("Cannot " + opName.toLowerCase() + " " + fromPath + " with duplicated/nested paths", (Throwable)e);
            }
            if (relocationError.isInsufficientQuota()) {
                throw new NotAcceptableException(opName + " failed due to insufficient space: " + fromPath + " to " + toPath, (Throwable)e);
            }
        }
        throw new DropboxException("Failed to " + opName.toLowerCase() + ": " + fromPath + " to " + toPath, (Throwable)e);
    }

    Metadata copy(String fromIdPath, String toPath) throws DropboxException, NotFoundException, ConflictException, RefreshAccessException, RetryLaterException, NotAcceptableException {
        try {
            RelocationResult res = this.client.files().copyV2(fromIdPath, toPath);
            return res.getMetadata();
        }
        catch (RelocationErrorException e) {
            return this.handleRelocationError(e.errorValue, "Copy", fromIdPath, toPath, (DbxApiException)e);
        }
        catch (InvalidAccessTokenException e) {
            String msg = "Invalid access credentials";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
            }
            throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
        }
        catch (RetryException e) {
            String msg = "Dropbox overloaded or hit rate exceeded";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
            }
            throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
        }
        catch (BadResponseCodeException e) {
            String msg = "Error copying file";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ", " + fromIdPath + " to " + toPath + ": (" + e.getStatusCode() + ") " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + " " + fromIdPath);
        }
        catch (DbxException e) {
            String msg = "Error copying file";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(msg + ", " + fromIdPath + " to " + toPath + ": " + e.getMessage()), (Throwable)e);
            }
            throw new DropboxException(msg + " " + fromIdPath);
        }
    }

    private void initUser() throws DropboxException, RefreshAccessException, NotFoundException {
    }

    protected String lowerCase(String str) {
        return str.toUpperCase().toLowerCase();
    }

    String filePath(String parent, String name) {
        return parent + '/' + name;
    }

    int[] transferChunk(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[2048];
        int uploaded = 0;
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
            if ((uploaded += len) < 157282304) continue;
            return new int[]{uploaded, 0};
        }
        return new int[]{uploaded, -1};
    }

    class PathEncoder {
        PathEncoder() {
        }

        String encode(String input) {
            StringBuilder resultStr = new StringBuilder();
            for (char ch : input.toCharArray()) {
                if (this.isUnsafe(ch)) {
                    resultStr.append('%');
                    resultStr.append(this.toHex(ch / 16));
                    resultStr.append(this.toHex(ch % 16));
                    continue;
                }
                resultStr.append(ch);
            }
            return resultStr.toString();
        }

        private char toHex(int ch) {
            return (char)(ch < 10 ? 48 + ch : 65 + ch - 10);
        }

        private boolean isUnsafe(char ch) {
            if (ch > '\u0080' || ch < '\u0000') {
                return true;
            }
            return " %$&+,:;=?@<>#%".indexOf(ch) >= 0;
        }
    }

    class ListFolder
    extends ChunkIterator<Metadata> {
        final String idPath;
        String cursor;
        boolean hasMore;

        ListFolder(String idPath, String cursor) throws NotFoundException, DropboxException, RefreshAccessException, RetryLaterException, NotAcceptableException {
            this.idPath = idPath;
            this.cursor = cursor;
            this.iter = this.nextChunk();
        }

        protected Iterator<Metadata> nextChunk() throws NotFoundException, DropboxException, RefreshAccessException, RetryLaterException, NotAcceptableException {
            try {
                ListFolderResult result;
                if (this.cursor == null) {
                    try {
                        result = DropboxAPI.this.client.files().listFolder(this.idPath);
                    }
                    catch (ListFolderErrorException e) {
                        if (e.errorValue.isPath()) {
                            LookupError lookupError = e.errorValue.getPathValue();
                            if (lookupError.isNotFound() || lookupError.isNotFolder()) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Folder not found on Dropbox (to list): " + this.idPath), (Throwable)e);
                                }
                                result = null;
                            }
                            if (lookupError.isMalformedPath()) {
                                throw new NotAcceptableException("Malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
                            }
                            if (lookupError.isRestrictedContent()) {
                                throw new NotAcceptableException("Cannot list folder due to restrictions: " + this.idPath, (Throwable)e);
                            }
                            throw new DropboxException("Failed to list folder due to path lookup error: " + this.idPath, e);
                        }
                        throw new DropboxException("Failed to list folder: " + this.idPath, e);
                    }
                } else {
                    try {
                        result = DropboxAPI.this.client.files().listFolderContinue(this.cursor);
                    }
                    catch (ListFolderContinueErrorException e) {
                        if (e.errorValue.isPath()) {
                            LookupError lookupError = e.errorValue.getPathValue();
                            if (lookupError.isNotFound() || lookupError.isNotFolder()) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Folder not found on Dropbox (to continue list): " + this.idPath), (Throwable)e);
                                }
                                result = null;
                            }
                            if (lookupError.isMalformedPath()) {
                                throw new NotAcceptableException("Malformed path: " + lookupError.getMalformedPathValue(), (Throwable)e);
                            }
                            if (lookupError.isRestrictedContent()) {
                                throw new NotAcceptableException("Cannot continue list folder due to restrictions: " + this.idPath, (Throwable)e);
                            }
                            throw new DropboxException("Failed to continue list folder due to path lookup error: " + this.idPath, e);
                        }
                        if (e.errorValue.isReset()) {
                            throw new ResetCursorException("Reset cursor for: " + this.idPath, e);
                        }
                        throw new DropboxException("Failed to continue list folder: " + this.idPath, e);
                    }
                }
                if (result == null) {
                    throw new NotFoundException("No file or folder found: " + this.idPath);
                }
                this.cursor = result.getCursor();
                this.hasMore = result.getHasMore();
                List children = result.getEntries();
                this.available(children.size());
                return children.iterator();
            }
            catch (InvalidAccessTokenException e) {
                String msg = "Invalid access credentials";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + " (access token) : " + e.getMessage()), (Throwable)e);
                }
                throw new RefreshAccessException(msg + ". Please authorize to Dropbox");
            }
            catch (RetryException e) {
                String msg = "Dropbox overloaded or hit rate exceeded";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new RetryLaterException(msg + ". Please try again later (" + e.getBackoffMillis() + ")", e.getBackoffMillis());
            }
            catch (BadResponseCodeException e) {
                String msg = "Error requesting Metadata service";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new DropboxException(msg);
            }
            catch (DbxException e) {
                String msg = "Error requesting Metadata service";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(msg + ": " + e.getMessage()), (Throwable)e);
                }
                throw new DropboxException(msg);
            }
        }

        protected boolean hasNextChunk() {
            return this.hasMore;
        }

        String getCursor() {
            return this.cursor;
        }
    }

    class StoredToken
    extends UserToken {
        StoredToken() {
        }

        void store(String accessToken) throws CloudDriveException {
            this.store(accessToken, null, -1L);
        }
    }
}

