/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.gdrive;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.StoredCredential;
import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.About;
import com.google.api.services.drive.model.Change;
import com.google.api.services.drive.model.ChangeList;
import com.google.api.services.drive.model.ChildList;
import com.google.api.services.drive.model.ChildReference;
import com.google.api.services.drive.model.File;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfoplus;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.gdrive.GoogleDriveException;
import org.exoplatform.clouddrive.oauth2.UserToken;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class GoogleDriveAPI
implements DataStoreFactory {
    public static final String APP_NAME = "eXo Cloud Drive";
    public static final String FOLDER_MIMETYPE = "application/vnd.google-apps.folder";
    public static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/drive", "https://www.googleapis.com/auth/drive.file", "https://www.googleapis.com/auth/drive.appdata", "https://www.googleapis.com/auth/drive.scripts", "https://www.googleapis.com/auth/drive.apps.readonly", "https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/userinfo.profile");
    public static final String SCOPES_STRING = GoogleDriveAPI.scopes();
    public static final String ACCESS_TYPE = "offline";
    public static final String APPOVAl_PROMT = "force";
    public static final String NO_STATE = "__no_state_set__";
    protected static final String USER_ID = "user_id";
    protected static final Log LOG = ExoLogger.getLogger(GoogleDriveAPI.class);
    final Credential credential;
    final Drive drive;
    final AuthToken token = new AuthToken();
    final Oauth2 oauth2;

    GoogleDriveAPI(String clientId, String clientSecret, String authCode, String redirectUri) throws GoogleDriveException, CloudDriveException {
        GoogleTokenResponse response;
        GoogleAuthorizationCodeFlow authFlow;
        try {
            authFlow = this.createFlow(clientId, clientSecret, this.token);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error creating authentication flow: " + e.getMessage(), e);
        }
        try {
            response = authFlow.newTokenRequest(authCode).setRedirectUri(redirectUri).execute();
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error authenticating user code: " + e.getMessage(), e);
        }
        try {
            this.credential = authFlow.createAndStoreCredential((TokenResponse)response, USER_ID);
        }
        catch (IOException e) {
            throw new CloudDriveException("Error storing user credential: " + e.getMessage(), (Throwable)e);
        }
        this.drive = new Drive.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)this.credential).setApplicationName(APP_NAME).build();
        this.oauth2 = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)this.credential).setApplicationName(APP_NAME).build();
    }

    GoogleDriveAPI(String clientId, String clientSecret, String accessToken, String refreshToken, long expirationTime) throws CloudDriveException {
        GoogleAuthorizationCodeFlow authFlow;
        this.token.load(accessToken, refreshToken, expirationTime);
        try {
            authFlow = this.createFlow(clientId, clientSecret, this.token);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error creating authentication flow: " + e.getMessage(), e);
        }
        try {
            this.credential = authFlow.loadCredential(USER_ID);
        }
        catch (IOException e) {
            throw new CloudDriveException("Error loading Google user credentials: " + e.getMessage(), (Throwable)e);
        }
        this.drive = new Drive.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)this.credential).setApplicationName(APP_NAME).build();
        this.oauth2 = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)this.credential).setApplicationName(APP_NAME).build();
    }

    public DataStore<StoredCredential> getDataStore(String id) throws IOException {
        return this.token.store;
    }

    private static String scopes() {
        StringBuilder s = new StringBuilder();
        for (String scope : SCOPES) {
            s.append(scope);
            s.append(' ');
        }
        return s.toString();
    }

    GoogleAuthorizationCodeFlow createFlow(String clientId, String clientSecret, AuthToken storedToken) throws IOException {
        NetHttpTransport httpTransport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        GoogleAuthorizationCodeFlow.Builder flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, clientId, clientSecret, SCOPES);
        flow.setAccessType(ACCESS_TYPE).setApprovalPrompt(APPOVAl_PROMT);
        if (storedToken != null) {
            flow.setCredentialDataStore((DataStore)storedToken.store);
            flow.setCredentialCreatedListener((AuthorizationCodeFlow.CredentialCreatedListener)storedToken);
            flow.addRefreshListener((CredentialRefreshListener)storedToken);
        }
        return flow.build();
    }

    Userinfoplus userInfo() throws GoogleDriveException, CloudDriveException {
        Userinfoplus userInfo;
        try {
            userInfo = (Userinfoplus)this.oauth2.userinfo().get().execute();
        }
        catch (GoogleJsonResponseException e) {
            GoogleJsonError error = e.getDetails();
            throw new GoogleDriveException("Error getting userinfo: " + error.getMessage() + " (" + error.getCode() + ").", e);
        }
        catch (HttpResponseException e) {
            throw new GoogleDriveException("Error handling userinfo response: " + e.getMessage() + " (" + e.getStatusCode() + ").", e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error requesting userinfo: " + e.getMessage(), e);
        }
        if (userInfo != null && userInfo.getId() != null) {
            return userInfo;
        }
        throw new CloudDriveException("User ID cannot be retrieved.");
    }

    About about() throws GoogleDriveException, CloudDriveAccessException {
        try {
            return (About)this.drive.about().get().execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 403) {
                throw new CloudDriveAccessException("Error accessing About service: " + e.getMessage(), (Throwable)e);
            }
            throw new GoogleDriveException("Error reading About service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error requesting About service: " + e.getMessage(), e);
        }
    }

    ChildIterator children(String fileId) throws GoogleDriveException {
        return new ChildIterator(fileId);
    }

    ChangesIterator changes(long startChangeId) throws GoogleDriveException {
        return new ChangesIterator(startChangeId);
    }

    File file(String fileId) throws GoogleDriveException, NotFoundException {
        try {
            return (File)this.drive.files().get(fileId).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error getting file from Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error requesting file from Files service: " + e.getMessage(), e);
        }
    }

    File insert(File file, AbstractInputStreamContent content) throws GoogleDriveException, CloudDriveAccessException {
        try {
            return (File)this.drive.files().insert(file, content).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to inserting file with content in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            throw new GoogleDriveException("Error inserting file with content to Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error inserting file with content to Files service: " + e.getMessage(), e);
        }
    }

    File insert(File file) throws GoogleDriveException, CloudDriveAccessException {
        try {
            return (File)this.drive.files().insert(file).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to insert file to Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            throw new GoogleDriveException("Error inserting file to Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error inserting file to Files service: " + e.getMessage(), e);
        }
    }

    void update(File file, AbstractInputStreamContent content) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        String fileId = file.getId();
        try {
            this.drive.files().update(fileId, file, content).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to update file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for updating: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error updating file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error upating file with content in Files service: " + e.getMessage(), e);
        }
    }

    void update(File file) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        String fileId = file.getId();
        try {
            this.drive.files().update(fileId, file).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to update file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for updating: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error updating file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error upating file metadata in Files service: " + e.getMessage(), e);
        }
    }

    File copy(File file) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        String fileId = file.getId();
        try {
            return (File)this.drive.files().copy(fileId, file).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to copy file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for copying: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error copying file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error copying file metadata in Files service: " + e.getMessage(), e);
        }
    }

    void delete(String fileId) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        try {
            this.drive.files().delete(fileId).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to delete file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for deleting: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error deleting file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error deleting file in Files service: " + e.getMessage(), e);
        }
    }

    File trash(String fileId) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        try {
            return (File)this.drive.files().trash(fileId).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to trash file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for trashing: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error trashing file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error trashing file in Files service: " + e.getMessage(), e);
        }
    }

    File untrash(String fileId) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        try {
            return (File)this.drive.files().untrash(fileId).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to untrash file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for untrashing: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error untrashing file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error untrashing file in Files service: " + e.getMessage(), e);
        }
    }

    void refreshAccess() throws GoogleDriveException {
        Long expirationTime = this.credential.getExpiresInSeconds();
        if (expirationTime != null && expirationTime < 0L) {
            try {
                this.credential.refreshToken();
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error refreshing access token: " + e.getMessage(), e);
            }
        }
    }

    @Deprecated
    void updateToken(GoogleDriveAPI refreshApi) throws GoogleDriveException {
        this.credential.setRefreshToken(refreshApi.credential.getRefreshToken());
        try {
            this.credential.refreshToken();
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error updating access token: " + e.getMessage(), e);
        }
    }

    void updateToken(UserToken newToken) throws CloudDriveException {
        this.token.merge(newToken);
    }

    AuthToken getToken() {
        return this.token;
    }

    boolean isFolder(File file) {
        return file.getMimeType().equals(FOLDER_MIMETYPE);
    }

    Calendar parseDate(String datestring) {
        Date d = new Date();
        Calendar calendar = Calendar.getInstance();
        if (datestring.endsWith("Z")) {
            try {
                SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                d = s.parse(datestring);
            }
            catch (ParseException pe) {
                SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
                s.setLenient(true);
                try {
                    d = s.parse(datestring);
                }
                catch (ParseException e) {
                    LOG.error((Object)"An error occurred: ", (Throwable)e);
                }
            }
            calendar.setTime(d);
            return calendar;
        }
        String firstpart = datestring.substring(0, datestring.lastIndexOf(45));
        String secondpart = datestring.substring(datestring.lastIndexOf(45));
        secondpart = secondpart.substring(0, secondpart.indexOf(58)) + secondpart.substring(secondpart.indexOf(58) + 1);
        datestring = firstpart + secondpart;
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            d = s.parse(datestring);
        }
        catch (ParseException pe) {
            s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ");
            s.setLenient(true);
            try {
                d = s.parse(datestring);
            }
            catch (ParseException e) {
                LOG.error((Object)"An error occurred: ", (Throwable)e);
            }
        }
        calendar.setTime(d);
        return calendar;
    }

    private boolean isInsufficientPermissions(GoogleJsonResponseException e) {
        List errors;
        GoogleJsonError details = e.getDetails();
        if (e.getStatusCode() == 403 && details != null && (errors = details.getErrors()) != null) {
            for (GoogleJsonError.ErrorInfo ei : errors) {
                if (!ei.getReason().equals("insufficientPermissions")) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    class RequestInitializer
    implements HttpRequestInitializer {
        RequestInitializer() {
        }

        public void initialize(HttpRequest request) throws IOException {
            request.setRetryOnExecuteIOException(true);
            request.setNumberOfRetries(3);
            request.setUnsuccessfulResponseHandler(new HttpUnsuccessfulResponseHandler(){

                public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
                    if (supportsRetry) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            LOG.warn((Object)("Interrupted while waiting for a next attempt of drive operation: " + e.getMessage()));
                            Thread.currentThread().interrupt();
                        }
                    }
                    return supportsRetry;
                }
            });
        }
    }

    class ChangesIterator
    extends ChunkIterator<Change> {
        final Drive.Changes.List request;
        long largestChangeId;

        ChangesIterator(long startChangeId) throws GoogleDriveException {
            try {
                this.request = GoogleDriveAPI.this.drive.changes().list();
                this.request.setIncludeSubscribed(Boolean.valueOf(false));
                this.request.setIncludeDeleted(Boolean.valueOf(true));
                this.request.setStartChangeId(Long.valueOf(startChangeId));
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error creating request to Changes.List service: " + e.getMessage(), e);
            }
            this.iter = this.nextChunk();
        }

        protected Iterator<Change> nextChunk() throws GoogleDriveException {
            try {
                ChangeList children = (ChangeList)this.request.execute();
                this.largestChangeId = children.getLargestChangeId();
                this.request.setPageToken(children.getNextPageToken());
                List items = children.getItems();
                this.available(items.size());
                return items.iterator();
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error requesting Children.List service: " + e.getMessage(), e);
            }
        }

        protected boolean hasNextChunk() {
            return this.request.getPageToken() != null && this.request.getPageToken().length() > 0;
        }

        long getLargestChangeId() {
            return this.largestChangeId;
        }
    }

    class ChildIterator
    extends ChunkIterator<ChildReference> {
        final Drive.Children.List request;

        ChildIterator(String fileId) throws GoogleDriveException {
            try {
                this.request = GoogleDriveAPI.this.drive.children().list(fileId);
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error creating request to Children.List service: " + e.getMessage(), e);
            }
            this.iter = this.nextChunk();
        }

        protected Iterator<ChildReference> nextChunk() throws GoogleDriveException {
            try {
                ChildList children = (ChildList)this.request.execute();
                this.request.setPageToken(children.getNextPageToken());
                List items = children.getItems();
                this.available(items.size());
                return items.iterator();
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error requesting Children.List service: " + e.getMessage(), e);
            }
        }

        protected boolean hasNextChunk() {
            return this.request.getPageToken() != null && this.request.getPageToken().length() > 0;
        }
    }

    class AuthToken
    extends UserToken
    implements CredentialRefreshListener,
    AuthorizationCodeFlow.CredentialCreatedListener {
        final Store store = new Store();

        AuthToken() {
        }

        void store(StoredCredential credential) {
            try {
                this.store(credential.getAccessToken(), credential.getRefreshToken(), credential.getExpirationTimeMilliseconds());
            }
            catch (CloudDriveException e) {
                LOG.error((Object)"Error storing credential", (Throwable)e);
            }
        }

        void store(Credential credential) {
            try {
                this.store(credential.getAccessToken(), credential.getRefreshToken(), credential.getExpirationTimeMilliseconds());
            }
            catch (CloudDriveException e) {
                LOG.error((Object)"Error storing credential", (Throwable)e);
            }
        }

        public void onCredentialCreated(Credential credential, TokenResponse tokenResponse) throws IOException {
            this.store(credential);
        }

        public void onTokenResponse(Credential credential, TokenResponse tokenResponse) throws IOException {
            this.store(credential);
        }

        public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) throws IOException {
            String errDescription = tokenErrorResponse.getErrorDescription();
            String errURI = tokenErrorResponse.getErrorUri();
            LOG.error((Object)("Error refreshing credentials: " + tokenErrorResponse.getError() + (errDescription != null ? " " + errDescription : "") + (errURI != null ? ". Error URI: " + errURI : "")));
        }

        public void merge(UserToken newToken) throws CloudDriveException {
            super.merge(newToken);
            if (GoogleDriveAPI.this.credential != null) {
                GoogleDriveAPI.this.credential.setAccessToken(newToken.getAccessToken());
                GoogleDriveAPI.this.credential.setExpirationTimeMilliseconds(Long.valueOf(newToken.getExpirationTime()));
                GoogleDriveAPI.this.credential.setRefreshToken(newToken.getRefreshToken());
            }
        }

        class Store
        implements DataStore<StoredCredential> {
            Store() {
            }

            public DataStoreFactory getDataStoreFactory() {
                return GoogleDriveAPI.this;
            }

            public String getId() {
                return GoogleDriveAPI.class.getSimpleName();
            }

            public int size() throws IOException {
                return this.isEmpty() ? 0 : 1;
            }

            public boolean isEmpty() throws IOException {
                return AuthToken.this.getAccessToken() == null || AuthToken.this.getRefreshToken() == null;
            }

            public boolean containsKey(String userId) throws IOException {
                return GoogleDriveAPI.USER_ID.equals(userId);
            }

            public boolean containsValue(StoredCredential value) throws IOException {
                return value.getAccessToken().equals(AuthToken.this.getAccessToken()) && value.getRefreshToken().equals(AuthToken.this.getRefreshToken()) && value.getExpirationTimeMilliseconds().longValue() == AuthToken.this.getExpirationTime();
            }

            public Set<String> keySet() throws IOException {
                HashSet<String> keys = new HashSet<String>();
                keys.add(GoogleDriveAPI.USER_ID);
                return keys;
            }

            public Collection<StoredCredential> values() throws IOException {
                StoredCredential[] single = new StoredCredential[]{this.get(GoogleDriveAPI.USER_ID)};
                return Arrays.asList(single);
            }

            public StoredCredential get(String userId) throws IOException {
                StoredCredential stored = new StoredCredential();
                stored.setAccessToken(AuthToken.this.getAccessToken());
                stored.setRefreshToken(AuthToken.this.getRefreshToken());
                stored.setExpirationTimeMilliseconds(Long.valueOf(AuthToken.this.getExpirationTime()));
                return stored;
            }

            public DataStore<StoredCredential> set(String userId, StoredCredential value) throws IOException {
                AuthToken.this.store(value);
                return this;
            }

            public DataStore<StoredCredential> clear() throws IOException {
                return this;
            }

            public DataStore<StoredCredential> delete(String userId) throws IOException {
                return this;
            }
        }
    }
}

