/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.auth.oauth2;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.exoplatform.shaded.google.api.client.auth.oauth2.Credential;
import org.exoplatform.shaded.google.api.client.http.HttpRequest;
import org.exoplatform.shaded.google.api.client.http.UrlEncodedContent;
import org.exoplatform.shaded.google.api.client.util.Data;
import org.exoplatform.shaded.google.api.client.util.Preconditions;

public class BearerToken {
    static final String PARAM_NAME = "access_token";
    static final Pattern INVALID_TOKEN_ERROR = Pattern.compile("\\s*error\\s*=\\s*\"?invalid_token\"?");

    public static Credential.AccessMethod authorizationHeaderAccessMethod() {
        return new AuthorizationHeaderAccessMethod();
    }

    public static Credential.AccessMethod formEncodedBodyAccessMethod() {
        return new FormEncodedBodyAccessMethod();
    }

    public static Credential.AccessMethod queryParameterAccessMethod() {
        return new QueryParameterAccessMethod();
    }

    static final class QueryParameterAccessMethod
    implements Credential.AccessMethod {
        QueryParameterAccessMethod() {
        }

        public void intercept(HttpRequest request, String accessToken) throws IOException {
            request.getUrl().set(BearerToken.PARAM_NAME, accessToken);
        }

        public String getAccessTokenFromRequest(HttpRequest request) {
            Object param = request.getUrl().get(BearerToken.PARAM_NAME);
            return param == null ? null : param.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FormEncodedBodyAccessMethod
    implements Credential.AccessMethod {
        FormEncodedBodyAccessMethod() {
        }

        @Override
        public void intercept(HttpRequest request, String accessToken) throws IOException {
            Preconditions.checkArgument(!"GET".equals(request.getRequestMethod()), "HTTP GET method is not supported");
            FormEncodedBodyAccessMethod.getData(request).put(BearerToken.PARAM_NAME, accessToken);
        }

        @Override
        public String getAccessTokenFromRequest(HttpRequest request) {
            Object bodyParam = FormEncodedBodyAccessMethod.getData(request).get(BearerToken.PARAM_NAME);
            return bodyParam == null ? null : bodyParam.toString();
        }

        private static Map<String, Object> getData(HttpRequest request) {
            return Data.mapOf(UrlEncodedContent.getContent(request).getData());
        }
    }

    static final class AuthorizationHeaderAccessMethod
    implements Credential.AccessMethod {
        static final String HEADER_PREFIX = "Bearer ";

        AuthorizationHeaderAccessMethod() {
        }

        public void intercept(HttpRequest request, String accessToken) throws IOException {
            request.getHeaders().setAuthorization(HEADER_PREFIX + accessToken);
        }

        public String getAccessTokenFromRequest(HttpRequest request) {
            List<String> authorizationAsList = request.getHeaders().getAuthorizationAsList();
            if (authorizationAsList != null) {
                for (String header : authorizationAsList) {
                    if (!header.startsWith(HEADER_PREFIX)) continue;
                    return header.substring(HEADER_PREFIX.length());
                }
            }
            return null;
        }
    }
}

