/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.googleapis.auth.oauth2;

import java.io.IOException;
import java.util.Collection;
import org.exoplatform.shaded.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import org.exoplatform.shaded.google.api.client.auth.oauth2.BearerToken;
import org.exoplatform.shaded.google.api.client.auth.oauth2.ClientParametersAuthentication;
import org.exoplatform.shaded.google.api.client.auth.oauth2.Credential;
import org.exoplatform.shaded.google.api.client.auth.oauth2.CredentialRefreshListener;
import org.exoplatform.shaded.google.api.client.auth.oauth2.CredentialStore;
import org.exoplatform.shaded.google.api.client.auth.oauth2.StoredCredential;
import org.exoplatform.shaded.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import org.exoplatform.shaded.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import org.exoplatform.shaded.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import org.exoplatform.shaded.google.api.client.http.GenericUrl;
import org.exoplatform.shaded.google.api.client.http.HttpExecuteInterceptor;
import org.exoplatform.shaded.google.api.client.http.HttpRequestInitializer;
import org.exoplatform.shaded.google.api.client.http.HttpTransport;
import org.exoplatform.shaded.google.api.client.json.JsonFactory;
import org.exoplatform.shaded.google.api.client.util.Beta;
import org.exoplatform.shaded.google.api.client.util.Clock;
import org.exoplatform.shaded.google.api.client.util.Preconditions;
import org.exoplatform.shaded.google.api.client.util.store.DataStore;
import org.exoplatform.shaded.google.api.client.util.store.DataStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleAuthorizationCodeFlow
extends AuthorizationCodeFlow {
    private final String approvalPrompt;
    private final String accessType;

    public GoogleAuthorizationCodeFlow(HttpTransport transport, JsonFactory jsonFactory, String clientId, String clientSecret, Collection<String> scopes) {
        this(new Builder(transport, jsonFactory, clientId, clientSecret, scopes));
    }

    protected GoogleAuthorizationCodeFlow(Builder builder) {
        super(builder);
        this.accessType = builder.accessType;
        this.approvalPrompt = builder.approvalPrompt;
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest newTokenRequest(String authorizationCode) {
        return new GoogleAuthorizationCodeTokenRequest(this.getTransport(), this.getJsonFactory(), this.getTokenServerEncodedUrl(), "", "", authorizationCode, "").setClientAuthentication(this.getClientAuthentication()).setRequestInitializer(this.getRequestInitializer()).setScopes((Collection)this.getScopes());
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl newAuthorizationUrl() {
        return new GoogleAuthorizationCodeRequestUrl(this.getAuthorizationServerEncodedUrl(), this.getClientId(), "", this.getScopes()).setAccessType(this.accessType).setApprovalPrompt(this.approvalPrompt);
    }

    public final String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public final String getAccessType() {
        return this.accessType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AuthorizationCodeFlow.Builder {
        String approvalPrompt;
        String accessType;

        public Builder(HttpTransport transport, JsonFactory jsonFactory, String clientId, String clientSecret, Collection<String> scopes) {
            super(BearerToken.authorizationHeaderAccessMethod(), transport, jsonFactory, new GenericUrl("https://accounts.google.com/o/oauth2/token"), new ClientParametersAuthentication(clientId, clientSecret), clientId, "https://accounts.google.com/o/oauth2/auth");
            this.setScopes((Collection)scopes);
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, GoogleClientSecrets clientSecrets, Collection<String> scopes) {
            super(BearerToken.authorizationHeaderAccessMethod(), transport, jsonFactory, new GenericUrl("https://accounts.google.com/o/oauth2/token"), new ClientParametersAuthentication(clientSecrets.getDetails().getClientId(), clientSecrets.getDetails().getClientSecret()), clientSecrets.getDetails().getClientId(), "https://accounts.google.com/o/oauth2/auth");
            this.setScopes((Collection)scopes);
        }

        @Override
        public GoogleAuthorizationCodeFlow build() {
            return new GoogleAuthorizationCodeFlow(this);
        }

        @Override
        public Builder setDataStoreFactory(DataStoreFactory dataStore) throws IOException {
            return (Builder)super.setDataStoreFactory(dataStore);
        }

        @Override
        public Builder setCredentialDataStore(DataStore<StoredCredential> typedDataStore) {
            return (Builder)super.setCredentialDataStore(typedDataStore);
        }

        @Override
        public Builder setCredentialCreatedListener(AuthorizationCodeFlow.CredentialCreatedListener credentialCreatedListener) {
            return (Builder)super.setCredentialCreatedListener(credentialCreatedListener);
        }

        @Override
        @Deprecated
        @Beta
        public Builder setCredentialStore(CredentialStore credentialStore) {
            return (Builder)super.setCredentialStore(credentialStore);
        }

        @Override
        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            return (Builder)super.setRequestInitializer(requestInitializer);
        }

        @Override
        public Builder setScopes(Collection<String> scopes) {
            Preconditions.checkState(!scopes.isEmpty());
            return (Builder)super.setScopes(scopes);
        }

        @Override
        public Builder setMethod(Credential.AccessMethod method) {
            return (Builder)super.setMethod(method);
        }

        @Override
        public Builder setTransport(HttpTransport transport) {
            return (Builder)super.setTransport(transport);
        }

        @Override
        public Builder setJsonFactory(JsonFactory jsonFactory) {
            return (Builder)super.setJsonFactory(jsonFactory);
        }

        @Override
        public Builder setTokenServerUrl(GenericUrl tokenServerUrl) {
            return (Builder)super.setTokenServerUrl(tokenServerUrl);
        }

        @Override
        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            return (Builder)super.setClientAuthentication(clientAuthentication);
        }

        @Override
        public Builder setClientId(String clientId) {
            return (Builder)super.setClientId(clientId);
        }

        @Override
        public Builder setAuthorizationServerEncodedUrl(String authorizationServerEncodedUrl) {
            return (Builder)super.setAuthorizationServerEncodedUrl(authorizationServerEncodedUrl);
        }

        @Override
        public Builder setClock(Clock clock) {
            return (Builder)super.setClock(clock);
        }

        @Override
        public Builder addRefreshListener(CredentialRefreshListener refreshListener) {
            return (Builder)super.addRefreshListener(refreshListener);
        }

        @Override
        public Builder setRefreshListeners(Collection<CredentialRefreshListener> refreshListeners) {
            return (Builder)super.setRefreshListeners(refreshListeners);
        }

        public Builder setApprovalPrompt(String approvalPrompt) {
            this.approvalPrompt = approvalPrompt;
            return this;
        }

        public final String getApprovalPrompt() {
            return this.approvalPrompt;
        }

        public Builder setAccessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        public final String getAccessType() {
            return this.accessType;
        }
    }
}

