/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.googleapis.auth.clientlogin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Map;
import org.exoplatform.shaded.google.api.client.http.HttpResponse;
import org.exoplatform.shaded.google.api.client.util.Beta;
import org.exoplatform.shaded.google.api.client.util.ClassInfo;
import org.exoplatform.shaded.google.api.client.util.FieldInfo;
import org.exoplatform.shaded.google.api.client.util.GenericData;
import org.exoplatform.shaded.google.api.client.util.ObjectParser;
import org.exoplatform.shaded.google.api.client.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
final class AuthKeyValueParser
implements ObjectParser {
    public static final AuthKeyValueParser INSTANCE = new AuthKeyValueParser();

    public String getContentType() {
        return "text/plain";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parse(HttpResponse response, Class<T> dataClass) throws IOException {
        response.setContentLoggingLimit(0);
        InputStream content = response.getContent();
        try {
            T t = this.parse(content, dataClass);
            return t;
        }
        finally {
            content.close();
        }
    }

    public <T> T parse(InputStream content, Class<T> dataClass) throws IOException {
        String line;
        ClassInfo classInfo = ClassInfo.of(dataClass);
        T newInstance = Types.newInstance(dataClass);
        BufferedReader reader = new BufferedReader(new InputStreamReader(content));
        while ((line = reader.readLine()) != null) {
            int equals = line.indexOf(61);
            String key = line.substring(0, equals);
            String value = line.substring(equals + 1);
            Field field = classInfo.getField(key);
            if (field != null) {
                Class<?> fieldClass = field.getType();
                Object fieldValue = fieldClass == Boolean.TYPE || fieldClass == Boolean.class ? Boolean.valueOf(value) : value;
                FieldInfo.setFieldValue(field, newInstance, fieldValue);
                continue;
            }
            if (GenericData.class.isAssignableFrom(dataClass)) {
                GenericData data = (GenericData)newInstance;
                data.set(key, value);
                continue;
            }
            if (!Map.class.isAssignableFrom(dataClass)) continue;
            Map map = (Map)newInstance;
            map.put(key, value);
        }
        return newInstance;
    }

    private AuthKeyValueParser() {
    }

    @Override
    public <T> T parseAndClose(InputStream in, Charset charset, Class<T> dataClass) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, charset);
        return this.parseAndClose((Reader)reader, dataClass);
    }

    @Override
    public Object parseAndClose(InputStream in, Charset charset, Type dataType) {
        throw new UnsupportedOperationException("Type-based parsing is not yet supported -- use Class<T> instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T parseAndClose(Reader reader, Class<T> dataClass) throws IOException {
        try {
            String line;
            ClassInfo classInfo = ClassInfo.of(dataClass);
            T newInstance = Types.newInstance(dataClass);
            BufferedReader breader = new BufferedReader(reader);
            while ((line = breader.readLine()) != null) {
                int equals = line.indexOf(61);
                String key = line.substring(0, equals);
                String value = line.substring(equals + 1);
                Field field = classInfo.getField(key);
                if (field != null) {
                    Class<?> fieldClass = field.getType();
                    Object fieldValue = fieldClass == Boolean.TYPE || fieldClass == Boolean.class ? Boolean.valueOf(value) : value;
                    FieldInfo.setFieldValue(field, newInstance, fieldValue);
                    continue;
                }
                if (GenericData.class.isAssignableFrom(dataClass)) {
                    GenericData data = (GenericData)newInstance;
                    data.set(key, value);
                    continue;
                }
                if (!Map.class.isAssignableFrom(dataClass)) continue;
                Map map = (Map)newInstance;
                map.put(key, value);
            }
            T t = newInstance;
            return t;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public Object parseAndClose(Reader reader, Type dataType) {
        throw new UnsupportedOperationException("Type-based parsing is not yet supported -- use Class<T> instead");
    }
}

