/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.googledrive;

import com.google.api.client.util.DateTime;
import com.google.api.services.drive.model.About;
import com.google.api.services.drive.model.Change;
import com.google.api.services.drive.model.ChildReference;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.ParentReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.googledrive.GoogleDriveAPI;
import org.exoplatform.clouddrive.googledrive.GoogleDriveConnector;
import org.exoplatform.clouddrive.googledrive.GoogleDriveException;
import org.exoplatform.clouddrive.googledrive.GoogleProvider;
import org.exoplatform.clouddrive.googledrive.GoogleUser;
import org.exoplatform.clouddrive.googledrive.NoRefreshTokenException;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class JCRLocalGoogleDrive
extends JCRLocalCloudDrive {
    protected JCRLocalGoogleDrive(GoogleUser user, Node driveNode, SessionProviderService sessionProviders) throws CloudDriveException, RepositoryException {
        super(user, driveNode, sessionProviders);
    }

    protected JCRLocalGoogleDrive(GoogleDriveConnector.API apiBuilder, GoogleProvider provider, Node driveNode, SessionProviderService sessionProviders) throws RepositoryException, GoogleDriveException, CloudDriveException {
        super(JCRLocalGoogleDrive.loadUser(apiBuilder, provider, driveNode), driveNode, sessionProviders);
    }

    protected static GoogleUser loadUser(GoogleDriveConnector.API apiBuilder, GoogleProvider provider, Node driveNode) throws RepositoryException, GoogleDriveException, CloudDriveException {
        String refreshToken;
        String username = driveNode.getProperty("ecd:cloudUserName").getString();
        String email = driveNode.getProperty("ecd:userEmail").getString();
        String userId = driveNode.getProperty("ecd:cloudUserId").getString();
        String accessToken = driveNode.getProperty("gdrive:oauth2AccessToken").getString();
        try {
            refreshToken = driveNode.getProperty("gdrive:oauth2RefreshToken").getString();
        }
        catch (PathNotFoundException e) {
            refreshToken = null;
        }
        long expirationTime = driveNode.getProperty("gdrive:oauth2TokenExpirationTime").getLong();
        GoogleDriveAPI driveAPI = apiBuilder.load(userId, refreshToken, accessToken, expirationTime).build();
        return new GoogleUser(userId, username, email, provider, driveAPI);
    }

    @Override
    public GoogleUser getUser() {
        return (GoogleUser)this.user;
    }

    @Override
    protected void checkAccess() throws GoogleDriveException {
        this.getUser().api().checkAccess();
    }

    @Override
    protected void updateAccessKey(CloudUser newUser) throws CloudDriveException, RepositoryException {
        GoogleDriveAPI api = this.getUser().api();
        api.updateToken(((GoogleUser)newUser).api());
        Node driveNode = this.rootNode();
        try {
            driveNode.setProperty("gdrive:oauth2AccessToken", api.getAccessToken());
            driveNode.setProperty("gdrive:oauth2RefreshToken", api.getRefreshToken());
            driveNode.setProperty("gdrive:oauth2TokenExpirationTime", api.getExpirationTime());
            driveNode.save();
        }
        catch (RepositoryException e) {
            this.rollback(driveNode);
            throw new GoogleDriveException("Error updating access key: " + e.getMessage(), e);
        }
    }

    @Override
    protected boolean isSyncSupported(CloudFile cloudFile) {
        return false;
    }

    @Override
    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        About about = this.getUser().api().about();
        driveNode.setProperty("ecd:id", about.getRootFolderId());
        driveNode.setProperty("ecd:url", about.getSelfLink());
    }

    @Override
    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new GoogleDriveConnect();
    }

    @Override
    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new GoogleDriveSync();
    }

    @Override
    protected JCRLocalCloudDrive.SyncFileCommand getSyncFileCommand(Node file) throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        throw new SyncNotSupportedException("File synchronization not supported");
    }

    protected class GoogleDriveSync
    extends JCRLocalCloudDrive.SyncCommand {
        protected final GoogleDriveAPI api;
        GoogleDriveAPI.ChangesIterator changes;

        protected GoogleDriveSync() throws RepositoryException, DriveRemovedException {
            super(JCRLocalGoogleDrive.this);
            this.api = JCRLocalGoogleDrive.this.getUser().api();
        }

        @Override
        protected void syncFiles() throws RepositoryException, CloudDriveException {
            String largestChangeId = "";
            try {
                About about = this.api.about();
                largestChangeId = String.valueOf(about.getLargestChangeId());
            }
            catch (Exception e) {
                throw new NoRefreshTokenException("Error calling About service of Google Drive: " + e.getMessage(), e);
            }
            String localChangeId = this.driveRoot.getProperty("gdrive:largestChangeId").getString();
            if (largestChangeId.equals(localChangeId)) {
                return;
            }
            BigInteger changeId = new BigInteger(localChangeId);
            BigInteger startChangeId = changeId.add(BigInteger.ONE);
            this.changes = this.api.changes(startChangeId);
            if (this.changes.hasNext()) {
                this.readLocalNodes();
                this.syncNext();
            }
            this.driveRoot.setProperty("gdrive:largestChangeId", largestChangeId);
        }

        protected void syncNext() throws RepositoryException, CloudDriveException {
            while (this.changes.hasNext()) {
                boolean deleted;
                Change ch = (Change)this.changes.next();
                File gf = ch.getFile();
                String[] parents = this.getParents(gf);
                boolean bl = deleted = parents.length == 0 || gf.getLabels().getTrashed() != false ? true : ch.getDeleted();
                if (deleted) {
                    this.deleteFile(ch.getFileId());
                    continue;
                }
                this.updateFile(gf, parents);
            }
        }

        protected void deleteFile(String fileId) throws RepositoryException {
            List existing = (List)this.nodes.get(fileId);
            if (existing != null) {
                for (Node en : existing) {
                    String enpath = en.getPath();
                    Iterator ecnliter = this.nodes.values().iterator();
                    while (ecnliter.hasNext()) {
                        List ecnl = (List)ecnliter.next();
                        if (ecnl == existing) continue;
                        Iterator ecniter = ecnl.iterator();
                        while (ecniter.hasNext()) {
                            Node ecn = (Node)ecniter.next();
                            if (!ecn.getPath().startsWith(enpath)) continue;
                            ecniter.remove();
                        }
                        if (ecnl.size() != 0) continue;
                        ecnliter.remove();
                    }
                    en.remove();
                }
                this.nodes.remove(fileId);
            }
        }

        protected void updateFile(File gf, String[] parentIds) throws CloudDriveException, RepositoryException {
            ArrayList<Node> existing = (ArrayList<Node>)this.nodes.get(gf.getId());
            boolean isFolder = this.api.isFolder(gf);
            for (String parentFileId : parentIds) {
                List fileParent = (List)this.nodes.get(parentFileId);
                if (fileParent == null) {
                    this.syncNext();
                    fileParent = (List)this.nodes.get(parentFileId);
                    if (fileParent == null) {
                        throw new CloudDriveException("Inconsistent changes: cannot find parent Node for '" + gf.getTitle() + "'");
                    }
                }
                for (Node fp : fileParent) {
                    Node localNode = null;
                    Node localNodeCopy = null;
                    if (existing == null) {
                        existing = new ArrayList<Node>();
                        this.nodes.put(gf.getId(), existing);
                    } else {
                        Iterator i$ = existing.iterator();
                        while (i$.hasNext()) {
                            Node n;
                            localNodeCopy = n = (Node)i$.next();
                            if (!n.getParent().isSame((Item)fp)) continue;
                            localNode = n;
                            break;
                        }
                    }
                    if (localNode == null) {
                        localNode = isFolder ? (localNodeCopy == null ? JCRLocalGoogleDrive.this.openFolder(gf.getId(), gf.getTitle(), fp) : JCRLocalGoogleDrive.this.copyNode(localNodeCopy, fp)) : JCRLocalGoogleDrive.this.openFile(gf.getId(), gf.getTitle(), gf.getMimeType(), fp);
                        existing.add(localNode);
                    } else if (!localNode.getProperty("exo:title").getString().equals(gf.getTitle())) {
                        localNode = JCRLocalGoogleDrive.this.moveNode(localNode, gf.getTitle(), fp);
                    }
                    Calendar created = this.api.parseDate(gf.getCreatedDate().toStringRfc3339());
                    Calendar modified = this.api.parseDate(gf.getModifiedDate().toStringRfc3339());
                    if (isFolder) {
                        JCRLocalGoogleDrive.this.initFolder(localNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                    } else {
                        JCRLocalGoogleDrive.this.initFile(localNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), gf.getEmbedLink(), gf.getThumbnailLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                    }
                    this.result.add(new JCRLocalCloudFile(localNode.getPath(), gf.getId(), gf.getTitle(), gf.getAlternateLink(), gf.getEmbedLink(), gf.getThumbnailLink(), gf.getMimeType(), gf.getLastModifyingUserName(), (String)gf.getOwnerNames().get(0), created, modified, isFolder));
                    this.synced.add(localNode);
                }
            }
            if (existing != null) {
                Iterator niter = existing.iterator();
                while (niter.hasNext()) {
                    Node n = (Node)niter.next();
                    if (this.synced.contains(n)) continue;
                    niter.remove();
                    n.remove();
                }
            }
        }

        protected String[] getParents(File gfile) {
            List parents;
            if (gfile != null && (parents = gfile.getParents()) != null) {
                String[] parentIds = new String[parents.size()];
                for (int i = 0; i < parents.size(); ++i) {
                    parentIds[i] = ((ParentReference)parents.get(i)).getId();
                }
                return parentIds;
            }
            return new String[0];
        }

        @Override
        public int getComplete() {
            if (this.changes != null) {
                return this.changes.fetched;
            }
            return 0;
        }

        @Override
        public int getAvailable() {
            if (this.changes != null) {
                return this.changes.available;
            }
            return 0;
        }
    }

    protected class GoogleDriveConnect
    extends JCRLocalCloudDrive.ConnectCommand {
        protected final GoogleDriveAPI api;
        List<GoogleDriveAPI.ChildIterator> iterators;

        protected GoogleDriveConnect() throws RepositoryException, DriveRemovedException {
            super(JCRLocalGoogleDrive.this);
            this.iterators = new ArrayList<GoogleDriveAPI.ChildIterator>();
            this.api = JCRLocalGoogleDrive.this.getUser().api();
        }

        @Override
        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            About about = this.api.about();
            String id = about.getRootFolderId();
            this.fetchChilds(id, this.driveRoot);
            this.driveRoot.setProperty("gdrive:oauth2AccessToken", this.api.getAccessToken());
            this.driveRoot.setProperty("gdrive:oauth2RefreshToken", this.api.getRefreshToken());
            this.driveRoot.setProperty("gdrive:oauth2TokenExpirationTime", this.api.getExpirationTime());
            this.driveRoot.setProperty("gdrive:largestChangeId", about.getLargestChangeId().longValue());
        }

        protected void fetchChilds(String fileId, Node parent) throws CloudDriveException, RepositoryException {
            GoogleDriveAPI.ChildIterator children = this.api.children(fileId);
            this.iterators.add(children);
            while (children.hasNext()) {
                Node localNode;
                ChildReference child = (ChildReference)children.next();
                File gf = this.api.file(child.getId());
                if (gf.getLabels().getTrashed().booleanValue()) continue;
                boolean isFolder = this.api.isFolder(gf);
                DateTime createDate = gf.getCreatedDate();
                if (createDate == null) {
                    throw new GoogleDriveException("File " + gf.getTitle() + " doesn't have Created Date.");
                }
                Calendar created = this.api.parseDate(createDate.toStringRfc3339());
                DateTime modifiedDate = gf.getModifiedDate();
                if (modifiedDate == null) {
                    throw new GoogleDriveException("File " + gf.getTitle() + " doesn't have Modified Date.");
                }
                Calendar modified = this.api.parseDate(modifiedDate.toStringRfc3339());
                if (isFolder) {
                    localNode = JCRLocalGoogleDrive.this.openFolder(gf.getId(), gf.getTitle(), parent);
                    JCRLocalGoogleDrive.this.initFolder(localNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                    this.fetchChilds(gf.getId(), localNode);
                } else {
                    localNode = JCRLocalGoogleDrive.this.openFile(gf.getId(), gf.getTitle(), gf.getMimeType(), parent);
                    JCRLocalGoogleDrive.this.initFile(localNode, gf.getId(), gf.getTitle(), gf.getMimeType(), gf.getAlternateLink(), gf.getEmbedLink(), gf.getThumbnailLink(), (String)gf.getOwnerNames().get(0), gf.getLastModifyingUserName(), created, modified);
                }
                this.result.add(new JCRLocalCloudFile(localNode.getPath(), gf.getId(), gf.getTitle(), gf.getAlternateLink(), gf.getEmbedLink(), gf.getThumbnailLink(), gf.getMimeType(), gf.getLastModifyingUserName(), (String)gf.getOwnerNames().get(0), created, modified, isFolder));
            }
        }

        @Override
        public int getComplete() {
            int complete = 0;
            for (GoogleDriveAPI.ChildIterator child : this.iterators) {
                complete += child.fetched;
            }
            return complete;
        }

        @Override
        public int getAvailable() {
            int available = 0;
            for (GoogleDriveAPI.ChildIterator child : this.iterators) {
                available += child.available;
            }
            return Math.round((float)available * 1.075f);
        }
    }
}

