/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.batch;

import com.google.api.client.googleapis.batch.BatchCallback;
import com.google.api.client.googleapis.batch.BatchUnparsedResponse;
import com.google.api.client.googleapis.batch.MultipartMixedContent;
import com.google.api.client.http.BackOffPolicy;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchRequest {
    private GenericUrl batchUrl = new GenericUrl("https://www.googleapis.com/batch");
    private final HttpRequestFactory requestFactory;
    List<RequestInfo<?, ?>> requestInfos = new ArrayList();

    public BatchRequest(HttpTransport transport, HttpRequestInitializer httpRequestInitializer) {
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
    }

    public BatchRequest setBatchUrl(GenericUrl batchUrl) {
        this.batchUrl = batchUrl;
        return this;
    }

    public GenericUrl getBatchUrl() {
        return this.batchUrl;
    }

    public <T, E> BatchRequest queue(HttpRequest httpRequest, Class<T> dataClass, Class<E> errorClass, BatchCallback<T, E> callback) throws IOException {
        Preconditions.checkNotNull((Object)httpRequest);
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(dataClass);
        Preconditions.checkNotNull(errorClass);
        this.requestInfos.add(new RequestInfo<T, E>(callback, dataClass, errorClass, httpRequest));
        return this;
    }

    public int size() {
        return this.requestInfos.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        boolean retryAllowed;
        Preconditions.checkState((!this.requestInfos.isEmpty() ? 1 : 0) != 0);
        HttpRequest batchRequest = this.requestFactory.buildPostRequest(this.batchUrl, null);
        batchRequest.setInterceptor((HttpExecuteInterceptor)new BatchInterceptor());
        int retriesRemaining = batchRequest.getNumberOfRetries();
        BackOffPolicy backOffPolicy = batchRequest.getBackOffPolicy();
        if (backOffPolicy != null) {
            backOffPolicy.reset();
        }
        do {
            long backOffTime;
            BatchUnparsedResponse batchResponse;
            retryAllowed = retriesRemaining > 0;
            batchRequest.setContent((HttpContent)new MultipartMixedContent(this.requestInfos, "__END_OF_PART__"));
            HttpResponse response = batchRequest.execute();
            try {
                String contentType = response.getHeaders().getContentType();
                String[] parts = contentType.split(";");
                String boundary = null;
                for (String part : parts) {
                    if (!part.contains("boundary=")) continue;
                    int boundaryStartIndex = part.indexOf("boundary=");
                    boundary = "--" + part.substring(boundaryStartIndex + "boundary=".length());
                    break;
                }
                InputStream contentStream = response.getContent();
                batchResponse = new BatchUnparsedResponse(contentStream, boundary, this.requestInfos, retryAllowed);
                while (batchResponse.hasNext) {
                    batchResponse.parseNextResponse();
                }
            }
            finally {
                response.disconnect();
            }
            List<RequestInfo<?, ?>> unsuccessfulRequestInfos = batchResponse.unsuccessfulRequestInfos;
            if (unsuccessfulRequestInfos.isEmpty()) break;
            this.requestInfos = unsuccessfulRequestInfos;
            if (batchResponse.backOffRequired && backOffPolicy != null && (backOffTime = backOffPolicy.getNextBackOffMillis()) != -1L) {
                this.sleep(backOffTime);
            }
            --retriesRemaining;
        } while (retryAllowed);
        this.requestInfos.clear();
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class BatchInterceptor
    implements HttpExecuteInterceptor {
        BatchInterceptor() {
        }

        public void intercept(HttpRequest batchRequest) throws IOException {
            for (RequestInfo<?, ?> requestInfo : BatchRequest.this.requestInfos) {
                HttpExecuteInterceptor interceptor = requestInfo.request.getInterceptor();
                if (interceptor == null) continue;
                interceptor.intercept(requestInfo.request);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RequestInfo<T, E> {
        final BatchCallback<T, E> callback;
        final Class<T> dataClass;
        final Class<E> errorClass;
        final HttpRequest request;

        RequestInfo(BatchCallback<T, E> callback, Class<T> dataClass, Class<E> errorClass, HttpRequest request) {
            this.callback = callback;
            this.dataClass = dataClass;
            this.errorClass = errorClass;
            this.request = request;
        }
    }
}

