/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.json.JsonHttpParser;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonCParser
extends JsonHttpParser
implements ObjectParser {
    private final JsonFactory jsonFactory;

    public final JsonFactory getFactory() {
        return this.jsonFactory;
    }

    public JsonCParser(JsonFactory jsonFactory) {
        super(jsonFactory);
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
    }

    @Deprecated
    public <T> T parse(HttpResponse response, Class<T> dataClass) throws IOException {
        return (T)JsonCParser.parserForResponse(this.getJsonFactory(), response).parseAndClose(dataClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static JsonParser parserForResponse(JsonFactory jsonFactory, HttpResponse response) throws IOException {
        String contentType = response.getContentType();
        if (contentType == null || !contentType.startsWith("application/json")) {
            throw new IllegalArgumentException("Wrong content type: expected <application/json> but got <" + contentType + ">");
        }
        boolean failed = true;
        JsonParser parser = JsonHttpParser.parserForResponse((JsonFactory)jsonFactory, (HttpResponse)response);
        try {
            parser.skipToKey(response.isSuccessStatusCode() ? "data" : "error");
            if (parser.getCurrentToken() == JsonToken.END_OBJECT) {
                throw new IllegalArgumentException("data key not found");
            }
            failed = false;
            JsonParser jsonParser = parser;
            return jsonParser;
        }
        finally {
            if (failed) {
                parser.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonParser initializeParser(JsonParser parser) throws IOException {
        boolean failed = true;
        try {
            String match = parser.skipToKey((Set)Sets.newHashSet((Object[])new String[]{"data", "error"}));
            if (match == null || parser.getCurrentToken() == JsonToken.END_OBJECT) {
                throw new IllegalArgumentException("data key not found");
            }
            failed = false;
        }
        finally {
            if (failed) {
                parser.close();
            }
        }
        return parser;
    }

    public <T> T parseAndClose(InputStream in, Charset charset, Class<T> dataClass) throws IOException {
        return (T)this.parseAndClose(in, charset, (Type)dataClass);
    }

    public Object parseAndClose(InputStream in, Charset charset, Type dataType) throws IOException {
        return JsonCParser.initializeParser(this.jsonFactory.createJsonParser(in, charset)).parse(dataType, true, null);
    }

    public <T> T parseAndClose(Reader reader, Class<T> dataClass) throws IOException {
        return (T)this.parseAndClose(reader, (Type)dataClass);
    }

    public Object parseAndClose(Reader reader, Type dataType) throws IOException {
        return JsonCParser.initializeParser(this.jsonFactory.createJsonParser(reader)).parse(dataType, true, null);
    }
}

