/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.dao.BoxCollaboration;
import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxFolder;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.boxjavalibv2.interfaces.IBoxResourceHub;
import com.box.boxjavalibv2.requests.CreateNewFolderRequest;
import com.box.boxjavalibv2.requests.DeleteFolderRequest;
import com.box.boxjavalibv2.requests.GetFolderCollaborationsRequest;
import com.box.boxjavalibv2.requests.GetFolderItemsRequest;
import com.box.boxjavalibv2.requests.GetFolderTrashItemsRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxDefaultRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxFileRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxFolderRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxItemRestoreRequestObject;
import com.box.boxjavalibv2.resourcemanagers.BoxCollaborationsManager;
import com.box.boxjavalibv2.resourcemanagers.BoxItemsManager;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxConfig;
import com.box.restclientv2.interfaces.IBoxRESTClient;
import com.box.restclientv2.interfaces.IBoxRequestAuth;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class BoxFoldersManager
extends BoxItemsManager {
    public BoxFoldersManager(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    public BoxFolder getFolder(String folderId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFolder)super.getItem(folderId, requestObject, BoxResourceType.FOLDER);
    }

    public BoxFolder getTrashFolder(String folderId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFolder)super.getTrashItem(folderId, BoxResourceType.FOLDER, requestObject);
    }

    public BoxFolder createFolder(BoxFolderRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        CreateNewFolderRequest request = new CreateNewFolderRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxFolder)this.getResponseAndParseAndTryCast(request, BoxResourceType.FOLDER, this.getJSONParser());
    }

    public void deleteFolder(String folderId, BoxFolderRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        DeleteFolderRequest request = new DeleteFolderRequest(this.getConfig(), this.getJSONParser(), folderId, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    public void deleteTrashFolder(String id, BoxFileRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        super.deleteTrashItem(id, BoxResourceType.FOLDER, requestObject);
    }

    public BoxFolder restoreTrashFolder(String id, BoxItemRestoreRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        return (BoxFolder)super.restoreTrashItem(id, BoxResourceType.FOLDER, requestObject);
    }

    public BoxFolder copyFolder(String folderId, BoxFolderRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFolder)super.copyItem(folderId, requestObject, BoxResourceType.FOLDER);
    }

    public BoxCollection getFolderItems(String folderId, BoxFolderRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetFolderItemsRequest request = new GetFolderItemsRequest(this.getConfig(), this.getJSONParser(), folderId, requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.ITEMS, this.getJSONParser());
    }

    public BoxCollection getFolderTrashItems(String folderId, BoxFolderRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetFolderTrashItemsRequest request = new GetFolderTrashItemsRequest(this.getConfig(), this.getJSONParser(), folderId, requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.ITEMS, this.getJSONParser());
    }

    public BoxFolder updateFolderInfo(String folderId, BoxFolderRequestObject requestObject) throws UnsupportedEncodingException, BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFolder)super.updateItemInfo(folderId, requestObject, BoxResourceType.FOLDER);
    }

    public BoxFolder createSharedLink(String folderId, BoxFolderRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFolder)super.createSharedLink(folderId, requestObject, BoxResourceType.FOLDER);
    }

    public List<BoxCollaboration> getFolderCollaborations(String folderId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetFolderCollaborationsRequest request = new GetFolderCollaborationsRequest(this.getConfig(), this.getJSONParser(), folderId, requestObject);
        BoxCollection collection = (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.COLLABORATIONS, this.getJSONParser());
        return BoxCollaborationsManager.getCollaborations(collection);
    }

    public static List<BoxFolder> getFolders(BoxCollection collection) {
        ArrayList<BoxFolder> folders = new ArrayList<BoxFolder>();
        ArrayList<BoxTypedObject> list = collection.getEntries();
        for (BoxTypedObject object : list) {
            if (!(object instanceof BoxFolder)) continue;
            folders.add((BoxFolder)object);
        }
        return folders;
    }
}

