/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class ISO8601DateParser {
    public static Date parse(String input) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        if (input.endsWith("Z")) {
            input = input.substring(0, input.length() - 1) + "GMT-00:00";
        } else {
            int inset = 6;
            String s0 = input.substring(0, input.length() - inset);
            String s1 = input.substring(input.length() - inset, input.length());
            input = s0 + "GMT" + s1;
        }
        return df.parse(input);
    }

    public static Date parseSilently(String input) {
        try {
            Date date = StringUtils.isEmpty((String)input) ? null : ISO8601DateParser.parse(input);
            return date;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String toString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        TimeZone tz = TimeZone.getTimeZone("UTC");
        df.setTimeZone(tz);
        String output = df.format(date);
        String result = output.replaceAll("UTC", "+00:00");
        return result;
    }
}

