/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.box;

import com.box.boxjavalibv2.BoxClient;
import com.box.boxjavalibv2.authorization.OAuthRefreshListener;
import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxEvent;
import com.box.boxjavalibv2.dao.BoxEventCollection;
import com.box.boxjavalibv2.dao.BoxFile;
import com.box.boxjavalibv2.dao.BoxFolder;
import com.box.boxjavalibv2.dao.BoxItem;
import com.box.boxjavalibv2.dao.BoxOAuthToken;
import com.box.boxjavalibv2.dao.BoxSharedLink;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import com.box.boxjavalibv2.dao.BoxUser;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.interfaces.IAuthData;
import com.box.boxjavalibv2.interfaces.IAuthSecureStorage;
import com.box.boxjavalibv2.requests.requestobjects.BoxDefaultRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxEventRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxFolderRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxOAuthRequestObject;
import com.box.boxjavalibv2.resourcemanagers.BoxFilesManager;
import com.box.boxjavalibv2.resourcemanagers.BoxFoldersManager;
import com.box.boxjavalibv2.utils.ISO8601DateParser;
import com.box.restclientv2.exceptions.BoxRestException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.box.AuthTokenException;
import org.exoplatform.clouddrive.box.BoxException;
import org.exoplatform.clouddrive.oauth2.UserToken;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BoxAPI {
    protected static final Log LOG = ExoLogger.getLogger(BoxAPI.class);
    public static final String NO_STATE = "__no_state_set__";
    public static final String BOX_ROOT_ID = "0";
    public static final String BOX_TRASH_ID = "1";
    protected static final String BOX_FILES_PATH = "files/0/f/";
    public static final String BOX_FILE_URL = "https://app.box.com/files/0/f/";
    public static final String BOX_WEBDOCUMENT_MIMETYPE = "application/x-exo.box.webdoc";
    public static final String BOX_WEBDOCUMENT_EXT = "webdoc";
    public static final String BOX_EMBED_URL = "https://app.box.com/embed_widget/000000000000/%s?view=list&sort=date&theme=gray&show_parent_path=no&show_item_feed_actions=no&session_expired=true";
    public static final Set<String> BOX_EVENTS = new HashSet<String>();
    private BoxToken token;
    private BoxClient client;
    private ChangesLink changesLink;

    BoxAPI(String key, String clientSecret, String authCode, String redirectUri) throws BoxException, CloudDriveException {
        this.client = new BoxClient(key, clientSecret);
        this.token = new BoxToken();
        this.client.addOAuthRefreshListener((OAuthRefreshListener)this.token);
        try {
            BoxOAuthRequestObject obj = BoxOAuthRequestObject.createOAuthRequestObject((String)authCode, (String)key, (String)clientSecret, (String)redirectUri);
            BoxOAuthToken bt = this.client.getOAuthManager().createOAuth(obj);
            this.token.store(bt);
            this.client.authenticate((IAuthData)bt);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error submiting authentication code: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            throw new BoxException("Error authenticating user code: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            throw new BoxException("Authentication code error: " + e.getMessage(), e);
        }
        this.updateChangesLink();
    }

    BoxAPI(String key, String clientSecret, String accessToken, String refreshToken, long expirationTime) throws CloudDriveException {
        this.client = new BoxClient(key, clientSecret);
        this.token = new BoxToken();
        this.token.load(accessToken, refreshToken, expirationTime);
        this.client.addOAuthRefreshListener((OAuthRefreshListener)this.token);
        this.client.authenticateFromSecureStorage((IAuthSecureStorage)this.token);
    }

    void updateToken(UserToken newToken) throws CloudDriveException {
        this.token.merge(newToken);
    }

    UserToken getToken() {
        return this.token;
    }

    BoxUser currentUser() throws BoxException {
        BoxDefaultRequestObject obj = new BoxDefaultRequestObject();
        try {
            return this.client.getUsersManager().getCurrentUser(obj);
        }
        catch (BoxRestException e) {
            throw new BoxException("Error requesting current user: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            throw new BoxException("Error getting current user: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            throw new BoxException("Authentication error for current user: " + e.getMessage(), e);
        }
    }

    BoxFolder getRootFolder() throws BoxException {
        try {
            BoxFolder root = this.client.getFoldersManager().getFolder(BOX_ROOT_ID, null);
            return root;
        }
        catch (BoxRestException e) {
            throw new BoxException("Error getting root folder: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            throw new BoxException("Error reading root folder: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            throw new BoxException("Authentication error for root folder: " + e.getMessage(), e);
        }
    }

    ItemsIterator getFolderItems(String folderId) throws CloudDriveException {
        return new ItemsIterator(folderId);
    }

    Calendar parseDate(String dateString) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        Date d = ISO8601DateParser.parse((String)dateString);
        calendar.setTime(d);
        return calendar;
    }

    String formatDate(Calendar date) {
        return ISO8601DateParser.toString((Date)date.getTime());
    }

    String getLink(BoxItem item) {
        CharSequence link;
        BoxSharedLink shared = item.getSharedLink();
        if (shared != null && (link = shared.getUrl()) != null) {
            return link;
        }
        link = new StringBuilder();
        ((StringBuilder)link).append(BOX_FILE_URL);
        String id = item.getId();
        if (BOX_ROOT_ID.equals(id)) {
            ((StringBuilder)link).append(id);
        } else if (item instanceof BoxFile) {
            String parentId = item.getParent().getId();
            ((StringBuilder)link).append(parentId);
            ((StringBuilder)link).append("/1/f_");
            ((StringBuilder)link).append(id);
        } else if (item instanceof BoxFolder) {
            ((StringBuilder)link).append(id);
            ((StringBuilder)link).append('/');
            ((StringBuilder)link).append(item.getName());
        } else {
            ((StringBuilder)link).append(BOX_FILE_URL);
        }
        ((StringBuilder)link).append("/");
        return ((StringBuilder)link).toString();
    }

    String getEmbedLink(BoxItem item) {
        String link;
        String[] lparts;
        StringBuilder linkValue = new StringBuilder();
        BoxSharedLink shared = item.getSharedLink();
        if (shared != null && (lparts = (link = shared.getUrl()).split("/")).length > 3 && lparts[lparts.length - 2].equals("s")) {
            linkValue.append("s/");
            linkValue.append(lparts[lparts.length - 1]);
        }
        if (linkValue.length() == 0) {
            linkValue.append(BOX_FILES_PATH);
            String id = item.getId();
            if (BOX_ROOT_ID.equals(id)) {
                linkValue.append(id);
            } else if (item instanceof BoxFile) {
                String parentId = item.getParent().getId();
                linkValue.append(parentId);
                linkValue.append("/1/f_");
                linkValue.append(id);
            } else if (item instanceof BoxFolder) {
                linkValue.append(id);
            } else {
                linkValue.append(BOX_FILE_URL);
            }
        }
        return String.format(BOX_EMBED_URL, linkValue.toString());
    }

    String getChangesLink() throws BoxException {
        if (this.changesLink != null) {
            return this.changesLink.getUrl();
        }
        return this.updateChangesLink();
    }

    String updateChangesLink() throws BoxException {
        BoxDefaultRequestObject obj = new BoxDefaultRequestObject();
        try {
            BoxCollection changesPoll = this.client.getEventsManager().getEventOptions(obj);
            ArrayList ce = changesPoll.getEntries();
            if (ce.size() > 0) {
                long retryTimeout;
                long maxRetries;
                long ttl;
                BoxTypedObject c = (BoxTypedObject)ce.get(0);
                Object urlObj = c.getValue("url");
                String url = urlObj != null ? urlObj.toString() : null;
                Object typeObj = c.getValue("type");
                String type = typeObj != null ? typeObj.toString() : null;
                Object ttlObj = c.getValue("ttl");
                if (ttlObj == null) {
                    ttlObj = c.getExtraData("ttl");
                }
                try {
                    ttl = ttlObj != null ? Long.parseLong(ttlObj.toString()) : 0L;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Error parsing ttl value in Events response [" + ttlObj + "]: " + e));
                    ttl = 0L;
                }
                Object maxRetriesObj = c.getValue("max_retries");
                if (maxRetriesObj == null) {
                    maxRetriesObj = c.getExtraData("max_retries");
                }
                try {
                    maxRetries = maxRetriesObj != null ? Long.parseLong(maxRetriesObj.toString()) : 0L;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Error parsing max_retries value in Events response [" + maxRetriesObj + "]: " + e));
                    maxRetries = 0L;
                }
                Object retryTimeoutObj = c.getValue("retry_timeout");
                if (retryTimeoutObj == null) {
                    retryTimeoutObj = c.getExtraData("retry_timeout");
                }
                try {
                    retryTimeout = retryTimeoutObj != null ? Long.parseLong(retryTimeoutObj.toString()) : 0L;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Error parsing retry_timeout value in Events response [" + retryTimeoutObj + "]: " + e));
                    retryTimeout = 0L;
                }
                this.changesLink = new ChangesLink(type, url, ttl, maxRetries, retryTimeout);
                return url;
            }
            throw new BoxException("Empty entries from Events service.");
        }
        catch (BoxRestException e) {
            throw new BoxException("Error requesting changes long poll URL: " + e.getMessage(), e);
        }
        catch (BoxServerException e) {
            throw new BoxException("Error reading changes long poll URL: " + e.getMessage(), e);
        }
        catch (AuthFatalFailureException e) {
            throw new BoxException("Authentication error for changes long poll URL: " + e.getMessage(), e);
        }
    }

    EventsIterator getEvents(long streamPosition) throws BoxException, AuthTokenException {
        return new EventsIterator(streamPosition);
    }

    static {
        BOX_EVENTS.add("ITEM_CREATE");
        BOX_EVENTS.add("ITEM_UPLOAD");
        BOX_EVENTS.add("ITEM_MOVE");
        BOX_EVENTS.add("ITEM_COPY");
        BOX_EVENTS.add("ITEM_TRASH");
        BOX_EVENTS.add("ITEM_UNDELETE_VIA_TRASH");
        BOX_EVENTS.add("ITEM_RENAME");
    }

    class ChangesLink {
        final String type;
        final String url;
        final long ttl;
        final long maxRetries;
        final long retryTimeout;

        ChangesLink(String type, String url, long ttl, long maxRetries, long retryTimeout) {
            this.type = type;
            this.url = url;
            this.ttl = ttl;
            this.maxRetries = maxRetries;
            this.retryTimeout = retryTimeout;
        }

        String getType() {
            return this.type;
        }

        String getUrl() {
            return this.url;
        }

        long getTtl() {
            return this.ttl;
        }

        long getMaxRetries() {
            return this.maxRetries;
        }

        long getRetryTimeout() {
            return this.retryTimeout;
        }
    }

    class EventsIterator
    extends ChunkIterator<BoxEvent> {
        final int limit;
        long streamPosition;
        List<BoxEvent> nextChunk;

        EventsIterator(long streamPosition) throws BoxException, AuthTokenException {
            this.streamPosition = streamPosition;
            this.limit = 1000;
            this.iter = this.nextChunk();
        }

        BoxEventCollection events(long position) throws BoxException, AuthTokenException {
            try {
                BoxEventRequestObject request = BoxEventRequestObject.getEventsRequestObject((long)(position <= -1L ? -1L : position));
                request.setStreamType("changes");
                request.setLimit(this.limit);
                return BoxAPI.this.client.getEventsManager().getEvents(request);
            }
            catch (BoxRestException e) {
                throw new BoxException("Error requesting Events service: " + e.getMessage(), e);
            }
            catch (BoxServerException e) {
                throw new BoxException("Error reading Events service: " + e.getMessage(), e);
            }
            catch (AuthFatalFailureException e) {
                if (e.isCallerResponsibleForFix()) {
                    throw new AuthTokenException("Authentication failure. Reauthenticate.");
                }
                throw new BoxException("Authentication error for Events service: " + e.getMessage(), e);
            }
        }

        @Override
        protected Iterator<BoxEvent> nextChunk() throws BoxException, AuthTokenException {
            List<BoxEvent> events;
            BoxEventCollection ec;
            if (this.nextChunk == null) {
                ec = this.events(this.streamPosition);
                events = this.readEvents(ec);
                this.streamPosition = ec.getNextStreamPosition();
            } else {
                events = this.nextChunk;
            }
            ec = this.events(this.streamPosition);
            List<BoxEvent> nextEvents = this.readEvents(ec);
            this.nextChunk = ec.getChunkSize() > 0 && this.hasNewEvents(events, nextEvents) ? nextEvents : null;
            return events.iterator();
        }

        @Override
        protected boolean hasNextChunk() {
            return this.nextChunk != null;
        }

        private List<BoxEvent> readEvents(BoxEventCollection collection) {
            ArrayList<BoxEvent> events = new ArrayList<BoxEvent>();
            for (BoxTypedObject eobj : collection.getEntries()) {
                BoxEvent event = (BoxEvent)eobj;
                if (!BOX_EVENTS.contains(event.getEventType())) continue;
                events.add(event);
            }
            return events;
        }

        private boolean hasNewEvents(List<BoxEvent> events, List<BoxEvent> nextEvents) {
            HashSet<String> ids = new HashSet<String>();
            for (BoxEvent event : events) {
                ids.add(event.getId());
            }
            int consumed = 0;
            for (BoxEvent event : nextEvents) {
                if (!ids.contains(event.getId())) continue;
                ++consumed;
            }
            return nextEvents.size() > consumed;
        }
    }

    class ItemsIterator
    extends ChunkIterator<BoxItem> {
        final String folderId;
        int limit;
        int offset;
        BoxFolder parent;

        ItemsIterator(String folderId) throws CloudDriveException {
            this.folderId = folderId;
            this.limit = 1000;
            this.offset = 0;
            this.iter = this.nextChunk();
        }

        @Override
        protected Iterator<BoxItem> nextChunk() throws AuthTokenException, CloudDriveException {
            BoxFolderRequestObject obj = BoxFolderRequestObject.getFolderItemsRequestObject((int)this.limit, (int)this.offset);
            obj.addField("id");
            obj.addField("parent");
            obj.addField("name");
            obj.addField("type");
            obj.addField("etag");
            obj.addField("sequence_id");
            obj.addField("created_at");
            obj.addField("modified_at");
            obj.addField("description");
            obj.addField("size");
            obj.addField("created_by");
            obj.addField("modified_by");
            obj.addField("owned_by");
            obj.addField("shared_link");
            obj.addField("item_status");
            obj.addField("item_collection");
            try {
                this.parent = BoxAPI.this.client.getFoldersManager().getFolder(this.folderId, (BoxDefaultRequestObject)obj);
                BoxCollection items = this.parent.getItemCollection();
                this.available(items.getTotalCount().intValue());
                ArrayList oitems = new ArrayList();
                oitems.addAll(BoxFoldersManager.getFolders((BoxCollection)items));
                oitems.addAll(BoxFilesManager.getFiles((BoxCollection)items));
                return oitems.iterator();
            }
            catch (BoxRestException e) {
                throw new BoxException("Error getting folder items: " + e.getMessage(), e);
            }
            catch (BoxServerException e) {
                throw new BoxException("Error reading folder items: " + e.getMessage(), e);
            }
            catch (AuthFatalFailureException e) {
                if (e.isCallerResponsibleForFix()) {
                    throw new AuthTokenException("Authentication failure. Reauthenticate.");
                }
                throw new BoxException("Authentication error on folder items: " + e.getMessage(), e);
            }
        }

        @Override
        protected boolean hasNextChunk() {
            return false;
        }
    }

    class BoxToken
    extends UserToken
    implements OAuthRefreshListener,
    IAuthSecureStorage {
        BoxToken() {
        }

        void store(BoxOAuthToken btoken) throws CloudDriveException {
            this.store(btoken.getAccessToken(), btoken.getRefreshToken(), btoken.getExpiresIn().intValue());
        }

        public void onRefresh(IAuthData newAuthData) {
            BoxOAuthToken newToken = (BoxOAuthToken)newAuthData;
            try {
                this.store(newToken);
            }
            catch (CloudDriveException e) {
                LOG.error((Object)"Error storing refreshed access token", (Throwable)e);
            }
        }

        public void saveAuth(IAuthData auth) {
            try {
                this.store((BoxOAuthToken)auth);
            }
            catch (CloudDriveException e) {
                LOG.error((Object)"Error saving access token", (Throwable)e);
            }
        }

        public IAuthData getAuth() {
            BoxOAuthToken auth = new BoxOAuthToken();
            auth.put("access_token", (Object)this.getAccessToken());
            auth.put("refresh_token", (Object)this.getRefreshToken());
            auth.put("expires_in", (Object)this.getExpirationTime());
            auth.put("token_type", (Object)"bearer");
            return auth;
        }
    }
}

