/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import com.ibm.icu.text.Transliterator;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.clouddrive.BaseCloudDriveListener;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveEnvironment;
import org.exoplatform.clouddrive.CloudDriveEvent;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudFileAPI;
import org.exoplatform.clouddrive.CloudFileSynchronizer;
import org.exoplatform.clouddrive.CloudProviderException;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.CommandPoolExecutor;
import org.exoplatform.clouddrive.ConflictException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.FileTrashRemovedException;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.NotConnectedException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.NotYetCloudFileException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.SkipSyncException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.clouddrive.jcr.LostRemovalSynchronizer;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.clouddrive.utils.IdentityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.security.ConversationState;

public abstract class JCRLocalCloudDrive
extends CloudDrive {
    public static final String ECD_CLOUDDRIVE = "ecd:cloudDrive";
    public static final String ECD_CLOUDFILE = "ecd:cloudFile";
    public static final String ECD_CLOUDFOLDER = "ecd:cloudFolder";
    public static final String ECD_CLOUDFILERESOURCE = "ecd:cloudFileResource";
    public static final String ECD_IGNORED = "ecd:ignored";
    public static final String EXO_DATETIME = "exo:datetime";
    public static final String EXO_MODIFY = "exo:modify";
    public static final String EXO_TRASHFOLDER = "exo:trashFolder";
    public static final String EXO_THUMBNAILS = "exo:thumbnails";
    public static final String EXO_THUMBNAIL = "exo:thumbnail";
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FILE = "nt:file";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String ECD_LOCALFORMAT = "ecd:localFormat";
    public static final double CURRENT_LOCALFORMAT = 1.1;
    public static final long HISTORY_EXPIRATION = 691200000L;
    public static final int HISTORY_MAX_LENGTH = 1000;
    public static final String DUMMY_DATA = "";
    public static final String USER_WORKSPACE = "user.workspace";
    public static final String USER_NODEPATH = "user.nodePath";
    public static final String USER_SESSIONPROVIDER = "user.sessionProvider";
    protected static final CloudDrive.Command ALREADY_DONE = new AlreadyDone();
    protected static final ThreadLocal<CloudDrive> actionDrive = new ThreadLocal();
    protected static final Transliterator accentsConverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
    protected final String rootWorkspace;
    protected final ManageableRepository repository;
    protected final SessionProviderService sessionProviders;
    protected final CloudUser user;
    protected final String rootUUID;
    protected final ThreadLocal<SoftReference<Node>> rootNodeHolder;
    protected final JCRListener jcrListener;
    protected final ConnectCommand noConnect = new NoConnectCommand();
    protected final AtomicReference<ConnectCommand> currentConnect = new AtomicReference<ConnectCommand>(this.noConnect);
    protected final SyncCommand noSyncCommand = new NoSyncCommand();
    protected final AtomicReference<SyncCommand> currentSync = new AtomicReference<SyncCommand>(this.noSyncCommand);
    protected final ReadWriteLock syncLock = new ReentrantReadWriteLock(true);
    protected final ConcurrentHashMap<String, FileChange> fileChanges = new ConcurrentHashMap();
    protected final ThreadLocal<Map<String, FileChange>> fileRemovals = new ThreadLocal();
    protected final ConcurrentHashMap<String, String> fileCopies = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, FileTrashing> fileTrash = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Set<String>> fileHistory = new ConcurrentHashMap();
    protected final AtomicLong currentChangeId = new AtomicLong(-1L);
    protected final AtomicLong fileChangeSequencer = new AtomicLong(1L);
    protected final CommandPoolExecutor commandExecutor;
    protected final CloudDriveEnvironment commandEnv = new ExoJCREnvironment();
    protected final Set<CloudFileSynchronizer> fileSynchronizers = new LinkedHashSet<CloudFileSynchronizer>();
    protected final CloudFileAPI fileAPI;
    protected final NodeFinder finder;
    private String titleCached;

    protected JCRLocalCloudDrive(CloudUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder) throws CloudDriveException, RepositoryException {
        boolean existing;
        this.user = user;
        this.sessionProviders = sessionProviders;
        this.finder = finder;
        this.commandExecutor = CommandPoolExecutor.getInstance();
        Session session = driveNode.getSession();
        this.repository = (ManageableRepository)session.getRepository();
        this.rootWorkspace = session.getWorkspace().getName();
        if (driveNode.isNodeType(ECD_CLOUDDRIVE)) {
            if (driveNode.hasProperty("exo:title")) {
                this.titleCached = driveNode.getProperty("exo:title").getString();
            }
            existing = true;
        } else {
            try {
                this.initDrive(driveNode);
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw e;
            }
            catch (RuntimeException e) {
                this.rollback(driveNode);
                throw e;
            }
            existing = false;
        }
        this.rootUUID = driveNode.getUUID();
        this.rootNodeHolder = new ThreadLocal();
        this.rootNodeHolder.set(new SoftReference<Node>(driveNode));
        this.fileAPI = this.createFileAPI();
        this.jcrListener = this.addJCRListener(driveNode);
        this.addListener(this.jcrListener.changesListener);
        if (existing) {
            this.loadHistory();
        }
    }

    @Override
    public String getTitle() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("exo:title").getString();
    }

    @Override
    public String getLink() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:url").getString();
    }

    @Override
    public String getId() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:id").getString();
    }

    @Override
    public String getLocalUser() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:localUserName").getString();
    }

    @Override
    public Calendar getInitDate() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:initDate").getDate();
    }

    @Override
    public String getPath() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getPath();
    }

    @Override
    public Calendar getConnectDate() throws DriveRemovedException, NotConnectedException, RepositoryException {
        if (this.isConnected()) {
            return this.rootNode().getProperty("ecd:connectDate").getDate();
        }
        throw new NotConnectedException("Drive '" + this.title() + "' not connected.");
    }

    @Override
    public CloudFile getFile(String path) throws DriveRemovedException, NotCloudFileException, NotYetCloudFileException, RepositoryException {
        Node driveNode = this.rootNode();
        Item target = this.finder.findItem(driveNode.getSession(), path);
        String nodePath = target.getPath();
        String drivePath = driveNode.getPath();
        if (nodePath.length() > drivePath.length() && nodePath.startsWith(drivePath)) {
            if (target.isNode()) {
                Node fileNode = this.fileNode((Node)target);
                if (fileNode != null) {
                    return this.readFile(fileNode);
                }
                throw new NotYetCloudFileException("Node '" + path + "' is not a cloud file or marked as ignored.");
            }
            throw new NotCloudFileException("Item at path '" + path + "' is Property and cannot be read as cloud file.");
        }
        throw new NotCloudFileException("Item at path '" + path + "' does not belong to Cloud Drive '" + this.title() + "'");
    }

    @Override
    public boolean hasFile(String path) throws DriveRemovedException, RepositoryException {
        Node driveNode = this.rootNode();
        Item target = this.finder.findItem(driveNode.getSession(), path);
        String nodePath = target.getPath();
        String drivePath = driveNode.getPath();
        if (nodePath.length() > drivePath.length() && nodePath.startsWith(drivePath) && target.isNode()) {
            return this.fileNode((Node)target) != null;
        }
        return false;
    }

    @Override
    public List<CloudFile> listFiles() throws DriveRemovedException, CloudDriveException, RepositoryException {
        return this.listFiles(this.rootNode());
    }

    @Override
    @Deprecated
    public List<CloudFile> listFiles(CloudFile parent) throws DriveRemovedException, NotCloudFileException, RepositoryException {
        Node driveNode;
        String parentPath = parent.getPath();
        if (parentPath.startsWith((driveNode = this.rootNode()).getPath())) {
            Item item = driveNode.getSession().getItem(parentPath);
            if (item.isNode()) {
                return this.listFiles((Node)item);
            }
            throw new NotCloudFileException("Item at path '" + parentPath + "' is Property and cannot be read as Cloud Drive file.");
        }
        throw new NotCloudFileException("File '" + parentPath + "' does not belong to '" + this.title() + "' Cloud Drive.");
    }

    protected void initDrive(Node rootNode) throws CloudDriveException, RepositoryException {
        Session session = rootNode.getSession();
        rootNode.addMixin(ECD_CLOUDDRIVE);
        if (!rootNode.hasProperty("exo:title")) {
            this.titleCached = JCRLocalCloudDrive.rootTitle(this.getUser());
            rootNode.setProperty("exo:title", this.titleCached);
        } else {
            this.titleCached = rootNode.getProperty("exo:title").getString();
        }
        rootNode.setProperty("ecd:connected", false);
        rootNode.setProperty("ecd:localUserName", session.getUserID());
        rootNode.setProperty("ecd:initDate", Calendar.getInstance());
        rootNode.setProperty("ecd:provider", this.getUser().getProvider().getId());
        rootNode.setProperty(ECD_LOCALFORMAT, 1.1);
    }

    protected List<CloudFile> listFiles(Node parentNode) throws RepositoryException {
        ArrayList<CloudFile> files = new ArrayList<CloudFile>();
        NodeIterator fileNodes = parentNode.getNodes();
        while (fileNodes.hasNext()) {
            Node fileNode = fileNodes.nextNode();
            if (!fileNode.isNodeType(ECD_CLOUDFILE)) continue;
            JCRLocalCloudFile local = this.readFile(fileNode);
            files.add(local);
            if (!local.isFolder()) continue;
            files.addAll(this.listFiles(fileNode));
        }
        return files;
    }

    @Override
    public CloudDrive.Command connect() throws CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            return ALREADY_DONE;
        }
        ConnectCommand connect = this.getConnectCommand();
        if (this.currentConnect.compareAndSet(this.noConnect, connect)) {
            connect.start();
        } else {
            ConnectCommand existingConnect = this.currentConnect.get();
            if (existingConnect != this.noConnect) {
                connect = existingConnect;
            } else {
                connect.start();
            }
        }
        return connect;
    }

    protected abstract ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException;

    protected abstract SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException;

    protected abstract CloudFileAPI createFileAPI() throws DriveRemovedException, SyncNotSupportedException, RepositoryException;

    private synchronized void disconnect(Node rootNode) throws CloudDriveException, RepositoryException {
        try {
            try {
                rootNode.setProperty("ecd:connected", false);
                rootNode.getProperty("ecd:connected").save();
                NodeIterator niter = rootNode.getNodes();
                while (niter.hasNext()) {
                    niter.nextNode().remove();
                }
                rootNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(rootNode);
                throw e;
            }
            catch (RuntimeException e) {
                this.rollback(rootNode);
                throw e;
            }
        }
        catch (ItemNotFoundException e) {
            throw new DriveRemovedException("Drive '" + this.title() + "' was removed.", e);
        }
    }

    @Override
    protected void disconnect() throws CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            Node driveRoot = this.rootNode();
            this.disconnect(driveRoot);
            this.listeners.fireOnDisconnect(new CloudDriveEvent(this.getUser(), this.rootWorkspace, driveRoot.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudDrive.Command synchronize() throws SyncNotSupportedException, DriveRemovedException, CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            this.refreshAccess();
            SyncCommand sync = this.getSyncCommand();
            if (!this.currentSync.compareAndSet(this.noSyncCommand, sync)) {
                AtomicReference<SyncCommand> atomicReference = this.currentSync;
                synchronized (atomicReference) {
                    SyncCommand existingSync = this.currentSync.get();
                    if (existingSync != this.noSyncCommand) {
                        return existingSync;
                    }
                    this.currentSync.set(sync);
                }
            }
            sync.start();
            return sync;
        }
        throw new NotConnectedException("Cloud drive '" + this.title() + "' not connected.");
    }

    @Override
    public boolean isConnected() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:connected").getBoolean();
    }

    @Override
    public boolean isDrive(Node node) throws DriveRemovedException, RepositoryException {
        return this.isDrive(node, false);
    }

    @Override
    protected void initRemove(Node file) throws SyncNotSupportedException, CloudDriveException, RepositoryException {
        Map<String, FileChange> planned;
        String filePath = file.getPath();
        FileChange remove = new FileChange(filePath, this.fileAPI.getId(file), this.fileAPI.isFolder(file), "D", this.synchronizer(file));
        if (file.isNodeType(MIX_REFERENCEABLE)) {
            remove.setFileUUID(file.getUUID());
        }
        if ((planned = this.fileRemovals.get()) != null) {
            FileChange existing = planned.get(filePath);
            if (existing == null) {
                planned.put(filePath, remove);
            } else {
                FileChange next = remove;
                boolean canChain = true;
                while (next != null && canChain) {
                    canChain = next.fileId != null && remove.fileId != null ? next.fileId != remove.fileId : true;
                    next = next.next != null ? next.next : null;
                }
                if (canChain) {
                    existing.chain(remove);
                }
            }
        } else {
            planned = new HashMap<String, FileChange>();
            planned.put(filePath, remove);
            this.fileRemovals.set(planned);
        }
    }

    @Override
    protected void initCopy(Node file, Node destParent) throws RepositoryException, CloudDriveException {
        String filePath = file.getPath();
        String fileId = this.fileAPI.getId(file);
        String destPath = destParent.getPath();
        this.fileCopies.put(fileId, filePath);
    }

    CloudFileSynchronizer synchronizer(Node file) throws RepositoryException, SkipSyncException, SyncNotSupportedException {
        for (CloudFileSynchronizer s : this.fileSynchronizers) {
            if (!s.accept(file)) continue;
            return s;
        }
        throw new SyncNotSupportedException("Synchronization not supported for file type " + file.getPrimaryNodeType().getName() + " in node " + file.getPath());
    }

    CloudFileSynchronizer synchronizer(Class<?> clazz) throws RepositoryException, SkipSyncException, SyncNotSupportedException {
        for (CloudFileSynchronizer s : this.fileSynchronizers) {
            if (!clazz.isAssignableFrom(s.getClass())) continue;
            return s;
        }
        if (LostRemovalSynchronizer.class.equals(clazz)) {
            return new LostRemovalSynchronizer();
        }
        throw new SyncNotSupportedException("Synchronizer cannot be found " + clazz.getName());
    }

    private void addChanged(String fileId, String changeType) throws RepositoryException, CloudDriveException {
        Set<String> existing;
        Set<String> changes = this.fileHistory.get(fileId);
        if (changes == null && (existing = this.fileHistory.putIfAbsent(fileId, changes = new LinkedHashSet<String>())) != null) {
            changes = existing;
        }
        changes.add(changeType + this.getChangeId());
    }

    private boolean hasChanged(String fileId, String ... changeTypes) throws RepositoryException, CloudDriveException {
        Set<String> changes = this.fileHistory.get(fileId);
        if (changes != null) {
            long changeId = this.getChangeId();
            int i$ = 0;
            String[] arr$ = changeTypes;
            int len$ = arr$.length;
            if (i$ < len$) {
                String changeType = arr$[i$];
                return changes.contains(changeType + changeId);
            }
        }
        return false;
    }

    protected boolean hasUpdated(String fileId) throws RepositoryException, CloudDriveException {
        return this.hasChanged(fileId, "U", "A");
    }

    protected boolean hasRemoved(String fileId) throws RepositoryException, CloudDriveException {
        return this.hasChanged(fileId, "D");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanChanged(String fileId, String ... changeTypes) throws RepositoryException, CloudDriveException {
        Set<String> changes = this.fileHistory.get(fileId);
        if (changes != null) {
            long changeId = this.getChangeId();
            for (String changeType : changeTypes) {
                changes.remove(changeType + changeId);
            }
            if (changes.size() == 0) {
                Set<String> set = changes;
                synchronized (set) {
                    if (changes.size() == 0) {
                        this.fileHistory.remove(fileId);
                    }
                }
            }
        }
    }

    protected void cleanUpdated(String fileId) throws RepositoryException, CloudDriveException {
        this.cleanChanged(fileId, "U", "A");
    }

    protected void cleanRemoved(String fileId) throws RepositoryException, CloudDriveException {
        this.cleanChanged(fileId, "D");
    }

    @Deprecated
    private Collection<String> getChanged(String fileId) {
        Set<String> changes = this.fileHistory.get(fileId);
        if (changes != null) {
            return changes;
        }
        return Collections.emptyList();
    }

    protected String nextChangeId() throws RepositoryException, CloudDriveException {
        Long driveChangeId = this.getChangeId();
        return driveChangeId.toString() + '-' + this.fileChangeSequencer.getAndIncrement();
    }

    protected synchronized void saveChanges(List<FileChange> changes) throws RepositoryException, CloudDriveException {
        StringBuilder store = new StringBuilder();
        for (FileChange ch : changes) {
            store.append(ch.changeId);
            store.append('=');
            store.append(ch.changeType);
            store.append(ch.isFolder ? (char)'Y' : 'N');
            store.append(String.format("%010d", ch.path.length()));
            store.append(ch.path);
            if (ch.fileId != null) {
                if (ch.fileId.length() > 9999) {
                    throw new CloudDriveException("File id too long (greater of 4 digits): " + ch.fileId);
                }
                store.append('I');
                store.append(String.format("%04d", ch.fileId.length()));
                store.append(ch.fileId);
            }
            if (ch.synchronizer != null) {
                store.append('S');
                store.append(ch.synchronizer.getClass().getName());
            }
            store.append('\n');
        }
        Node driveNode = this.rootNode();
        try {
            Property localChanges = driveNode.getProperty("ecd:localChanges");
            String current = localChanges.getString();
            if (current.length() > 0) {
                store.insert(0, current);
            }
            localChanges.setValue(store.toString());
            localChanges.save();
        }
        catch (PathNotFoundException e) {
            driveNode.setProperty("ecd:localChanges", store.toString());
            driveNode.save();
        }
    }

    protected synchronized void commitChanges(List<FileChange> changes) throws RepositoryException, CloudDriveException {
        Node driveNode = this.rootNode();
        Long timestamp = System.currentTimeMillis();
        StringBuilder store = new StringBuilder();
        StringBuilder history = new StringBuilder();
        try {
            Property localChanges = driveNode.getProperty("ecd:localChanges");
            String current = localChanges.getString();
            if (current.length() > 0) {
                block6: for (String ch : current.split("\n")) {
                    if (ch.length() <= 0) continue;
                    for (FileChange fch : changes) {
                        if (!ch.startsWith(fch.changeId)) continue;
                        history.append(timestamp.toString());
                        history.append(':');
                        history.append(ch);
                        history.append('\n');
                        continue block6;
                    }
                    store.append(ch);
                    store.append('\n');
                }
            }
            localChanges.setValue(store.toString());
            localChanges.save();
        }
        catch (PathNotFoundException e) {
            driveNode.setProperty("ecd:localChanges", store.toString());
            driveNode.save();
        }
        try {
            StringBuilder currentHistory = new StringBuilder();
            Property localHistory = driveNode.getProperty("ecd:localHistory");
            String current = localHistory.getString();
            if (current.length() > 0) {
                int i;
                String[] fchs = current.split("\n");
                int n = i = fchs.length > 1000 ? fchs.length - 1000 : 0;
                while (i > fchs.length) {
                    String ch;
                    ch = fchs[i];
                    if (ch.length() > 0) {
                        int cindex = ch.indexOf(58);
                        try {
                            long chTimestamp = Long.parseLong(ch.substring(0, cindex));
                            if (timestamp - chTimestamp < 691200000L) {
                                currentHistory.append(ch);
                                currentHistory.append('\n');
                            }
                        }
                        catch (NumberFormatException e) {
                            throw new CloudDriveException("Error parsing change timestamp: " + ch, e);
                        }
                    }
                    ++i;
                }
            }
            if (currentHistory.length() > 0) {
                history.insert(0, currentHistory.toString());
            }
            localHistory.setValue(history.toString());
            localHistory.save();
        }
        catch (PathNotFoundException e) {
            driveNode.setProperty("ecd:localHistory", history.toString());
            driveNode.save();
        }
        for (FileChange ch : changes) {
            if (ch.fileId != null) {
                this.addChanged(ch.fileId, ch.changeType);
                continue;
            }
            LOG.warn((Object)("Cannot cache file change with null file id: " + ch.changeType + ", " + ch.getPath()));
        }
    }

    protected synchronized List<FileChange> savedChanges() throws RepositoryException, CloudDriveException {
        ArrayList<FileChange> changes = new ArrayList<FileChange>();
        Node driveNode = this.rootNode();
        try {
            Property localChanges = driveNode.getProperty("ecd:localChanges");
            String current = localChanges.getString();
            if (current.length() > 0) {
                LOG.info((Object)("Applying stored local changes in " + this.title()));
                for (String ch : current.split("\n")) {
                    if (ch.length() <= 0) continue;
                    changes.add(this.parseChange(ch));
                }
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return changes;
    }

    protected synchronized void loadHistory() throws RepositoryException, CloudDriveException {
        Node driveNode = this.rootNode();
        try {
            Property localChanges = driveNode.getProperty("ecd:localHistory");
            String current = localChanges.getString();
            if (current.length() > 0) {
                LOG.info((Object)("Loading local history of " + this.title()));
                for (String ch : current.split("\n")) {
                    if (ch.length() <= 0) continue;
                    this.loadChanged(ch);
                }
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    private FileChange parseChange(String ch) throws CloudDriveException, RepositoryException {
        Class<Object> syncClass;
        String fileId;
        String path;
        int cindex = ch.indexOf(61);
        String changeId = ch.substring(0, cindex);
        String changeType = new String(new char[]{ch.charAt(++cindex)});
        boolean isFolder = ch.charAt(cindex++) == 'Y';
        try {
            int pathIndex = ++cindex + 10;
            int pathLen = Integer.parseInt(ch.substring(cindex, pathIndex));
            cindex = pathIndex + pathLen;
            path = ch.substring(pathIndex, cindex);
        }
        catch (NumberFormatException e) {
            throw new CloudDriveException("Cannot parse path from local changes: " + ch, e);
        }
        if (cindex < ch.length() && ch.charAt(cindex) == 'I') {
            try {
                int idIndex = ++cindex + 4;
                int idLen = Integer.parseInt(ch.substring(cindex, idIndex));
                cindex = idIndex + idLen;
                fileId = ch.substring(idIndex, cindex);
            }
            catch (NumberFormatException e) {
                throw new CloudDriveException("Cannot parse file id from local changes: " + ch, e);
            }
        } else {
            fileId = null;
        }
        if (cindex < ch.length() && ch.charAt(cindex) == 'S') {
            try {
                syncClass = Class.forName(ch.substring(cindex + 1));
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Cannot find stored synchronizer class from local changes: " + ch), (Throwable)e);
                syncClass = LostRemovalSynchronizer.class;
            }
        } else {
            syncClass = null;
        }
        return new FileChange(changeId, path, fileId, isFolder, changeType, syncClass != null ? this.synchronizer(syncClass) : null);
    }

    private void loadChanged(String ch) throws CloudDriveException, RepositoryException {
        int cindex = ch.indexOf(61);
        String changeType = new String(new char[]{ch.charAt(++cindex)});
        ++cindex;
        try {
            int pathIndex = ++cindex + 10;
            int pathLen = Integer.parseInt(ch.substring(cindex, pathIndex));
            cindex = pathIndex + pathLen;
        }
        catch (NumberFormatException e) {
            throw new CloudDriveException("Cannot parse path from local changes: " + ch, e);
        }
        if (cindex < ch.length() && ch.charAt(cindex) == 'I') {
            String fileId;
            try {
                int idIndex = ++cindex + 4;
                int idLen = Integer.parseInt(ch.substring(cindex, idIndex));
                cindex = idIndex + idLen;
                fileId = ch.substring(idIndex, cindex);
            }
            catch (NumberFormatException e) {
                throw new CloudDriveException("Cannot parse file id from local changes: " + ch, e);
            }
            if (fileId != null) {
                this.addChanged(fileId, changeType);
            } else {
                LOG.warn((Object)("Cannot load file change with null file id: " + ch));
            }
        }
    }

    protected void setChangeId(Long id) throws CloudDriveException, RepositoryException {
        this.saveChangeId(id);
        this.currentChangeId.set(id);
        this.fileChangeSequencer.addAndGet(1L - this.fileChangeSequencer.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getChangeId() throws RepositoryException, CloudDriveException {
        Long id = this.currentChangeId.get();
        if (id < 0L) {
            AtomicLong atomicLong = this.currentChangeId;
            synchronized (atomicLong) {
                id = this.currentChangeId.get();
                if (id < 0L) {
                    id = this.readChangeId();
                }
            }
        }
        return id;
    }

    @Override
    protected boolean isDrive(Node node, boolean includeFiles) throws DriveRemovedException, RepositoryException {
        Node driveNode = this.rootNode();
        if (driveNode.getSession().getWorkspace().getName().equals(node.getSession().getWorkspace().getName())) {
            Item target;
            if (this.isConnected() && this.isSameDrive(node)) {
                return true;
            }
            if (includeFiles && (target = this.finder.findItem(node.getSession(), node.getPath())).isNode()) {
                node = (Node)target;
                return node.getPath().startsWith(driveNode.getPath());
            }
        }
        return false;
    }

    @Override
    protected boolean isDrive(String workspace, String path, boolean includeFiles) throws DriveRemovedException, RepositoryException {
        Item target;
        Node driveNode = this.rootNode();
        if (driveNode.getSession().getWorkspace().getName().equals(workspace) && (target = this.finder.findItem(driveNode.getSession(), path)).isNode()) {
            Node node = (Node)target;
            if (this.isConnected() && this.isSameDrive(node)) {
                return true;
            }
            if (includeFiles) {
                return node.getPath().startsWith(driveNode.getPath());
            }
        }
        return false;
    }

    protected boolean isSameDrive(Node anotherNode) throws RepositoryException {
        if (anotherNode.isNodeType(ECD_CLOUDDRIVE)) {
            return this.rootUUID.equals(anotherNode.getUUID());
        }
        return false;
    }

    protected Node fileNode(Node node) throws RepositoryException {
        Node parent;
        Node fileNode = this.getOrCleanFileNode(node);
        if (fileNode != null) {
            return fileNode;
        }
        if (this.fileAPI.isFileResource(node) && this.fileAPI.isFile(parent = node.getParent())) {
            return this.ensureOwned(parent);
        }
        return null;
    }

    protected Session systemSession() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionProvider ssp = this.sessionProviders.getSystemSessionProvider(null);
        if (ssp != null) {
            return ssp.getSession(this.rootWorkspace, this.repository);
        }
        throw new RepositoryException("Cannot get session provider.");
    }

    protected Session session() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        if (sp != null) {
            return sp.getSession(this.rootWorkspace, this.repository);
        }
        throw new RepositoryException("Cannot get session provider.");
    }

    protected Node rootNode() throws DriveRemovedException, RepositoryException {
        Node rootNode;
        SoftReference<Node> rootNodeRef = this.rootNodeHolder.get();
        if (rootNodeRef != null) {
            rootNode = rootNodeRef.get();
            ConversationState cs = ConversationState.getCurrent();
            if (rootNode != null && rootNode.getSession().isLive() && cs != null && IdentityHelper.isUserMatch(rootNode.getSession().getUserID(), cs.getIdentity().getUserId())) {
                try {
                    rootNode.refresh(true);
                    return rootNode;
                }
                catch (InvalidItemStateException e) {
                    throw new DriveRemovedException("Drive " + this.title() + " was removed.", e);
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
            }
        }
        Session session = this.session();
        try {
            rootNode = session.getNodeByUUID(this.rootUUID);
        }
        catch (ItemNotFoundException e) {
            throw new DriveRemovedException("Drive " + this.title() + " was removed.", e);
        }
        this.rootNodeHolder.set(new SoftReference<Node>(rootNode));
        return rootNode;
    }

    protected void rollback(Node rootNode) {
        try {
            rootNode.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)("Error rolling back the changes on drive '" + this.title() + "': " + e.getMessage()));
        }
    }

    void handleError(Node rootNode, Throwable error, String commandName) {
        String rootPath = null;
        if (rootNode != null) {
            try {
                rootPath = rootNode.getPath();
            }
            catch (RepositoryException e) {
                LOG.warn((Object)("Error reading drive root '" + e.getMessage() + "' " + (commandName != null ? "of " + commandName + " command " : DUMMY_DATA) + "to listeners on Cloud Drive '" + this.title() + "':" + e.getMessage()));
            }
            if (commandName.equals("connect")) {
                try {
                    this.removeJCRListener(rootNode.getSession());
                }
                catch (Throwable e) {
                    LOG.warn((Object)("Error removing observation listener on connect error '" + error.getMessage() + "' " + " on Cloud Drive '" + this.title() + "':" + e.getMessage()));
                }
            }
            this.rollback(rootNode);
        }
        try {
            this.listeners.fireOnError(new CloudDriveEvent(this.getUser(), this.rootWorkspace, rootPath), error, commandName);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Error firing error '" + error.getMessage() + "' " + (commandName != null ? "of " + commandName + " command " : DUMMY_DATA) + "to listeners on Cloud Drive '" + this.title() + "':" + e.getMessage()));
        }
    }

    private Node openNode(String fileId, String fileTitle, Node parent, String nodeType) throws RepositoryException, CloudDriveException {
        Node node;
        String cleanName;
        String name = cleanName = JCRLocalCloudDrive.cleanName(fileTitle);
        String internalName = null;
        int siblingNumber = 1;
        block2: while (true) {
            try {
                while (true) {
                    StringBuilder newName;
                    if (this.fileAPI.isFile(node = parent.getNode(name))) {
                        if (fileId.equals(this.fileAPI.getId(node))) {
                            this.ensureOwned(node);
                            break block2;
                        }
                        newName = new StringBuilder();
                        newName.append(cleanName);
                        newName.append('-');
                        newName.append(siblingNumber);
                        name = newName.toString();
                        ++siblingNumber;
                        continue;
                    }
                    if (this.getOrCleanFileNode(node) != null || !parent.hasNode(name)) continue;
                    newName = new StringBuilder();
                    newName.append(cleanName);
                    newName.append('-');
                    newName.append(siblingNumber);
                    name = newName.toString();
                    ++siblingNumber;
                }
            }
            catch (PathNotFoundException e) {
                if (internalName == null) {
                    internalName = name;
                    String finderName = this.finder.cleanName(fileTitle);
                    if (finderName.length() > 1) {
                        name = finderName;
                        continue;
                    }
                }
                node = parent.addNode(internalName, nodeType);
            }
            break;
        }
        return node;
    }

    private Node ensureOwned(Node node) throws RepositoryException {
        return IdentityHelper.ensureOwned(node, this.systemSession());
    }

    protected Node openFile(String fileId, String fileTitle, String fileType, Node parent) throws RepositoryException, CloudDriveException {
        Node localNode = this.openNode(fileId, fileTitle, parent, NT_FILE);
        if (localNode.isNew() && !localNode.hasNode("jcr:content")) {
            Node content = localNode.addNode("jcr:content", NT_RESOURCE);
            content.setProperty("jcr:data", DUMMY_DATA);
        }
        return localNode;
    }

    protected Node openFolder(String folderId, String folderTitle, Node parent) throws RepositoryException, CloudDriveException {
        return this.openNode(folderId, folderTitle, parent, NT_FOLDER);
    }

    protected Node moveFile(String id, String title, Node source, Node destParent) throws RepositoryException, CloudDriveException {
        Node place = this.openNode(id, title, destParent, NT_FILE);
        if (place.isNew() && !place.hasProperty("ecd:id")) {
            String nodeName = place.getName();
            place.remove();
            Session session = destParent.getSession();
            String destPath = destParent.getPath() + "/" + nodeName;
            session.move(source.getPath(), destPath);
            return source;
        }
        return place;
    }

    protected Node copyNode(Node node, Node destParent) throws RepositoryException {
        Node nodeCopy = destParent.addNode(node.getName(), node.getPrimaryNodeType().getName());
        for (NodeType mixin : node.getMixinNodeTypes()) {
            String mixinName = mixin.getName();
            if (nodeCopy.isNodeType(mixinName)) continue;
            nodeCopy.addMixin(mixin.getName());
        }
        PropertyIterator piter = node.getProperties();
        while (piter.hasNext()) {
            Property ep = piter.nextProperty();
            PropertyDefinition pdef = ep.getDefinition();
            if (pdef.isProtected()) continue;
            if (pdef.isMultiple()) {
                nodeCopy.setProperty(ep.getName(), ep.getValues());
                continue;
            }
            nodeCopy.setProperty(ep.getName(), ep.getValue());
        }
        NodeIterator niter = node.getNodes();
        while (niter.hasNext()) {
            Node ecn = niter.nextNode();
            NodeDefinition ndef = ecn.getDefinition();
            if (ndef.isProtected()) continue;
            this.copyNode(ecn, nodeCopy);
        }
        return nodeCopy;
    }

    protected void readNodes(Node parent, Map<String, List<Node>> nodes, boolean deep) throws RepositoryException {
        NodeIterator niter = parent.getNodes();
        while (niter.hasNext()) {
            Node node = this.getOrCleanFileNode(niter.nextNode());
            if (node == null) continue;
            String fileId = this.fileAPI.getId(node);
            List<Node> nodeList = nodes.get(fileId);
            if (nodeList == null) {
                nodeList = new ArrayList<Node>();
                nodes.put(fileId, nodeList);
            }
            nodeList.add(node);
            if (!deep || !this.fileAPI.isFolder(node)) continue;
            this.readNodes(node, nodes, deep);
        }
    }

    protected Node readNode(Node parent, String fileTitle, String fileId) throws RepositoryException, CloudDriveException {
        Node node;
        String cleanName;
        String name = cleanName = JCRLocalCloudDrive.cleanName(fileTitle);
        String internalName = null;
        int siblingNumber = 1;
        block2: while (true) {
            try {
                while (this.fileAPI.isFile(node = parent.getNode(name))) {
                    if (!fileId.equals(this.fileAPI.getId(node))) {
                        StringBuilder newName = new StringBuilder();
                        newName.append(cleanName);
                        newName.append('-');
                        newName.append(siblingNumber);
                        name = newName.toString();
                        ++siblingNumber;
                        continue;
                    }
                    break block2;
                }
                LOG.warn((Object)("Not a cloud file under clodu drive folder: " + node.getPath()));
                return null;
            }
            catch (PathNotFoundException e) {
                if (internalName == null) {
                    internalName = name;
                    if ((name = this.finder.cleanName(fileTitle)).length() > 0) continue;
                }
                return null;
            }
            break;
        }
        return node;
    }

    protected Node findNode(String id) throws RepositoryException, DriveRemovedException {
        Node rootNode = this.rootNode();
        QueryManager qm = rootNode.getSession().getWorkspace().getQueryManager();
        Query q = qm.createQuery("SELECT * FROM ecd:cloudFile WHERE ecd:id='" + id + "' AND jcr:path LIKE '" + rootNode.getPath() + "/%'", "sql");
        QueryResult qr = q.execute();
        NodeIterator nodes = qr.getNodes();
        if (nodes.hasNext()) {
            return this.ensureOwned(nodes.nextNode());
        }
        return null;
    }

    protected NodeIterator findNodes(Collection<String> ids) throws RepositoryException, DriveRemovedException {
        Node rootNode = this.rootNode();
        QueryManager qm = rootNode.getSession().getWorkspace().getQueryManager();
        StringBuilder idstmt = new StringBuilder();
        Iterator<String> ii = ids.iterator();
        while (ii.hasNext()) {
            String id = ii.next();
            idstmt.append("ecd:id='");
            idstmt.append(id);
            idstmt.append('\'');
            if (!ii.hasNext()) continue;
            idstmt.append(" OR ");
        }
        Query q = qm.createQuery("SELECT * FROM ecd:cloudFile WHERE " + idstmt + " AND jcr:path LIKE '" + rootNode.getPath() + "/%'", "sql");
        QueryResult qr = q.execute();
        return qr.getNodes();
    }

    protected JCRLocalCloudFile readFile(Node fileNode) throws RepositoryException {
        String downloadUrl;
        String previewUrl;
        String fileUrl = fileNode.getProperty("ecd:url").getString();
        try {
            previewUrl = fileNode.getProperty("ecd:previewUrl").getString();
        }
        catch (PathNotFoundException e) {
            previewUrl = null;
        }
        try {
            downloadUrl = fileNode.getProperty("ecd:downloadUrl").getString();
        }
        catch (PathNotFoundException e) {
            downloadUrl = null;
        }
        return new JCRLocalCloudFile(fileNode.getPath(), fileNode.getProperty("ecd:id").getString(), fileNode.getProperty("exo:title").getString(), fileUrl, previewUrl, downloadUrl, fileNode.getProperty("ecd:type").getString(), fileNode.getProperty("ecd:lastUser").getString(), fileNode.getProperty("ecd:author").getString(), fileNode.getProperty("ecd:created").getDate(), fileNode.getProperty("ecd:modified").getDate(), fileNode.isNodeType(ECD_CLOUDFOLDER));
    }

    protected void initFile(Node localNode, String title, String id, String type, String link, String previewLink, String downloadLink, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        if (!localNode.isNodeType(ECD_CLOUDFILE)) {
            localNode.addMixin(ECD_CLOUDFILE);
        }
        this.initCommon(localNode, title, id, type, link, author, lastUser, created, modified);
        Node content = localNode.getNode("jcr:content");
        if (!content.isNodeType(ECD_CLOUDFILERESOURCE)) {
            content.addMixin(ECD_CLOUDFILERESOURCE);
        }
        content.setProperty("jcr:mimeType", type);
        content.setProperty("jcr:lastModified", modified);
        localNode.setProperty("ecd:previewUrl", previewLink);
        localNode.setProperty("ecd:downloadUrl", downloadLink);
    }

    protected void initFolder(Node localNode, String id, String title, String type, String link, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        if (!localNode.isNodeType(ECD_CLOUDFOLDER)) {
            localNode.addMixin(ECD_CLOUDFOLDER);
        }
        this.initCommon(localNode, id, title, type, link, author, lastUser, created, modified);
    }

    protected void initCommon(Node localNode, String id, String title, String type, String link, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        localNode.setProperty("exo:title", title);
        localNode.setProperty("ecd:id", id);
        localNode.setProperty("ecd:driveUUID", this.rootUUID);
        localNode.setProperty("ecd:type", type);
        localNode.setProperty("ecd:url", link);
        localNode.setProperty("ecd:author", author);
        localNode.setProperty("ecd:lastUser", lastUser);
        localNode.setProperty("ecd:created", created);
        localNode.setProperty("ecd:modified", modified);
        localNode.setProperty("ecd:synchronized", Calendar.getInstance());
        if (localNode.isNodeType(EXO_DATETIME)) {
            localNode.setProperty("exo:dateCreated", created);
            localNode.setProperty("exo:dateModified", modified);
        }
        if (localNode.isNodeType(EXO_MODIFY)) {
            localNode.setProperty("exo:lastModifiedDate", modified);
            localNode.setProperty("exo:lastModifier", lastUser);
        }
    }

    @Override
    protected String title() {
        return this.titleCached;
    }

    protected JCRListener addJCRListener(Node driveNode) throws RepositoryException {
        JCRListener handler = new JCRListener(driveNode.getPath());
        ObservationManager observation = driveNode.getSession().getWorkspace().getObservationManager();
        observation.addEventListener((EventListener)handler.removeListener, 2, driveNode.getParent().getPath(), false, null, null, false);
        observation.addEventListener((EventListener)handler.addListener, 1, null, false, null, new String[]{EXO_TRASHFOLDER}, false);
        LinkedHashSet<String> supported = new LinkedHashSet<String>();
        for (CloudFileSynchronizer s : this.fileSynchronizers) {
            for (String nt : s.getSupportedNodetypes()) {
                supported.add(nt);
            }
        }
        observation.addEventListener((EventListener)handler.changesListener, 19, driveNode.getPath(), true, null, supported.size() > 0 ? supported.toArray(new String[supported.size()]) : null, false);
        return handler;
    }

    protected void removeJCRListener(Session session) throws RepositoryException {
        ObservationManager observation = session.getWorkspace().getObservationManager();
        observation.removeEventListener((EventListener)this.jcrListener.removeListener);
        observation.removeEventListener((EventListener)this.jcrListener.addListener);
        observation.removeEventListener((EventListener)this.jcrListener.changesListener);
    }

    @Override
    protected void configure(CloudDriveEnvironment env, Collection<CloudFileSynchronizer> synchronizers) {
        this.commandEnv.chain(env);
        this.fileSynchronizers.addAll(synchronizers);
    }

    protected boolean cleanup(Node node) {
        try {
            if (node.isNodeType(EXO_THUMBNAILS) || node.isNodeType(EXO_THUMBNAIL)) {
                String path = node.getPath();
                Item cleanIt = this.systemSession().getItem(path);
                Node parent = cleanIt.getParent();
                cleanIt.remove();
                parent.save();
                LOG.info((Object)("Not a cloud file node removed from the drive: " + path));
                return true;
            }
        }
        catch (Throwable e) {
            LOG.error((Object)"Error removing not a cloud file node", e);
        }
        return false;
    }

    @Deprecated
    protected Node createIfNotCloudFile(Node node) throws RepositoryException, CloudDriveException {
        if (!this.fileAPI.isFile(node) && !this.tryCreateCloudFile(node)) {
            return null;
        }
        return node;
    }

    @Deprecated
    protected boolean tryCreateCloudFile(Node node) throws RepositoryException, CloudDriveException {
        if (!this.fileAPI.isIgnored(node)) {
            String path = node.getPath();
            LOG.warn((Object)("Not a cloud file detected " + path));
            if (!this.cleanup(node)) {
                while (true) {
                    try {
                        new FileChange(path, "A").apply();
                        return true;
                    }
                    catch (SyncNotSupportedException e) {
                        LOG.warn((Object)("Cannot create file in cloud - it will be ignored: " + path + " (" + node.getPrimaryNodeType().getName() + "). " + e.getMessage()));
                        try {
                            node.refresh(false);
                            this.fileAPI.ignoreFile(node);
                        }
                        catch (Throwable t) {
                            LOG.error((Object)("Error ignoring not a cloud item " + path), t);
                        }
                    }
                    catch (ConflictException e) {
                        this.fixNameConflict(node);
                        continue;
                    }
                    catch (SkipSyncException e) {
                    }
                    catch (InterruptedException e) {
                        throw new CloudDriveException("File creation interrupted " + path, e);
                    }
                    break;
                }
            }
        }
        return false;
    }

    protected Node getOrCleanFileNode(Node node) throws RepositoryException {
        if (this.fileAPI.isFile(node)) {
            return this.ensureOwned(node);
        }
        if (this.fileAPI.isIgnored(node)) {
            return null;
        }
        String path = node.getPath();
        LOG.warn((Object)("Not a cloud file detected " + path));
        if (!this.cleanup(node)) {
            this.ensureOwned(node);
        }
        return null;
    }

    private void fixNameConflict(Node file) throws RepositoryException {
        String newTitle;
        String newName;
        int index;
        String baseExt;
        String baseTitle;
        Session session = file.getSession();
        Node parent = file.getParent();
        String title = this.fileAPI.getTitle(file);
        String[] titleParts = title.split("\\.");
        if (titleParts.length >= 2) {
            baseTitle = titleParts[0];
            baseExt = titleParts[titleParts.length - 1];
        } else {
            baseTitle = title;
            baseExt = null;
        }
        int openingParenthesesPos = baseTitle.lastIndexOf(40);
        int closingParenthesesPos = baseTitle.lastIndexOf(41);
        if (openingParenthesesPos > 0 && closingParenthesesPos > 0 && closingParenthesesPos > openingParenthesesPos + 1) {
            try {
                index = Integer.valueOf(baseTitle.substring(openingParenthesesPos, closingParenthesesPos));
            }
            catch (NumberFormatException e) {
                index = 1;
            }
        } else {
            index = 1;
        }
        do {
            newTitle = baseTitle + " (" + index++ + ")";
            if (baseExt == null) continue;
            newTitle = newTitle + "." + baseExt;
        } while (parent.hasNode(newName = JCRLocalCloudDrive.cleanName(newTitle)));
        session.move(file.getPath(), parent.getPath() + "/" + newName);
        file.setProperty("exo:title", newTitle);
    }

    protected abstract Long readChangeId() throws CloudDriveException, RepositoryException;

    protected abstract void saveChangeId(Long var1) throws CloudDriveException, RepositoryException;

    protected static String cleanName(String name) {
        String str = accentsConverter.transliterate(name.trim());
        StringBuilder cleanedStr = new StringBuilder(str.trim());
        if (cleanedStr.length() == 1) {
            char c = cleanedStr.charAt(0);
            if (c == '.' || c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                cleanedStr.deleteCharAt(0);
                cleanedStr.append('_');
                cleanedStr.append(Integer.toHexString(c).toUpperCase());
            }
        } else {
            for (int i = 0; i < cleanedStr.length(); ++i) {
                char c = cleanedStr.charAt(i);
                if (c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                    cleanedStr.deleteCharAt(i);
                    cleanedStr.insert(i, '_');
                    continue;
                }
                if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || c == '.' || c == '-' || c == '_') continue;
                cleanedStr.deleteCharAt(i--);
            }
        }
        return cleanedStr.toString().trim();
    }

    @Deprecated
    public static Node cleanNode(Node node, String title) throws RepositoryException, CloudDriveException {
        String cleanName;
        String name = node.getName();
        if (name.indexOf(":") < 0 && !(cleanName = JCRLocalCloudDrive.cleanName(title)).equals(node.getName())) {
            Node parent = node.getParent();
            int siblingNumber = 1;
            name = cleanName;
            try {
                while (true) {
                    parent.getNode(name);
                    StringBuilder newName = new StringBuilder();
                    newName.append(cleanName);
                    newName.append('-');
                    newName.append(siblingNumber);
                    name = newName.toString();
                    ++siblingNumber;
                }
            }
            catch (PathNotFoundException e) {
                Session session = parent.getSession();
                session.move(node.getPath(), parent.getPath() + "/" + name);
            }
        }
        return node;
    }

    static void startAction(CloudDrive drive) {
        actionDrive.set(drive);
    }

    static boolean acceptAction(CloudDrive drive) {
        return drive != null && drive != actionDrive.get();
    }

    static void doneAction() {
        actionDrive.remove();
    }

    public static void checkTrashed(Node node) throws RepositoryException, DriveRemovedException {
        if (node.getParent().isNodeType(EXO_TRASHFOLDER)) {
            throw new DriveRemovedException("Drive " + node.getPath() + " was moved to Trash.");
        }
    }

    public static void migrateName(Node node) throws RepositoryException {
        if (node.isNodeType(ECD_CLOUDDRIVE)) {
            boolean upgrade;
            try {
                double localFormat = node.getProperty(ECD_LOCALFORMAT).getDouble();
                if (localFormat == 1.1) {
                    upgrade = false;
                } else {
                    LOG.warn((Object)("Local format unknown: " + localFormat + ". Supported format: " + 1.1 + " or lower."));
                    upgrade = false;
                }
            }
            catch (PathNotFoundException e) {
                upgrade = true;
            }
            if (upgrade) {
                String name = node.getName();
                Session session = node.getSession();
                try {
                    session.move(node.getPath(), node.getParent().getPath() + '/' + JCRLocalCloudDrive.cleanName(name));
                    node.setProperty(ECD_LOCALFORMAT, 1.1);
                    session.save();
                }
                catch (RepositoryException e) {
                    try {
                        session.refresh(false);
                    }
                    catch (RepositoryException re) {
                        LOG.warn((Object)("Error rolling back the session during root node migration: " + (Object)((Object)re)));
                    }
                    throw e;
                }
            }
        } else {
            LOG.warn((Object)("Not a Cloud Drive root node: " + node.getPath()));
        }
    }

    public static String rootName(CloudUser user) throws RepositoryException, DriveRemovedException {
        return JCRLocalCloudDrive.cleanName(JCRLocalCloudDrive.rootTitle(user));
    }

    public static String rootTitle(CloudUser user) throws RepositoryException, DriveRemovedException {
        return user.getProvider().getName() + " - " + user.getEmail();
    }

    protected class FileChange {
        public static final String REMOVE = "D";
        public static final String CREATE = "A";
        public static final String UPDATE = "U";
        final CountDownLatch applied = new CountDownLatch(1);
        final String path;
        final boolean isFolder;
        final String changeType;
        String changeId;
        String filePath;
        String fileId;
        String fileUUID;
        FileChange next;
        CloudFileSynchronizer synchronizer;
        Set<String> updated;

        FileChange(String path, String fileId, boolean isFolder, String changeType, CloudFileSynchronizer synchronizer) throws CloudDriveException, RepositoryException {
            this.changeId = JCRLocalCloudDrive.this.nextChangeId();
            this.path = path;
            this.fileId = fileId;
            this.isFolder = isFolder;
            this.changeType = changeType;
            this.synchronizer = synchronizer;
        }

        FileChange(String changeId, String path, String fileId, boolean isFolder, String changeType, CloudFileSynchronizer synchronizer) {
            this.changeId = changeId;
            this.path = path;
            this.fileId = fileId;
            this.isFolder = isFolder;
            this.changeType = changeType;
            this.synchronizer = synchronizer;
        }

        FileChange(String filePath, String changeType) throws RepositoryException, CloudDriveException {
            this(filePath, null, false, changeType, null);
        }

        void setFileUUID(String fileUUID) {
            this.fileUUID = fileUUID;
        }

        void initUpdated(Set<String> updated) {
            this.updated = updated;
        }

        boolean chain(FileChange next) {
            if (this.applied.getCount() > 0L && this != next) {
                if (this.next == null) {
                    this.next = next;
                    return true;
                }
                return this.next.chain(next);
            }
            return false;
        }

        String getPath() {
            if (this.filePath != null) {
                return this.filePath;
            }
            return this.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void apply() throws DriveRemovedException, CloudDriveException, RepositoryException, InterruptedException {
            block34: {
                if (this.applied.getCount() <= 0L) return;
                try {
                    String changeName = null;
                    if (REMOVE.equals(this.changeType)) {
                        if (this.synchronizer == null) throw new SyncNotSupportedException("Synchronization not available for file removal: " + this.path);
                        if (JCRLocalCloudDrive.this.fileAPI.isTrashSupported()) {
                            changeName = "trash";
                            this.trash();
                        } else {
                            changeName = "remove";
                            this.remove();
                        }
                        break block34;
                    }
                    try {
                        Session session = JCRLocalCloudDrive.this.session();
                        Item item = session.getItem(this.path);
                        Node file = null;
                        try {
                            if (item.isNode()) {
                                file = JCRLocalCloudDrive.this.ensureOwned((Node)item);
                                if (CREATE.equals(this.changeType)) {
                                    if (JCRLocalCloudDrive.this.fileAPI.isFile(file)) {
                                        if (!JCRLocalCloudDrive.this.rootUUID.equals(file.getProperty("ecd:driveUUID").getString())) throw new SyncNotSupportedException("Cannot add file from other cloud drive " + file.getPath());
                                        if (file.hasProperty("ecd:trashed")) {
                                            changeName = "untrash";
                                            this.untrash(file);
                                        } else {
                                            String srcFileId = JCRLocalCloudDrive.this.fileAPI.getId(file);
                                            Node srcFile = null;
                                            String srcPath = JCRLocalCloudDrive.this.fileCopies.remove(srcFileId);
                                            if (srcPath != null) {
                                                Item srcItem = session.getItem(srcPath);
                                                if (srcItem.isNode()) {
                                                    srcFile = (Node)srcItem;
                                                } else {
                                                    LOG.warn((Object)("Copy's source path points to a Property " + srcPath));
                                                }
                                            } else {
                                                NodeIterator niter = JCRLocalCloudDrive.this.findNodes(Arrays.asList(srcFileId));
                                                while (niter.hasNext()) {
                                                    Node f = niter.nextNode();
                                                    if (file.isSame((Item)f)) continue;
                                                    srcFile = f;
                                                }
                                            }
                                            if (srcFile == null) {
                                                changeName = "move/rename";
                                                this.update(file);
                                            } else {
                                                changeName = "copy";
                                                this.copy(srcFile, file);
                                            }
                                        }
                                    } else if (JCRLocalCloudDrive.this.fileAPI.isFileResource(file)) {
                                    } else {
                                        changeName = "creation";
                                        this.create(file);
                                    }
                                }
                            } else {
                                file = item.getParent();
                                if (UPDATE.equals(this.changeType)) {
                                    if (JCRLocalCloudDrive.this.fileAPI.isFile(file)) {
                                        changeName = "update";
                                        this.update(file);
                                    } else if (JCRLocalCloudDrive.this.fileAPI.isFileResource(file)) {
                                        changeName = "content update";
                                        file = file.getParent();
                                        this.updateContent(file);
                                    }
                                }
                            }
                        }
                        catch (SyncNotSupportedException e) {
                            if (file == null) break block34;
                            if (!JCRLocalCloudDrive.this.fileAPI.isIgnored(file)) {
                                LOG.warn((Object)("Cannot synchronize cloud file " + changeName + ": " + e.getMessage() + ". Ignoring the file."));
                                try {
                                    JCRLocalCloudDrive.this.fileAPI.ignoreFile(file);
                                    throw e;
                                }
                                catch (Throwable t) {
                                    LOG.error((Object)("Error ignoring not a cloud item " + this.getPath()), t);
                                }
                                throw e;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Synchronization not available for ignored cloud item " + changeName + ": " + this.getPath()));
                            }
                        }
                    }
                    catch (SkipSyncException skipSyncException) {
                        // empty catch block
                    }
                }
                finally {
                    this.complete();
                }
            }
            if (this.next == null) return;
            this.next.apply();
        }

        private void await() throws InterruptedException {
            while (this.applied.getCount() > 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">>>> Await " + this.getPath()));
                }
                this.applied.await();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void begin() throws InterruptedException {
            ConcurrentHashMap<String, FileChange> concurrentHashMap = JCRLocalCloudDrive.this.fileChanges;
            synchronized (concurrentHashMap) {
                String lockedPath = this.getPath();
                FileChange other = JCRLocalCloudDrive.this.fileChanges.putIfAbsent(lockedPath, this);
                if (other != this && (other = JCRLocalCloudDrive.this.fileChanges.put(lockedPath, this)) != this) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">>> Waiting for " + other.getPath()));
                    }
                    other.await();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<<< Done " + other.getPath()));
                    }
                }
                for (FileChange c : JCRLocalCloudDrive.this.fileChanges.values()) {
                    if (c == this || !c.getPath().startsWith(lockedPath)) continue;
                    LOG.info((Object)(">>>> Waiting for child " + c.getPath()));
                    c.await();
                    LOG.info((Object)("<<<< Done " + c.getPath()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete() throws PathNotFoundException, RepositoryException, CloudDriveException {
            try {
                JCRLocalCloudDrive.this.fileChanges.remove(this.getPath(), this);
            }
            finally {
                this.applied.countDown();
            }
        }

        private void init(Node file) throws RepositoryException, CloudDriveException {
            if (this.fileId == null) {
                this.fileId = JCRLocalCloudDrive.this.fileAPI.getId(file);
            }
            if (this.filePath == null) {
                this.filePath = file.getPath();
            }
        }

        private void remove() throws PathNotFoundException, CloudDriveException, RepositoryException, InterruptedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Remove file " + this.path + " " + this.fileId));
            }
            this.begin();
            this.synchronizer.remove(this.path, this.fileId, this.isFolder, JCRLocalCloudDrive.this.fileAPI);
            if (this.fileUUID != null) {
                for (Node linked : JCRLocalCloudDrive.this.finder.findLinked(JCRLocalCloudDrive.this.session(), this.fileUUID)) {
                    Node parent = JCRLocalCloudDrive.this.ensureOwned(linked.getParent());
                    JCRLocalCloudDrive.this.ensureOwned(linked).remove();
                    parent.save();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trash() throws PathNotFoundException, CloudDriveException, RepositoryException, InterruptedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trash file " + this.path + " " + this.fileId));
            }
            this.begin();
            FileTrashing confirmation = new FileTrashing();
            FileTrashing existing = JCRLocalCloudDrive.this.fileTrash.putIfAbsent(this.fileId, confirmation);
            if (existing != null) {
                confirmation = existing;
            }
            try {
                this.synchronizer.trash(this.path, this.fileId, this.isFolder, JCRLocalCloudDrive.this.fileAPI);
            }
            catch (FileTrashRemovedException e) {
                confirmation.remove();
            }
            catch (NotFoundException e) {
                confirmation.remove();
            }
            try {
                confirmation.complete();
            }
            finally {
                JCRLocalCloudDrive.this.fileTrash.remove(this.fileId, confirmation);
            }
        }

        private void untrash(Node file) throws SkipSyncException, SyncNotSupportedException, CloudDriveException, RepositoryException, InterruptedException {
            this.init(file);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Untrash file " + this.filePath + " " + this.fileId));
            }
            this.begin();
            while (true) {
                try {
                    JCRLocalCloudDrive.this.synchronizer(file).untrash(file, JCRLocalCloudDrive.this.fileAPI);
                }
                catch (ConflictException e) {
                    JCRLocalCloudDrive.this.fixNameConflict(file);
                    continue;
                }
                break;
            }
            file.setProperty("ecd:trashed", (String)null);
        }

        private void update(Node file) throws SkipSyncException, SyncNotSupportedException, CloudDriveException, RepositoryException, InterruptedException {
            this.init(file);
            if (!this.isUpdated(this.fileId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Update file " + this.filePath + " " + this.fileId));
                }
                this.begin();
                while (true) {
                    try {
                        JCRLocalCloudDrive.this.synchronizer(file).update(file, JCRLocalCloudDrive.this.fileAPI);
                    }
                    catch (ConflictException e) {
                        JCRLocalCloudDrive.this.fixNameConflict(file);
                        continue;
                    }
                    break;
                }
                this.addUpdated(this.fileId);
            }
        }

        private void copy(Node srcFile, Node destFile) throws SkipSyncException, SyncNotSupportedException, CloudDriveException, RepositoryException, InterruptedException {
            this.init(destFile);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Copy file " + srcFile.getPath() + " -> " + this.filePath + " " + this.fileId));
            }
            this.begin();
            while (true) {
                try {
                    JCRLocalCloudDrive.this.synchronizer(destFile).copy(srcFile, destFile, JCRLocalCloudDrive.this.fileAPI);
                }
                catch (ConflictException e) {
                    JCRLocalCloudDrive.this.fixNameConflict(destFile);
                    continue;
                }
                break;
            }
            this.fileId = JCRLocalCloudDrive.this.fileAPI.getId(destFile);
            this.addUpdated(this.fileId);
        }

        private void updateContent(Node file) throws SkipSyncException, SyncNotSupportedException, CloudDriveException, RepositoryException, InterruptedException {
            this.init(file);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Update content of file " + this.filePath + " " + this.fileId));
            }
            this.begin();
            JCRLocalCloudDrive.this.synchronizer(file).updateContent(file, JCRLocalCloudDrive.this.fileAPI);
        }

        private void create(Node file) throws SkipSyncException, SyncNotSupportedException, CloudDriveException, RepositoryException, InterruptedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Create file " + this.path));
            }
            this.filePath = file.getPath();
            this.begin();
            try {
                file.refresh(true);
            }
            catch (InvalidItemStateException e) {
                LOG.warn((Object)("Creating file already removed. " + e.getMessage()));
                throw new SkipSyncException("Skip creation of already removed file. " + e.getMessage());
            }
            if (JCRLocalCloudDrive.this.fileAPI.isFile(file)) {
                if (!JCRLocalCloudDrive.this.rootUUID.equals(file.getProperty("ecd:driveUUID").getString())) {
                    throw new SyncNotSupportedException("Cannot add file created in another cloud drive " + file.getPath());
                }
            } else {
                try {
                    JCRLocalCloudDrive.this.synchronizer(file).create(file, JCRLocalCloudDrive.this.fileAPI);
                }
                catch (NotFoundException e) {
                    this.filePath = file.getPath();
                    LOG.warn((Object)("Parent not found in cloud for file creation " + this.filePath + ". " + e.getMessage()));
                    file.remove();
                    return;
                }
            }
            this.filePath = file.getPath();
            this.fileId = JCRLocalCloudDrive.this.fileAPI.getId(file);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created file " + this.filePath + " " + this.fileId));
            }
        }

        private boolean isUpdated(String fileId) {
            return this.updated != null ? this.updated.contains(fileId) : false;
        }

        private void addUpdated(String fileId) {
            if (this.updated != null) {
                this.updated.add(fileId);
            }
        }
    }

    protected abstract class AbstractFileAPI
    implements CloudFileAPI {
        protected AbstractFileAPI() {
        }

        protected String rootPath() throws DriveRemovedException, RepositoryException {
            return JCRLocalCloudDrive.this.rootNode().getPath();
        }

        @Override
        public boolean isFolder(Node node) throws RepositoryException {
            return node.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFOLDER);
        }

        @Override
        public boolean isFile(Node node) throws RepositoryException {
            return node.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFILE);
        }

        @Override
        public boolean isFileResource(Node node) throws RepositoryException {
            return node.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFILERESOURCE);
        }

        @Override
        public boolean isIgnored(Node node) throws RepositoryException {
            return node.isNodeType(JCRLocalCloudDrive.ECD_IGNORED);
        }

        @Override
        public void ignoreFile(Node node) throws RepositoryException {
            if (!node.isNodeType(JCRLocalCloudDrive.ECD_IGNORED)) {
                node.addMixin(JCRLocalCloudDrive.ECD_IGNORED);
            }
        }

        @Override
        public String getId(Node fileNode) throws RepositoryException {
            return fileNode.getProperty("ecd:id").getString();
        }

        @Override
        public String getTitle(Node fileNode) throws RepositoryException {
            return fileNode.getProperty("exo:title").getString();
        }

        @Override
        public String getParentId(Node fileNode) throws RepositoryException {
            Node parent = fileNode.getParent();
            return parent.getProperty("ecd:id").getString();
        }

        @Override
        public Collection<String> findParents(Node fileNode) throws DriveRemovedException, RepositoryException {
            LinkedHashSet<String> parentIds = new LinkedHashSet<String>();
            NodeIterator niter = JCRLocalCloudDrive.this.findNodes(Arrays.asList(this.getId(fileNode)));
            while (niter.hasNext()) {
                Node p = niter.nextNode().getParent();
                parentIds.add(p.getProperty("ecd:id").getString());
            }
            return Collections.unmodifiableCollection(parentIds);
        }
    }

    protected class SyncFilesCommand
    extends AbstractCommand {
        static final String NAME = "files synchronization";
        final List<FileChange> changes;

        SyncFilesCommand(List<FileChange> changes) {
            this.changes = changes;
        }

        @Override
        public String getName() {
            return NAME;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process() throws CloudDriveAccessException, CloudDriveException, RepositoryException, InterruptedException {
            if (JCRLocalCloudDrive.this.isConnected()) {
                JCRLocalCloudDrive.this.syncLock.readLock().lock();
                try {
                    JCRLocalCloudDrive.this.saveChanges(this.changes);
                    this.sync(this.rootNode);
                }
                finally {
                    JCRLocalCloudDrive.this.syncLock.readLock().unlock();
                }
            } else {
                LOG.warn((Object)("Cannot synchronize file in cloud drive '" + JCRLocalCloudDrive.this.title() + "': drive not connected"));
            }
        }

        void sync(Node driveNode) throws RepositoryException, CloudDriveException, InterruptedException {
            HashSet<String> ignoredPaths = new HashSet<String>();
            HashSet<String> updated = new HashSet<String>();
            Iterator<FileChange> chiter = this.changes.iterator();
            block3: while (chiter.hasNext() && !Thread.currentThread().isInterrupted()) {
                FileChange change = chiter.next();
                for (String ipath : ignoredPaths) {
                    if (!change.getPath().startsWith(ipath)) continue;
                    continue block3;
                }
                try {
                    change.initUpdated(updated);
                    change.apply();
                }
                catch (SyncNotSupportedException e) {
                    ignoredPaths.add(change.getPath());
                }
                catch (PathNotFoundException e) {
                    if (change.changeType.equals("D")) {
                        LOG.warn((Object)("Ignoring already removed item removal: " + change.fileId + " " + change.getPath()), (Throwable)e);
                        continue;
                    }
                    if (change.changeType.equals("A")) {
                        LOG.warn((Object)("Ignoring already removed item creation: " + change.getPath()), (Throwable)e);
                        continue;
                    }
                    if (change.changeType.equals("U")) {
                        Node existing = JCRLocalCloudDrive.this.findNode(change.fileId);
                        if (existing == null) continue;
                        LOG.warn((Object)("Item already updated (file renamed) " + change.getPath() + " belongs to " + existing.getPath() + ". Change faced with this: " + e.getMessage()));
                        continue;
                    }
                    if (e.getMessage().indexOf("/exo:thumbnails") > 0 && change.getPath().indexOf("/exo:thumbnails") > 0) {
                        ignoredPaths.add(change.getPath());
                        continue;
                    }
                    throw e;
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Files synchronization interrupted in " + JCRLocalCloudDrive.this.title());
            }
            driveNode.save();
            JCRLocalCloudDrive.this.commitChanges(this.changes);
        }
    }

    protected final class NoSyncCommand
    extends SyncCommand {
        protected NoSyncCommand() {
        }

        @Override
        protected void syncFiles() throws CloudDriveException, RepositoryException {
        }
    }

    protected abstract class SyncCommand
    extends AbstractCommand {
        protected Map<String, List<Node>> nodes;

        protected SyncCommand() {
        }

        @Override
        public String getName() {
            return "synchronization";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process() throws CloudDriveAccessException, CloudDriveException, RepositoryException, InterruptedException {
            JCRLocalCloudDrive.this.syncLock.writeLock().lock();
            try {
                List<FileChange> changes = JCRLocalCloudDrive.this.savedChanges();
                if (changes.size() > 0) {
                    new SyncFilesCommand(changes).sync(this.rootNode);
                }
                this.syncFiles();
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Drive synchronization interrupted for " + JCRLocalCloudDrive.this.title());
                }
                this.rootNode.save();
            }
            finally {
                JCRLocalCloudDrive.this.currentSync.set(JCRLocalCloudDrive.this.noSyncCommand);
                JCRLocalCloudDrive.this.syncLock.writeLock().unlock();
            }
            JCRLocalCloudDrive.this.listeners.fireOnSynchronized(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, this.rootNode.getPath()));
        }

        protected abstract void syncFiles() throws CloudDriveException, RepositoryException;

        protected void readLocalNodes() throws RepositoryException {
            LinkedHashMap<String, List<Node>> nodes = new LinkedHashMap<String, List<Node>>();
            String rootId = JCRLocalCloudDrive.this.fileAPI.getId(this.rootNode);
            ArrayList<Node> rootList = new ArrayList<Node>();
            rootList.add(this.rootNode);
            nodes.put(rootId, rootList);
            JCRLocalCloudDrive.this.readNodes(this.rootNode, nodes, true);
            this.nodes = nodes;
        }
    }

    protected final class NoConnectCommand
    extends ConnectCommand {
        NoConnectCommand() throws RepositoryException, DriveRemovedException {
        }

        @Override
        protected void fetchFiles() throws CloudDriveException, RepositoryException {
        }
    }

    protected abstract class ConnectCommand
    extends AbstractCommand {
        protected ConnectCommand() throws RepositoryException, DriveRemovedException {
        }

        protected abstract void fetchFiles() throws CloudDriveException, RepositoryException;

        @Override
        public String getName() {
            return "connect";
        }

        @Override
        protected void process() throws CloudDriveException, RepositoryException, InterruptedException {
            String empty = JCRLocalCloudDrive.DUMMY_DATA.intern();
            this.rootNode.setProperty("ecd:localChanges", empty);
            this.rootNode.setProperty("ecd:localHistory", empty);
            this.rootNode.setProperty("ecd:connected", false);
            this.rootNode.save();
            this.fetchFiles();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Drive connection interrupted for " + JCRLocalCloudDrive.this.title());
            }
            this.rootNode.setProperty("ecd:cloudUserId", JCRLocalCloudDrive.this.getUser().getId());
            this.rootNode.setProperty("ecd:cloudUserName", JCRLocalCloudDrive.this.getUser().getUsername());
            this.rootNode.setProperty("ecd:userEmail", JCRLocalCloudDrive.this.getUser().getEmail());
            this.rootNode.setProperty("ecd:connectDate", Calendar.getInstance());
            this.rootNode.setProperty("ecd:connected", true);
            this.rootNode.save();
            JCRLocalCloudDrive.this.listeners.fireOnConnect(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, this.rootNode.getPath()));
        }
    }

    protected abstract class AbstractCommand
    implements CloudDrive.Command,
    CloudDrive.CommandProgress {
        protected final Queue<CloudFile> changed = new ConcurrentLinkedQueue<CloudFile>();
        protected final Queue<String> removed = new ConcurrentLinkedQueue<String>();
        protected Node rootNode;
        protected final AtomicInteger progressReported = new AtomicInteger();
        protected final AtomicLong startTime = new AtomicLong();
        protected final AtomicLong finishTime = new AtomicLong();
        protected final List<ChunkIterator<?>> iterators = new ArrayList();
        protected Future<CloudDrive.Command> async;
        protected ExoJCRSettings settings;

        protected AbstractCommand() {
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        protected abstract void process() throws CloudDriveAccessException, CloudDriveException, RepositoryException, InterruptedException;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final void exec() throws CloudDriveAccessException, CloudDriveException, RepositoryException {
            block13: {
                this.startTime.set(System.currentTimeMillis());
                try {
                    JCRLocalCloudDrive.this.commandEnv.prepare(this);
                    JCRLocalCloudDrive.this.jcrListener.disable();
                    JCRLocalCloudDrive.startAction(JCRLocalCloudDrive.this);
                    this.rootNode = JCRLocalCloudDrive.this.rootNode();
                    int attemptNumb = 0;
                    while (!Thread.currentThread().isInterrupted()) {
                        try {
                            this.process();
                            return;
                        }
                        catch (CloudProviderException e) {
                            if (Thread.currentThread().isInterrupted()) throw e;
                            if (!JCRLocalCloudDrive.this.getUser().getProvider().retryOnProviderError()) throw e;
                            if (++attemptNumb > 3) {
                                throw e;
                            }
                            JCRLocalCloudDrive.this.rollback(this.rootNode);
                            LOG.warn((Object)("Error running " + this.getName() + " command. " + e.getMessage() + ". Rolled back and will run next attempt in " + 10000L + "ms."));
                            Thread.sleep(10000L);
                        }
                    }
                    if (!Thread.currentThread().isInterrupted()) break block13;
                    throw new InterruptedException("Drive " + this.getName() + " interrupted in " + JCRLocalCloudDrive.this.title());
                }
                catch (CloudDriveException e) {
                    JCRLocalCloudDrive.this.handleError(this.rootNode, e, this.getName());
                    JCRLocalCloudDrive.this.commandEnv.fail(this, e);
                    throw e;
                }
                catch (RepositoryException e) {
                    JCRLocalCloudDrive.this.handleError(this.rootNode, e, this.getName());
                    JCRLocalCloudDrive.this.commandEnv.fail(this, e);
                    throw e;
                }
                catch (InterruptedException e) {
                    JCRLocalCloudDrive.this.handleError(this.rootNode, e, this.getName());
                    JCRLocalCloudDrive.this.commandEnv.fail(this, e);
                    Thread.currentThread().interrupt();
                    throw new CloudDriveException("Drive " + this.getName() + " canceled", e);
                }
                catch (RuntimeException e) {
                    JCRLocalCloudDrive.this.handleError(this.rootNode, e, this.getName());
                    JCRLocalCloudDrive.this.commandEnv.fail(this, e);
                    e.printStackTrace();
                    throw e;
                }
            }
            LOG.warn((Object)("Drive " + this.getName() + " finished unexpectedly."));
            return;
            finally {
                JCRLocalCloudDrive.doneAction();
                JCRLocalCloudDrive.this.jcrListener.enable();
                JCRLocalCloudDrive.this.commandEnv.cleanup(this);
                this.finishTime.set(System.currentTimeMillis());
            }
        }

        Future<CloudDrive.Command> start() throws CloudDriveException {
            JCRLocalCloudDrive.this.commandEnv.configure(this);
            try {
                this.async = JCRLocalCloudDrive.this.commandExecutor.submit(this.getName(), new CommandCallable(this));
                return this.async;
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Command executor interrupted and cannot submit " + this.getName() + " for drive " + JCRLocalCloudDrive.this.title() + ". " + e.getMessage()));
                Thread.currentThread().interrupt();
                throw new CloudDriveException("Drive " + this.getName() + " interrupted for " + JCRLocalCloudDrive.this.title(), e);
            }
        }

        @Override
        public long getComplete() {
            int complete = 0;
            for (ChunkIterator<?> child : this.iterators) {
                complete = (int)((long)complete + child.getFetched());
            }
            return complete;
        }

        @Override
        public long getAvailable() {
            int available = 0;
            for (ChunkIterator<?> child : this.iterators) {
                available = (int)((long)available + child.getAvailable());
            }
            return Math.round((float)available * 1.075f);
        }

        @Override
        public int getProgress() {
            int reported;
            if (this.isDone()) {
                return 100;
            }
            int current = Math.round((float)this.getComplete() * 100.0f / (float)this.getAvailable());
            if (current >= (reported = this.progressReported.get())) {
                reported = current;
            }
            this.progressReported.set(reported);
            return reported;
        }

        @Override
        public boolean isDone() {
            return this.getFinishTime() > 0L;
        }

        @Override
        public long getStartTime() {
            return this.startTime.get();
        }

        @Override
        public long getFinishTime() {
            return this.finishTime.get();
        }

        @Override
        public Collection<CloudFile> getFiles() {
            return Collections.unmodifiableCollection(this.changed);
        }

        @Override
        public Collection<String> getRemoved() {
            return Collections.unmodifiableCollection(this.removed);
        }

        @Override
        public void await() throws ExecutionException, InterruptedException {
            if (this.async != null && !this.async.isDone() && !this.async.isCancelled()) {
                this.async.get();
            }
        }
    }

    protected class ExoJCREnvironment
    extends CloudDriveEnvironment {
        protected final Map<CloudDrive.Command, ExoJCRSettings> config = Collections.synchronizedMap(new HashMap());

        protected ExoJCREnvironment() {
        }

        @Override
        public void configure(CloudDrive.Command command) throws CloudDriveException {
            ConversationState conversation = ConversationState.getCurrent();
            if (conversation == null) {
                throw new CloudDriveException("Error to " + this.getName() + " drive for user " + JCRLocalCloudDrive.this.getUser().getEmail() + ". User identity not set.");
            }
            this.config.put(command, new ExoJCRSettings(conversation, ExoContainerContext.getCurrentContainer()));
            super.configure(command);
        }

        @Override
        public void prepare(CloudDrive.Command command) throws CloudDriveException {
            super.prepare(command);
            ExoJCRSettings settings = this.config.get(command);
            if (settings == null) {
                throw new CloudDriveException(((Object)((Object)this)).getClass().getName() + " setting not configured for " + command + " to be prepared.");
            }
            settings.prevConversation = ConversationState.getCurrent();
            ConversationState.setCurrent((ConversationState)settings.conversation);
            settings.prevContainer = ExoContainerContext.getCurrentContainerIfPresent();
            ExoContainerContext.setCurrentContainer((ExoContainer)settings.container);
            settings.prevSessions = JCRLocalCloudDrive.this.sessionProviders.getSessionProvider(null);
            SessionProvider sp = new SessionProvider(settings.conversation);
            JCRLocalCloudDrive.this.sessionProviders.setSessionProvider(null, sp);
        }

        @Override
        public void cleanup(CloudDrive.Command command) throws CloudDriveException {
            ExoJCRSettings settings = this.config.get(command);
            if (settings == null) {
                throw new CloudDriveException(((Object)((Object)this)).getClass().getName() + " setting not configured for " + command + " to be cleaned.");
            }
            ConversationState.setCurrent((ConversationState)settings.prevConversation);
            ExoContainerContext.setCurrentContainer((ExoContainer)settings.prevContainer);
            SessionProvider sp = JCRLocalCloudDrive.this.sessionProviders.getSessionProvider(null);
            JCRLocalCloudDrive.this.sessionProviders.setSessionProvider(null, settings.prevSessions);
            sp.close();
            super.cleanup(command);
        }
    }

    protected class ExoJCRSettings {
        final ConversationState conversation;
        final ExoContainer container;
        ConversationState prevConversation;
        ExoContainer prevContainer;
        SessionProvider prevSessions;

        ExoJCRSettings(ConversationState conversation, ExoContainer container) {
            this.conversation = conversation;
            this.container = container;
        }
    }

    protected class CommandCallable
    implements Callable<CloudDrive.Command> {
        final AbstractCommand command;

        CommandCallable(AbstractCommand command) throws CloudDriveException {
            this.command = command;
        }

        @Override
        public CloudDrive.Command call() throws Exception {
            this.command.exec();
            return this.command;
        }
    }

    public class JCRListener {
        final String initialRootPath;
        final RemoveDriveListener removeListener;
        final AddTrashListener addListener;
        final DriveChangesListener changesListener;
        volatile boolean trashed = false;
        volatile boolean added = false;

        JCRListener(String initialRootPath) {
            this.initialRootPath = initialRootPath;
            this.removeListener = new RemoveDriveListener();
            this.addListener = new AddTrashListener();
            this.changesListener = new DriveChangesListener();
        }

        synchronized void checkTrashed(Node driveRoot) throws RepositoryException {
            if (this.trashed && this.added) {
                try {
                    if (driveRoot.getParent().isNodeType(JCRLocalCloudDrive.EXO_TRASHFOLDER)) {
                        this.finishTrashed(driveRoot.getSession(), driveRoot.getPath());
                        Thread remover = new Thread("cloud-drive-remover (" + JCRLocalCloudDrive.this.title() + ")"){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                boolean interrupted = false;
                                try {
                                    Session session = JCRLocalCloudDrive.this.systemSession();
                                    Node driveRoot = session.getNodeByUUID(JCRLocalCloudDrive.this.rootUUID);
                                    try {
                                        Thread.sleep(2000L);
                                    }
                                    catch (InterruptedException e) {
                                        LOG.warn((Object)("Cloud Drive remover interrupted " + e.getMessage()));
                                        interrupted = true;
                                    }
                                    JCRLocalCloudDrive.startAction(JCRLocalCloudDrive.this);
                                    try {
                                        JCRLocalCloudDrive.this.disconnect(driveRoot);
                                    }
                                    catch (Throwable e) {
                                        LOG.error((Object)("Error disconnecting Cloud Drive " + JCRLocalCloudDrive.this.title() + " before its removal. " + e.getMessage()), e);
                                    }
                                    try {
                                        driveRoot.remove();
                                        session.save();
                                        LOG.info((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " successfully removed from the Trash."));
                                    }
                                    catch (ItemNotFoundException e) {
                                        LOG.warn((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " node already removed directly from JCR: " + e.getMessage()));
                                    }
                                }
                                catch (Throwable e) {
                                    LOG.error((Object)("Error removing node of Cloud Drive " + JCRLocalCloudDrive.this.title() + ". " + e.getMessage()), e);
                                }
                                finally {
                                    JCRLocalCloudDrive.doneAction();
                                    if (interrupted) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                            }
                        };
                        remover.start();
                    }
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
        }

        void finishTrashed(Session session, String rootPath) {
            this.added = false;
            this.trashed = false;
            try {
                JCRLocalCloudDrive.this.removeJCRListener(session);
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error unregistering Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node listeners: " + e.getMessage()), (Throwable)e);
            }
            JCRLocalCloudDrive.this.listeners.fireOnRemove(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, rootPath));
        }

        @Deprecated
        void removeDriveNode(Node driveNode) throws RepositoryException {
            try {
                driveNode.remove();
            }
            catch (ItemNotFoundException e) {
                LOG.warn((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " node already removed directly from JCR: " + e.getMessage()));
            }
        }

        public void enable() {
            this.changesListener.enable();
        }

        public void disable() {
            this.changesListener.disable();
        }

        class DriveChangesListener
        extends BaseCloudDriveListener
        implements EventListener {
            final ThreadLocal<AtomicLong> lock = new ThreadLocal();

            DriveChangesListener() {
            }

            void disable() {
                AtomicLong requests = this.lock.get();
                if (requests == null) {
                    requests = new AtomicLong(1L);
                    this.lock.set(requests);
                } else {
                    requests.incrementAndGet();
                }
            }

            void enable() {
                AtomicLong requests = this.lock.get();
                if (requests == null) {
                    requests = new AtomicLong(0L);
                    this.lock.set(requests);
                } else if (requests.get() > 0L) {
                    requests.decrementAndGet();
                }
            }

            boolean enabled() {
                AtomicLong requests = this.lock.get();
                return requests == null || requests.get() == 0L;
            }

            public void onEvent(EventIterator events) {
                if (this.enabled()) {
                    try {
                        ArrayList<FileChange> changes = new ArrayList<FileChange>();
                        while (events.hasNext()) {
                            Event event = events.nextEvent();
                            String eventPath = event.getPath();
                            if (eventPath.endsWith("jcr:mixinTypes") || eventPath.endsWith("jcr:content") || eventPath.indexOf("ecd:") >= 0 || eventPath.indexOf("/exo:thumbnails") > 0) continue;
                            if (event.getType() == 2) {
                                FileChange remove;
                                Map<String, FileChange> removed;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Cloud file removed " + eventPath));
                                }
                                if ((removed = JCRLocalCloudDrive.this.fileRemovals.get()) == null || (remove = removed.remove(eventPath)) == null) continue;
                                changes.add(remove);
                                continue;
                            }
                            if (event.getType() == 1) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Cloud file added. User: " + event.getUserID() + ". Path: " + eventPath));
                                }
                                changes.add(new FileChange(eventPath, "A"));
                                continue;
                            }
                            if (event.getType() != 16) continue;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Cloud file property changed. User: " + event.getUserID() + ". Path: " + eventPath));
                            }
                            changes.add(new FileChange(eventPath, "U"));
                        }
                        if (changes.size() > 0) {
                            new SyncFilesCommand(changes).start();
                        }
                    }
                    catch (CloudDriveException e) {
                        LOG.error((Object)("Error starting file synchronization in cloud drive '" + JCRLocalCloudDrive.this.title() + "'"), (Throwable)e);
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Error reading cloud file for synchronization in cloud drive '" + JCRLocalCloudDrive.this.title() + "'"), (Throwable)e);
                    }
                }
            }

            @Override
            public void onError(CloudDriveEvent event, Throwable error, String operationName) {
                if (operationName.equals("files synchronization")) {
                    if (error instanceof RefreshAccessException) {
                        Throwable cause = error.getCause();
                        LOG.error((Object)("Error running " + operationName + " in drive " + JCRLocalCloudDrive.this.title() + ". " + error.getMessage() + (cause != null ? ". " + cause.getMessage() : JCRLocalCloudDrive.DUMMY_DATA)));
                    } else {
                        LOG.error((Object)("Error running " + operationName + " in drive " + JCRLocalCloudDrive.this.title()), error);
                    }
                }
            }
        }

        class AddTrashListener
        implements EventListener {
            AddTrashListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    Session session = JCRLocalCloudDrive.this.systemSession();
                    Node driveRoot = null;
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        String path = event.getPath();
                        try {
                            Item item = session.getItem(path);
                            if (item.isNode()) {
                                Node node = (Node)item;
                                if (node.isNodeType(JCRLocalCloudDrive.ECD_CLOUDDRIVE)) {
                                    String rootPath;
                                    block14: {
                                        if (driveRoot == null) {
                                            try {
                                                driveRoot = session.getNodeByUUID(JCRLocalCloudDrive.this.rootUUID);
                                                if (!LOG.isDebugEnabled()) break block14;
                                                LOG.debug((Object)("Cloud Drive trashed " + path));
                                            }
                                            catch (ItemNotFoundException e) {
                                                LOG.warn((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " node already removed directly from JCR: " + e.getMessage()));
                                                JCRListener.this.finishTrashed(session, JCRListener.this.initialRootPath);
                                                continue;
                                            }
                                        }
                                    }
                                    if ((rootPath = driveRoot.getPath()).equals(path)) {
                                        JCRListener.this.added = true;
                                    }
                                    JCRListener.this.checkTrashed(driveRoot);
                                    continue;
                                }
                                if (!JCRLocalCloudDrive.this.fileAPI.isFile(node) || !JCRLocalCloudDrive.this.rootUUID.equals(node.getProperty("ecd:driveUUID").getString())) continue;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Cloud drive item trashed " + path));
                                }
                                node.setProperty("ecd:trashed", true);
                                node.save();
                                String fileId = JCRLocalCloudDrive.this.fileAPI.getId(node);
                                FileTrashing confirmation = new FileTrashing();
                                FileTrashing existing = JCRLocalCloudDrive.this.fileTrash.putIfAbsent(fileId, confirmation);
                                if (existing != null) {
                                    existing.confirm(path, fileId);
                                    continue;
                                }
                                confirmation.confirm(path, fileId);
                                continue;
                            }
                            LOG.warn((Object)("Item in Trash not a node:" + path));
                        }
                        catch (PathNotFoundException e) {
                            LOG.warn((Object)("Cloud item already deleted directly from JCR: " + path));
                        }
                    }
                }
                catch (AccessDeniedException e) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive " + JCRLocalCloudDrive.this.title() + " item move to Trash event" + (userId != null ? " for user " + userId : JCRLocalCloudDrive.DUMMY_DATA)), (Throwable)e);
                }
            }
        }

        class RemoveDriveListener
        implements EventListener {
            RemoveDriveListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    Node driveRoot;
                    Session session = JCRLocalCloudDrive.this.systemSession();
                    try {
                        driveRoot = session.getNodeByUUID(JCRLocalCloudDrive.this.rootUUID);
                    }
                    catch (ItemNotFoundException e) {
                        LOG.warn((Object)("Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node already removed directly from JCR: " + e.getMessage()));
                        JCRListener.this.finishTrashed(session, JCRListener.this.initialRootPath);
                        return;
                    }
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        if (!JCRListener.this.initialRootPath.equals(event.getPath())) continue;
                        JCRListener.this.trashed = true;
                    }
                    JCRListener.this.checkTrashed(driveRoot);
                }
                catch (AccessDeniedException e) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node move/remove event" + (userId != null ? " for user " + userId : JCRLocalCloudDrive.DUMMY_DATA)), (Throwable)e);
                }
            }
        }
    }

    class FileTrashing {
        private final CountDownLatch latch = new CountDownLatch(1);
        private String trashPath;
        private String fileId;
        private boolean remove = false;

        FileTrashing() {
        }

        void confirm(String path, String fileId) {
            this.trashPath = path;
            this.fileId = fileId;
            this.latch.countDown();
        }

        void remove() {
            this.remove = true;
        }

        void complete() throws InterruptedException, RepositoryException {
            this.latch.await(60L, TimeUnit.SECONDS);
            if (this.remove) {
                this.removeTrashed();
            }
        }

        private void removeTrashed() throws RepositoryException {
            if (this.trashPath != null && this.fileId != null) {
                Node trash;
                Session session = JCRLocalCloudDrive.this.systemSession();
                Item trashed = session.getItem(this.trashPath);
                if (trashed.isNode()) {
                    Node file = (Node)trashed;
                    if (JCRLocalCloudDrive.this.fileAPI.isFile(file) && this.fileId.equals(JCRLocalCloudDrive.this.fileAPI.getId(file)) && JCRLocalCloudDrive.this.rootUUID.equals(file.getProperty("ecd:driveUUID").getString())) {
                        file.remove();
                        session.save();
                        return;
                    }
                    trash = trashed.getParent();
                } else {
                    trash = trashed.getParent().getParent();
                }
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query q = qm.createQuery("SELECT * FROM ecd:cloudFile WHERE ecd:id=" + this.fileId + " AND jcr:path LIKE '" + trash.getPath() + "/%'", "sql");
                QueryResult qr = q.execute();
                NodeIterator niter = qr.getNodes();
                while (niter.hasNext()) {
                    Node file = niter.nextNode();
                    if (!JCRLocalCloudDrive.this.rootUUID.equals(file.getProperty("ecd:driveUUID").getString())) continue;
                    file.remove();
                }
                session.save();
            }
        }
    }

    static class AlreadyDone
    implements CloudDrive.Command {
        final long time = System.currentTimeMillis();

        AlreadyDone() {
        }

        @Override
        public int getProgress() {
            return 100;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Collection<CloudFile> getFiles() {
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getRemoved() {
            return Collections.emptyList();
        }

        @Override
        public long getStartTime() {
            return this.time;
        }

        @Override
        public long getFinishTime() {
            return this.time;
        }

        @Override
        public void await() throws InterruptedException {
        }

        @Override
        public String getName() {
            return "complete";
        }
    }
}

