/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFileAPI;
import org.exoplatform.clouddrive.CloudFileSynchronizer;
import org.exoplatform.clouddrive.SkipSyncException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public final class LostRemovalSynchronizer
implements CloudFileSynchronizer {
    protected static final Log LOG = ExoLogger.getLogger(LostRemovalSynchronizer.class);

    @Override
    public String[] getSupportedNodetypes() {
        return new String[0];
    }

    @Override
    public boolean accept(Node file) throws RepositoryException, SkipSyncException {
        return false;
    }

    @Override
    public boolean remove(String filePath, String fileId, boolean isFolder, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        if (isFolder) {
            api.removeFolder(fileId);
        } else {
            api.removeFile(fileId);
        }
        return true;
    }

    @Override
    public boolean trash(String filePath, String fileId, boolean isFolder, CloudFileAPI api) throws RepositoryException, CloudDriveException {
        if (isFolder) {
            return api.trashFolder(fileId);
        }
        return api.trashFile(fileId);
    }

    @Override
    public boolean create(Node file, CloudFileAPI api) throws RepositoryException, CloudDriveException {
        throw new SyncNotSupportedException("Not supported");
    }

    @Override
    public boolean untrash(Node file, CloudFileAPI api) throws RepositoryException, CloudDriveException {
        throw new SyncNotSupportedException("Not supported");
    }

    @Override
    public boolean update(Node file, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        throw new SyncNotSupportedException("Not supported");
    }

    @Override
    public boolean updateContent(Node file, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        throw new SyncNotSupportedException("Not supported");
    }

    @Override
    public boolean copy(Node srcFile, Node destFile, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        throw new SyncNotSupportedException("Not supported");
    }
}

