/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.cmis;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.exoplatform.clouddrive.CannotConnectDriveException;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFileAPI;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConflictException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.cmis.CMISAPI;
import org.exoplatform.clouddrive.cmis.CMISConnector;
import org.exoplatform.clouddrive.cmis.CMISException;
import org.exoplatform.clouddrive.cmis.CMISUser;
import org.exoplatform.clouddrive.cmis.ContentReader;
import org.exoplatform.clouddrive.cmis.rest.ContentService;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.gatein.common.util.Base64;

public class JCRLocalCMISDrive
extends JCRLocalCloudDrive {
    public static final long FULL_SYNC_PERIOD = 889032704L;
    protected final AtomicLong changeIdSequencer = new AtomicLong(0L);
    protected final String exoURL;

    protected JCRLocalCMISDrive(CMISUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, String exoURL) throws CloudDriveException, RepositoryException {
        super((CloudUser)user, driveNode, sessionProviders, finder, mimeTypes);
        this.exoURL = exoURL;
        CMISAPI api = user.api();
        this.saveAccess(driveNode, api.getPassword(), api.getServiceURL(), api.getRepositoryId());
    }

    protected JCRLocalCMISDrive(CMISConnector.API apiBuilder, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, String exoURL) throws RepositoryException, CloudDriveException {
        super((CloudUser)JCRLocalCMISDrive.loadUser(apiBuilder, driveNode), driveNode, sessionProviders, finder, mimeTypes);
        this.exoURL = exoURL;
    }

    protected static CMISUser loadUser(CMISConnector.API apiBuilder, Node driveNode) throws RepositoryException, CMISException, CloudDriveException {
        String userName = driveNode.getProperty("ecd:cloudUserName").getString();
        String email = driveNode.getProperty("ecd:userEmail").getString();
        String userId = driveNode.getProperty("ecd:cloudUserId").getString();
        String accessKey = driveNode.getProperty("cmiscd:accessKey").getString();
        try {
            String password = new String(Base64.decode((String)accessKey), "UTF-8");
            String serviceURL = driveNode.getProperty("cmiscd:serviceURL").getString();
            String repositoryId = driveNode.getProperty("cmiscd:repositoryId").getString();
            CMISAPI driveAPI = apiBuilder.auth(userName, password).serviceUrl(serviceURL).build();
            driveAPI.initRepository(repositoryId);
            return apiBuilder.createUser(userId, userName, email, driveAPI);
        }
        catch (UnsupportedEncodingException e) {
            throw new CloudDriveException("Error decoding user key", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAccess(Node driveNode, String password, String serviceURL, String repositoryId) throws CloudDriveException {
        try {
            this.jcrListener.disable();
            try {
                String accessKey = Base64.encodeBytes((byte[])password.getBytes("UTF-8"));
                driveNode.setProperty("cmiscd:accessKey", accessKey);
                if (serviceURL != null) {
                    driveNode.setProperty("cmiscd:serviceURL", serviceURL);
                } else if (!driveNode.hasProperty("cmiscd:serviceURL")) {
                    this.rollback(driveNode);
                    throw new CloudDriveException("CMIS service URL required for user access");
                }
                if (repositoryId != null) {
                    driveNode.setProperty("cmiscd:repositoryId", repositoryId);
                } else if (!driveNode.hasProperty("cmiscd:repositoryId")) {
                    this.rollback(driveNode);
                    throw new CloudDriveException("CMIS repository ID required for user access");
                }
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error saving user key", (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new CloudDriveException("Error encoding user key", (Throwable)e);
            }
        }
        finally {
            this.jcrListener.enable();
        }
    }

    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new Connect();
    }

    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new Sync();
    }

    protected CloudFileAPI createFileAPI() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new FileAPI();
    }

    protected Long readChangeId() throws RepositoryException, CloudDriveException {
        try {
            return this.rootNode().getProperty("cmiscd:changeTimestamp").getLong();
        }
        catch (PathNotFoundException e) {
            throw new CloudDriveException("Change id not found for the drive " + this.title());
        }
    }

    protected void saveChangeId(Long id) throws CloudDriveException, RepositoryException {
        Node driveNode = this.rootNode();
        driveNode.setProperty("cmiscd:changeTimestamp", id.longValue());
    }

    public CMISUser getUser() {
        return (CMISUser)this.user;
    }

    protected void refreshAccess() throws CloudDriveException {
    }

    protected void updateAccess(CloudUser newUser) throws CloudDriveException, RepositoryException {
        CMISAPI newAPI = ((CMISUser)newUser).api();
        String user = newAPI.getUser();
        String password = newAPI.getPassword();
        try {
            Node driveNode = this.rootNode();
            String userId = driveNode.getProperty("ecd:cloudUserId").getString();
            if (!userId.equals(user)) {
                throw new CloudDriveException("User doesn't match to access key: " + user);
            }
            this.saveAccess(driveNode, password, null, null);
            this.getUser().api().updateUser(newAPI.getParamaters());
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void initCMISItem(Node localNode, CmisObject item) throws RepositoryException, CMISException {
        this.setChangeToken(localNode, item.getChangeToken());
        localNode.setProperty("cmiscd:refreshTimestamp", item.getRefreshTimestamp());
        localNode.setProperty("cmiscd:description", item.getDescription());
    }

    protected void initFile(Node localNode, String title, String id, String type, String link, String previewLink, String thumbnailLink, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        String recommendedType = this.findMimetype(title, type);
        if (recommendedType != null && !type.equals(recommendedType)) {
            type = recommendedType;
        }
        super.initFile(localNode, title, id, type, link, previewLink, thumbnailLink, author, lastUser, created, modified);
    }

    protected void setChangeToken(Node localNode, String changeToken) throws RepositoryException, CMISException {
        localNode.setProperty("cmiscd:changeToken", changeToken);
    }

    protected String getChangeToken(Node localNode) throws RepositoryException, CMISException {
        return localNode.getProperty("cmiscd:changeToken").getString();
    }

    protected JCRLocalCloudFile updateItem(CMISAPI api, CmisObject item, Node parent, Node node) throws RepositoryException, CloudDriveException {
        String thumbnailLink;
        String link;
        String typeMode;
        String type;
        long contentLength;
        boolean isFolder;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> updateItem: " + item.getName() + " " + item.getType().getDisplayName() + " (" + item.getBaseType().getDisplayName() + ", " + item.getBaseTypeId().value() + ")"));
        }
        String id = item.getId();
        String name = item.getName();
        if (api.isDocument(item)) {
            isFolder = false;
            boolean isDocument = true;
            Document document = (Document)item;
            contentLength = document.getContentStreamLength();
            type = document.getContentStreamMimeType();
            if (type == null || type.equals(this.mimeTypes.getDefaultMimeType())) {
                type = this.mimeTypes.getMimeType(name);
            }
            typeMode = this.mimeTypes.getMimeTypeMode(type, name);
        } else {
            boolean isDocument = false;
            isFolder = api.isFolder(item);
            contentLength = -1L;
            type = item.getType().getId();
            typeMode = null;
        }
        if (node == null) {
            node = isFolder ? this.openFolder(id, name, parent) : this.openFile(id, name, parent);
        }
        GregorianCalendar created = item.getCreationDate();
        GregorianCalendar modified = item.getLastModificationDate();
        String createdBy = item.getCreatedBy();
        String modifiedBy = item.getLastModifiedBy();
        boolean changed = node.isNew();
        if (!changed) {
            String changeToken = item.getChangeToken();
            if (changeToken == null) {
                changed = modified.after(node.getProperty("ecd:modified").getDate());
            } else {
                boolean bl = changed = !this.getChangeToken(node).equals(changeToken);
            }
        }
        if (isFolder) {
            link = api.getLink((Folder)item);
            thumbnailLink = null;
            if (changed) {
                this.initFolder(node, id, name, type, link, createdBy, modifiedBy, created, modified);
                this.initCMISItem(node, item);
            }
        } else {
            thumbnailLink = link = api.getLink(item);
            if (changed) {
                this.initFile(node, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified);
                this.initCMISItem(node, item);
                if (contentLength >= 0L) {
                    node.setProperty("cmiscd:size", contentLength);
                }
            }
        }
        return new JCRLocalCloudFile(node.getPath(), id, name, link, this.editLink(node), this.previewLink(node), thumbnailLink, type, typeMode, createdBy, modifiedBy, (Calendar)created, (Calendar)modified, isFolder, node, changed);
    }

    protected String createContentLink(String path, String fileId) throws DriveRemovedException, RepositoryException {
        StringBuilder link = new StringBuilder();
        link.append('/');
        StringBuilder linkPath = new StringBuilder();
        linkPath.append(PortalContainer.getCurrentPortalContainerName());
        linkPath.append('/');
        linkPath.append(PortalContainer.getCurrentRestContextName());
        linkPath.append(ContentService.SERVICE_PATH);
        linkPath.append('/');
        linkPath.append(this.rootWorkspace);
        linkPath.append(path);
        try {
            URI uri = new URI(null, null, linkPath.toString(), "contentId=" + fileId, null);
            link.append(uri.getRawPath());
            link.append('?');
            link.append(uri.getRawQuery());
            return link.toString();
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Error creating content link for " + path + ": " + e.getMessage()));
            return null;
        }
    }

    protected String previewLink(Node fileNode) throws RepositoryException {
        try {
            return this.createContentLink(fileNode.getPath(), this.fileAPI.getId(fileNode));
        }
        catch (DriveRemovedException e) {
            return null;
        }
    }

    protected String editLink(Node fileNode) {
        return null;
    }

    protected String findMimetype(Document file, String localType) {
        return this.findMimetype(file.getName(), file.getContentStreamMimeType(), localType);
    }

    protected String findMimetype(String fileName, String fileType) {
        return this.findMimetype(fileName, fileType, null);
    }

    protected String findMimetype(String fileName, String fileType, String alternativeType) {
        String defaultType = this.mimeTypes.getDefaultMimeType();
        if (fileType == null || fileType.startsWith(defaultType)) {
            String resolvedType = this.mimeTypes.getMimeType(fileName);
            fileType = resolvedType != null && !resolvedType.startsWith(defaultType) ? resolvedType : (alternativeType != null ? alternativeType : defaultType);
        }
        return fileType;
    }

    protected void ensureSame(CloudUser user, Node driveNode) throws RepositoryException, CannotConnectDriveException {
        super.ensureSame(user, driveNode);
        try {
            String serviceURL = driveNode.getProperty("cmiscd:serviceURL").getString();
            String repositoryId = driveNode.getProperty("cmiscd:repositoryId").getString();
            CMISUser cmisUser = (CMISUser)user;
            if (!repositoryId.equals(cmisUser.api().getRepositoryId())) {
                LOG.warn((Object)("Cannot connect drive. Node " + driveNode.getPath() + " was connected to another repository " + repositoryId));
                throw new CannotConnectDriveException("Node already initialized for another repository " + repositoryId);
            }
            if (!serviceURL.equals(cmisUser.api().getServiceURL())) {
                LOG.warn((Object)("Cannot connect drive. Node " + driveNode.getPath() + " was connected to another server " + serviceURL));
                throw new CannotConnectDriveException("Node already initialized by another server " + serviceURL);
            }
        }
        catch (PathNotFoundException e) {
            throw new CannotConnectDriveException("Mandatory drive property not found: " + e.getMessage());
        }
    }

    public ContentReader getFileContent(String fileId) throws CMISException, NotFoundException, CloudDriveAccessException, DriveRemovedException, RepositoryException {
        CmisObject item;
        CMISAPI api = this.getUser().api();
        if (api.isDocument(item = api.getObject(fileId))) {
            String fileType;
            Document document = (Document)item;
            String name = document.getName();
            String mimeType = document.getContentStreamMimeType();
            if ((mimeType == null || mimeType.startsWith(this.mimeTypes.getDefaultMimeType())) && (fileType = this.mimeTypes.getMimeType(name)) != null) {
                mimeType = fileType;
            }
            return new DocumentContent(document.getContentStream(), mimeType, name);
        }
        return null;
    }

    protected class DocumentContent
    implements ContentReader {
        protected final ContentStream content;
        protected final String type;
        protected final long length;
        protected final String fileName;

        protected DocumentContent(ContentStream content, String type, String fileName) {
            this.content = content;
            this.length = content.getLength();
            this.type = type != null ? type : content.getMimeType();
            this.fileName = fileName;
        }

        @Override
        public InputStream getStream() {
            return this.content.getStream();
        }

        @Override
        public String getMimeType() {
            return this.type;
        }

        @Override
        public String getTypeMode() {
            return JCRLocalCMISDrive.this.mimeTypes.getMimeTypeMode(this.type, this.fileName);
        }

        @Override
        public long getLength() {
            return this.length;
        }
    }

    protected class FileAPI
    extends JCRLocalCloudDrive.AbstractFileAPI
    implements LocalFile {
        protected final CMISAPI api;

        protected FileAPI() {
            super((JCRLocalCloudDrive)JCRLocalCMISDrive.this);
            this.api = JCRLocalCMISDrive.this.getUser().api();
        }

        @Override
        public String findRemoteParent(String fileId, Set<String> remoteParents) throws CMISException {
            try {
                Collection localParents = this.findParents(fileId);
                for (String rpid : remoteParents) {
                    if (localParents.contains(rpid)) continue;
                    return rpid;
                }
            }
            catch (DriveRemovedException e) {
                throw new CMISException(e);
            }
            catch (RepositoryException e) {
                throw new CMISException("Error finding file parents", e);
            }
            return null;
        }

        public String createFile(Node fileNode, Calendar created, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            String link;
            Document file;
            String parentId = this.getParentId(fileNode);
            String title = this.getTitle(fileNode);
            try {
                file = this.api.createDocument(parentId, title, mimeType, content);
            }
            catch (ConflictException e) {
                CmisObject existing = null;
                CMISAPI.ChildrenIterator files = this.api.getFolderItems(parentId);
                while (files.hasNext()) {
                    CmisObject item = (CmisObject)files.next();
                    if (!title.equals(item.getName())) continue;
                    existing = item;
                    break;
                }
                if (existing == null || !this.api.isDocument(existing)) {
                    throw e;
                }
                file = (Document)existing;
            }
            String id = file.getId();
            String name = file.getName();
            String thumbnailLink = link = this.api.getLink((CmisObject)file);
            String createdBy = file.getCreatedBy();
            String modifiedBy = file.getLastModifiedBy();
            String type = JCRLocalCMISDrive.this.findMimetype(file, mimeType);
            JCRLocalCMISDrive.this.initFile(fileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified);
            JCRLocalCMISDrive.this.initCMISItem(fileNode, (CmisObject)file);
            return id;
        }

        public String createFolder(Node folderNode, Calendar created) throws CloudDriveException, RepositoryException {
            Folder folder;
            String parentId = this.getParentId(folderNode);
            String title = this.getTitle(folderNode);
            try {
                folder = this.api.createFolder(this.getParentId(folderNode), this.getTitle(folderNode));
            }
            catch (ConflictException e) {
                CmisObject existing = null;
                CMISAPI.ChildrenIterator files = this.api.getFolderItems(parentId);
                while (files.hasNext()) {
                    CmisObject item = (CmisObject)files.next();
                    if (!title.equals(item.getName())) continue;
                    existing = item;
                    break;
                }
                if (existing == null || !this.api.isFolder(existing)) {
                    throw e;
                }
                folder = (Folder)existing;
            }
            String id = folder.getId();
            String name = folder.getName();
            String link = this.api.getLink(folder);
            String createdBy = folder.getCreatedBy();
            String modifiedBy = folder.getLastModifiedBy();
            String type = folder.getType().getId();
            JCRLocalCMISDrive.this.initFolder(folderNode, id, name, type, link, createdBy, modifiedBy, created, created);
            JCRLocalCMISDrive.this.initCMISItem(folderNode, (CmisObject)folder);
            return id;
        }

        public void updateFile(Node fileNode, Calendar modified) throws CloudDriveException, RepositoryException {
            String id = this.getId(fileNode);
            CmisObject obj = this.api.updateObject(this.getParentId(fileNode), id, this.getTitle(fileNode), this);
            if (obj != null) {
                if (this.api.isDocument(obj)) {
                    String link;
                    Document file = (Document)obj;
                    id = file.getId();
                    String name = file.getName();
                    String thumbnailLink = link = this.api.getLink((CmisObject)file);
                    String createdBy = file.getCreatedBy();
                    String modifiedBy = file.getLastModifiedBy();
                    String type = file.getContentStreamMimeType();
                    GregorianCalendar created = file.getCreationDate();
                    modified = file.getLastModificationDate();
                    JCRLocalCMISDrive.this.initFile(fileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified);
                    JCRLocalCMISDrive.this.initCMISItem(fileNode, (CmisObject)file);
                } else {
                    throw new CMISException("Object not a document: " + id + ", " + obj.getName());
                }
            }
        }

        public void updateFolder(Node folderNode, Calendar modified) throws CloudDriveException, RepositoryException {
            String id = this.getId(folderNode);
            CmisObject obj = this.api.updateObject(this.getParentId(folderNode), id, this.getTitle(folderNode), this);
            if (obj != null) {
                if (this.api.isFolder(obj)) {
                    Folder folder = (Folder)obj;
                    id = folder.getId();
                    String name = folder.getName();
                    String link = this.api.getLink(folder);
                    String createdBy = folder.getCreatedBy();
                    String modifiedBy = folder.getLastModifiedBy();
                    String type = folder.getType().getId();
                    GregorianCalendar created = folder.getCreationDate();
                    modified = folder.getLastModificationDate();
                    JCRLocalCMISDrive.this.initFolder(folderNode, id, name, type, link, createdBy, modifiedBy, created, modified);
                    JCRLocalCMISDrive.this.initCMISItem(folderNode, (CmisObject)folder);
                } else {
                    throw new CMISException("Object not a folder: " + id + ", " + obj.getName());
                }
            }
        }

        public void updateFileContent(Node fileNode, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            String link;
            Document file = this.api.updateContent(this.getId(fileNode), this.getTitle(fileNode), content, mimeType, this);
            String id = file.getId();
            String name = file.getName();
            String thumbnailLink = link = this.api.getLink((CmisObject)file);
            String createdBy = file.getCreatedBy();
            String modifiedBy = file.getLastModifiedBy();
            String type = file.getContentStreamMimeType();
            GregorianCalendar created = file.getCreationDate();
            modified = file.getLastModificationDate();
            JCRLocalCMISDrive.this.initFile(fileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified);
            JCRLocalCMISDrive.this.initCMISItem(fileNode, (CmisObject)file);
        }

        public String copyFile(Node srcFileNode, Node destFileNode) throws CloudDriveException, RepositoryException {
            String link;
            Document file = this.api.copyDocument(this.getId(srcFileNode), this.getParentId(destFileNode), this.getTitle(destFileNode));
            String id = file.getId();
            String name = file.getName();
            String thumbnailLink = link = this.api.getLink((CmisObject)file);
            String createdBy = file.getCreatedBy();
            String modifiedBy = file.getLastModifiedBy();
            String type = file.getContentStreamMimeType();
            GregorianCalendar created = file.getCreationDate();
            GregorianCalendar modified = file.getLastModificationDate();
            JCRLocalCMISDrive.this.initFile(destFileNode, id, name, type, link, null, thumbnailLink, createdBy, modifiedBy, created, modified);
            JCRLocalCMISDrive.this.initCMISItem(destFileNode, (CmisObject)file);
            return id;
        }

        public String copyFolder(Node srcFolderNode, Node destFolderNode) throws CloudDriveException, RepositoryException {
            Folder folder = this.api.copyFolder(this.getId(srcFolderNode), this.getParentId(destFolderNode), this.getTitle(destFolderNode));
            String id = folder.getId();
            String name = folder.getName();
            String link = this.api.getLink(folder);
            String createdBy = folder.getCreatedBy();
            String modifiedBy = folder.getLastModifiedBy();
            String type = folder.getType().getId();
            GregorianCalendar created = folder.getCreationDate();
            GregorianCalendar modified = folder.getLastModificationDate();
            JCRLocalCMISDrive.this.initFolder(destFolderNode, id, name, type, link, createdBy, modifiedBy, created, modified);
            JCRLocalCMISDrive.this.initCMISItem(destFolderNode, (CmisObject)folder);
            return id;
        }

        public void removeFile(String id) throws CloudDriveException, RepositoryException {
            this.api.deleteDocument(id);
        }

        public void removeFolder(String id) throws CloudDriveException, RepositoryException {
            this.api.deleteFolder(id);
        }

        public boolean trashFile(String id) throws CloudDriveException, RepositoryException {
            throw new CMISException("Trash not supported");
        }

        public boolean trashFolder(String id) throws CloudDriveException, RepositoryException {
            throw new CMISException("Trash not supported");
        }

        public boolean untrashFile(Node fileNode) throws CloudDriveException, RepositoryException {
            throw new CMISException("Trash not supported");
        }

        public boolean untrashFolder(Node folderNode) throws CloudDriveException, RepositoryException {
            throw new CMISException("Trash not supported");
        }

        public boolean isTrashSupported() {
            return false;
        }

        private JCRLocalCloudFile restore(CmisObject obj, Node parent) throws NotFoundException, CloudDriveException, RepositoryException {
            JCRLocalCloudFile localItem = JCRLocalCMISDrive.this.updateItem(this.api, obj, parent, null);
            if (localItem.getNode().isNew() && localItem.isFolder()) {
                CMISAPI.ChildrenIterator childs = this.api.getFolderItems(localItem.getId());
                Node localNode = localItem.getNode();
                while (childs.hasNext()) {
                    this.restore((CmisObject)childs.next(), localNode);
                }
            }
            return localItem;
        }

        public JCRLocalCloudFile restore(String id, String path) throws NotFoundException, CloudDriveException, RepositoryException {
            JCRLocalCloudFile result = null;
            CmisObject remote = this.api.getObject(id);
            ArrayList<Folder> remoteParents = new ArrayList<Folder>(this.api.getParents(remote));
            NodeIterator niter = JCRLocalCMISDrive.this.findNodes(Arrays.asList(id));
            while (niter.hasNext()) {
                Node localFile = niter.nextNode();
                Node localParent = localFile.getParent();
                String parentId = JCRLocalCMISDrive.this.fileAPI.getId(localParent);
                JCRLocalCloudFile restored = null;
                Iterator rpiter = remoteParents.iterator();
                while (rpiter.hasNext()) {
                    Folder remoteParent = (Folder)rpiter.next();
                    String rpid = remoteParent.getId();
                    if (!parentId.equals(rpid)) continue;
                    restored = this.restore(remote, localParent);
                    rpiter.remove();
                    if (!path.equals(localFile.getPath())) continue;
                    result = restored;
                }
                if (restored != null || JCRLocalCMISDrive.this.fileAPI.isIgnored(localFile)) continue;
                try {
                    localFile.remove();
                }
                catch (PathNotFoundException e) {}
            }
            for (Folder remoteParent : remoteParents) {
                String rpid = remoteParent.getId();
                NodeIterator niter2 = JCRLocalCMISDrive.this.findNodes(Arrays.asList(rpid));
                while (niter2.hasNext()) {
                    Node localParent = niter2.nextNode();
                    JCRLocalCloudFile restored = this.restore(remote, localParent);
                    if (result != null) continue;
                    result = restored;
                }
            }
            return result;
        }
    }

    protected static interface LocalFile {
        public String findRemoteParent(String var1, Set<String> var2) throws CMISException;
    }

    protected class Sync
    extends JCRLocalCloudDrive.SyncCommand {
        protected final CMISAPI api;
        protected CMISException preSyncError;

        protected Sync() {
            super((JCRLocalCloudDrive)JCRLocalCMISDrive.this);
            this.preSyncError = null;
            this.api = JCRLocalCMISDrive.this.getUser().api();
        }

        protected void preSyncFiles() throws CloudDriveException, RepositoryException, InterruptedException {
            try {
                super.preSyncFiles();
            }
            catch (CMISException e) {
                this.preSyncError = e;
                JCRLocalCMISDrive.this.rollback(this.rootNode);
                LOG.warn((Object)("Synchronization error: failed to apply local changes to CMIS repository. Full sync will be initiated for " + JCRLocalCMISDrive.this.title()), (Throwable)((Object)e));
            }
        }

        protected void syncFiles() throws CloudDriveException, RepositoryException, InterruptedException {
            long changeId;
            CMISAPI.ChangeToken lastChangeToken;
            CMISAPI.ChangeToken changeToken;
            block8: {
                RepositoryInfo repoInfo = this.api.getRepositoryInfo();
                changeToken = this.api.readToken(repoInfo.getLatestChangeLogToken());
                CMISAPI.ChangeToken localChangeToken = this.api.readToken(JCRLocalCMISDrive.this.getChangeToken(this.rootNode));
                lastChangeToken = this.api.emptyToken();
                changeId = System.currentTimeMillis();
                if (!changeToken.isEmpty() && this.preSyncError == null) {
                    if (!changeToken.equals(localChangeToken)) {
                        try {
                            if (CapabilityChanges.NONE != repoInfo.getCapabilities().getChangesCapability()) {
                                lastChangeToken = new ChangesAlgorithm().syncFiles(localChangeToken);
                                break block8;
                            }
                            LOG.info((Object)("CMIS Change Log capability not supported by repository " + repoInfo.getName() + " (" + repoInfo.getVendorName() + " " + repoInfo.getProductName() + " " + repoInfo.getProductVersion() + "). Full synchronization will be used instead of the more efficient based on Change Log. " + "Check if it is possible to enable Change Log for your repository."));
                        }
                        catch (CMISException e) {
                            LOG.warn((Object)("Synchronization error: failed to read CMIS Change Log. Full sync will be initiated for " + JCRLocalCMISDrive.this.title()), (Throwable)((Object)e));
                            JCRLocalCMISDrive.this.rollback(this.rootNode);
                        }
                    } else {
                        return;
                    }
                }
            }
            if (!lastChangeToken.isEmpty() && this.preSyncError == null) {
                changeToken = lastChangeToken;
            } else {
                LOG.info((Object)("Full synchronization initiated instead of the more efficient based on CMIS Change Log: " + JCRLocalCMISDrive.this.title()));
                new TraversingAlgorithm().syncFiles();
                JCRLocalCMISDrive.this.rollbackAllChanges();
            }
            JCRLocalCMISDrive.this.setChangeToken(this.rootNode, changeToken.getString());
            JCRLocalCMISDrive.this.setChangeId(changeId);
        }

        protected class TraversingAlgorithm {
            protected final Map<String, List<Node>> allLocal = new HashMap<String, List<Node>>();
            protected final Queue<CMISItem> allItems = new ConcurrentLinkedQueue<CMISItem>();
            protected final Queue<Future<Folder>> readers = new ConcurrentLinkedQueue<Future<Folder>>();

            protected TraversingAlgorithm() {
            }

            protected Future<Folder> readItems(String folderId) throws RepositoryException, CloudDriveException {
                Future reader = JCRLocalCMISDrive.this.workerExecutor.submit((Callable)new FolderReader(folderId));
                this.readers.add(reader);
                return reader;
            }

            protected void syncFiles() throws RepositoryException, CloudDriveException, InterruptedException {
                Sync.this.readLocalNodes();
                for (Map.Entry ne : Sync.this.nodes.entrySet()) {
                    this.allLocal.put((String)ne.getKey(), new ArrayList((Collection)ne.getValue()));
                }
                Folder root = this.syncChilds(Sync.this.api.getRootFolder().getId());
                Sync.this.nodes.remove(root.getId());
                boolean notInterrupted = true;
                Iterator niter = Sync.this.nodes.values().iterator();
                while (niter.hasNext() && (notInterrupted = !Thread.currentThread().isInterrupted())) {
                    List nls = (List)niter.next();
                    block2: for (Node n : nls) {
                        String npath = n.getPath();
                        for (String rpath : Sync.this.removed) {
                            if (!npath.startsWith(rpath)) continue;
                            continue block2;
                        }
                        Sync.this.removed.add(npath);
                        n.remove();
                    }
                }
                if (notInterrupted) {
                    JCRLocalCMISDrive.this.initCMISItem(Sync.this.rootNode, (CmisObject)root);
                    JCRLocalCMISDrive.this.rollbackAllChanges();
                }
                this.allLocal.clear();
                this.allItems.clear();
                this.readers.clear();
            }

            protected boolean isReadDone() {
                Iterator riter = this.readers.iterator();
                while (riter.hasNext()) {
                    Future r = (Future)riter.next();
                    if (r.isDone()) {
                        riter.remove();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            protected Folder syncChilds(String folderId) throws RepositoryException, CloudDriveException, InterruptedException {
                CMISItem item;
                Future<Folder> reader = this.readItems(folderId);
                while (!((item = this.allItems.poll()) == null && this.isReadDone() || Thread.currentThread().isInterrupted())) {
                    if (item != null) {
                        CmisObject obj = item.object;
                        List<Node> parentList = this.allLocal.get(item.parentId);
                        if (parentList != null) {
                            for (Node parent : parentList) {
                                JCRLocalCloudFile localItem = JCRLocalCMISDrive.this.updateItem(Sync.this.api, obj, parent, null);
                                if (localItem.isChanged()) {
                                    Sync.this.changed.add(localItem);
                                    List<Node> itemList = this.allLocal.get(localItem.getId());
                                    if (itemList == null) {
                                        itemList = new ArrayList<Node>();
                                        this.allLocal.put(localItem.getId(), itemList);
                                    }
                                    itemList.add(localItem.getNode());
                                }
                                String fileId = obj.getId();
                                List existing = (List)Sync.this.nodes.get(fileId);
                                if (existing == null) continue;
                                String path = localItem.getPath();
                                Iterator eiter = existing.iterator();
                                while (eiter.hasNext()) {
                                    Node enode = (Node)eiter.next();
                                    if (!enode.getPath().startsWith(path)) continue;
                                    eiter.remove();
                                }
                                if (existing.size() != 0) continue;
                                Sync.this.nodes.remove(fileId);
                            }
                            continue;
                        }
                        if (item.isPostponed()) {
                            throw new CloudDriveException("Inconsistency error: parent cannot be found for remote file " + obj.getName());
                        }
                        this.allItems.add(item);
                        item.postpone();
                        continue;
                    }
                    Thread.yield();
                    Thread.sleep(50L);
                }
                try {
                    return reader.get();
                }
                catch (ExecutionException e) {
                    LOG.error((Object)("Sync worker error: " + e.getMessage()));
                    Throwable c = e.getCause();
                    if (c != null) {
                        if (c instanceof CloudDriveException) {
                            throw (CloudDriveException)c;
                        }
                        if (c instanceof RepositoryException) {
                            throw (RepositoryException)c;
                        }
                        if (c instanceof RuntimeException) {
                            throw (RuntimeException)c;
                        }
                        if (c instanceof Error) {
                            throw (Error)c;
                        }
                        throw new CMISException("Error in sync worker thread", c);
                    }
                    throw new CMISException("Execution error in sync worker thread", e);
                }
            }

            protected class FolderReader
            implements Callable<Folder> {
                protected final String folderId;

                protected FolderReader(String folderId) {
                    this.folderId = folderId;
                }

                @Override
                public Folder call() throws Exception {
                    CMISAPI.ChildrenIterator items = Sync.this.api.getFolderItems(this.folderId);
                    Sync.this.iterators.add(items);
                    while (items.hasNext() && !Thread.currentThread().isInterrupted()) {
                        CmisObject obj = (CmisObject)items.next();
                        if (Sync.this.api.isRelationship(obj)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)("Skipped relationship object: " + obj.getId() + " " + obj.getName()));
                            continue;
                        }
                        TraversingAlgorithm.this.allItems.add(new CMISItem(obj, this.folderId));
                        if (!Sync.this.api.isFolder(obj)) continue;
                        TraversingAlgorithm.this.readItems(obj.getId());
                    }
                    return items.parent;
                }
            }

            protected class CMISItem {
                protected final CmisObject object;
                protected final String parentId;
                private boolean postponed;

                protected CMISItem(CmisObject object, String parentId) {
                    this.object = object;
                    this.parentId = parentId;
                }

                void postpone() {
                    this.postponed = true;
                }

                boolean isPostponed() {
                    return this.postponed;
                }
            }
        }

        protected class ChangesAlgorithm {
            protected CMISAPI.ChangesIterator changes;
            protected final Set<Node> synced = new HashSet<Node>();

            protected ChangesAlgorithm() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected CMISAPI.ChangeToken syncFiles(CMISAPI.ChangeToken fromChangeToken) throws CloudDriveException, RepositoryException {
                this.changes = Sync.this.api.getChanges(fromChangeToken);
                Sync.this.iterators.add(this.changes);
                if (!this.changes.hasNext()) {
                    return Sync.this.api.emptyToken();
                }
                Sync.this.readLocalNodes();
                CmisObject previousItem = null;
                ChangeEvent previousEvent = null;
                LinkedHashSet<String> previousParentIds = null;
                while (this.changes.hasNext() && !Thread.currentThread().isInterrupted()) {
                    CmisObject item = null;
                    LinkedHashSet<String> parentIds = new LinkedHashSet<String>();
                    ChangeEvent change = this.changes.next();
                    ChangeType changeType = change.getChangeType();
                    String id = change.getObjectId();
                    if (Sync.this.api.isSyncableChange(change)) {
                        block23: {
                            if (!ChangeType.DELETED.equals((Object)changeType)) {
                                try {
                                    item = Sync.this.api.getObject(change.getObjectId());
                                }
                                catch (NotFoundException e) {
                                    if (!LOG.isDebugEnabled()) break block23;
                                    LOG.debug((Object)("File " + changeType.value() + " " + id + " not found remotely - apply DELETED logic."));
                                }
                            }
                        }
                        if (item == null) {
                            if (JCRLocalCMISDrive.this.hasRemoved(id)) {
                                JCRLocalCMISDrive.this.cleanRemoved(id);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> Returned file removal " + id));
                                }
                            } else if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(">> File removal " + id));
                            }
                            this.deleteFile(id, new HashSet<String>());
                        } else {
                            boolean isFolder;
                            String name;
                            block24: {
                                name = item.getName();
                                isFolder = Sync.this.api.isFolder(item);
                                if (isFolder) {
                                    Folder p = ((Folder)item).getFolderParent();
                                    if (p != null) {
                                        parentIds.add(p.getId());
                                        break block24;
                                    } else {
                                        if (!LOG.isDebugEnabled()) continue;
                                        LOG.debug((Object)("Found change of folder without parent. Skipping it: " + id + " " + name));
                                        continue;
                                    }
                                }
                                if (Sync.this.api.isRelationship(item)) {
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug((Object)("Found change of relationship. Skipping it: " + id + " " + name));
                                    continue;
                                }
                                List ps = ((FileableCmisObject)item).getParents(Sync.this.api.folderContext);
                                if (ps.size() == 0) {
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug((Object)("Found change of fileable item without parent. Skipping it: " + id + " " + name));
                                    continue;
                                }
                                for (Folder p : ps) {
                                    parentIds.add(p.getId());
                                }
                            }
                            if (JCRLocalCMISDrive.this.hasUpdated(id)) {
                                JCRLocalCMISDrive.this.cleanUpdated(id);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> Returned file update " + id + " " + name));
                                }
                            } else {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> File update " + id + " " + name));
                                }
                                if (previousItem != null && name.equals(previousItem.getName()) && previousEvent != null && ChangeType.CREATED.equals((Object)previousEvent.getChangeType()) && previousParentIds != null && parentIds.containsAll(previousParentIds)) {
                                    previousItem = null;
                                    previousEvent = null;
                                    previousParentIds = null;
                                    continue;
                                }
                                this.updateFile(item, parentIds, isFolder);
                            }
                        }
                    }
                    previousItem = item;
                    previousEvent = change;
                    previousParentIds = parentIds;
                }
                return this.changes.getLastChangeToken();
            }

            protected void deleteFile(String fileId, Set<String> parentIds) throws RepositoryException {
                List existing = (List)Sync.this.nodes.get(fileId);
                if (existing != null) {
                    Iterator enliter = existing.iterator();
                    while (enliter.hasNext()) {
                        Node en = (Node)enliter.next();
                        String enpath = en.getPath();
                        Node ep = en.getParent();
                        if (JCRLocalCMISDrive.this.fileAPI.isFolder(ep) || JCRLocalCMISDrive.this.fileAPI.isDrive(ep)) {
                            String parentId = JCRLocalCMISDrive.this.fileAPI.getId(ep);
                            if (parentIds.contains(parentId)) continue;
                            Iterator ecnliter = Sync.this.nodes.values().iterator();
                            while (ecnliter.hasNext()) {
                                List ecnl = (List)ecnliter.next();
                                if (ecnl == existing) continue;
                                Iterator ecniter = ecnl.iterator();
                                while (ecniter.hasNext()) {
                                    Node ecn = (Node)ecniter.next();
                                    if (!ecn.getPath().startsWith(enpath)) continue;
                                    ecniter.remove();
                                }
                                if (ecnl.size() != 0) continue;
                                ecnliter.remove();
                            }
                            Sync.this.removed.add(enpath);
                            en.remove();
                            enliter.remove();
                            continue;
                        }
                        LOG.warn((Object)("Skipped node with not cloud folder/drive parent: " + enpath));
                    }
                    if (existing.size() == 0) {
                        existing.remove(fileId);
                    }
                }
            }

            protected void updateFile(CmisObject item, Set<String> parentIds, boolean isFolder) throws CloudDriveException, RepositoryException {
                String id = item.getId();
                String name = item.getName();
                ArrayList<Node> existing = (ArrayList<Node>)Sync.this.nodes.get(id);
                for (String pid : parentIds) {
                    List fileParents = (List)Sync.this.nodes.get(pid);
                    if (fileParents == null) {
                        throw new CMISException("Inconsistent changes: cannot find parent Node for " + id + " '" + name + "'");
                    }
                    for (Node fp : fileParents) {
                        JCRLocalCloudFile localFile;
                        Node localNode = null;
                        Node localNodeCopy = null;
                        if (existing == null) {
                            existing = new ArrayList<Node>();
                            Sync.this.nodes.put(id, existing);
                        } else {
                            Iterator i$ = existing.iterator();
                            while (i$.hasNext()) {
                                Node n;
                                localNodeCopy = n = (Node)i$.next();
                                if (!n.getParent().isSame((Item)fp)) continue;
                                localNode = n;
                                break;
                            }
                        }
                        if (localNode == null) {
                            if (isFolder && localNodeCopy != null) {
                                localNode = JCRLocalCMISDrive.this.copyNode(localNodeCopy, fp);
                            }
                            if ((localFile = JCRLocalCMISDrive.this.updateItem(Sync.this.api, item, fp, localNode)).isChanged()) {
                                Sync.this.changed.add(localFile);
                            }
                            localNode = localFile.getNode();
                            existing.add(localNode);
                        } else if (!JCRLocalCMISDrive.this.fileAPI.getTitle(localNode).equals(name)) {
                            localFile = JCRLocalCMISDrive.this.updateItem(Sync.this.api, item, fp, JCRLocalCMISDrive.this.moveFile(id, name, localNode, fp));
                            if (localFile.isChanged()) {
                                Sync.this.changed.add(localFile);
                            }
                            localNode = localFile.getNode();
                        }
                        this.synced.add(localNode);
                    }
                }
                if (existing != null) {
                    Iterator niter = existing.iterator();
                    while (niter.hasNext()) {
                        Node n = (Node)niter.next();
                        if (this.synced.contains(n)) continue;
                        Sync.this.removed.add(n.getPath());
                        niter.remove();
                        n.remove();
                    }
                }
            }
        }
    }

    protected class Connect
    extends JCRLocalCloudDrive.ConnectCommand {
        protected final CMISAPI api;

        protected Connect() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalCMISDrive.this);
            this.api = JCRLocalCMISDrive.this.getUser().api();
        }

        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            CMISAPI.ChangeToken changeToken = this.api.readToken(this.api.getRepositoryInfo().getLatestChangeLogToken());
            long changeId = System.currentTimeMillis();
            Folder root = this.api.getRootFolder();
            this.rootNode.setProperty("ecd:id", root.getId());
            this.rootNode.setProperty("ecd:url", this.api.getLink(root));
            this.fetchChilds(root.getId(), this.rootNode);
            if (!Thread.currentThread().isInterrupted()) {
                JCRLocalCMISDrive.this.initCMISItem(this.rootNode, (CmisObject)root);
                JCRLocalCMISDrive.this.setChangeToken(this.rootNode, changeToken.getString());
                JCRLocalCMISDrive.this.setChangeId(changeId);
            }
        }

        protected Folder fetchChilds(String fileId, Node parent) throws CloudDriveException, RepositoryException {
            CMISAPI.ChildrenIterator items = this.api.getFolderItems(fileId);
            this.iterators.add(items);
            while (items.hasNext() && !Thread.currentThread().isInterrupted()) {
                CmisObject item = (CmisObject)items.next();
                if (this.api.isRelationship(item)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Skipped relationship object: " + item.getId() + " " + item.getName()));
                    continue;
                }
                JCRLocalCloudFile localItem = JCRLocalCMISDrive.this.updateItem(this.api, item, parent, null);
                if (localItem.isChanged()) {
                    this.changed.add(localItem);
                    if (!localItem.isFolder()) continue;
                    this.fetchChilds(localItem.getId(), localItem.getNode());
                    continue;
                }
                throw new CMISException("Fetched item was not added to local drive storage");
            }
            return items.parent;
        }
    }
}

