/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxFile;
import com.box.boxjavalibv2.dao.BoxFolder;
import com.box.boxjavalibv2.dao.BoxItem;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.box.boxjavalibv2.requests.DeleteTrashItemRequest;
import com.box.boxjavalibv2.requests.GetFolderTrashItemsRequest;
import com.box.boxjavalibv2.requests.GetTrashItemRequest;
import com.box.boxjavalibv2.requests.RestoreTrashItemRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxItemRestoreRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxPagingRequestObject;
import com.box.boxjavalibv2.resourcemanagers.AbstractBoxResourceManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxTrashManager;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.authorization.IBoxRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;

public class BoxTrashManagerImpl
extends AbstractBoxResourceManager
implements IBoxTrashManager {
    public BoxTrashManagerImpl(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    public void deleteTrashFile(String id, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        this.deleteTrashItem(id, BoxResourceType.FILE, requestObject);
    }

    public BoxFile restoreTrashFile(String id, BoxItemRestoreRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        return (BoxFile)this.restoreTrashItem(id, BoxResourceType.FILE, requestObject);
    }

    public BoxFile getTrashFile(String fileId, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        return (BoxFile)this.getTrashItem(fileId, BoxResourceType.FILE, requestObject);
    }

    public BoxFolder getTrashFolder(String folderId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFolder)this.getTrashItem(folderId, BoxResourceType.FOLDER, requestObject);
    }

    public BoxCollection getTrashItems(BoxPagingRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetFolderTrashItemsRequest request = new GetFolderTrashItemsRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.ITEMS, this.getJSONParser());
    }

    public void deleteTrashFolder(String id, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        this.deleteTrashItem(id, BoxResourceType.FOLDER, requestObject);
    }

    public BoxFolder restoreTrashFolder(String id, BoxItemRestoreRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        return (BoxFolder)this.restoreTrashItem(id, BoxResourceType.FOLDER, requestObject);
    }

    private BoxItem getTrashItem(String itemId, BoxResourceType type, BoxDefaultRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        GetTrashItemRequest request = new GetTrashItemRequest(this.getConfig(), this.getJSONParser(), itemId, type, requestObject);
        Object result = this.getResponseAndParse(request, type, this.getJSONParser());
        return (BoxItem)this.tryCastBoxItem(type, result);
    }

    private void deleteTrashItem(String id, BoxResourceType type, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        DeleteTrashItemRequest request = new DeleteTrashItemRequest(this.getConfig(), this.getJSONParser(), id, type, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    private BoxItem restoreTrashItem(String id, BoxResourceType type, BoxItemRestoreRequestObject requestObject) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        RestoreTrashItemRequest request = new RestoreTrashItemRequest(this.getConfig(), this.getJSONParser(), id, type, requestObject);
        return (BoxItem)this.getResponseAndParseAndTryCast(request, type, this.getJSONParser());
    }
}

