/*
 * Decompiled with CFR 0.152.
 */
package com.box.restclientv2.requestsbase;

import com.box.boxjavalibv2.exceptions.BoxJSONException;
import com.box.boxjavalibv2.filetransfer.IFileTransferListener;
import com.box.boxjavalibv2.httpentities.MultipartEntityWithProgressListener;
import com.box.boxjavalibv2.jsonentities.IBoxJSONStringEntity;
import com.box.boxjavalibv2.jsonentities.MapJSONStringEntity;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.utils.ISO8601DateParser;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;

public class BoxFileUploadRequestObject
extends BoxDefaultRequestObject {
    private static final String METADATA = "metadata";
    private MultipartEntityWithProgressListener entity = null;
    private static final String KEY_PARENT = "parent";
    private static final String KEY_NAME = "name";
    private static final String KEY_FILE_NAME = "filename";
    private static final String KEY_CONTENT_CREATED_AT = "content_created_at";
    private static final String KEY_CONTENT_MODIFIED_AT = "content_modified_at";

    private BoxFileUploadRequestObject() {
    }

    public static BoxFileUploadRequestObject uploadFileRequestObject(String parentId, String fileName, File file) throws BoxRestException, BoxJSONException {
        try {
            BoxFileUploadRequestObject requestObject = new BoxFileUploadRequestObject();
            return requestObject.setMultipartMIME(BoxFileUploadRequestObject.getNewFileMultipartEntity(parentId, fileName, file));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public static BoxFileUploadRequestObject uploadFileRequestObject(String parentId, String fileName, InputStream inputStream) throws BoxRestException, BoxJSONException {
        try {
            return new BoxFileUploadRequestObject().setMultipartMIME(BoxFileUploadRequestObject.getNewFileMultipartEntity(parentId, inputStream, fileName));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public static BoxFileUploadRequestObject uploadNewVersionRequestObject(String name, File file) throws BoxRestException {
        try {
            return new BoxFileUploadRequestObject().setMultipartMIME(BoxFileUploadRequestObject.getNewVersionMultipartEntity(name, file));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public static BoxFileUploadRequestObject uploadNewVersionRequestObject(String name, InputStream inputStream) throws BoxRestException {
        try {
            return new BoxFileUploadRequestObject().setMultipartMIME(BoxFileUploadRequestObject.getNewVersionMultipartEntity(name, inputStream));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public BoxFileUploadRequestObject setMultipartMIME(MultipartEntityWithProgressListener mime) throws BoxRestException {
        this.entity = mime;
        return this;
    }

    public BoxFileUploadRequestObject setListener(IFileTransferListener listener) {
        this.entity.setListener(listener);
        return this;
    }

    public BoxFileUploadRequestObject setContentMD5(String sha1) {
        this.getRequestExtras().addHeader("Content-MD5", sha1);
        return this;
    }

    public BoxFileUploadRequestObject setLocalFileCreatedAt(Date createdAt) throws UnsupportedEncodingException {
        this.entity.addContentBodyPart(KEY_CONTENT_CREATED_AT, (ContentBody)new StringBody(ISO8601DateParser.toString(createdAt)));
        return this;
    }

    public BoxFileUploadRequestObject setLocalFileLastModifiedAt(Date modifiedAt) throws UnsupportedEncodingException {
        this.entity.addContentBodyPart(KEY_CONTENT_MODIFIED_AT, (ContentBody)new StringBody(ISO8601DateParser.toString(modifiedAt)));
        return this;
    }

    public HttpEntity getEntity(IBoxJSONParser parser) throws UnsupportedEncodingException, BoxJSONException {
        this.entity.prepareParts(parser);
        return this.entity;
    }

    private static MultipartEntityWithProgressListener getNewFileMultipartEntity(String parentId, InputStream inputStream, String fileName) throws BoxRestException, UnsupportedEncodingException, BoxJSONException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addContentBodyPart("folder_id", (ContentBody)new StringBody(parentId));
        me.addBoxJSONStringEntityPart(METADATA, BoxFileUploadRequestObject.getMetadataBody(parentId, fileName));
        me.addContentBodyPart(fileName, (ContentBody)new InputStreamBody(inputStream, KEY_FILE_NAME));
        return me;
    }

    private static MultipartEntityWithProgressListener getNewFileMultipartEntity(String parentId, String name, File file) throws BoxRestException, UnsupportedEncodingException, BoxJSONException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addContentBodyPart("folder_id", (ContentBody)new StringBody(parentId));
        me.addContentBodyPart(KEY_FILE_NAME, (ContentBody)new FileBody(file, KEY_FILE_NAME, "*/*", "UTF-8"));
        me.addBoxJSONStringEntityPart(METADATA, BoxFileUploadRequestObject.getMetadataBody(parentId, name));
        if (me.getContentBodyPart(KEY_CONTENT_MODIFIED_AT) == null) {
            String date = ISO8601DateParser.toString(new Date(file.lastModified()));
            me.addContentBodyPart(KEY_CONTENT_MODIFIED_AT, (ContentBody)new StringBody(date));
        }
        return me;
    }

    private static IBoxJSONStringEntity getMetadataBody(String parentId, String name) throws UnsupportedEncodingException, BoxRestException, BoxJSONException {
        MapJSONStringEntity parentEntity = new MapJSONStringEntity();
        parentEntity.put("id", parentId);
        MapJSONStringEntity entity = new MapJSONStringEntity();
        entity.put(KEY_PARENT, parentEntity);
        entity.put(KEY_NAME, name);
        return entity;
    }

    private static MultipartEntityWithProgressListener getNewVersionMultipartEntity(String name, File file) throws UnsupportedEncodingException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addContentBodyPart(name, (ContentBody)new FileBody(file, name, "*/*", "UTF-8"));
        if (me.getContentBodyPart(KEY_CONTENT_MODIFIED_AT) == null) {
            me.addContentBodyPart(KEY_CONTENT_MODIFIED_AT, (ContentBody)new StringBody(ISO8601DateParser.toString(new Date(file.lastModified()))));
        }
        return me;
    }

    private static MultipartEntityWithProgressListener getNewVersionMultipartEntity(String name, InputStream inputStream) throws UnsupportedEncodingException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addContentBodyPart(name, (ContentBody)new InputStreamBody(inputStream, name));
        return me;
    }
}

