/*
 * Decompiled with CFR 0.152.
 */
package com.box.restclientv2.responses;

import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.responseparsers.IBoxResponseParser;
import com.box.restclientv2.responses.IBoxResponse;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class DefaultBoxResponse
implements IBoxResponse {
    private int expectedResponseCode;
    private final HttpResponse httpResponse;

    public DefaultBoxResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public int getResponseStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public Object parseResponse(IBoxResponseParser responseParser, IBoxResponseParser errorParser) throws BoxRestException {
        int statusCode = this.getHttpResponse().getStatusLine().getStatusCode();
        if (statusCode != this.getExpectedResponseCode()) {
            return errorParser.parse(this);
        }
        return responseParser.parse(this);
    }

    public void setExpectedResponseCode(int code) {
        this.expectedResponseCode = code;
    }

    public int getExpectedResponseCode() {
        return this.expectedResponseCode;
    }

    public double getContentLength() {
        Header header = this.getHttpResponse().getFirstHeader("Content-Length");
        if (header != null) {
            try {
                return Double.parseDouble(header.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }
}

