/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.chain.Context;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.NotConnectedException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.jcr.AbstractJCRAction;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CloudFileAction
extends AbstractJCRAction {
    private static Log LOG = ExoLogger.getLogger(CloudFileAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(Context context) throws Exception {
        Item item = (Item)context.get((Object)InvocationContext.CURRENT_ITEM);
        if (!item.getName().equals("jcr:data")) return false;
        try {
            Node fileNode = item.isNode() ? (Node)item : item.getParent();
            CloudDriveService drives = this.drives(context);
            CloudDrive localDrive = drives.findDrive(fileNode);
            if (!this.accept(localDrive)) return false;
            this.start(localDrive);
            try {
                localDrive.synchronize();
                boolean bl = true;
                return bl;
            }
            catch (SyncNotSupportedException e) {
                LOG.error((Object)("Node cannot be stored in Cloud Drive. Action Node was: " + fileNode.getPath()), (Throwable)e);
                return false;
            }
            catch (NotConnectedException e) {
                LOG.error((Object)("Drive not connected. Action Node was: " + fileNode.getPath()), (Throwable)e);
                return false;
            }
            finally {
                this.done();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Action item isn't property of ecd:cloudFile or invalid JCR session. Item: " + item), (Throwable)e);
        }
        return false;
    }
}

