/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.dao.BoxItem;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.box.boxjavalibv2.requests.CopyItemRequest;
import com.box.boxjavalibv2.requests.CreateSharedLinkRequest;
import com.box.boxjavalibv2.requests.GetItemRequest;
import com.box.boxjavalibv2.requests.UpdateItemInfoRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxItemCopyRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxItemRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxSharedLinkRequestObject;
import com.box.boxjavalibv2.resourcemanagers.AbstractBoxResourceManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxItemsManager;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.authorization.IBoxRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import java.io.UnsupportedEncodingException;

public class BoxItemsManagerImpl
extends AbstractBoxResourceManager
implements IBoxItemsManager {
    public BoxItemsManagerImpl(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    public BoxItem getItem(String id, BoxDefaultRequestObject requestObject, BoxResourceType type) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetItemRequest request = new GetItemRequest(this.getConfig(), this.getJSONParser(), id, type, requestObject);
        Object result = this.getResponseAndParse(request, type, this.getJSONParser());
        return (BoxItem)this.tryCastBoxItem(type, result);
    }

    public BoxItem copyItem(String id, BoxItemCopyRequestObject requestObject, BoxResourceType type) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        CopyItemRequest request = new CopyItemRequest(this.getConfig(), this.getJSONParser(), id, requestObject, type);
        return (BoxItem)this.getResponseAndParseAndTryCast(request, type, this.getJSONParser());
    }

    public BoxItem updateItemInfo(String id, BoxItemRequestObject requestObject, BoxResourceType type) throws UnsupportedEncodingException, BoxRestException, BoxServerException, AuthFatalFailureException {
        UpdateItemInfoRequest request = new UpdateItemInfoRequest(this.getConfig(), this.getJSONParser(), id, requestObject, type);
        return (BoxItem)this.getResponseAndParseAndTryCast(request, type, this.getJSONParser());
    }

    public BoxItem createSharedLink(String id, BoxSharedLinkRequestObject requestObject, BoxResourceType type) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        CreateSharedLinkRequest request = new CreateSharedLinkRequest(this.getConfig(), this.getJSONParser(), id, requestObject, type);
        return (BoxItem)this.getResponseAndParseAndTryCast(request, type, this.getJSONParser());
    }
}

