/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;

public class Metadata {
    private final JsonObject values;
    private JsonArray operations;

    public Metadata() {
        this.values = new JsonObject();
    }

    Metadata(JsonObject values) {
        this.values = values;
    }

    public Metadata(Metadata other) {
        this.values = new JsonObject(other.values);
    }

    public String getID() {
        return this.get("/$id");
    }

    public String getTypeName() {
        return this.get("/$type");
    }

    public String getParentID() {
        return this.get("/$parent");
    }

    public Metadata add(String path, String value) {
        this.values.add(this.pathToProperty(path), value);
        this.addOp("add", path, value);
        return this;
    }

    public Metadata replace(String path, String value) {
        this.values.set(this.pathToProperty(path), value);
        this.addOp("replace", path, value);
        return this;
    }

    public Metadata remove(String path) {
        this.values.remove(this.pathToProperty(path));
        this.addOp("remove", path, null);
        return this;
    }

    public Metadata test(String path, String value) {
        this.addOp("test", path, value);
        return this;
    }

    public String get(String path) {
        JsonValue value = this.values.get(this.pathToProperty(path));
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public String getPatch() {
        if (this.operations == null) {
            return "[]";
        }
        return this.operations.toString();
    }

    public String toString() {
        return this.values.toString();
    }

    private String pathToProperty(String path) {
        if (path == null || !path.startsWith("/")) {
            throw new IllegalArgumentException("Path must be prefixed with a \"/\".");
        }
        return path.substring(1);
    }

    private void addOp(String op, String path, String value) {
        if (this.operations == null) {
            this.operations = new JsonArray();
        }
        this.operations.add((JsonValue)new JsonObject().add("op", op).add("path", path).add("value", value));
    }
}

