/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.action;

import java.security.AccessControlException;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.ecms.CloudDriveContext;
import org.exoplatform.clouddrive.ecms.action.CloudFileActionService;
import org.exoplatform.clouddrive.ecms.action.UIPermissionInfo;
import org.exoplatform.ecm.permission.info.UIPermissionInputSet;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.info.UIPermissionForm;
import org.exoplatform.ecm.webui.core.UIPermissionFormBase;
import org.exoplatform.ecm.webui.core.UIPermissionManagerBase;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/core/UIPermissionForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIPermissionFormBase.ResetActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIPermissionForm.CloseActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIPermissionFormBase.SelectUserActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIPermissionFormBase.SelectMemberActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIPermissionFormBase.AddAnyActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIPermissionInputSet.OnChangeActionListener.class})})
public class UIPermissionForm
extends org.exoplatform.ecm.webui.component.explorer.popup.info.UIPermissionForm {
    protected static final Log LOG = ExoLogger.getLogger(UIPermissionForm.class);
    protected final UIPermissionInputSet permissions;

    public UIPermissionForm() throws Exception {
        this.removeChildById("permission");
        this.permissions = new UIPermissionInputSet("permission", false);
        this.addChild((UIComponent)this.permissions);
    }

    protected void checkAll(boolean check) {
    }

    public void fillForm(String user, ExtendedNode node) throws Exception {
        this.refresh();
        this.permissions.getUIStringInput("userOrGroup").setValue((Object)user);
    }

    protected void lockForm(boolean isLock) {
        try {
            super.lockForm(isLock);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static class SaveActionListener
    extends UIPermissionForm.SaveActionListener {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(Event<org.exoplatform.ecm.webui.component.explorer.popup.info.UIPermissionForm> event) throws Exception {
            UIPermissionForm uiForm = (UIPermissionForm)((Object)event.getSource());
            WebuiRequestContext rcontext = event.getRequestContext();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            UIPermissionManagerBase uiParent = (UIPermissionManagerBase)uiForm.getParent();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            CloudDriveService cloudDrives = (CloudDriveService)uiForm.getApplicationComponent(CloudDriveService.class);
            Node currentNode = uiForm.getCurrentNode();
            CloudDrive localDrive = cloudDrives.findDrive(currentNode);
            if (localDrive == null) {
                LOG.warn((Object)("Cloud Drive cannot be found for " + currentNode.getPath()));
                return;
            }
            this.initContext(rcontext, currentNode);
            String userOrGroup = (String)((UIPermissionInputSet)uiForm.getChild(UIPermissionInputSet.class)).getUIStringInput("userOrGroup").getValue();
            if (Utils.isNameEmpty((String)userOrGroup)) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.userOrGroup-required", null, 1));
                return;
            }
            ExtendedNode node = (ExtendedNode)currentNode;
            if (!PermissionUtil.canChangePermission((Node)node)) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.not-change-permission", null, 1));
                return;
            }
            if (node.canAddMixin("exo:privilegeable")) {
                node.addMixin("exo:privilegeable");
            }
            try {
                String groupId;
                Group group;
                CloudFileActionService actions = (CloudFileActionService)uiForm.getApplicationComponent(CloudFileActionService.class);
                ManageDriveService documentDrives = (ManageDriveService)uiForm.getApplicationComponent(ManageDriveService.class);
                DriveData documentsDrive = null;
                OrganizationService org = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
                String[] groupIdentity = userOrGroup.split(":");
                if (groupIdentity.length == 2 && (group = org.getGroupHandler().findGroupById(groupIdentity[1])) != null && (documentsDrive = documentDrives.getDriveByName((groupId = group.getId()).replace('/', '.'))) != null) {
                    Node newLink;
                    Node docsDriveRoot;
                    if (actions.getCloudFileLinks((Node)node, groupId, true).getSize() == 0L) {
                        docsDriveRoot = (Node)node.getSession().getItem(documentsDrive.getHomePath());
                        if (!PermissionUtil.canAddNode((Node)docsDriveRoot)) {
                            Object newLink2 = null;
                            uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.not-change-permission", null, 1));
                            return;
                        }
                        actions.shareCloudFile((Node)node, localDrive, userOrGroup);
                        newLink = actions.linkFile((Node)node, docsDriveRoot, groupId);
                        actions.setAllPermissions(newLink, userOrGroup);
                    } else {
                        docsDriveRoot = null;
                        newLink = null;
                        actions.shareCloudFile((Node)node, localDrive, userOrGroup);
                    }
                    if (newLink != null) {
                        ApplicationMessage title = new ApplicationMessage("CloudFile.msg.LinkCreated", (Object[])new String[]{""});
                        SpaceService spaces = (SpaceService)WCMCoreUtils.getService(SpaceService.class);
                        Space space = spaces.getSpaceByGroupId(groupId);
                        ApplicationMessage text = space != null ? new ApplicationMessage("CloudFile.msg.FileLinksSharedInSpace", (Object[])new String[]{"", actions.documentName(docsDriveRoot), space.getDisplayName()}) : new ApplicationMessage("CloudFile.msg.FileLinksSharedInSpace", (Object[])new String[]{"", actions.documentName(docsDriveRoot), group.getGroupName()});
                        ResourceBundle res = rcontext.getApplicationResourceBundle();
                        title.setResourceBundle(res);
                        text.setResourceBundle(res);
                        CloudDriveContext.showInfo((RequestContext)rcontext, title.getMessage(), text.getMessage());
                    }
                }
                if (documentsDrive == null) {
                    User user = org.getUserHandler().findUserByName(userOrGroup);
                    if (user == null) {
                        uiApp.addMessage(new ApplicationMessage("CloudFile.msg.CannotFindUser", (Object[])new String[]{userOrGroup}, 1));
                        return;
                    }
                    Node link = actions.linkShareToUser((Node)node, localDrive, userOrGroup);
                    ApplicationMessage title = new ApplicationMessage("CloudFile.msg.LinkCreated", (Object[])new String[]{""});
                    ApplicationMessage text = new ApplicationMessage("CloudFile.msg.FileLinksSharedWithUser", (Object[])new String[]{"", actions.documentName(link.getParent()), user.getFirstName() + " " + user.getLastName()});
                    ResourceBundle res = rcontext.getApplicationResourceBundle();
                    title.setResourceBundle(res);
                    text.setResourceBundle(res);
                    CloudDriveContext.showInfo((RequestContext)rcontext, title.getMessage(), text.getMessage());
                }
            }
            catch (AccessDeniedException ade) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.not-change-permission", null, 1));
                return;
            }
            catch (AccessControlException accessControlException) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.not-change-permission", null, 1));
                return;
            }
            UIPermissionInfo permInfo = (UIPermissionInfo)uiParent.getChild(UIPermissionInfo.class);
            permInfo.updateGrid(((UIGrid)permInfo.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage());
            currentNode.getSession().save();
            uiForm.refresh();
            uiExplorer.setIsHidePopup(true);
        }

        protected void initContext(WebuiRequestContext context, Node currentNode) throws RepositoryException, CloudDriveException {
            String path = currentNode.getPath();
            String workspace = currentNode.getSession().getWorkspace().getName();
            CloudDriveContext.init((RequestContext)context, workspace, path);
        }
    }
}

