/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.gdrive;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.gdrive.GoogleDriveException;
import org.exoplatform.clouddrive.oauth2.UserToken;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.shaded.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import org.exoplatform.shaded.google.api.client.auth.oauth2.Credential;
import org.exoplatform.shaded.google.api.client.auth.oauth2.CredentialRefreshListener;
import org.exoplatform.shaded.google.api.client.auth.oauth2.StoredCredential;
import org.exoplatform.shaded.google.api.client.auth.oauth2.TokenErrorResponse;
import org.exoplatform.shaded.google.api.client.auth.oauth2.TokenResponse;
import org.exoplatform.shaded.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import org.exoplatform.shaded.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import org.exoplatform.shaded.google.api.client.googleapis.json.GoogleJsonError;
import org.exoplatform.shaded.google.api.client.googleapis.json.GoogleJsonResponseException;
import org.exoplatform.shaded.google.api.client.http.AbstractInputStreamContent;
import org.exoplatform.shaded.google.api.client.http.HttpRequest;
import org.exoplatform.shaded.google.api.client.http.HttpResponse;
import org.exoplatform.shaded.google.api.client.http.HttpResponseException;
import org.exoplatform.shaded.google.api.client.http.javanet.NetHttpTransport;
import org.exoplatform.shaded.google.api.client.json.GenericJson;
import org.exoplatform.shaded.google.api.client.json.jackson2.JacksonFactory;
import org.exoplatform.shaded.google.api.client.util.Data;
import org.exoplatform.shaded.google.api.client.util.Key;
import org.exoplatform.shaded.google.api.client.util.store.DataStore;
import org.exoplatform.shaded.google.api.client.util.store.DataStoreFactory;
import org.exoplatform.shaded.google.api.services.drive.Drive;
import org.exoplatform.shaded.google.api.services.drive.DriveRequest;
import org.exoplatform.shaded.google.api.services.drive.model.About;
import org.exoplatform.shaded.google.api.services.drive.model.Change;
import org.exoplatform.shaded.google.api.services.drive.model.ChangeList;
import org.exoplatform.shaded.google.api.services.drive.model.ChildList;
import org.exoplatform.shaded.google.api.services.drive.model.ChildReference;
import org.exoplatform.shaded.google.api.services.drive.model.File;
import org.exoplatform.shaded.google.api.services.oauth2.Oauth2;
import org.exoplatform.shaded.google.api.services.oauth2.model.Userinfoplus;

class GoogleDriveAPI
implements DataStoreFactory {
    public static final String APP_NAME = "eXo Cloud Drive";
    public static final String FOLDER_MIMETYPE = "application/vnd.google-apps.folder";
    public static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/drive", "https://www.googleapis.com/auth/drive.file", "https://www.googleapis.com/auth/drive.appdata", "https://www.googleapis.com/auth/drive.scripts", "https://www.googleapis.com/auth/drive.apps.readonly", "https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/userinfo.profile");
    public static final String SCOPES_STRING = GoogleDriveAPI.scopes();
    public static final String ACCESS_TYPE = "offline";
    public static final String APPOVAl_PROMT = "force";
    public static final String NO_STATE = "__no_state_set__";
    protected static final String USER_ID = "user_id";
    protected static final String USER_EMAIL_ADDRESS = "emailAddress";
    protected static final Long FILE_ID_EXPIRED = 86400000L;
    protected static final Long FILE_ERROR_WAIT = 2000L;
    protected static final Log LOG = ExoLogger.getLogger(GoogleDriveAPI.class);
    final Credential credential;
    final Drive drive;
    final AuthToken token;
    final Oauth2 oauth2;
    final Pattern tzPattern = Pattern.compile("([+-][0-2]\\d:[0-5]\\d|Z)$");
    final Lock generateIdsLock = new ReentrantLock();
    final AtomicReference<GeneratedIds> generatedIds = new AtomicReference<GeneratedIds>(new GeneratedIds());

    GoogleDriveAPI(String clientId, String clientSecret, String authCode, String redirectUri) throws GoogleDriveException, CloudDriveException {
        GoogleTokenResponse response;
        GoogleAuthorizationCodeFlow authFlow;
        this.token = new AuthToken();
        try {
            authFlow = this.createFlow(clientId, clientSecret, this.token);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error creating authentication flow: " + e.getMessage(), e);
        }
        try {
            response = authFlow.newTokenRequest(authCode).setRedirectUri(redirectUri).execute();
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error authenticating user code: " + e.getMessage(), e);
        }
        try {
            this.credential = authFlow.createAndStoreCredential(response, USER_ID);
        }
        catch (IOException e) {
            throw new CloudDriveException("Error storing user credential: " + e.getMessage(), (Throwable)e);
        }
        this.drive = new Drive.Builder(new NetHttpTransport(), new JacksonFactory(), this.credential).setApplicationName(APP_NAME).build();
        this.oauth2 = new Oauth2.Builder(new NetHttpTransport(), new JacksonFactory(), this.credential).setApplicationName(APP_NAME).build();
    }

    GoogleDriveAPI(String clientId, String clientSecret, String accessToken, String refreshToken, long expirationTime) throws CloudDriveException {
        GoogleAuthorizationCodeFlow authFlow;
        this.token = new AuthToken();
        this.token.load(accessToken, refreshToken, expirationTime);
        try {
            authFlow = this.createFlow(clientId, clientSecret, this.token);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error creating authentication flow: " + e.getMessage(), e);
        }
        try {
            this.credential = authFlow.loadCredential(USER_ID);
        }
        catch (IOException e) {
            throw new CloudDriveException("Error loading Google user credentials: " + e.getMessage(), (Throwable)e);
        }
        this.drive = new Drive.Builder(new NetHttpTransport(), new JacksonFactory(), this.credential).setApplicationName(APP_NAME).build();
        this.oauth2 = new Oauth2.Builder(new NetHttpTransport(), new JacksonFactory(), this.credential).setApplicationName(APP_NAME).build();
    }

    public DataStore<StoredCredential> getDataStore(String id) throws IOException {
        return this.token.store;
    }

    private static String scopes() {
        StringBuilder s = new StringBuilder();
        for (String scope : SCOPES) {
            s.append(scope);
            s.append(' ');
        }
        return s.toString();
    }

    GoogleAuthorizationCodeFlow createFlow(String clientId, String clientSecret, AuthToken storedToken) throws IOException {
        NetHttpTransport httpTransport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        GoogleAuthorizationCodeFlow.Builder flow = new GoogleAuthorizationCodeFlow.Builder(httpTransport, jsonFactory, clientId, clientSecret, SCOPES);
        flow.setAccessType(ACCESS_TYPE).setApprovalPrompt(APPOVAl_PROMT);
        if (storedToken != null) {
            flow.setCredentialDataStore((DataStore)storedToken.store);
            flow.setCredentialCreatedListener(storedToken);
            flow.addRefreshListener(storedToken);
        }
        return flow.build();
    }

    Userinfoplus userInfo() throws GoogleDriveException, CloudDriveException {
        Userinfoplus userInfo;
        try {
            userInfo = (Userinfoplus)this.oauth2.userinfo().get().execute();
        }
        catch (GoogleJsonResponseException e) {
            GoogleJsonError error = e.getDetails();
            throw new GoogleDriveException("Error getting userinfo: " + error.getMessage() + " (" + error.getCode() + ").", e);
        }
        catch (HttpResponseException e) {
            throw new GoogleDriveException("Error handling userinfo response: " + e.getMessage() + " (" + e.getStatusCode() + ").", e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error requesting userinfo: " + e.getMessage(), e);
        }
        if (userInfo != null && userInfo.getId() != null) {
            return userInfo;
        }
        throw new CloudDriveException("User ID cannot be retrieved.");
    }

    About about() throws GoogleDriveException, CloudDriveAccessException {
        try {
            return (About)this.drive.about().get().execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 403) {
                throw new CloudDriveAccessException("Error accessing About service: " + e.getMessage(), (Throwable)e);
            }
            throw new GoogleDriveException("Error reading About service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error requesting About service: " + e.getMessage(), e);
        }
    }

    ChildIterator children(String fileId) throws GoogleDriveException {
        return new ChildIterator(fileId);
    }

    ChangesIterator changes(long startChangeId) throws GoogleDriveException {
        return new ChangesIterator(startChangeId);
    }

    File file(String fileId) throws GoogleDriveException, NotFoundException {
        try {
            return (File)this.drive.files().get(fileId).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error getting file from Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error requesting file from Files service: " + e.getMessage(), e);
        }
    }

    File insert(File file, AbstractInputStreamContent content) throws GoogleDriveException, CloudDriveAccessException {
        String id = this.generateFileId();
        file.setId(id);
        try {
            return (File)this.drive.files().insert(file, content).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to inserting file with content in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            try {
                return this.waitFile(id);
            }
            catch (GoogleDriveException wfe) {
                LOG.warn((Object)("Error reading file after attempting to upload it " + id + " (" + file.getTitle() + ")"), (Throwable)e);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            throw new GoogleDriveException("Error inserting file with content to Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error inserting file with content to Files service: " + e.getMessage(), e);
        }
    }

    File insert(File file) throws GoogleDriveException, CloudDriveAccessException {
        String id = this.generateFileId();
        file.setId(id);
        try {
            return (File)this.drive.files().insert(file).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to insert file to Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            try {
                return this.waitFile(id);
            }
            catch (GoogleDriveException wfe) {
                LOG.warn((Object)("Error reading file after attempting to create it " + id + " (" + file.getTitle() + ")"), (Throwable)e);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            throw new GoogleDriveException("Error inserting file to Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error inserting file to Files service: " + e.getMessage(), e);
        }
    }

    void update(File file, AbstractInputStreamContent content) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        String fileId = file.getId();
        try {
            this.drive.files().update(fileId, file, content).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to update file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for updating: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error updating file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error upating file with content in Files service: " + e.getMessage(), e);
        }
    }

    void update(File file) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        String fileId = file.getId();
        try {
            this.drive.files().update(fileId, file).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to update file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for updating: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error updating file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error upating file metadata in Files service: " + e.getMessage(), e);
        }
    }

    File copy(String srcFileId, File destFile) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        try {
            return (File)this.drive.files().copy(srcFileId, destFile).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to copy file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for copying: " + srcFileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error copying file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error copying file metadata in Files service: " + e.getMessage(), e);
        }
    }

    void delete(String fileId) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        try {
            this.drive.files().delete(fileId).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to delete file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for deleting: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error deleting file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error deleting file in Files service: " + e.getMessage(), e);
        }
    }

    File trash(String fileId) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        try {
            return (File)this.drive.files().trash(fileId).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to trash file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for trashing: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error trashing file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error trashing file in Files service: " + e.getMessage(), e);
        }
    }

    File untrash(String fileId) throws GoogleDriveException, NotFoundException, CloudDriveAccessException {
        try {
            return (File)this.drive.files().untrash(fileId).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (this.isInsufficientPermissions(e)) {
                throw new CloudDriveAccessException("Insufficient permissions to untrash file in Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
            }
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Cloud file not found for untrashing: " + fileId, (Throwable)e);
            }
            throw new GoogleDriveException("Error untrashing file in Files service: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error untrashing file in Files service: " + e.getMessage(), e);
        }
    }

    String generateFileId() throws GoogleDriveException, CloudDriveAccessException {
        String id;
        block10: {
            id = this.generatedIds.get().nextId();
            if (id == null) {
                this.generateIdsLock.lock();
                try {
                    GeneratedIds newIds;
                    id = this.generatedIds.get().nextId();
                    if (id != null) break block10;
                    FilesGenerateIds request = new FilesGenerateIds();
                    if (this.drive.getGoogleClientRequestInitializer() != null) {
                        this.drive.getGoogleClientRequestInitializer().initialize(request);
                    }
                    if ((id = (newIds = (GeneratedIds)request.execute()).nextId()) != null) {
                        this.generatedIds.set(newIds);
                        break block10;
                    }
                    throw new GoogleDriveException("Received empty list of generated file IDs from Files service");
                }
                catch (GoogleJsonResponseException e) {
                    if (this.isInsufficientPermissions(e)) {
                        throw new CloudDriveAccessException("Insufficient permissions to generate file IDs by Files service. " + e.getStatusMessage() + " (" + e.getStatusCode() + ")");
                    }
                    throw new GoogleDriveException("Error to generate file IDs by Files service: " + e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new GoogleDriveException("Error to generate file IDs by Files service: " + e.getMessage(), e);
                }
                finally {
                    this.generateIdsLock.unlock();
                }
            }
        }
        return id;
    }

    void refreshAccess() throws GoogleDriveException {
        Long expirationTime = this.credential.getExpiresInSeconds();
        if (expirationTime != null && expirationTime < 0L) {
            try {
                this.credential.refreshToken();
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error refreshing access token: " + e.getMessage(), e);
            }
        }
    }

    void updateToken(UserToken newToken) throws CloudDriveException {
        this.token.merge(newToken);
    }

    AuthToken getToken() {
        return this.token;
    }

    boolean isFolder(File file) {
        return file.getMimeType().equals(FOLDER_MIMETYPE);
    }

    Calendar parseDate(String datestring) {
        Date d = new Date();
        Calendar calendar = Calendar.getInstance();
        if (datestring.endsWith("Z")) {
            try {
                SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                d = s.parse(datestring);
            }
            catch (ParseException pe) {
                SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
                s.setLenient(true);
                try {
                    d = s.parse(datestring);
                }
                catch (ParseException e) {
                    LOG.error((Object)"An error occurred: ", (Throwable)e);
                }
            }
            calendar.setTime(d);
            return calendar;
        }
        Matcher dm = this.tzPattern.matcher(datestring);
        if (dm.find() && dm.groupCount() >= 1) {
            String tz = dm.group(1);
            datestring = dm.replaceFirst(tz.replace(":", ""));
        }
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            d = s.parse(datestring);
        }
        catch (ParseException pe) {
            s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ");
            s.setLenient(true);
            try {
                d = s.parse(datestring);
            }
            catch (ParseException e) {
                LOG.error((Object)"An error occurred: ", (Throwable)e);
            }
        }
        calendar.setTime(d);
        return calendar;
    }

    private boolean isInsufficientPermissions(GoogleJsonResponseException e) {
        List<GoogleJsonError.ErrorInfo> errors;
        GoogleJsonError details = e.getDetails();
        if (e.getStatusCode() == 403 && details != null && (errors = details.getErrors()) != null) {
            for (GoogleJsonError.ErrorInfo ei : errors) {
                if (!ei.getReason().equals("insufficientPermissions")) continue;
                return true;
            }
        }
        return false;
    }

    private File waitFile(String id) throws GoogleDriveException, NotFoundException {
        try {
            Thread.sleep(FILE_ERROR_WAIT);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Error waiting before reading the file " + id), (Throwable)e);
        }
        return this.file(id);
    }

    static {
        Data.nullOf(GeneratedIds.class);
    }

    public class FilesGenerateIds
    extends DriveRequest<GeneratedIds> {
        private static final String REST_PATH = "files/generateIds";

        protected FilesGenerateIds() {
            super(GoogleDriveAPI.this.drive, "GET", REST_PATH, (Object)null, GeneratedIds.class);
        }

        @Override
        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        @Override
        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public FilesGenerateIds setAlt(String alt) {
            return (FilesGenerateIds)super.setAlt(alt);
        }

        public FilesGenerateIds setFields(String fields) {
            return (FilesGenerateIds)super.setFields(fields);
        }

        public FilesGenerateIds setKey(String key) {
            return (FilesGenerateIds)super.setKey(key);
        }

        public FilesGenerateIds setOauthToken(String oauthToken) {
            return (FilesGenerateIds)super.setOauthToken(oauthToken);
        }

        public FilesGenerateIds setPrettyPrint(Boolean prettyPrint) {
            return (FilesGenerateIds)super.setPrettyPrint(prettyPrint);
        }

        public FilesGenerateIds setQuotaUser(String quotaUser) {
            return (FilesGenerateIds)super.setQuotaUser(quotaUser);
        }

        public FilesGenerateIds setUserIp(String userIp) {
            return (FilesGenerateIds)super.setUserIp(userIp);
        }

        @Override
        public FilesGenerateIds set(String parameterName, Object value) {
            return (FilesGenerateIds)super.set(parameterName, value);
        }
    }

    public static class GeneratedIds
    extends GenericJson {
        @Key
        private String kind;
        @Key
        private String space;
        @Key
        private List<String> ids;
        private Queue<String> idsQueue;
        private Long expired = System.currentTimeMillis() + FILE_ID_EXPIRED;

        private boolean fillQueue() {
            if (this.idsQueue == null) {
                if (this.ids != null) {
                    this.idsQueue = new ConcurrentLinkedQueue<String>();
                    this.idsQueue.addAll(this.ids);
                } else {
                    return false;
                }
            }
            return !this.idsQueue.isEmpty();
        }

        public boolean isExpired() {
            return this.expired <= System.currentTimeMillis();
        }

        public boolean hasId() {
            if (this.isExpired()) {
                return false;
            }
            if (this.fillQueue()) {
                return true;
            }
            return !this.idsQueue.isEmpty();
        }

        public String nextId() {
            if (this.isExpired()) {
                return null;
            }
            if (!this.fillQueue()) {
                return null;
            }
            return this.idsQueue.poll();
        }

        public String getKind() {
            return this.kind;
        }

        public String getSpace() {
            return this.space;
        }

        public List<String> getIds() {
            return this.ids;
        }

        public GeneratedIds setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public GeneratedIds setSpace(String space) {
            this.space = space;
            return this;
        }

        public GeneratedIds setIds(List<String> ids) {
            this.ids = ids;
            return this;
        }
    }

    class ChangesIterator
    extends ChunkIterator<Change> {
        final Drive.Changes.List request;
        long largestChangeId;

        ChangesIterator(long startChangeId) throws GoogleDriveException {
            try {
                this.request = GoogleDriveAPI.this.drive.changes().list();
                this.request.setIncludeSubscribed(false);
                this.request.setIncludeDeleted(true);
                this.request.setStartChangeId(startChangeId);
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error creating request to Changes.List service: " + e.getMessage(), e);
            }
            this.iter = this.nextChunk();
        }

        protected Iterator<Change> nextChunk() throws GoogleDriveException {
            try {
                ChangeList children = (ChangeList)this.request.execute();
                this.largestChangeId = children.getLargestChangeId();
                this.request.setPageToken(children.getNextPageToken());
                List<Change> items = children.getItems();
                this.available(items.size());
                return items.iterator();
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error requesting Children.List service: " + e.getMessage(), e);
            }
        }

        protected boolean hasNextChunk() {
            return this.request.getPageToken() != null && this.request.getPageToken().length() > 0;
        }

        long getLargestChangeId() {
            return this.largestChangeId;
        }
    }

    class ChildIterator
    extends ChunkIterator<ChildReference> {
        final Drive.Children.List request;

        ChildIterator(String fileId) throws GoogleDriveException {
            try {
                this.request = GoogleDriveAPI.this.drive.children().list(fileId);
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error creating request to Children.List service: " + e.getMessage(), e);
            }
            this.iter = this.nextChunk();
        }

        protected Iterator<ChildReference> nextChunk() throws GoogleDriveException {
            try {
                ChildList children = (ChildList)this.request.execute();
                this.request.setPageToken(children.getNextPageToken());
                List<ChildReference> items = children.getItems();
                this.available(items.size());
                return items.iterator();
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error requesting Children.List service: " + e.getMessage(), e);
            }
        }

        protected boolean hasNextChunk() {
            return this.request.getPageToken() != null && this.request.getPageToken().length() > 0;
        }
    }

    class AuthToken
    extends UserToken
    implements CredentialRefreshListener,
    AuthorizationCodeFlow.CredentialCreatedListener {
        final Store store = new Store();

        AuthToken() {
        }

        void store(StoredCredential credential) {
            try {
                this.store(credential.getAccessToken(), credential.getRefreshToken(), credential.getExpirationTimeMilliseconds());
            }
            catch (CloudDriveException e) {
                LOG.error((Object)"Error storing credential", (Throwable)e);
            }
        }

        void store(Credential credential) {
            try {
                this.store(credential.getAccessToken(), credential.getRefreshToken(), credential.getExpirationTimeMilliseconds());
            }
            catch (CloudDriveException e) {
                LOG.error((Object)"Error storing credential", (Throwable)e);
            }
        }

        @Override
        public void onCredentialCreated(Credential credential, TokenResponse tokenResponse) throws IOException {
            this.store(credential);
        }

        @Override
        public void onTokenResponse(Credential credential, TokenResponse tokenResponse) throws IOException {
            this.store(credential);
        }

        @Override
        public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) throws IOException {
            String errDescription = tokenErrorResponse.getErrorDescription();
            String errURI = tokenErrorResponse.getErrorUri();
            LOG.error((Object)("Error refreshing credentials: " + tokenErrorResponse.getError() + (errDescription != null ? " " + errDescription : "") + (errURI != null ? ". Error URI: " + errURI : "")));
        }

        public void merge(UserToken newToken) throws CloudDriveException {
            super.merge(newToken);
            if (GoogleDriveAPI.this.credential != null) {
                GoogleDriveAPI.this.credential.setAccessToken(newToken.getAccessToken());
                GoogleDriveAPI.this.credential.setExpirationTimeMilliseconds(newToken.getExpirationTime());
                GoogleDriveAPI.this.credential.setRefreshToken(newToken.getRefreshToken());
            }
        }

        class Store
        implements DataStore<StoredCredential> {
            Store() {
            }

            @Override
            public DataStoreFactory getDataStoreFactory() {
                return GoogleDriveAPI.this;
            }

            @Override
            public String getId() {
                return GoogleDriveAPI.class.getSimpleName();
            }

            @Override
            public int size() throws IOException {
                return this.isEmpty() ? 0 : 1;
            }

            @Override
            public boolean isEmpty() throws IOException {
                return AuthToken.this.getAccessToken() == null || AuthToken.this.getRefreshToken() == null;
            }

            @Override
            public boolean containsKey(String userId) throws IOException {
                return GoogleDriveAPI.USER_ID.equals(userId);
            }

            @Override
            public boolean containsValue(StoredCredential value) throws IOException {
                return value.getAccessToken().equals(AuthToken.this.getAccessToken()) && value.getRefreshToken().equals(AuthToken.this.getRefreshToken()) && value.getExpirationTimeMilliseconds().longValue() == AuthToken.this.getExpirationTime();
            }

            @Override
            public Set<String> keySet() throws IOException {
                HashSet<String> keys = new HashSet<String>();
                keys.add(GoogleDriveAPI.USER_ID);
                return keys;
            }

            @Override
            public Collection<StoredCredential> values() throws IOException {
                StoredCredential[] single = new StoredCredential[]{this.get(GoogleDriveAPI.USER_ID)};
                return Arrays.asList(single);
            }

            @Override
            public StoredCredential get(String userId) throws IOException {
                StoredCredential stored = new StoredCredential();
                stored.setAccessToken(AuthToken.this.getAccessToken());
                stored.setRefreshToken(AuthToken.this.getRefreshToken());
                stored.setExpirationTimeMilliseconds(AuthToken.this.getExpirationTime());
                return stored;
            }

            @Override
            public DataStore<StoredCredential> set(String userId, StoredCredential value) throws IOException {
                AuthToken.this.store(value);
                return this;
            }

            @Override
            public DataStore<StoredCredential> clear() throws IOException {
                return this;
            }

            @Override
            public DataStore<StoredCredential> delete(String userId) throws IOException {
                return this;
            }
        }
    }
}

