/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.googleapis.testing.auth.oauth2;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.shaded.google.api.client.googleapis.testing.TestUtils;
import org.exoplatform.shaded.google.api.client.http.LowLevelHttpRequest;
import org.exoplatform.shaded.google.api.client.http.LowLevelHttpResponse;
import org.exoplatform.shaded.google.api.client.json.GenericJson;
import org.exoplatform.shaded.google.api.client.json.JsonFactory;
import org.exoplatform.shaded.google.api.client.json.jackson2.JacksonFactory;
import org.exoplatform.shaded.google.api.client.json.webtoken.JsonWebSignature;
import org.exoplatform.shaded.google.api.client.testing.http.MockHttpTransport;
import org.exoplatform.shaded.google.api.client.testing.http.MockLowLevelHttpRequest;
import org.exoplatform.shaded.google.api.client.testing.http.MockLowLevelHttpResponse;
import org.exoplatform.shaded.google.api.client.util.Beta;

@Beta
public class MockTokenServerTransport
extends MockHttpTransport {
    static final String EXPECTED_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    static final JsonFactory JSON_FACTORY = new JacksonFactory();
    Map<String, String> serviceAccounts = new HashMap<String, String>();
    Map<String, String> clients = new HashMap<String, String>();
    Map<String, String> refreshTokens = new HashMap<String, String>();

    public void addServiceAccount(String email, String accessToken) {
        this.serviceAccounts.put(email, accessToken);
    }

    public void addClient(String clientId, String clientSecret) {
        this.clients.put(clientId, clientSecret);
    }

    public void addRefreshToken(String refreshToken, String accessTokenToReturn) {
        this.refreshTokens.put(refreshToken, accessTokenToReturn);
    }

    public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
        if (url.equals("https://accounts.google.com/o/oauth2/token")) {
            MockLowLevelHttpRequest request = new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    String content = this.getContentAsString();
                    Map<String, String> query = TestUtils.parseQuery(content);
                    String accessToken = null;
                    String foundId = query.get("client_id");
                    if (foundId != null) {
                        if (!MockTokenServerTransport.this.clients.containsKey(foundId)) {
                            throw new IOException("Client ID not found.");
                        }
                        String foundSecret = query.get("client_secret");
                        String expectedSecret = MockTokenServerTransport.this.clients.get(foundId);
                        if (foundSecret == null || !foundSecret.equals(expectedSecret)) {
                            throw new IOException("Client secret not found.");
                        }
                        String foundRefresh = query.get("refresh_token");
                        if (!MockTokenServerTransport.this.refreshTokens.containsKey(foundRefresh)) {
                            throw new IOException("Refresh Token not found.");
                        }
                        accessToken = MockTokenServerTransport.this.refreshTokens.get(foundRefresh);
                    } else if (query.containsKey("grant_type")) {
                        String grantType = query.get("grant_type");
                        if (!MockTokenServerTransport.EXPECTED_GRANT_TYPE.equals(grantType)) {
                            throw new IOException("Unexpected Grant Type.");
                        }
                        String assertion = query.get("assertion");
                        JsonWebSignature signature = JsonWebSignature.parse(JSON_FACTORY, assertion);
                        String foundEmail = signature.getPayload().getIssuer();
                        if (!MockTokenServerTransport.this.serviceAccounts.containsKey(foundEmail)) {
                            throw new IOException("Service Account Email not found as issuer.");
                        }
                        accessToken = MockTokenServerTransport.this.serviceAccounts.get(foundEmail);
                        String foundScopes = (String)signature.getPayload().get("scope");
                        if (foundScopes == null || foundScopes.length() == 0) {
                            throw new IOException("Scopes not found.");
                        }
                    } else {
                        throw new IOException("Uknown token type.");
                    }
                    GenericJson refreshContents = new GenericJson();
                    refreshContents.setFactory(JSON_FACTORY);
                    refreshContents.put("access_token", (Object)accessToken);
                    refreshContents.put("expires_in", (Object)3600000);
                    refreshContents.put("token_type", (Object)"Bearer");
                    String refreshText = refreshContents.toPrettyString();
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(refreshText);
                    return response;
                }
            };
            return request;
        }
        return super.buildRequest(method, url);
    }
}

