/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teampolicies.OfficeAddInPolicy;
import com.dropbox.core.v2.teampolicies.TeamSharingPolicies;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class FullTeam
extends Team {
    protected final TeamSharingPolicies sharingPolicies;
    protected final OfficeAddInPolicy officeAddinPolicy;

    public FullTeam(String id, String name, TeamSharingPolicies sharingPolicies, OfficeAddInPolicy officeAddinPolicy) {
        super(id, name);
        if (sharingPolicies == null) {
            throw new IllegalArgumentException("Required value for 'sharingPolicies' is null");
        }
        this.sharingPolicies = sharingPolicies;
        if (officeAddinPolicy == null) {
            throw new IllegalArgumentException("Required value for 'officeAddinPolicy' is null");
        }
        this.officeAddinPolicy = officeAddinPolicy;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TeamSharingPolicies getSharingPolicies() {
        return this.sharingPolicies;
    }

    public OfficeAddInPolicy getOfficeAddinPolicy() {
        return this.officeAddinPolicy;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sharingPolicies, this.officeAddinPolicy});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FullTeam other = (FullTeam)obj;
            return !(this.id != other.id && !this.id.equals(other.id) || this.name != other.name && !this.name.equals(other.name) || this.sharingPolicies != other.sharingPolicies && !this.sharingPolicies.equals(other.sharingPolicies) || this.officeAddinPolicy != other.officeAddinPolicy && !this.officeAddinPolicy.equals((Object)other.officeAddinPolicy));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FullTeam> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FullTeam value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("sharing_policies");
            TeamSharingPolicies.Serializer.INSTANCE.serialize(value.sharingPolicies, g);
            g.writeFieldName("office_addin_policy");
            OfficeAddInPolicy.Serializer.INSTANCE.serialize(value.officeAddinPolicy, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FullTeam deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            OfficeAddInPolicy f_officeAddinPolicy;
            TeamSharingPolicies f_sharingPolicies;
            String f_name;
            String f_id;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_id = null;
                f_name = null;
                f_sharingPolicies = null;
                f_officeAddinPolicy = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("sharing_policies".equals(field)) {
                        f_sharingPolicies = (TeamSharingPolicies)TeamSharingPolicies.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("office_addin_policy".equals(field)) {
                        f_officeAddinPolicy = OfficeAddInPolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_sharingPolicies == null) {
                    throw new JsonParseException(p, "Required field \"sharing_policies\" missing.");
                }
                if (f_officeAddinPolicy == null) {
                    throw new JsonParseException(p, "Required field \"office_addin_policy\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FullTeam value = new FullTeam(f_id, f_name, f_sharingPolicies, f_officeAddinPolicy);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

