/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ThreadExecutor {
    public static final long SYNC_PERIOD = 10000L;
    public static final long STOP_TIMEOUT = 40000L;
    public static final int MIN_THREADS = 2;
    public static final int MIN_FACTOR = 4;
    public static final int MAX_FACTOR = 50;
    public static final int QUEUE_FACTOR = 100;
    public static final String SINGLETON_THREAD_PREFIX = "clouddrive-thread-";
    protected static final Log LOG = ExoLogger.getLogger(ThreadExecutor.class);
    protected static ThreadExecutor singleton;
    private final ConcurrentHashMap<CloudDrive, Object> drives = new ConcurrentHashMap();
    private final int maxFactor;
    private final int queueFactor;
    private final String threadNamePrefix;
    private final ExecutorService executor;

    public static ThreadExecutor getInstance() {
        if (singleton == null) {
            singleton = new ThreadExecutor();
        }
        return singleton;
    }

    public static ThreadExecutor createInstance(String threadNamePrefix, int maxThreadsPerCPU, int queuePerCPU) {
        return new ThreadExecutor(threadNamePrefix, maxThreadsPerCPU, queuePerCPU);
    }

    private ThreadExecutor() {
        this(SINGLETON_THREAD_PREFIX, 50, 100);
    }

    private ThreadExecutor(String threadNamePrefix, int maxFactor, int queueFactor) {
        int cpus;
        this.maxFactor = maxFactor;
        this.queueFactor = queueFactor;
        this.threadNamePrefix = threadNamePrefix;
        int poolThreads = cpus = Runtime.getRuntime().availableProcessors();
        int maxThreads = Math.round((float)cpus * 1.0f * (float)maxFactor);
        maxThreads = maxThreads > 0 ? maxThreads : 1;
        maxThreads = maxThreads < 2 ? 2 : maxThreads;
        int queueSize = cpus * queueFactor;
        queueSize = queueSize < queueFactor ? queueFactor : queueSize;
        LOG.info((Object)("Initializing command executor for max " + maxThreads + " threads, queue size " + queueSize));
        this.executor = new ThreadPoolExecutor(poolThreads, maxThreads, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new CommandThreadFactory(threadNamePrefix), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public synchronized <P> Future<P> submit(Callable<P> command) {
        return this.executor.submit(command);
    }

    public synchronized Future<?> submit(Runnable worker) {
        return this.executor.submit(worker);
    }

    public void stop() {
        this.stopSheduller();
    }

    private void stopSheduller() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    static class CommandThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        CommandThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L){

                protected void finalize() throws Throwable {
                    super.finalize();
                    threadNumber.decrementAndGet();
                }
            };
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

