/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.ecms.ConnectCloudDriveManagerComponent;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.picocontainer.Startable;

public class CloudDriveUIService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(CloudDriveUIService.class);
    private static final String EXO_BUTTONS = "exo:buttons";
    public static final String CONNECT_CLOUD_DRIVE_ACTION = "add.connect.clouddrive.action";
    private final RepositoryService jcrService;
    private final ManageViewService manageView;
    private final CloudDriveService driveService;
    private final UIExtensionManager uiExtensions;
    private final List<String> VIEWS = Arrays.asList("b_list-view/List", "e_admin-view/Admin", "c_icon-view/Icons");

    public CloudDriveUIService(RepositoryService repoService, CloudDriveService driveService, UIExtensionManager uiExtensions, ManageViewService manageView) {
        this.jcrService = repoService;
        this.manageView = manageView;
        this.driveService = driveService;
        this.uiExtensions = uiExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareViews() throws Exception {
        ArrayList<String> cdActions = new ArrayList<String>();
        for (UIExtension ext : this.uiExtensions.getUIExtensions("org.exoplatform.ecm.dms.UIActionBar")) {
            if (!ConnectCloudDriveManagerComponent.class.isAssignableFrom(ext.getComponent())) continue;
            cdActions.add(ext.getName());
        }
        SessionProvider jcrSessions = SessionProvider.createSystemProvider();
        try {
            Session session = jcrSessions.getSession("dms-system", this.jcrService.getCurrentRepository());
            for (String view : this.VIEWS) {
                Node listNode = (Node)session.getItem(this.manageView.getViewByName(view, jcrSessions).getPath());
                StringBuilder newActions = new StringBuilder();
                if (listNode.hasProperty(EXO_BUTTONS)) {
                    String[] actions = listNode.getProperty(EXO_BUTTONS).getString().split(";");
                    for (int i = 0; i < actions.length; ++i) {
                        newActions.append(actions[i].trim());
                        if (i >= actions.length - 1) continue;
                        newActions.append(';');
                        newActions.append(' ');
                    }
                }
                for (String cda : cdActions) {
                    char[] ac = cda.toCharArray();
                    if (ac.length > 0) {
                        ac[0] = Character.toLowerCase(ac[0]);
                    }
                    if (newActions.indexOf(new String(ac)) >= 0) continue;
                    newActions.append(';');
                    newActions.append(' ');
                    newActions.append(ac);
                }
                listNode.setProperty(EXO_BUTTONS, newActions.toString());
            }
            session.save();
        }
        finally {
            jcrSessions.close();
        }
    }

    public void start() {
        try {
            this.prepareViews();
            LOG.info((Object)"Connect Cloud Drive action successfully added");
        }
        catch (Exception e) {
            LOG.error((Object)("Error adding Connect Cloud Drive Action: " + e.getMessage()), (Throwable)e);
        }
    }

    public void stop() {
    }

    protected void repositoryStarted(String name) {
        try {
            this.jcrService.setCurrentRepositoryName(name);
            this.prepareViews();
        }
        catch (RepositoryConfigurationException e) {
            LOG.error((Object)("Error adding Connect Cloud Drive Action - cannot set current repository name '" + name + "': " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Error adding Connect Cloud Drive Action to " + name + "': " + e.getMessage()), (Throwable)e);
        }
    }
}

