/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms;

import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.ProviderNotAvailableException;
import org.exoplatform.clouddrive.ecms.ConnectCloudDriveManagerComponent;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;

@ComponentConfig(events={@EventConfig(listeners={ConnectGoogleDriveActionListener.class})})
public class ConnectGoogleDriveActionComponent
extends ConnectCloudDriveManagerComponent {
    protected static final Log LOG = ExoLogger.getLogger(ConnectGoogleDriveActionComponent.class);

    public String renderEventURL(boolean ajax, String name, String beanId, Parameter[] params) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        String nodePath = uiExplorer.getCurrentNode().getPath();
        String workspace = uiExplorer.getCurrentNode().getSession().getWorkspace().getName();
        CloudDriveService drivesService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
        if (drivesService != null) {
            try {
                CloudProvider provider = drivesService.getProvider("gdrive");
                return "javascript:cloudDrive.connect('" + provider.getId() + "', '" + provider.getAuthUrl() + "', '" + nodePath + "', '" + workspace + "');";
            }
            catch (ProviderNotAvailableException e) {
                LOG.error((Object)("Error rendering Connect to Google Drive component: " + e.getMessage()));
                return super.renderEventURL(ajax, name, beanId, params);
            }
        }
        LOG.error((Object)"CloudDriveService not registred in the container.");
        return super.renderEventURL(ajax, name, beanId, params);
    }

    public String getName() {
        return "Connect your Google Drive";
    }

    public static class ConnectGoogleDriveActionListener
    extends UIActionBarActionListener<ConnectGoogleDriveActionComponent> {
        public void processEvent(Event<ConnectGoogleDriveActionComponent> event) throws Exception {
        }
    }
}

