/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.filters;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.NotYetCloudFileException;
import org.exoplatform.clouddrive.ecms.filters.AbstractCloudDriveNodeFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;

public class BelongToCloudDriveFilter
extends AbstractCloudDriveNodeFilter {
    protected static final Log LOG = ExoLogger.getLogger(BelongToCloudDriveFilter.class);

    @Override
    protected boolean accept(Node node) throws RepositoryException {
        CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
        CloudDrive drive = driveService.findDrive(node);
        if (drive != null) {
            try {
                try {
                    drive.getFile(node.getPath());
                }
                catch (NotYetCloudFileException e) {
                    // empty catch block
                }
                WebuiRequestContext.getCurrentInstance().setAttribute(CloudDrive.class, (Object)drive);
                return true;
            }
            catch (DriveRemovedException e) {
            }
            catch (NotCloudFileException e) {
                // empty catch block
            }
        }
        return false;
    }
}

