/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public class FileTypeFilter
implements UIExtensionFilter {
    protected static final Log LOG = ExoLogger.getLogger(FileTypeFilter.class);
    protected Set<String> mimeTypes;
    protected List<MimeType> accepted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    Collection<MimeType> mimeTypes() {
        if (this.accepted == null) {
            FileTypeFilter fileTypeFilter = this;
            synchronized (fileTypeFilter) {
                if (this.accepted == null) {
                    this.accepted = new ArrayList<MimeType>();
                    for (String m : this.mimeTypes) {
                        try {
                            this.accepted.add(new MimeType(m));
                        }
                        catch (MimeTypeParseException e) {
                            LOG.warn((Object)("Error parsing configured MIME type " + m + ": " + (Object)((Object)e)));
                        }
                    }
                }
            }
        }
        return this.accepted;
    }

    public boolean accept(Map<String, Object> context) throws Exception {
        if (this.mimeTypes == null || this.mimeTypes.isEmpty()) {
            return true;
        }
        String type = context.get("mimeType").toString();
        if (this.mimeTypes.contains(type)) {
            return true;
        }
        for (String accepted : this.mimeTypes) {
            if (!type.startsWith(accepted)) continue;
            return true;
        }
        return false;
    }

    public UIExtensionFilterType getType() {
        return UIExtensionFilterType.MANDATORY;
    }

    public void onDeny(Map<String, Object> context) throws Exception {
    }
}

