/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.symlink;

import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveManager;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.ecms.CloudDriveContext;
import org.exoplatform.clouddrive.ecms.symlink.CloudFileSymlinkException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;

public class CloudFileSymlink {
    protected final UIJCRExplorer uiExplorer;
    protected final Set<Node> srcNodes = new LinkedHashSet<Node>();
    protected String destWorkspace;
    protected String destPath;
    protected Node destNode;
    protected Node link;
    protected boolean move;

    public CloudFileSymlink(UIJCRExplorer uiExplorer) {
        this.uiExplorer = uiExplorer;
    }

    public CloudFileSymlink addSource(Node srcNode) {
        this.srcNodes.add(srcNode);
        return this;
    }

    public CloudFileSymlink addSource(String srcInfo) throws Exception {
        return this.addSource(this.getNodeByInfo(srcInfo));
    }

    public CloudFileSymlink addSource(String srcWorkspace, String srcPath) throws Exception {
        return this.addSource(this.getNodeByPath(srcWorkspace, srcPath));
    }

    public CloudFileSymlink setDestination(Node destNode) throws Exception {
        this.destWorkspace = destNode.getSession().getWorkspace().getName();
        this.destNode = this.getNodeByPath(this.destWorkspace, destNode.getPath());
        this.destPath = this.destNode.getPath();
        return this;
    }

    public CloudFileSymlink setDestination(String destInfo) throws Exception {
        return this.setDestination(this.getNodeByInfo(destInfo));
    }

    public CloudFileSymlink move() {
        this.move = true;
        return this;
    }

    public Node getLink() {
        return this.link;
    }

    public String getDestinationWorkspace() {
        return this.destWorkspace;
    }

    public String getDestonationPath() {
        return this.destPath;
    }

    public Node getDestinationNode() {
        return this.destNode;
    }

    public boolean create() throws CloudFileSymlinkException, Exception {
        if (this.srcNodes.size() > 0) {
            for (Node srcNode : this.srcNodes) {
                if (this.create(srcNode)) continue;
                return false;
            }
            RequestContext rcontext = WebuiRequestContext.getCurrentInstance();
            if (rcontext != null) {
                String destName;
                String multiple = this.srcNodes.size() > 1 ? "s" : "";
                try {
                    destName = this.destNode.getProperty("exo:title").getString();
                }
                catch (PathNotFoundException e) {
                    destName = this.destNode.getName();
                }
                ApplicationMessage title = new ApplicationMessage("CloudFile.msg.LinkCreated", (Object[])new String[]{multiple});
                ApplicationMessage text = new ApplicationMessage("CloudFile.msg.FileLinksCreated", (Object[])new String[]{multiple, destName});
                ResourceBundle res = rcontext.getApplicationResourceBundle();
                title.setResourceBundle(res);
                text.setResourceBundle(res);
                CloudDriveContext.showInfo(rcontext, title.getMessage(), text.getMessage());
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean create(Node srcNode) throws CloudFileSymlinkException, Exception {
        if (this.destWorkspace == null) throw new IllegalArgumentException("Destination should be defined.");
        String srcPath = srcNode.getPath();
        if (this.destPath.startsWith(srcPath) || !PermissionUtil.canAddNode((Node)this.destNode) || this.uiExplorer.nodeIsLocked(this.destNode) || !this.destNode.isCheckedOut()) return false;
        CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
        CloudDrive srcLocal = driveService.findDrive(srcNode);
        if (srcLocal != null && srcLocal.isDrive(srcNode)) {
            throw new CloudFileSymlinkException("Copy or move of cloud drive not supported: " + srcPath + " -> " + this.destPath, new ApplicationMessage("CloudFile.msg.CloudDriveCopyMoveNotSupported", null, 1));
        }
        CloudDrive destLocal = driveService.findDrive(this.destNode);
        if (destLocal == null) {
            if (srcLocal == null) return false;
            if (this.move) {
                if (!srcLocal.hasFile(srcPath)) return false;
                throw new CloudFileSymlinkException("Move of cloud file to outside the cloud drive not supported: " + srcPath + " -> " + this.destPath, new ApplicationMessage("CloudFile.msg.MoveToOutsideDriveNotSupported", null, 1));
            }
            String srcWorkspace = srcNode.getSession().getWorkspace().getName();
            if (!srcWorkspace.equals(this.destWorkspace)) {
                throw new CloudFileSymlinkException("Linking between workspaces not supported for Cloud Drive files. " + srcWorkspace + ":" + srcPath + " -> " + this.destWorkspace + ":" + this.destPath, new ApplicationMessage("CloudFile.msg.MoveBetweenWorkspacesNotSupported", null, 1));
            }
            LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
            String linkName = srcNode.getName();
            String linkTitle = srcNode.hasProperty("exo:title") ? srcNode.getProperty("exo:title").getString() : linkName;
            this.link = linkManager.createLink(this.destNode, null, srcNode, linkName, linkTitle);
            return true;
        }
        if (srcLocal == null) return false;
        if (!srcLocal.equals(destLocal)) throw new CloudFileSymlinkException("Copy or move of cloud file to another cloud drive not supported: " + srcPath + " -> " + this.destPath, new ApplicationMessage("CloudFile.msg.MoveToAnotherDriveNotSupported", null, 1));
        if (this.move) return false;
        new CloudDriveManager(destLocal).initCopy(srcNode, this.destNode);
        return false;
    }

    protected Node getNodeByInfo(String pathInfo) throws Exception {
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(pathInfo);
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + pathInfo + "'");
        }
        String workspace = matcher.group(1);
        String path = matcher.group(2);
        return this.getNodeByPath(workspace, path);
    }

    protected Node getNodeByPath(String workspace, String path) throws Exception {
        Session srcSession = this.uiExplorer.getSessionByWorkspace(workspace);
        return this.uiExplorer.getNodeByPath(path, srcSession, true);
    }
}

