/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.json.JSONObject;

public class CloudDriveContext {
    protected static final String JAVASCRIPT = "CloudDriveContext_Javascript".intern();
    protected static final Log LOG = ExoLogger.getLogger(CloudDriveContext.class);
    private static final ThreadLocal<Map<String, String>> messages = new ThreadLocal();
    private final RequireJS require;
    private final Set<String> nodes = new HashSet<String>();
    private final Set<String> providers = new HashSet<String>();
    private boolean hasContextNode;

    public static void init(UIComponent uiComponent) throws Exception {
        Node contextNode;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)uiComponent.getAncestorOfType(UIJCRExplorer.class);
        if (uiExplorer != null) {
            contextNode = uiExplorer.getCurrentNode();
        } else if (uiComponent.getParent() instanceof UIBaseNodePresentation) {
            UIBaseNodePresentation docViewer = (UIBaseNodePresentation)uiComponent.getParent();
            contextNode = docViewer.getNode();
        } else {
            contextNode = null;
        }
        if (contextNode != null) {
            CloudDriveContext.init(WebuiRequestContext.getCurrentInstance(), contextNode.getSession().getWorkspace().getName(), contextNode.getPath());
        } else {
            LOG.error((Object)("Cannot find ancestor context node in component " + uiComponent + ", parent: " + uiComponent.getParent()));
        }
    }

    public static void init(RequestContext requestContext) throws CloudDriveException {
        CloudDriveContext.init(requestContext, null, null);
    }

    public static void init(RequestContext requestContext, String workspace, String nodePath) throws CloudDriveException {
        CloudDriveContext context;
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj == null) {
            CloudDriveContext context2 = new CloudDriveContext(requestContext);
            CloudDriveService service = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
            for (CloudProvider provider : service.getProviders()) {
                context2.addProvider(provider);
            }
            if (workspace != null && nodePath != null) {
                context2.init(workspace, nodePath);
            } else {
                context2.init();
            }
            Map<String, String> contextMessages = messages.get();
            if (contextMessages != null) {
                for (Map.Entry<String, String> msg : contextMessages.entrySet()) {
                    context2.showInfo(msg.getKey(), msg.getValue());
                }
                contextMessages.clear();
            }
            requestContext.setAttribute(JAVASCRIPT, (Object)context2);
        } else if (CloudDriveContext.class.isAssignableFrom(obj.getClass()) && !(context = (CloudDriveContext)CloudDriveContext.class.cast(obj)).hasContextNode() && workspace != null && nodePath != null) {
            context.init(workspace, nodePath);
        }
    }

    public static boolean initConnected(RequestContext requestContext, Node parent) throws RepositoryException, CloudDriveException {
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj != null) {
            CloudDriveContext context = (CloudDriveContext)obj;
            context.addConnected(parent.getNodes());
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Context not initialized for adding of drive nodes.");
        }
        return false;
    }

    public static void showInfo(RequestContext requestContext, String title, String message) throws RepositoryException, CloudDriveException {
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj != null) {
            CloudDriveContext context = (CloudDriveContext)obj;
            context.showInfo(title, message);
        } else {
            Map<String, String> contextMessages;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Context not initialized. Adding info message to local cache.");
            }
            if ((contextMessages = messages.get()) == null) {
                contextMessages = new LinkedHashMap<String, String>();
                messages.set(contextMessages);
            }
            contextMessages.put(title, message);
        }
    }

    private CloudDriveContext(RequestContext requestContext) {
        JavascriptManager js = ((WebuiRequestContext)requestContext).getJavascriptManager();
        this.require = js.require("SHARED/cloudDrive", "cloudDrive");
        this.hasContextNode = false;
    }

    private CloudDriveContext init() {
        this.require.addScripts("\ncloudDrive.init();\n");
        return this;
    }

    private CloudDriveContext init(String workspace, String nodePath) {
        this.require.addScripts("\ncloudDrive.init('" + workspace + "','" + nodePath + "');\n");
        this.hasContextNode = true;
        return this;
    }

    private boolean hasContextNode() {
        return this.hasContextNode;
    }

    private CloudDriveContext addConnected(NodeIterator nodes) throws CloudDriveException, RepositoryException {
        if (nodes.hasNext()) {
            CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
            StringBuilder map = new StringBuilder();
            map.append('{');
            int count = 0;
            while (nodes.hasNext()) {
                String title;
                Node child = nodes.nextNode();
                CloudDrive drive = driveService.findDrive(child);
                if (drive == null || this.nodes.contains(title = child.getProperty("exo:title").getString())) continue;
                map.append('\"');
                map.append(title);
                map.append("\":\"");
                map.append(drive.getUser().getProvider().getId());
                map.append("\",");
                ++count;
                this.nodes.add(title);
            }
            if (count >= 1) {
                map.deleteCharAt(map.length() - 1);
                map.append('}');
                this.require.addScripts("\ncloudDrive.initConnected(" + map.toString() + ");\n");
            }
        }
        return this;
    }

    private CloudDriveContext addProvider(CloudProvider provider) throws CloudDriveException {
        String id = provider.getId();
        if (!this.providers.contains(id)) {
            String providerJson = new JSONObject((Object)provider).toString();
            if (providerJson != null) {
                this.require.addScripts("\ncloudDrive.initProvider('" + id + "', " + providerJson.toString() + ");\n");
                this.providers.add(id);
            } else {
                LOG.error((Object)("Error converting cloud provider (" + provider.getName() + ") to JSON object (null)."));
            }
        }
        return this;
    }

    private CloudDriveContext showInfo(String title, String text) {
        this.require.addScripts("\ncloudDrive.showInfo('" + title + "','" + text + "');\n");
        return this;
    }
}

