/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.sharepoint.rest;

import java.util.ArrayList;
import javax.annotation.security.RolesAllowed;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.features.CloudDriveFeatures;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/clouddrive/drive/sharepoint")
@Produces(value={"application/json"})
public class SharepointWebService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(SharepointWebService.class);
    protected final CloudDriveFeatures features;
    protected final CloudDriveService cloudDrives;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;

    public SharepointWebService(CloudDriveService cloudDrives, CloudDriveFeatures features, RepositoryService jcrService, SessionProviderService sessionProviders) {
        this.cloudDrives = cloudDrives;
        this.features = features;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
    }

    @GET
    @Path(value="/comments/")
    @RolesAllowed(value={"users"})
    public Response getFileComments(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        ArrayList<Object> comments = new ArrayList<Object>();
                        try {
                            CloudFile file = local.getFile(path);
                            comments.add(new Object());
                        }
                        catch (NotCloudFileException e) {
                            // empty catch block
                        }
                        return Response.ok().entity(comments).build();
                    }
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive file comments " + workspace + ":" + path + ": " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                }
                catch (CloudDriveException e) {
                    LOG.warn((Object)("Error reading file comments " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error reading file comments. " + e.getMessage())).build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading file comments " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading file comments: storage error.").build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading file comments " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading file comments: runtime error.").build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }
}

